/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.b2c.order.config.engine.action;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.statemachine.engine.action.AbstractCisBaseStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.center.data.dto.DictDto;
import com.yunxi.dg.base.center.data.proxy.api.IDictQueryApiProxy;
import com.yunxi.dg.base.center.openapi.dto.reponse.SkuSupplyPriceRespDto;
import com.yunxi.dg.base.center.openapi.dto.request.AccountBalanceOrderLineReqDto;
import com.yunxi.dg.base.center.openapi.dto.request.SkuSupplyPriceQueryReqDto;
import com.yunxi.dg.base.center.openapi.proxy.price.IPlaceOrderGoodsApiProxy;
import com.yunxi.dg.base.center.price.dto.request.SkuSupplyPriceQueryV2ReqDto;
import com.yunxi.dg.base.center.price.dto.response.SkuPolicyPriceRespDto;
import com.yunxi.dg.base.center.price.proxy.query.IDgPriceQueryV2ApiProxy;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.center.trade.constants.DgDeliveryModelTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgChannelSupplyPriceConfigDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.eo.DgChannelSupplyPriceConfigEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.vo.DgB2COrderThroughRespDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgOmsSupplyPriceValiateAction
extends AbstractCisBaseStatemachineAction<DgB2COrderActionDefineEnum, DgB2COrderMachineStatus, DgB2COrderMachineEvents, Object, RestResponse<Void>, DgB2COrderThroughRespDto> {
    private static final Logger log = LoggerFactory.getLogger(DgOmsSupplyPriceValiateAction.class);
    @Resource
    private IDgShopQueryApiProxy shopQueryApiProxy;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPriceQueryV2ApiProxy priceQueryV2ApiProxy;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;
    @Resource
    private IDgCustomerQueryApiProxy dgCustomerQueryApiProxy;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private IPlaceOrderGoodsApiProxy placeOrderGoodsApiProxy;
    @Resource
    private IDgChannelSupplyPriceConfigDomain dgChannelSupplyPriceConfigDomain;

    public DgOmsSupplyPriceValiateAction() {
        super((CisActionDefine)DgB2COrderActionDefineEnum.OMS_SUPPLY_PRICE_SAVE);
    }

    public RestResponse<Void> executeSub(DgB2COrderThroughRespDto throughDtoDefine, Object request) {
        log.info("[\u72b6\u6001\u673a]\u7279\u6b8a\u6e20\u9053\u4f9b\u8d27\u4ef7\u6821\u9a8c\uff08\u5929\u732b\u4f18\u54c1\u9700\u8981\u4fdd\u5b58\u4e2d\u53f0\u4f9b\u8d27\u4ef7,\u624b\u5de5\u521b\u5efa\u7684\u4eac\u4e1c\u5382\u9001\uff0c\u82cf\u5b81\u5382\u9001\uff09-action");
        if (StringUtils.isNotBlank((CharSequence)throughDtoDefine.getDeliveryModelCode()) && DgDeliveryModelTypeEnum.CONSIGN_MODEL.getCode().equals(throughDtoDefine.getDeliveryModelCode())) {
            log.info("\u5bc4\u552e\u53d1\u8d27\u4e0d\u6821\u9a8c\u4f9b\u8d27\u4ef7");
            return RestResponse.VOID;
        }
        DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(throughDtoDefine.getId());
        DgShopRespDto shopExtRespDto = (DgShopRespDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.getShopDetailById(snapshotEo.getShopId()));
        AssertUtils.notNull((Object)shopExtRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u5e97\u94fa\u4fe1\u606f");
        if (shopExtRespDto.getStoreType().equals(1)) {
            log.info("\u76f4\u8425\u5e97\u94fa\u4e0d\u6821\u9a8c\u4ef7\u683c");
            return RestResponse.VOID;
        }
        DgChannelSupplyPriceConfigEo supplyPriceConfigEo = this.dgChannelSupplyPriceConfigDomain.queryEoByChannel(snapshotEo.getChannelCode());
        if (supplyPriceConfigEo != null && YesOrNoEnum.YES.getType().toString().equals(supplyPriceConfigEo.getSupplyPriceObtainWay())) {
            if (2 == shopExtRespDto.getStoreType() || 3 == shopExtRespDto.getStoreType() || 4 == shopExtRespDto.getStoreType()) {
                log.info("\u7ecf\u9500\uff0c\u5206\u9500\uff0c\u5382\u9001\u5e97\u94fa\u7c7b\u578b\u9700\u8981\u6821\u9a8c\u4f9b\u8d27\u4ef7");
                log.info("\u7ecf\u9500\uff0c\u5206\u9500\u6839\u636e\u914d\u7f6e\u6821\u9a8c\u4f9b\u8d27\u4ef7");
                if (shopExtRespDto.getSettlementAmount() == 1) {
                    log.info("\u7ecf\u9500\uff0c\u5206\u9500\u5e97\u94fa\u5f00\u542f\u4e86\u4f9b\u8d27\u4ef7\u6821\u9a8c");
                    this.validateSuuplyPrice(throughDtoDefine, snapshotEo);
                }
            }
        } else {
            log.info("\u914d\u7f6e\u4e3a\u4e0d\u4eceOMS\u83b7\u53d6\u4f9b\u8d27\u4ef7\u7684\u6e20\u9053\uff0c\u5982\u679c\u662f\u7279\u4ef7\u8865\u53d1\u8d60\u54c1\u5355\uff0c\u53d6\u5b9e\u4ed8\u91d1\u989d;\u5982\u679c\u4e3a\u624b\u5de5\u5355\uff0c\u4e5f\u9700\u8981\u4eceOMS\u4e2d\u53f0\u83b7\u53d6\u4f9b\u8d27\u4ef7");
            if (shopExtRespDto.getIsSpecialModel() != null && YesOrNoEnum.YES.getType().equals(shopExtRespDto.getIsSpecialModel()) && (SaleOrderTypeEnum.REPLENISH_ORDER.getType().equals(throughDtoDefine.getOrderType()) || SaleOrderTypeEnum.SPECIAL_ORDER.getType().equals(throughDtoDefine.getOrderType()))) {
                log.info("\u5e97\u94fa\u5f00\u542f\u4e86\u7279\u4ef7/\u8d60\u54c1\u53d1\u8d27\u6a21\u5f0f\uff0c\u5e76\u4e14\u8ba2\u5355\u7c7b\u578b\u4e3a\u8865\u53d1/\u7279\u4ef7,\u4e0d\u9700\u8981\u6821\u9a8c\u4e2d\u53f0OMS\u4f9b\u8d27\u4ef7");
            } else {
                List labelCode = this.dgOrderLabelRecordDomain.queryExistLabelCode(throughDtoDefine.getId(), Collections.singletonList(DgOrderLabelEnum.SALE_ORDER_CREATE));
                if (CollectionUtils.isNotEmpty((Collection)labelCode)) {
                    if (shopExtRespDto.getStoreType().equals(1)) {
                        log.info("\u76f4\u8425\u5e97\u94fa\u4e0d\u6821\u9a8c\u4ef7\u683c");
                        return RestResponse.VOID;
                    }
                    if (2 == shopExtRespDto.getStoreType() || 3 == shopExtRespDto.getStoreType() || 4 == shopExtRespDto.getStoreType()) {
                        log.info("\u7ecf\u9500\uff0c\u5206\u9500\uff0c\u5382\u9001\u5e97\u94fa\u7c7b\u578b\u9700\u8981\u6821\u9a8c\u4f9b\u8d27\u4ef7");
                        if (shopExtRespDto.getSettlementAmount() == 1) {
                            log.info("\u5e97\u94fa\u5f00\u542f\u4e86\u4f9b\u8d27\u4ef7\u6821\u9a8c");
                            this.validateSuuplyPrice(throughDtoDefine, snapshotEo);
                        }
                    }
                }
            }
        }
        return RestResponse.VOID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateSuuplyPrice(DgB2COrderThroughRespDto throughDtoDefine, DgPerformOrderSnapshotEo snapshotEo) {
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryNotCancelOrderLineInfoByOrderId(throughDtoDefine.getId());
        log.info("\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderLineDtos));
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("yunxi-dg-base-center-trade", "B2C_SUPPLY_PRICE_WAY"));
        if (null == dictDto || dictDto.getValue().equals("1")) {
            ArrayList reqDtos = Lists.newArrayList();
            for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
                SkuSupplyPriceQueryV2ReqDto skuSupplyPriceQueryV2ReqDto = new SkuSupplyPriceQueryV2ReqDto();
                skuSupplyPriceQueryV2ReqDto.setSkuId(orderLineDto.getSkuId());
                skuSupplyPriceQueryV2ReqDto.setSaleCompanyId(Long.valueOf(-1L));
                skuSupplyPriceQueryV2ReqDto.setShopId(snapshotEo.getShopId());
                reqDtos.add(skuSupplyPriceQueryV2ReqDto);
            }
            log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u8bf7\u6c42\u53c2\u6570,customerId:{},reqDtso:{}", (Object)snapshotEo.getCustomerId(), (Object)JSON.toJSONString((Object)reqDtos));
            List priceRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.priceQueryV2ApiProxy.queryCustomerSkuPolicySupplyPrice(snapshotEo.getCustomerId(), (List)reqDtos));
            log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u8bf7\u6c42\u7ed3\u679c,reqDtso:{}", (Object)JSON.toJSONString((Object)priceRespDtos));
            if (!CollectionUtils.isNotEmpty((Collection)priceRespDtos)) throw new BizException("\u5f53\u524d\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u672a\u8bbe\u7f6e");
            HashMap policyPriceRespDtoMap = CollectionUtil.isNotEmpty((Collection)priceRespDtos) ? priceRespDtos.stream().collect(Collectors.toMap(SkuPolicyPriceRespDto::getSkuId, Function.identity(), (a, b) -> a)) : new HashMap();
            for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
                SkuPolicyPriceRespDto skuPolicyPriceRespDto = (SkuPolicyPriceRespDto)policyPriceRespDtoMap.get(orderLineDto.getSkuId());
                log.info("\u5546\u54c1\u3010{}\u3011\u4f9b\u8d27\u4ef7\u4e3a\uff1a{}", (Object)orderLineDto.getSkuCode(), skuPolicyPriceRespDto != null ? skuPolicyPriceRespDto.getSupplyPrice() : "");
                if (skuPolicyPriceRespDto != null && skuPolicyPriceRespDto.getSupplyPrice() != null) continue;
                throw new BizException("\u5546\u54c1\uff1a" + orderLineDto.getSkuCode() + "\u672a\u8bbe\u7f6e\u4f9b\u8d27\u4ef7");
            }
            return;
        } else {
            Map<Integer, List<DgPerformOrderLineDto>> orderLineGroupByGiftFlag = orderLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineDto::getGiftFlag));
            SkuSupplyPriceQueryReqDto reqDto = new SkuSupplyPriceQueryReqDto();
            reqDto.setShopCode(throughDtoDefine.getPerformOrderSnapshotDto().getShopCode());
            reqDto.setCustomerId(throughDtoDefine.getPerformOrderSnapshotDto().getCustomerId());
            reqDto.setCustomerCode(throughDtoDefine.getPerformOrderSnapshotDto().getCustomerCode());
            ArrayList orderLineList = new ArrayList();
            reqDto.setOrderLineList(orderLineList);
            orderLineDtos.forEach(line -> {
                AccountBalanceOrderLineReqDto dto = new AccountBalanceOrderLineReqDto();
                dto.setSkuId(line.getSkuId());
                dto.setSkuCode(line.getSkuCode());
                dto.setGiftFlag(line.getGiftFlag());
                dto.setSettlementPrice(line.getPayAmount());
                orderLineList.add(dto);
            });
            RestResponse skuSupplyPriceResp = this.placeOrderGoodsApiProxy.getSkuSupplyPrice(reqDto);
            log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u8bf7\u6c42\u7ed3\u679c,reqDtso:{}", (Object)JSON.toJSONString((Object)skuSupplyPriceResp));
            List skuSupplyPriceRespDtos = (List)skuSupplyPriceResp.getData();
            if (!CollectionUtils.isNotEmpty((Collection)skuSupplyPriceRespDtos) || !Objects.equals(skuSupplyPriceResp.getResultCode(), "0")) throw new BizException("\u5f53\u524d\u5546\u54c1\u4ef7\u683c\u653f\u7b56\u672a\u8bbe\u7f6e-" + skuSupplyPriceResp.getResultMsg());
            HashMap policyPriceRespDtoMap = CollectionUtil.isNotEmpty((Collection)skuSupplyPriceRespDtos) ? skuSupplyPriceRespDtos.stream().collect(Collectors.toMap(SkuSupplyPriceRespDto::getSkuId, Function.identity(), (a, b) -> a)) : new HashMap();
            for (DgPerformOrderLineDto orderLineDto : orderLineDtos) {
                SkuSupplyPriceRespDto skuPolicyPriceRespDto = (SkuSupplyPriceRespDto)policyPriceRespDtoMap.get(orderLineDto.getSkuId());
                log.info("\u5546\u54c1\u3010{}\u3011\u4f9b\u8d27\u4ef7\u4e3a\uff1a{}", (Object)orderLineDto.getSkuCode(), skuPolicyPriceRespDto != null ? skuPolicyPriceRespDto.getSupplyPrice() : "");
                if (skuPolicyPriceRespDto != null && skuPolicyPriceRespDto.getSupplyPrice() != null) continue;
                throw new BizException("\u5546\u54c1\uff1a" + orderLineDto.getSkuCode() + "\u672a\u8bbe\u7f6e\u4f9b\u8d27\u4ef7");
            }
        }
    }
}

