/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.f2b.order.config.engine.action;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.statemachine.engine.action.AbstractCisBaseStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.share.dto.entity.DgInventorySupplyStrategyQueryReqDto;
import com.yunxi.dg.base.center.share.proxy.strategy.IDgInventorySupplyStrategyQueryApiProxy;
import com.yunxi.dg.base.center.trade.constants.CustomOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgOrderSourceModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAttachmentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrItemExtDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAttachmentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.execute.DgB2BOrderStatemachineExecutor;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant.DgF2BOrderActionDefineEnum;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant.DgF2BOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant.DgF2BOrderMachineStatus;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.vo.DgF2BOrderThroughRespDto;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgF2BCreateB2BOrderAction
extends AbstractCisBaseStatemachineAction<DgF2BOrderActionDefineEnum, DgF2BOrderMachineStatus, DgF2BOrderMachineEvents, Object, Boolean, DgF2BOrderThroughRespDto> {
    private static final Logger log = LoggerFactory.getLogger(DgF2BCreateB2BOrderAction.class);
    @Resource
    private DgB2BOrderStatemachineExecutor dgB2BOrderStatemachineExecutor;
    @Resource
    private IDgPerformOrderAddrItemDomain dgPerformOrderAddrItemDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderAttachmentDomain performOrderAttachmentDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgInventorySupplyStrategyQueryApiProxy dgInventorySupplyStrategyQueryApiProxy;
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;

    public DgF2BCreateB2BOrderAction() {
        super((CisActionDefine)DgF2BOrderActionDefineEnum.B2B_ORDER_FULFILLMENT, true);
    }

    public Boolean executeSub(DgF2BOrderThroughRespDto dto, Object request) {
        Boolean flag = Boolean.FALSE;
        ArrayList b2bOrderList = Lists.newArrayList();
        try {
            DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(dto.getId());
            List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(performOrderRespDto.getId());
            List orderItemLineDtoList = this.performOrderItemLineDomain.queryInfoByOrderId(performOrderRespDto.getId());
            List attachmentEos = this.performOrderAttachmentDomain.queryAttachmentByOrderId(performOrderRespDto.getId());
            DgBizPerformOrderReqDto performOrderReqDto = this.converB2bOrderInfoReqDto(performOrderRespDto);
            performOrderReqDto.setAttachmentFileList(BeanUtil.copyToList((Collection)attachmentEos, DgPerformOrderAttachmentDto.class));
            if (Arrays.stream(CustomOrderTypeEnum.values()).anyMatch(type -> type.getType().equals(performOrderReqDto.getOrderType()))) {
                List addrItemExtDtos = this.dgPerformOrderAddrItemDomain.queryItemAddrInfo(performOrderRespDto.getId());
                b2bOrderList.addAll(this.splitChangeDeliveryOrder(performOrderReqDto, addrItemExtDtos, orderLineDtoList, orderItemLineDtoList));
            } else {
                DgPerformOrderAddrDto orderAddrDasOne = this.performOrderAddrDomain.queryAddressByOrderId(performOrderRespDto.getId());
                performOrderReqDto.setOrderAddrReqDto((DgPerformOrderAddrReqDto)BeanUtil.copyProperties((Object)orderAddrDasOne, DgPerformOrderAddrReqDto.class, (String[])new String[0]));
                performOrderReqDto.setOrderLineDetails(orderLineDtoList);
                performOrderReqDto.setOrderItemLineDtoList(orderItemLineDtoList);
                b2bOrderList.add(performOrderReqDto);
            }
            if (CollectionUtils.isNotEmpty((Collection)b2bOrderList)) {
                for (DgBizPerformOrderReqDto dgBizPerformOrderReqDto : b2bOrderList) {
                    Optional.ofNullable(this.dgB2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), null, dgBizPerformOrderReqDto, (Object)DgB2BOrderMachineEvents.CHANNEL_ORDER_SYNC).getActionResultSubRestResponse(Long.class)).orElseGet(RestResponse::new);
                }
            }
        }
        catch (Exception e) {
            flag = Boolean.FALSE;
            e.printStackTrace();
            log.error("\u6e20\u9053\u521b\u5efaB2B\u8ba2\u5355\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return flag;
    }

    private List<DgBizPerformOrderReqDto> splitChangeDeliveryOrder(DgBizPerformOrderReqDto performOrderRespDto, List<DgPerformOrderAddrItemExtDto> addrItemExtDtos, List<DgPerformOrderLineDto> orderLineDtoList, List<DgPerformOrderItemLineDto> orderItemLineDtoList) {
        ArrayList changeDeliveryOrderList = Lists.newArrayList();
        Map orderLineDtoMap = orderLineDtoList.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
        Map orderItemLineMap = orderItemLineDtoList.stream().collect(Collectors.toMap(DgPerformOrderItemLineDto::getOrderLineId, Function.identity()));
        HashMap addrOrderLineMap = Maps.newHashMap();
        HashMap addrOrderItemLineMap = Maps.newHashMap();
        HashMap addrMap = Maps.newHashMap();
        for (DgPerformOrderAddrItemExtDto dgPerformOrderAddrItemExtDto : addrItemExtDtos) {
            if (dgPerformOrderAddrItemExtDto.getItemNum() == null || dgPerformOrderAddrItemExtDto.getItemNum().compareTo(BigDecimal.ZERO) == 0) continue;
            addrMap.putIfAbsent(dgPerformOrderAddrItemExtDto.getOrderAddrId(), dgPerformOrderAddrItemExtDto);
            List addrOrderLineDtoList = addrOrderLineMap.getOrDefault(dgPerformOrderAddrItemExtDto.getOrderAddrId(), Lists.newArrayList());
            DgPerformOrderLineDto dgPerformOrderLineDetailDto = (DgPerformOrderLineDto)orderLineDtoMap.get(dgPerformOrderAddrItemExtDto.getOrderItemId());
            HashMap map = Maps.newHashMap();
            map.put("stocksCode", dgPerformOrderAddrItemExtDto.getStocksCode());
            dgPerformOrderLineDetailDto.setExtension(JSON.toJSONString((Object)map));
            addrOrderLineDtoList.add(dgPerformOrderLineDetailDto);
            addrOrderLineMap.put(dgPerformOrderAddrItemExtDto.getOrderAddrId(), addrOrderLineDtoList);
            List addrOrderItemLineDtoList = addrOrderItemLineMap.getOrDefault(dgPerformOrderAddrItemExtDto.getOrderAddrId(), Lists.newArrayList());
            DgPerformOrderItemLineDto addrOrderItemLineDto = (DgPerformOrderItemLineDto)orderItemLineMap.get(dgPerformOrderAddrItemExtDto.getOrderItemId());
            addrOrderItemLineDto.setExtension(JSON.toJSONString((Object)map));
            addrOrderItemLineDtoList.add(addrOrderItemLineDto);
            addrOrderItemLineMap.put(dgPerformOrderAddrItemExtDto.getOrderAddrId(), addrOrderItemLineDtoList);
        }
        for (Map.Entry entry : addrMap.entrySet()) {
            DgPerformOrderAddrItemExtDto addrItemExtDto = (DgPerformOrderAddrItemExtDto)entry.getValue();
            List orderLineDtos = (List)addrOrderLineMap.get(entry.getKey());
            List itemLineDtos = addrOrderItemLineMap.getOrDefault(entry.getKey(), Lists.newArrayList());
            if (CollectionUtils.isEmpty((Collection)orderLineDtos)) continue;
            DgBizPerformOrderReqDto newOrderReqDto = new DgBizPerformOrderReqDto();
            CubeBeanUtils.copyProperties((Object)newOrderReqDto, (Object)performOrderRespDto, (String[])new String[0]);
            newOrderReqDto.setMainOrderNo(newOrderReqDto.getSaleOrderNo());
            newOrderReqDto.getPerformOrderExtensionDto().setAddrSaleOrderNo(addrItemExtDto.getAddrSaleOrderNo());
            newOrderReqDto.getPerformOrderExtensionDto().setPurchaseOrderNo(addrItemExtDto.getPurchaseOrderNo());
            DgPerformOrderAddrReqDto performOrderAddrDto = (DgPerformOrderAddrReqDto)BeanUtil.copyProperties((Object)addrItemExtDto, DgPerformOrderAddrReqDto.class, (String[])new String[]{"id", "createTime", "createPerson", "updateTime", "updatePerson"});
            newOrderReqDto.setOrderAddrReqDto(performOrderAddrDto);
            newOrderReqDto.setOrderLineDetails(orderLineDtos);
            newOrderReqDto.setOrderItemLineDtoList(itemLineDtos);
            this.converItemData(newOrderReqDto);
            changeDeliveryOrderList.add(newOrderReqDto);
        }
        return changeDeliveryOrderList;
    }

    private DgBizPerformOrderReqDto converB2bOrderInfoReqDto(DgPerformOrderRespDto performOrderRespDto) {
        DgBizPerformOrderReqDto performOrderReqDto = new DgBizPerformOrderReqDto();
        CubeBeanUtils.copyProperties((Object)performOrderReqDto, (Object)performOrderRespDto, (String[])new String[]{"id", "saleOrderNo", "createTime", "createPerson", "updateTime", "updatePerson"});
        performOrderReqDto.setOrderStatus(DgOmsSaleOrderStatus.WAIT_PICK.getCode());
        performOrderReqDto.setOmsSaleOrderStatus(DgOmsSaleOrderStatus.WAIT_PICK.getCode());
        performOrderReqDto.setBizModel(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode());
        performOrderReqDto.setOrderSourceModel(DgOrderSourceModelEnum.F2B.getCode());
        performOrderReqDto.setOrderSource(DgSaleOrderSourceEnum.CHANNEL_MALL.getType());
        performOrderReqDto.setPlatformOrderId(performOrderRespDto.getId());
        performOrderReqDto.setPlatformOrderNo(performOrderRespDto.getSaleOrderNo());
        performOrderReqDto.setPlatformCreateTime(performOrderRespDto.getCreateTime());
        performOrderReqDto.setAllowSplitFlag(Integer.valueOf(1));
        performOrderReqDto.getPerformOrderSnapshotDto().setChannelCode(DgOrderSourceModelEnum.F2B.getCode());
        performOrderReqDto.getPerformOrderSnapshotDto().setChannelName(DgOrderSourceModelEnum.F2B.getDesc());
        if (DgSaleOrderTypeEnum.OVERSEAS_ORDER.getType().equals(performOrderRespDto.getOrderType())) {
            DgInventorySupplyStrategyQueryReqDto strategyQueryReqDto = new DgInventorySupplyStrategyQueryReqDto();
            strategyQueryReqDto.setShopCode(performOrderRespDto.getPerformOrderSnapshotDto().getShopCode());
            List logicWarehouseCodes = (List)RestResponseHelper.extractData((RestResponse)this.dgInventorySupplyStrategyQueryApiProxy.queryDgLogicWarehouseByShopCode(strategyQueryReqDto));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)logicWarehouseCodes), (String)"\u6307\u5b9a\u903b\u8f91\u4ed3\u53d1\u8d27\u5931\u8d25-\u6839\u636e\u5e97\u94fa\u7f16\u53f7\u672a\u67e5\u5230\u903b\u8f91\u4ed3\u4fe1\u606f");
            LogicalWarehouseRespDto logicWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode((String)logicWarehouseCodes.get(0)));
            AssertUtils.notNull((Object)logicWarehouseRespDto, (String)String.format("\u6307\u5b9a\u903b\u8f91\u4ed3\u53d1\u8d27,%s\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728", logicWarehouseRespDto));
            performOrderReqDto.getPerformOrderWarehouseInfoDto().setLogicalWarehouseId(logicWarehouseRespDto.getId());
            performOrderReqDto.getPerformOrderWarehouseInfoDto().setLogicalWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
            performOrderReqDto.getPerformOrderWarehouseInfoDto().setLogicalWarehouseName(logicWarehouseRespDto.getWarehouseName());
            performOrderReqDto.getPerformOrderWarehouseInfoDto().setDefaultLogicalWarehouseId(logicWarehouseRespDto.getId());
            performOrderReqDto.getPerformOrderWarehouseInfoDto().setDefaultLogicalWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
            performOrderReqDto.getPerformOrderWarehouseInfoDto().setDefaultLogicalWarehouseName(logicWarehouseRespDto.getWarehouseName());
            performOrderReqDto.getPerformOrderWarehouseInfoDto().setDeliveryLogicalWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
        }
        return performOrderReqDto;
    }

    private void converItemData(DgBizPerformOrderReqDto dgBizPerformOrderReqDto) {
        BigDecimal goodsTotalAmount = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal payAmount = BigDecimal.ZERO;
        BigDecimal realPayAmount = BigDecimal.ZERO;
        BigDecimal goodsTotalNum = BigDecimal.ZERO;
        for (DgPerformOrderLineDto orderLineDto : dgBizPerformOrderReqDto.getOrderLineDetails()) {
            if (orderLineDto.getItemNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            orderLineDto.setDeliveryItemBatchNo(orderLineDto.getBatchNo());
            orderLineDto.setLogicalWarehouseId(dgBizPerformOrderReqDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseId());
            orderLineDto.setLogicalWarehouseCode(dgBizPerformOrderReqDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseCode());
            orderLineDto.setLogicalWarehouseName(dgBizPerformOrderReqDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseName());
            orderLineDto.setPlatformOrderId(dgBizPerformOrderReqDto.getId());
            orderLineDto.setPlatformOrderNo(dgBizPerformOrderReqDto.getSaleOrderNo());
            orderLineDto.setPlatformOrderItemNo(orderLineDto.getId().toString());
            goodsTotalNum = goodsTotalNum.add(orderLineDto.getItemNum());
            Map<String, BigDecimal> lineAmountDtoMap = orderLineDto.getAmountDtoList().stream().filter(amountDto -> Objects.equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode(), amountDto.getAmountSource())).collect(Collectors.toMap(DgPerformOrderLineAmountDto::getAccountType, DgPerformOrderLineAmountDto::getAmount, (e1, e2) -> e1));
            goodsTotalAmount = goodsTotalAmount.add(lineAmountDtoMap.getOrDefault(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode(), BigDecimal.ZERO));
            discountAmount = discountAmount.add(lineAmountDtoMap.getOrDefault(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode(), BigDecimal.ZERO));
            payAmount = payAmount.add(lineAmountDtoMap.getOrDefault(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode(), BigDecimal.ZERO));
            realPayAmount = realPayAmount.add(lineAmountDtoMap.getOrDefault(DgOmsOrderAmountTypeEnum.LINE_SETTLEMENT_AMOUNT.getCode(), BigDecimal.ZERO));
        }
        DgPerformOrderAmountDto amountDto2 = dgBizPerformOrderReqDto.getPerformOrderAmountDto();
        amountDto2.setGoodsTotalNum(goodsTotalNum);
        amountDto2.setSaleTotalAmount(goodsTotalAmount);
        amountDto2.setGoodsTotalAmount(goodsTotalAmount);
        amountDto2.setDiscountAmount(discountAmount);
        amountDto2.setPayAmount(payAmount);
        amountDto2.setOrderTotalAmount(payAmount);
        amountDto2.setRealPayAmount(realPayAmount);
        amountDto2.setMerchantReceivableAmount(realPayAmount);
    }
}

