/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.f2b.order.config.engine.guard;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisGuardResult;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelAccountService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelOrderService;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.config.engine.guard.AbstractF2BGByAGuard;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.vo.DgF2BOrderThroughRespDto;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgF2BCustomerPeriodLimitGuard
extends AbstractF2BGByAGuard<Object> {
    private static Logger logger = LoggerFactory.getLogger(DgF2BCustomerPeriodLimitGuard.class);
    @Resource
    private IChannelOrderService channelOrderService;
    @Resource
    private IChannelAccountService channelAccountService;

    public DgF2BCustomerPeriodLimitGuard() {
        super("\u6821\u9a8c\u5ba2\u6237\u8d26\u671f\u4e0a\u9650\u989d\u5ea6", true);
    }

    public CisGuardResult actionGuard(DgF2BOrderThroughRespDto through, Object request) {
        if (Objects.equals(DgSaleOrderTypeEnum.INTACT_GOODS_RECEIVE.getType(), through.getOrderType())) {
            return new CisGuardResult(Boolean.TRUE.booleanValue());
        }
        Boolean isCustomerPeriodLimit = true;
        try {
            List accountDtos = this.channelAccountService.queryCapitalAccount(through.getSaleOrderNo(), (List)Lists.newArrayList((Object[])new AccountCategoryEnum[]{AccountCategoryEnum.CAPITAL}));
            logger.info("\u6821\u9a8c\u5ba2\u6237\u8d26\u671f\u4e0a\u9650\u989d\u5ea6\u8fd4\u56de\u7ed3\u679c={}", JSON.toJSON((Object)accountDtos));
            if (CollectionUtils.isEmpty((Collection)accountDtos)) {
                return new CisGuardResult(isCustomerPeriodLimit.booleanValue());
            }
            List yfkAccountList = accountDtos.stream().filter(a -> Objects.equals(a.getAccountType(), "YFK")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(yfkAccountList)) {
                logger.info("\u9884\u4ed8\u6b3e\u8d26\u6237\u5927\u5c0f\uff1a{}", (Object)yfkAccountList.size());
                BigDecimal disposable = BigDecimal.ZERO;
                BigDecimal paymentPeriodLimit = null;
                for (AccountDto accountDto : yfkAccountList) {
                    if (Objects.nonNull(accountDto.getPaymentPeriodLimit())) {
                        paymentPeriodLimit = Objects.isNull(paymentPeriodLimit) ? BigDecimal.ZERO : paymentPeriodLimit;
                        paymentPeriodLimit = paymentPeriodLimit.add(accountDto.getPaymentPeriodLimit());
                    }
                    if (!Objects.nonNull(accountDto.getDisposable())) continue;
                    disposable = disposable.add(accountDto.getDisposable());
                }
                if (Objects.nonNull(paymentPeriodLimit) && Objects.nonNull(disposable) && disposable.compareTo(BigDecimal.ZERO) < 0) {
                    disposable = disposable.add(paymentPeriodLimit);
                }
                logger.info("\u6821\u9a8c\u5ba2\u6237\u8d26\u671f\u53ef\u63d0\u73b0\u4f59\u989d={},paymentPeriodLimit={}", (Object)disposable, paymentPeriodLimit);
                if (Objects.nonNull(paymentPeriodLimit) && Objects.nonNull(disposable) && disposable.compareTo(BigDecimal.ZERO) < 0) {
                    isCustomerPeriodLimit = false;
                }
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return new CisGuardResult(false, "\u6821\u9a8c\u5ba2\u6237\u8d26\u671f\u4e0a\u9650\u7684\u5f02\u5e38:" + e.getMessage());
        }
        return new CisGuardResult(isCustomerPeriodLimit.booleanValue(), through.getPerformOrderSnapshotDto().getCustomerName() + "\u5ba2\u6237\u8ba2\u5355\u91d1\u989d\u5df2\u8fbe\u8d26\u671f\u4e0a\u9650\u989d\u5ea6\uff0c\u8bf7\u5904\u7406\u540e\u518d\u8d27\u8bc4");
    }
}

