/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.f2b.order.config.engine.guard;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisGuardResult;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.enums.OrderAddrApplyAuditStatusEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.oa.dto.BaseResponse;
import com.yunxi.dg.base.center.oa.proxy.oa.IExternalOaApiProxy;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderAddrApplyLineDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrApplyDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrApplyDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrApplyLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrApplyEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderAddrApplyService;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.config.engine.guard.AbstractF2BGByAGuard;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.vo.DgF2BOrderThroughRespDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgF2BNeedLockActionGuard
extends AbstractF2BGByAGuard<Object> {
    private static final Logger log = LoggerFactory.getLogger(DgF2BNeedLockActionGuard.class);
    @Resource
    private IDgPerformOrderAddrApplyDomain dgPerformOrderAddrApplyDomain;
    @Resource
    private IDgPerformOrderAddrApplyLineDas dgPerformOrderAddrApplyLineDas;
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderAddrApplyService dgPerformOrderAddrApplyService;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IContext context;
    @Resource
    private IExternalOaApiProxy externalOaApiProxy;

    public DgF2BNeedLockActionGuard() {
        super("\u662f\u5426\u9700\u8981\u6302\u8d77\u8ba2\u5355", false);
    }

    public CisGuardResult actionGuard(DgF2BOrderThroughRespDto through, Object request) {
        Long orderId = through.getId();
        ArrayList orderIds = Lists.newArrayList((Object[])new Long[]{orderId});
        List addrApplyEos = this.dgPerformOrderAddrApplyDomain.queryWaitAuditAddrInfo((List)orderIds);
        boolean locked = false;
        if (CollectionUtils.isNotEmpty((Collection)addrApplyEos)) {
            List orderRespDtos;
            List lineEos;
            locked = true;
            DgPerformOrderAddrApplyEo applyEo = (DgPerformOrderAddrApplyEo)addrApplyEos.get(0);
            ArrayList addressIds = null;
            if (Objects.equals(applyEo.getChangeType(), 1) && applyEo.getAddressId() != null && CollectionUtils.isNotEmpty((Collection)(lineEos = this.dgPerformOrderAddrApplyLineDas.queryWaitAuditOrderId((List)(addressIds = Lists.newArrayList((Object[])new Long[]{applyEo.getAddressId()})), (List)orderIds)))) {
                throw new BizException("\u5df2\u5b58\u5728\u5f85OA\u5ba1\u6279\u7684\u5730\u5740\u4fee\u6539\u4fe1\u606f\uff0c\u5f53\u524d\u4fee\u6539\u7684\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u63d0\u4ea4");
            }
            if (CollectionUtils.isNotEmpty(addressIds) && CollectionUtils.isNotEmpty((Collection)(orderRespDtos = this.dgPerformOrderInfoDomain.queryOrderByAddressIds(addressIds)))) {
                for (DgPerformOrderRespDto respDto : orderRespDtos) {
                    try {
                        this.dgPerformOrderAddrApplyService.lockPMSOrder(respDto.getId(), true);
                    }
                    catch (Exception e) {
                        locked = false;
                        log.info("\u4f9b\u5e94\u94fe\u8ba2\u5355\u6302\u8d77\u5931\u8d25:{}", (Object)e.getMessage());
                    }
                }
                if (!locked) {
                    throw new BizException("\u4fee\u6539\u7684\u8ba2\u5355\u5730\u5740\u5173\u8054\u7684\u4f9b\u5e94\u94fe\u8ba2\u5355\u6302\u8d77\u5931\u8d25");
                }
            }
            if (applyEo.getAuditStatus().equals(OrderAddrApplyAuditStatusEnum.WAIT_COMMIT.getCode())) {
                ArrayList dtos = Lists.newArrayList();
                DgPerformOrderAddrApplyDto applyDto = (DgPerformOrderAddrApplyDto)BeanUtil.copyProperties((Object)applyEo, DgPerformOrderAddrApplyDto.class, (String[])new String[0]);
                dtos.add(applyDto);
                DgPerformOrderAddrApplyLineDto alDto = new DgPerformOrderAddrApplyLineDto();
                if (Objects.equals(applyEo.getChangeType(), 1) && applyEo.getAddressId() != null) {
                    LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
                    lqw.eq(DgPerformOrderAddrEo::getOrderId, (Object)orderId);
                    lqw.eq(DgPerformOrderAddrEo::getAddressId, (Object)applyEo.getAddressId());
                    lqw.eq(BaseEo::getDr, (Object)0);
                    DgPerformOrderAddrEo orderAddrEo = (DgPerformOrderAddrEo)this.dgPerformOrderAddrDomain.getMapper().selectOne((Wrapper)lqw);
                    AssertUtils.notNull((Object)orderAddrEo, (String)"\u8ba2\u5355\u5730\u5740\u672a\u627e\u5230");
                    alDto.setPhoneNumber(orderAddrEo.getReceivePhone());
                    alDto.setRecipientName(orderAddrEo.getReceiveName());
                    alDto.setProvinceCityDistrict(StringUtils.join((Object[])new String[]{orderAddrEo.getProvince(), orderAddrEo.getCity(), orderAddrEo.getCounty()}));
                    alDto.setDetailedAddress(orderAddrEo.getReceiveAddress());
                    alDto.setOrderAddrId(orderAddrEo.getId());
                    alDto.setAddressId(applyEo.getAddressId());
                }
                alDto.setOrderId(orderId);
                alDto.setApplyId(applyEo.getId());
                alDto.setOrderStatus(DgF2BOrderStatus.forCode((String)through.getOrderStatus()).getDesc());
                alDto.setSaleOrderNo(through.getSaleOrderNo());
                applyDto.setApplyLineDtos((List)Lists.newArrayList((Object[])new DgPerformOrderAddrApplyLineDto[]{alDto}));
                applyDto.setUserId(this.context.userId());
                applyDto.setUpdatePerson(this.context.userName());
                applyEo.setAuditStatus(OrderAddrApplyAuditStatusEnum.WAIT_AUDIT.getCode());
                this.dgPerformOrderAddrApplyDomain.updateSelective((BaseEo)applyEo);
                this.dgPerformOrderAddrApplyService.sendPushOaMsg((List)dtos);
            } else {
                log.error("\u8ba2\u5355\u5730\u5740\u5df2\u7ecf\u63d0\u4ea4OA\u5ba1\u6279\uff1a{}", (Object)orderId);
            }
        } else {
            List lineEos;
            List addrDtos = this.performOrderAddrDomain.queryByOrderId(orderId);
            List addressIds = addrDtos.stream().filter(o -> o.getAddressId() != null).map(DgPerformOrderAddrDto::getAddressId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(addressIds) && CollectionUtils.isNotEmpty((Collection)(lineEos = this.dgPerformOrderAddrApplyLineDas.queryWaitAuditOrderId((List)Lists.newArrayList(addressIds), (List)orderIds)))) {
                log.info("\u8ba2\u5355\u5730\u5740\u88ab\u4fee\u6539\uff0c\u5f53\u524d\u8ba2\u5355\u6267\u884c\u6302\u8d77\u903b\u8f91\uff1a{}", (Object)orderId);
                this.dgPerformOrderAddrApplyService.lockPMSOrder(orderId, true);
                locked = true;
            }
        }
        return new CisGuardResult(locked);
    }

    public String getOaChannelMapping(String shopCode) {
        String code = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{shopCode})) {
            try {
                BaseResponse channelDate = this.externalOaApiProxy.getChannelDate(shopCode);
                if (channelDate.getSuccess().booleanValue()) {
                    code = ((Integer)channelDate.getData()).toString();
                }
            }
            catch (Exception e) {
                log.info("OA\u63a5\u53e3\u8bf7\u6c42\u9519\u8bef\uff1a{}", (Throwable)e);
            }
        }
        log.info("\u5e97\u94fa\u7f16\u7801\u8f6c\u6362\u6e20\u9053\u7f16\u7801\u7ed3\u679c\uff1a{} ==> {}", (Object)shopCode, code);
        return code;
    }
}

