/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.handler.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ActivityConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.FactoryDeliveryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderStockBatchDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoJoinReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderModTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderCreateBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.PayMethodBo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShopItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemRateDgRespDto;
import com.yunxi.dg.base.center.item.proxy.item.IItemRateDgQueryApiProxy;
import com.yunxi.dg.base.center.item.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.price.dto.request.SkuSupplyPriceQueryReqDto;
import com.yunxi.dg.base.center.price.dto.response.SkuPolicyPriceRespDto;
import com.yunxi.dg.base.center.price.proxy.query.IDgPriceQueryV2ApiProxy;
import com.yunxi.dg.base.center.shop.dto.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgTobShopQueryApiProxy;
import com.yunxi.dg.base.center.trade.dto.config.DgOrderConfigurationRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.ResultOrderOptReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BSingleOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgShopOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.activity.DgOrderActivityBizReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.AccountPreviewDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.CostAccountDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.OrderPreviewItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.dto.pay.DgPerformOrderPayReqDto;
import com.yunxi.dg.base.center.trade.service.help.PriceHelp;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderConfigurationService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgCalcActivityService;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.constant.DgF2BOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.f2b.order.execute.DgF2BOrderStatemachineExecutor;
import com.yunxi.dg.base.center.trade.statemachine.handler.IChannelOrderStatemachineHandle;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.center.trade.utils.OrderExpiredUtil;
import com.yunxi.dg.base.commons.annotations.OptLogEntryMethod;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChannelOrderStatemachineHandleImpl
implements IChannelOrderStatemachineHandle {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderStatemachineHandleImpl.class);
    @Resource
    private DgF2BOrderStatemachineExecutor dgF2BOrderStatemachineExecutor;
    @Resource
    private IDgOrderConfigurationService dgOrderConfigurationService;
    @Resource
    private IDgTobShopQueryApiProxy dgTobShopQueryApiProxy;
    @Resource
    private IDgCustomerQueryApiProxy dgCustomerQueryApiProxy;
    @Resource
    private IItemRateDgQueryApiProxy itemRateDgQueryApiProxy;
    @Resource
    private IDgPriceQueryV2ApiProxy dgPriceQueryV2ApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IDgCalcActivityService dgCalcActivityService;
    @Resource
    private NoGreateUtil noGreateUtil;

    @Override
    public RestResponse<DgOrderResultRespDto> save(String bizModel, DgOrderReqDto order) {
        DgOrderResultRespDto respDto = new DgOrderResultRespDto();
        ArrayList shopOrderResultRespDtos = Lists.newArrayList();
        this.validateCreateOrderParams(order);
        respDto.setShopOrderResultRespDtos((List)shopOrderResultRespDtos);
        return new RestResponse((Object)respDto);
    }

    private List<DgF2BSingleOrderContextVo> buildSingeOrderContextVos(DgOrderReqDto dgOrderReqDto) {
        ArrayList singleOrderContextVos = Lists.newArrayList();
        dgOrderReqDto.getShopOrderReqDtoList().stream().forEach(dgShopOrderReqDto -> {
            List accountPreviewDtoList;
            DgF2BSingleOrderContextVo vo = new DgF2BSingleOrderContextVo();
            HashMap shopItemGroup = Maps.newHashMap();
            ArrayList activityBizReqDtos = Lists.newArrayList();
            ArrayList costAccountDtos = Lists.newArrayList();
            shopItemGroup.put(dgShopOrderReqDto.getShopId(), dgShopOrderReqDto.getItemList());
            vo.setShopItemGroup((Map)shopItemGroup);
            Optional.ofNullable(dgShopOrderReqDto.getActivityList()).ifPresent(activityBizReqDtos::addAll);
            if (dgShopOrderReqDto.getDgPerformOrderPayReqDto() != null && CollectionUtils.isNotEmpty((Collection)dgShopOrderReqDto.getDgPerformOrderPayReqDto().getPayReqDtos()) && CollectionUtils.isNotEmpty(accountPreviewDtoList = dgShopOrderReqDto.getDgPerformOrderPayReqDto().getPayReqDtos().stream().map(dgBasePayReqDto -> {
                AccountPreviewDto accountPreviewDto = new AccountPreviewDto();
                accountPreviewDto.setAccountCategory(dgBasePayReqDto.getAccountCategory());
                accountPreviewDto.setAccountType(dgBasePayReqDto.getPayMethod());
                accountPreviewDto.setCurrUseBalance(dgBasePayReqDto.getPayAmount());
                accountPreviewDto.setItemCountsType(dgBasePayReqDto.getItemCountsType());
                return accountPreviewDto;
            }).collect(Collectors.toList()))) {
                CostAccountDto costAccountDto = new CostAccountDto();
                costAccountDto.setShopId(dgShopOrderReqDto.getShopId());
                costAccountDto.setAccountPreviewDtos(accountPreviewDtoList);
                costAccountDtos.add(costAccountDto);
            }
        });
        return null;
    }

    private void prepareData(DgF2BOrderContextVo dgF2BOrderContextVo) {
        ItemRateDgRespDto itemRateDgRespDto;
        DgOrderPreviewReqDto previewReqDto = dgF2BOrderContextVo.getPreviewReqDto();
        ArrayList skuIds = Lists.newArrayList();
        ArrayList itemIdList = Lists.newArrayList();
        for (OrderPreviewItemReqDto orderPreviewItemReqDto : previewReqDto.getItemList()) {
            skuIds.add(orderPreviewItemReqDto.getSkuId());
            itemIdList.add(orderPreviewItemReqDto.getItemId());
        }
        DgShopQueryReqDto dgShopQueryReqDto = new DgShopQueryReqDto();
        dgShopQueryReqDto.setIdList((List)Lists.newArrayList(dgF2BOrderContextVo.getShopItemGroup().keySet()));
        List dgShopRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgTobShopQueryApiProxy.queryListShop(dgShopQueryReqDto));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dgShopRespDtos), (String)"\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map shopMap = dgShopRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        dgF2BOrderContextVo.setShopMap(shopMap);
        DgCustomerRespDto dgCustomerRespDto = (DgCustomerRespDto)RestResponseHelper.extractData((RestResponse)this.dgCustomerQueryApiProxy.queryById(previewReqDto.getCustomerId()));
        AssertUtils.notNull((Object)dgCustomerRespDto, (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        dgF2BOrderContextVo.setDgCustomerRespDto(dgCustomerRespDto);
        ShopItemQueryDgReqDto shopItemQueryDgReqDto = new ShopItemQueryDgReqDto();
        shopItemQueryDgReqDto.setShopIdList((List)Lists.newArrayList(dgF2BOrderContextVo.getShopItemGroup().keySet()));
        shopItemQueryDgReqDto.setSkuIds((List)skuIds);
        shopItemQueryDgReqDto.setShelfStatus((List)Lists.newArrayList((Object[])new Integer[]{1}));
        shopItemQueryDgReqDto.setPageSize(Integer.valueOf(1000));
        log.info("\u5546\u54c1\u4fe1\u606f\u5165\u53c2\u6570\uff1a{}", JSON.toJSON((Object)shopItemQueryDgReqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryItemShopListByPage(shopItemQueryDgReqDto));
        log.info("\u5546\u54c1\u4fe1\u606f\u7ed3\u679c\uff1a{}", JSON.toJSON((Object)pageInfo));
        AssertUtils.isTrue((pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList()) ? 1 : 0) != 0, (String)"\u6240\u9009\u5546\u54c1\u5168\u90e8\u4e0a\u67b6\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map shelfItemMap = pageInfo.getList().stream().collect(Collectors.groupingBy(DgItemSkuRespDto::getShopId, Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1)));
        dgF2BOrderContextVo.setShelfItemMap(shelfItemMap);
        if (CollectionUtil.isNotEmpty((Collection)previewReqDto.getMaterialList())) {
            List materialIds = previewReqDto.getMaterialList().stream().map(OrderPreviewItemReqDto::getSkuId).collect(Collectors.toList());
            List materialSkuIds = previewReqDto.getMaterialList().stream().map(OrderPreviewItemReqDto::getSkuId).collect(Collectors.toList());
            ItemQueryDgReqDto shopMaterialQueryDgReqDto = new ItemQueryDgReqDto();
            shopMaterialQueryDgReqDto.setSkuIds(materialSkuIds);
            log.info("\u4fc3\u9500\u7269\u6599\u4fe1\u606f\u5165\u53c2\u6570\uff1a{}", JSON.toJSON((Object)shopMaterialQueryDgReqDto));
            List materialSkuRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.querySkuList(shopMaterialQueryDgReqDto));
            log.info("\u4fc3\u9500\u7269\u6599\u4fe1\u606f\u7ed3\u679c\uff1a{}", JSON.toJSON((Object)materialSkuRespDtos));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)materialSkuRespDtos), (String)"\u6240\u9009\u4fc3\u9500\u7269\u6599\u4fe1\u606f\u4e0d\u5b58\u5728");
            Map materialMap = materialSkuRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
            dgF2BOrderContextVo.setMaterialMap(materialMap);
            itemIdList.addAll(previewReqDto.getMaterialList().stream().map(OrderPreviewItemReqDto::getItemId).collect(Collectors.toList()));
            skuIds.addAll(materialIds);
        }
        if ((itemRateDgRespDto = (ItemRateDgRespDto)RestResponseHelper.extractData((RestResponse)this.itemRateDgQueryApiProxy.queryByItemIds((List)itemIdList))) != null && CollUtil.isNotEmpty((Map)itemRateDgRespDto.getItemRateMap())) {
            dgF2BOrderContextVo.setItemRateDgRespDtoMap(itemRateDgRespDto.getItemRateMap());
        }
        SkuSupplyPriceQueryReqDto priceQueryReqDto = new SkuSupplyPriceQueryReqDto();
        priceQueryReqDto.setCustomerId(previewReqDto.getCustomerId());
        priceQueryReqDto.setSkuIdList((List)skuIds);
        priceQueryReqDto.setShopIdList((List)Lists.newArrayList(shopMap.keySet()));
        List priceRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgPriceQueryV2ApiProxy.querySkuPolicySupplyPrice(priceQueryReqDto));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)priceRespDtos), (String)"\u6240\u9009\u5546\u54c1\u5168\u90e8\u6682\u65e0\u62a5\u4ef7");
        Map policyPriceDtoMap = priceRespDtos.stream().collect(Collectors.groupingBy(SkuPolicyPriceRespDto::getShopId, Collectors.toMap(SkuPolicyPriceRespDto::getSkuId, Function.identity(), (e1, e2) -> e1)));
        dgF2BOrderContextVo.setPolicyPriceDtoMap(policyPriceDtoMap);
        Map shopAccountDtoMap = Optional.ofNullable(dgF2BOrderContextVo.getPreviewReqDto().getCostAccountRespDtos()).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(CostAccountDto::getShopId, Function.identity(), (e1, e2) -> e1));
        dgF2BOrderContextVo.setShopAccountDtoMap(shopAccountDtoMap);
        List activityList = Optional.ofNullable(dgF2BOrderContextVo.getPreviewReqDto().getActivityList()).orElse(Lists.newArrayList());
        if (dgF2BOrderContextVo.getPreviewReqDto().getMatchActivity().booleanValue()) {
            shopMap.keySet().forEach(shopId -> {
                List itemIds = ((List)dgF2BOrderContextVo.getShopItemGroup().get(shopId)).stream().map(OrderPreviewItemReqDto::getItemId).collect(Collectors.toList());
                List promotionActivityList = this.dgCalcActivityService.getPromotionActivityList((List)Lists.newArrayList((Object[])new Long[]{shopId}), itemIds, dgCustomerRespDto.getId());
                if (CollectionUtils.isNotEmpty((Collection)promotionActivityList)) {
                    activityList.addAll(promotionActivityList);
                }
            });
        }
        Map<Long, List<DgOrderActivityBizReqDto>> shopJoinActivityMap = activityList.stream().collect(Collectors.groupingBy(DgOrderActivityBizReqDto::getShopId));
        dgF2BOrderContextVo.setActivityList(activityList);
        dgF2BOrderContextVo.setShopJoinActivityMap(shopJoinActivityMap);
    }

    private List<DgF2BSingleOrderContextVo> getDgF2BSingleOrderContextVos(DgF2BOrderContextVo dgF2BOrderContextVo, DgOrderReqDto dgOrderReqDto) {
        ArrayList dgF2BSingleOrderContextVos = Lists.newArrayList();
        for (DgShopOrderReqDto dgShopOrderReqDto : dgOrderReqDto.getShopOrderReqDtoList()) {
            DgF2BSingleOrderContextVo contextVo = new DgF2BSingleOrderContextVo();
            Long shopId = dgShopOrderReqDto.getShopId();
            String saleOrderNo = StringUtils.isNotBlank((CharSequence)dgShopOrderReqDto.getSaleOrderNo()) ? dgShopOrderReqDto.getSaleOrderNo() : this.noGreateUtil.generateF2BNo("DH", Integer.valueOf(4));
            dgShopOrderReqDto.setSaleOrderNo(saleOrderNo);
            DgShopRespDto dgShopRespDto = (DgShopRespDto)dgF2BOrderContextVo.getShopMap().get(dgShopOrderReqDto.getShopId());
            DgCustomerRespDto dgCustomerRespDto = dgF2BOrderContextVo.getDgCustomerRespDto();
            DgPerformOrderSnapshotDto snapshotDto = new DgPerformOrderSnapshotDto();
            snapshotDto.setCustomerId(dgCustomerRespDto.getId());
            snapshotDto.setCustomerCode(dgCustomerRespDto.getCode());
            snapshotDto.setCustomerName(dgCustomerRespDto.getName());
            snapshotDto.setShopId(dgShopRespDto.getId());
            snapshotDto.setShopCode(dgShopRespDto.getStoreCode());
            snapshotDto.setShopName(dgShopRespDto.getStoreName());
            snapshotDto.setEnterpriseId(dgShopRespDto.getSaleCompanyId());
            snapshotDto.setEnterpriseCode(dgShopRespDto.getSaleCompanyCode());
            snapshotDto.setEnterpriseName(dgShopRespDto.getSaleCompanyName());
            snapshotDto.setOrganizationId(dgShopRespDto.getSaleCompanyId());
            snapshotDto.setOrganizationCode(dgShopRespDto.getSaleCompanyCode());
            snapshotDto.setOrganizationName(dgShopRespDto.getSaleCompanyName());
            DgF2BPerformOrderReqDto f2BPerformOrderReqDto = new DgF2BPerformOrderReqDto();
            f2BPerformOrderReqDto.setSaleOrderNo(saleOrderNo);
            f2BPerformOrderReqDto.setOrderType(dgShopOrderReqDto.getOrderType());
            f2BPerformOrderReqDto.setOrderSource(dgShopOrderReqDto.getOrderSource());
            f2BPerformOrderReqDto.setPerformOrderSnapshotDto(snapshotDto);
            f2BPerformOrderReqDto.setOrderStatus(dgOrderReqDto.getOrderStatus());
            DgPerformOrderPaymentDto performOrderPaymentDto = new DgPerformOrderPaymentDto();
            performOrderPaymentDto.setPayStatus(Integer.valueOf(0));
            f2BPerformOrderReqDto.setPerformOrderPaymentDto(performOrderPaymentDto);
            f2BPerformOrderReqDto.setPerformOrderExtensionDto(new DgPerformOrderExtensionDto());
            f2BPerformOrderReqDto.setItemList((List)dgF2BOrderContextVo.getShopItemMap().get(shopId));
            f2BPerformOrderReqDto.setMaterialList((List)Optional.ofNullable(dgF2BOrderContextVo.getShopMaterialMap().get(shopId)).orElse(Lists.newArrayList()));
            f2BPerformOrderReqDto.setCostAccountRespDto((CostAccountDto)dgF2BOrderContextVo.getShopAccountDtoMap().get(shopId));
            OrderActivityInfoJoinReqDto activityInfoJoinReqDto = new OrderActivityInfoJoinReqDto();
            activityInfoJoinReqDto.setActivityList(this.convertOrderActivityInfoReqDtos((List)dgF2BOrderContextVo.getShopJoinActivityMap().get(shopId)));
            f2BPerformOrderReqDto.setActivity(activityInfoJoinReqDto);
            f2BPerformOrderReqDto.setMatchActivity(Boolean.FALSE.booleanValue());
            f2BPerformOrderReqDto.setNeedFeeThrow(dgOrderReqDto.isNeedFeeThrow());
            DgF2BOrderPreviewContext dgF2BOrderPreviewContext = new DgF2BOrderPreviewContext();
            DgOrderConfigurationRespDto config = this.dgOrderConfigurationService.queryDetailByShopCode(f2BPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
            AssertUtils.notNull((Object)config, (String)String.format("\u5e97\u94fa\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u5e97\u94fa\u540d\u79f0\uff1a%s", f2BPerformOrderReqDto.getPerformOrderSnapshotDto().getShopName()));
            f2BPerformOrderReqDto.setCloseTime(OrderExpiredUtil.calcOrderCancleTime((DgOrderConfigurationRespDto)config));
            dgF2BOrderPreviewContext.setDgF2BPerformOrderReqDto(f2BPerformOrderReqDto);
            contextVo.setDgShopOrderReqDto(dgShopOrderReqDto);
            contextVo.setDgF2BPerformOrderReqDto(f2BPerformOrderReqDto);
            contextVo.setDgShopRespDto(dgShopRespDto);
            contextVo.setDgF2BOrderPreviewContext(dgF2BOrderPreviewContext);
            dgF2BSingleOrderContextVos.add(contextVo);
        }
        return dgF2BSingleOrderContextVos;
    }

    private List<OrderActivityInfoReqDto> convertOrderActivityInfoReqDtos(List<DgOrderActivityBizReqDto> activityList) {
        if (CollectionUtils.isEmpty(activityList)) {
            return Collections.EMPTY_LIST;
        }
        HashSet<Long> set = new HashSet<Long>();
        ArrayList<DgOrderActivityBizReqDto> newActivityList = new ArrayList<DgOrderActivityBizReqDto>(activityList.size());
        for (DgOrderActivityBizReqDto activityBizReqDto : activityList) {
            if (!set.add(activityBizReqDto.getActivityId())) continue;
            newActivityList.add(activityBizReqDto);
        }
        return newActivityList.stream().map(orderActivityBizReqDto -> {
            OrderActivityInfoReqDto orderActivityInfoReqDto = new OrderActivityInfoReqDto();
            orderActivityInfoReqDto.setType(orderActivityBizReqDto.getType());
            if (CollectionUtils.isNotEmpty((Collection)orderActivityBizReqDto.getCouponIds())) {
                orderActivityInfoReqDto.setType(ActivityConstant.COUPON_ACTIVITY);
                orderActivityInfoReqDto.setActivityItemIds(orderActivityBizReqDto.getCouponIds());
            }
            orderActivityInfoReqDto.setActivityId(orderActivityBizReqDto.getActivityId());
            return orderActivityInfoReqDto;
        }).collect(Collectors.toList());
    }

    private void replenishData(DgF2BOrderContextVo dgF2BOrderContextVo) {
        Map shelfItemMap = dgF2BOrderContextVo.getShelfItemMap();
        Map shopMap = dgF2BOrderContextVo.getShopMap();
        Map policyPriceDtoMap = dgF2BOrderContextVo.getPolicyPriceDtoMap();
        Map itemRateDgRespDtoMap = dgF2BOrderContextVo.getItemRateDgRespDtoMap();
        HashMap shopItemMap = Maps.newHashMap();
        dgF2BOrderContextVo.getShopItemGroup().forEach((shopId, itemList) -> {
            ArrayList list = Lists.newArrayList();
            DgShopRespDto dgShopRespDto = (DgShopRespDto)shopMap.get(shopId);
            AssertUtils.notNull((Object)dgShopRespDto, (String)String.format("%s\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728", shopId));
            Map shopShelfItemMap = (Map)shelfItemMap.get(shopId);
            AssertUtils.notNull((Object)shopShelfItemMap, (String)String.format("%s\u5e97\u94fa\u5546\u54c1\u672a\u4e0a\u67b6", dgShopRespDto.getStoreName()));
            Map policyPriceRespDtoMap = (Map)policyPriceDtoMap.get(shopId);
            AssertUtils.notNull((Object)policyPriceRespDtoMap, (String)String.format("%s\u5e97\u94fa\u5546\u54c1\u6682\u65e0\u62a5\u4ef7", dgShopRespDto.getStoreName()));
            AtomicLong sortNoAtomicLong = new AtomicLong(0L);
            for (OrderPreviewItemReqDto itemReqDto : itemList) {
                DgItemSkuPageRespDto itemSkuRespDto = (DgItemSkuPageRespDto)shopShelfItemMap.get(itemReqDto.getSkuId());
                AssertUtils.notNull((Object)itemSkuRespDto, (String)String.format("%s\u5546\u54c1\u672a\u4e0a\u67b6", itemReqDto.getSkuId()));
                SkuPolicyPriceRespDto skuPolicyPriceRespDto = (SkuPolicyPriceRespDto)policyPriceRespDtoMap.get(itemReqDto.getSkuId());
                AssertUtils.notNull((Object)skuPolicyPriceRespDto, (String)String.format("%s\u5546\u54c1\u6682\u65e0\u62a5\u4ef7", itemSkuRespDto.getItemName()));
                BigDecimal dgPolicyPrice = PriceHelp.getDgPolicyPrice((SkuPolicyPriceRespDto)skuPolicyPriceRespDto, (Integer)itemReqDto.getItemNum().intValue());
                ItemRateDgRespDto rateDgRespDto = (ItemRateDgRespDto)itemRateDgRespDtoMap.get(itemReqDto.getItemId());
                DgPreviewPerformOrderItemReqDto previewItemReqDto = new DgPreviewPerformOrderItemReqDto();
                previewItemReqDto.setImgUrl(CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getImgUrlList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getImgUrlList().get(0)).getPath1() : (CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getMediaMainList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getMediaMainList().get(0)).getPath1() : null));
                previewItemReqDto.setItemName(itemSkuRespDto.getItemName());
                previewItemReqDto.setItemAttr(itemSkuRespDto.getItemAttribute());
                previewItemReqDto.setItemId(itemSkuRespDto.getItemId());
                previewItemReqDto.setItemCode(itemSkuRespDto.getItemCode());
                previewItemReqDto.setItemNum(itemReqDto.getItemNum());
                previewItemReqDto.setCatalogSerial(itemSkuRespDto.getDirId() + "");
                previewItemReqDto.setBrandSerial(itemSkuRespDto.getBrandId() + "");
                previewItemReqDto.setCatalogName(itemSkuRespDto.getDirName());
                previewItemReqDto.setItemMarketPrice(dgPolicyPrice);
                previewItemReqDto.setItemOrigPrice(dgPolicyPrice);
                previewItemReqDto.setPrice(dgPolicyPrice);
                previewItemReqDto.setShopId(shopId + "");
                previewItemReqDto.setSkuId(itemSkuRespDto.getId());
                previewItemReqDto.setSkuCode(itemSkuRespDto.getSkuCode());
                previewItemReqDto.setSkuName(itemSkuRespDto.getSkuName());
                previewItemReqDto.setSkuDesc(itemSkuRespDto.getSpecOne());
                previewItemReqDto.setOrderItemUnit(itemSkuRespDto.getSaleUnit());
                previewItemReqDto.setOrderItemUnitName(itemSkuRespDto.getSaleUnitName());
                previewItemReqDto.setSortNo(Long.valueOf(sortNoAtomicLong.incrementAndGet()));
                previewItemReqDto.setGift(YesNoEnum.NO.getValue());
                if (rateDgRespDto != null) {
                    previewItemReqDto.setTaxRate(rateDgRespDto.getRate());
                }
                list.add(previewItemReqDto);
            }
            shopItemMap.put(shopId, list);
        });
        dgF2BOrderContextVo.setShopItemMap((Map)shopItemMap);
        Map materialMap = dgF2BOrderContextVo.getMaterialMap();
        HashMap shopMaterialMap = Maps.newHashMap();
        dgF2BOrderContextVo.getShopMaterialGroup().forEach((shopId, materialBaseDataList) -> {
            ArrayList list = Lists.newArrayList();
            DgShopRespDto dgShopRespDto = (DgShopRespDto)shopMap.get(shopId);
            AssertUtils.notNull((Object)dgShopRespDto, (String)String.format("%s\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728", shopId));
            Map policyPriceRespDtoMap = (Map)policyPriceDtoMap.get(shopId);
            AssertUtils.notNull((Object)policyPriceRespDtoMap, (String)String.format("%s\u5e97\u94fa\u4fc3\u9500\u7269\u6599\u6682\u65e0\u62a5\u4ef7", dgShopRespDto.getStoreName()));
            AtomicLong lineNo = new AtomicLong(Optional.ofNullable(shopItemMap.get(shopId)).map(Collection::size).orElse(0).intValue());
            for (int i = 0; i < materialBaseDataList.size(); ++i) {
                OrderPreviewItemReqDto itemReqDto = (OrderPreviewItemReqDto)materialBaseDataList.get(i);
                DgItemSkuDetailRespDto itemSkuRespDto = (DgItemSkuDetailRespDto)materialMap.get(itemReqDto.getSkuId());
                AssertUtils.notNull((Object)itemSkuRespDto, (String)String.format("\u7b2c%s\u884c\u4fc3\u9500\u7269\u6599\u4fe1\u606f\u4e0d\u5b58\u5728", i + 1));
                SkuPolicyPriceRespDto skuPolicyPriceRespDto = (SkuPolicyPriceRespDto)policyPriceRespDtoMap.get(itemReqDto.getSkuId());
                AssertUtils.notNull((Object)skuPolicyPriceRespDto, (String)String.format("\u7b2c%s\u884c\u4fc3\u9500\u7269\u6599\u6682\u65e0\u62a5\u4ef7", i + 1));
                BigDecimal dgPolicyPrice = PriceHelp.getDgPolicyPrice((SkuPolicyPriceRespDto)skuPolicyPriceRespDto, (Integer)itemReqDto.getItemNum().intValue());
                ItemRateDgRespDto rateDgRespDto = (ItemRateDgRespDto)itemRateDgRespDtoMap.get(itemReqDto.getItemId());
                DgPreviewPerformOrderItemReqDto previewItemReqDto = new DgPreviewPerformOrderItemReqDto();
                previewItemReqDto.setImgUrl(CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getImgUrlList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getImgUrlList().get(0)).getPath1() : (CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getMediaMainList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getMediaMainList().get(0)).getPath1() : null));
                previewItemReqDto.setItemName(itemSkuRespDto.getItemName());
                previewItemReqDto.setItemAttr(itemSkuRespDto.getItemAttribute());
                previewItemReqDto.setItemId(itemSkuRespDto.getItemId());
                previewItemReqDto.setItemCode(itemSkuRespDto.getItemCode());
                previewItemReqDto.setItemNum(itemReqDto.getItemNum());
                previewItemReqDto.setCatalogSerial(itemSkuRespDto.getDirId() + "");
                previewItemReqDto.setBrandSerial(itemSkuRespDto.getBrandId() + "");
                previewItemReqDto.setCatalogName(itemSkuRespDto.getDirName());
                previewItemReqDto.setItemMarketPrice(dgPolicyPrice);
                previewItemReqDto.setItemOrigPrice(dgPolicyPrice);
                previewItemReqDto.setPrice(dgPolicyPrice);
                previewItemReqDto.setShopId(shopId + "");
                previewItemReqDto.setSkuId(itemSkuRespDto.getId());
                previewItemReqDto.setSkuCode(itemSkuRespDto.getSkuCode());
                previewItemReqDto.setSkuName(itemSkuRespDto.getSkuName());
                previewItemReqDto.setSkuDesc(itemSkuRespDto.getSpecOne());
                previewItemReqDto.setOrderItemUnit(itemSkuRespDto.getSaleUnit());
                previewItemReqDto.setOrderItemUnitName(itemSkuRespDto.getSaleUnitName());
                previewItemReqDto.setSortNo(Long.valueOf(lineNo.incrementAndGet()));
                previewItemReqDto.setGift(YesNoEnum.NO.getValue());
                previewItemReqDto.setMaterial(YesNoEnum.YES.getValue());
                if (rateDgRespDto != null) {
                    previewItemReqDto.setTaxRate(rateDgRespDto.getRate());
                }
                list.add(previewItemReqDto);
            }
            shopMaterialMap.put(shopId, list);
        });
        dgF2BOrderContextVo.setShopMaterialMap((Map)shopMaterialMap);
    }

    private void validateCreateOrderParams(DgOrderReqDto dgOrderReqDto) {
        AssertUtils.notNull((Object)dgOrderReqDto.getCustomerId(), (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        dgOrderReqDto.getShopOrderReqDtoList().stream().forEach(shopOrderReqDto -> {
            ArrayList skuIds = Lists.newArrayList();
            AssertUtils.notNull((Object)shopOrderReqDto.getShopId(), (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)shopOrderReqDto.getOrderAddrReqDto(), (String)String.format("\u6536\u83b7\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a:%s", shopOrderReqDto.getShopId()));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)shopOrderReqDto.getItemList()), (String)String.format("\u4e0b\u5355\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a", shopOrderReqDto.getShopId()));
            List itemList = shopOrderReqDto.getItemList();
            for (int i = 0; i < itemList.size(); ++i) {
                OrderPreviewItemReqDto item = (OrderPreviewItemReqDto)itemList.get(i);
                AssertUtils.notNull((Object)item.getItemId(), (String)String.format("\u7b2c%s\u884c\u5546\u54c1ID\u4e3a\u7a7a", i));
                AssertUtils.notNull((Object)item.getSkuId(), (String)String.format("\u7b2c%s\u884c\u5546\u54c1SKUID\u4e3a\u7a7a", i));
                AssertUtils.notNull((Object)item.getItemNum(), (String)String.format("\u7b2c%s\u884c\u4e0b\u5355\u6570\u91cf\u4e3a\u7a7a", i));
                skuIds.add(item.getSkuId());
            }
        });
    }

    private static DgF2BOrderContextVo getDgF2BOrderContextVo(DgOrderReqDto dgOrderReqDto) {
        HashMap shopItemGroup = Maps.newHashMap();
        ArrayList activityBizReqDtos = Lists.newArrayList();
        ArrayList costAccountDtos = Lists.newArrayList();
        dgOrderReqDto.getShopOrderReqDtoList().stream().forEach(dgShopOrderReqDto -> {
            List accountPreviewDtoList;
            shopItemGroup.put(dgShopOrderReqDto.getShopId(), dgShopOrderReqDto.getItemList());
            Optional.ofNullable(dgShopOrderReqDto.getActivityList()).ifPresent(activityBizReqDtos::addAll);
            if (dgShopOrderReqDto.getDgPerformOrderPayReqDto() != null && CollectionUtils.isNotEmpty((Collection)dgShopOrderReqDto.getDgPerformOrderPayReqDto().getPayReqDtos()) && CollectionUtils.isNotEmpty(accountPreviewDtoList = dgShopOrderReqDto.getDgPerformOrderPayReqDto().getPayReqDtos().stream().filter(dgBasePayReqDto -> AccountCategoryEnum.COST.getCode().equals(dgBasePayReqDto.getAccountCategory())).map(dgBasePayReqDto -> {
                AccountPreviewDto accountPreviewDto = new AccountPreviewDto();
                accountPreviewDto.setAccountCategory(dgBasePayReqDto.getAccountCategory());
                accountPreviewDto.setAccountType(dgBasePayReqDto.getPayMethod());
                accountPreviewDto.setCurrUseBalance(dgBasePayReqDto.getPayAmount());
                accountPreviewDto.setItemCountsType(dgBasePayReqDto.getItemCountsType());
                return accountPreviewDto;
            }).collect(Collectors.toList()))) {
                CostAccountDto costAccountDto = new CostAccountDto();
                costAccountDto.setShopId(dgShopOrderReqDto.getShopId());
                costAccountDto.setAccountPreviewDtos(accountPreviewDtoList);
                costAccountDtos.add(costAccountDto);
            }
        });
        DgOrderPreviewReqDto dgOrderPreviewReqDto = new DgOrderPreviewReqDto();
        dgOrderPreviewReqDto.setCustomerId(dgOrderReqDto.getCustomerId());
        dgOrderPreviewReqDto.setEnterpriseId(dgOrderReqDto.getEnterpriseId());
        dgOrderPreviewReqDto.setOrganizationId(dgOrderReqDto.getOrganizationId());
        dgOrderPreviewReqDto.setMatchActivity(Boolean.valueOf(false));
        dgOrderPreviewReqDto.setNeedFeeThrow(dgOrderReqDto.isNeedFeeThrow());
        dgOrderPreviewReqDto.setActivityList((List)activityBizReqDtos);
        dgOrderPreviewReqDto.setItemList(shopItemGroup.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        dgOrderPreviewReqDto.setCostAccountRespDtos((List)costAccountDtos);
        DgF2BOrderContextVo dgF2BOrderContextVo = new DgF2BOrderContextVo();
        dgF2BOrderContextVo.setPreviewReqDto(dgOrderPreviewReqDto);
        dgF2BOrderContextVo.setShopItemGroup((Map)shopItemGroup);
        dgF2BOrderContextVo.setShopOrderReqDtoList(dgOrderReqDto.getShopOrderReqDtoList());
        return dgF2BOrderContextVo;
    }

    @Override
    public RestResponse<Void> edit(String bizModel, DgOrderReqDto order) {
        return null;
    }

    @Override
    public RestResponse<DgOrderResultRespDto> submit(String bizModel, DgOrderReqDto order) {
        return null;
    }

    @Override
    public RestResponse<Long> createOrder(String bizModel, OrderReqDto addReqDto) {
        OrderCreateBo bo = null;
        Long orderId = addReqDto.getId();
        bo = orderId != null && Objects.equals(addReqDto.getSubmitType(), "2") ? (OrderCreateBo)RestResponseHelper.extractData((RestResponse)Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, addReqDto, (Object)DgF2BOrderMachineEvents.F2B_CHECK_ORDER).getActionResultSubRestResponse(OrderCreateBo.class)).orElseGet(RestResponse::new)) : (orderId != null && Objects.equals(addReqDto.getSubmitType(), "1") ? (OrderCreateBo)RestResponseHelper.extractData((RestResponse)Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, addReqDto, (Object)DgF2BOrderMachineEvents.F2B_MODIFY_ORDER).getActionResultSubRestResponse(OrderCreateBo.class)).orElseGet(RestResponse::new)) : (OrderCreateBo)RestResponseHelper.extractData((RestResponse)Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, null, addReqDto, (Object)DgF2BOrderMachineEvents.F2B_CREATE_ORDER).getActionResultSubRestResponse(OrderCreateBo.class)).orElseGet(RestResponse::new)));
        return new RestResponse((Object)bo.getOrderEo().getId());
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#shopOrderReqDtoList[0].id", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> submitOrder(String bizModel, DgOrderReqDto dgOrderReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getId(), dgOrderReqDto, (Object)DgF2BOrderMachineEvents.F2B_SUBMIT_ORDER).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> modifyOrder(String bizModel, DgOrderReqDto dgOrderReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getId(), dgOrderReqDto, (Object)DgF2BOrderMachineEvents.F2B_MODIFY_ORDER_NEW).getActionResultSubRestResponse(DgOrderResultRespDto.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> checkOrder(String bizModel, DgOrderReqDto dgOrderReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getId(), dgOrderReqDto, (Object)DgF2BOrderMachineEvents.F2B_CHECK_ORDER_NEW).getActionResultSubRestResponse(DgOrderResultRespDto.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> modifyOrderInfo(String bizModel, OrderModTobReqDto orderModTobReq) {
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> logicDeleteOrder(String bizModel, Long orderId) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, null, (Object)DgF2BOrderMachineEvents.F2B_DELETE_ORDER).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<String> modifyPayMethod(String bizModel, PayMethodReqDto payMethodReqDto) {
        PayMethodBo payMethodBo = (PayMethodBo)RestResponseHelper.extractData((RestResponse)Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, payMethodReqDto.getOrderId(), payMethodReqDto, (Object)DgF2BOrderMachineEvents.ORDER_PAY).getActionResultSubRestResponse(PayMethodBo.class)).orElseGet(RestResponse::new));
        return new RestResponse((Object)payMethodBo.getPayRecordEo().getPayNo());
    }

    @Override
    public RestResponse<Void> cancelByOrder(String bizModel, Long id, String reason) {
        this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, id, reason, (Object)DgF2BOrderMachineEvents.CANCEL);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> closeOrder(String bizModel, Long id, String reason) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, id, reason, (Object)DgF2BOrderMachineEvents.CLOSE).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#orderAuditReqDto.orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> csAuditOrder(String bizModel, OrderAuditReqDto orderAuditReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderAuditReqDto.getOrderId(), orderAuditReqDto, (Object)DgF2BOrderMachineEvents.CS_AUDIT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#orderAuditReqDto.orderId", linkCodeType="PERFORM_ORDER")
    public RestResponse<Void> financeAuditOrder(String bizModel, OrderAuditReqDto orderAuditReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderAuditReqDto.getOrderId(), orderAuditReqDto, (Object)DgF2BOrderMachineEvents.FINANCE_AUDIT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> orderRefundAudit(String bizModel, OrderAuditReqDto orderAuditReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderAuditReqDto.getOrderId(), orderAuditReqDto, (Object)DgF2BOrderMachineEvents.RETURN_AUDIT_ORDER).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> orderCsRefundAudit(String bizModel, OrderAuditReqDto orderAuditReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderAuditReqDto.getOrderId(), orderAuditReqDto, (Object)DgF2BOrderMachineEvents.CS_RETURN_AUDIT_ORDER).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> delivery(String bizModel, Long id) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, id, null, (Object)DgF2BOrderMachineEvents.ORDER_DELIVERY).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<String> factoryDelivery(String bizModel, FactoryDeliveryReqDto factoryDeliveryReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, factoryDeliveryReqDto.getOrderId(), factoryDeliveryReqDto, (Object)DgF2BOrderMachineEvents.FACTORY_DELIVERY).getActionResultSubRestResponse(String.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> confirmOrder(String bizModel, Long orderId) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, null, (Object)DgF2BOrderMachineEvents.CONFIRM).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Long> addStockBatch(String bizModel, OrderStockBatchDto orderStockBatch) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderStockBatch.getOrderId(), orderStockBatch, (Object)DgF2BOrderMachineEvents.ADD_STOCK_BATCH).getActionResultSubRestResponse(Long.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> clearTradeItemBatch(String bizModel, Long orderId) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, null, (Object)DgF2BOrderMachineEvents.CLEAR_TRADE_ITEM_BATCH).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> pay(String bizModel, DgPerformOrderPayReqDto dgPerformOrderPayReqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, dgPerformOrderPayReqDto.getOrderId(), dgPerformOrderPayReqDto, (Object)DgF2BOrderMachineEvents.F2B_ORDER_PAY).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> externalOrderDelivery(String bizModel, DgBizPerformNoticeSyncRecordDto dgBizPerformNoticeSyncRecordDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, dgBizPerformNoticeSyncRecordDto.getBusinessId(), dgBizPerformNoticeSyncRecordDto, (Object)DgF2BOrderMachineEvents.SYNC_ORDER_DELIVER_RESULT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> cancelExternalDelivery(String bizModel, Long orderId, ResultOrderOptReqDto reqDto) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, orderId, reqDto, (Object)DgF2BOrderMachineEvents.CANCEL_SYNC_DELIVER_RESULT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> partCancelOrder(String bizModel, Long id, String reason) {
        return Optional.ofNullable(this.dgF2BOrderStatemachineExecutor.executeStatemachine(bizModel, id, reason, (Object)DgF2BOrderMachineEvents.PART_CANCEL).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }
}

