/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.statemachine.handler.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OaAuditStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.UploadQcReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnModTobReqDto;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.channel.IDgF2BAfterOrderSaveAction;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.OaAuditResultDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderAuditDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderRejectReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.ResultOrderOptReqDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.service.entity.IQualityControlService;
import com.yunxi.dg.base.center.trade.statemachine.f2b.afterorder.constant.DgF2BAfterMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.f2b.afterorder.execute.DgF2BAfterrStatemachineExecutor;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgF2BAfterOrderStatemachineHandle;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.annotations.OptLogEntryMethod;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgF2BAfterOrderStatemachineHandleImpl
implements IDgF2BAfterOrderStatemachineHandle {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Resource
    private DgF2BAfterrStatemachineExecutor dgF2BAfterrStatemachineExecutor;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IQualityControlService qualityControlServiceImpl;
    @Resource
    private IDgF2BAfterOrderSaveAction dgF2BAfterOrderSaveAction;
    @Resource
    @Lazy
    protected DgF2BAfterOrderStatemachineHandleImpl xThis;

    private Long returnNo2OrderId(String returnNo) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = this.dgAfterSaleOrderDomain.queryByAfterSaleOrderNo(returnNo);
        AssertUtils.notNull((Object)dgAfterSaleOrderEo, (String)"\u9000\u8d27\u5355\u5355\u4e0d\u5b58\u5728");
        return dgAfterSaleOrderEo.getId();
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#dgAfterSaleOrderDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Long> addAfterSaleApplyOfOriginal(String bizModel, DgAfterSaleOrderDto dgAfterSaleOrderDto) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, null, dgAfterSaleOrderDto, (Object)DgF2BAfterMachineEvents.F2B_SUBMIT_RETURN_ORDER).getActionResultSubRestResponse(Long.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Long> submitByAfsOrderId(String bizModel, Long id) {
        DgAfterSaleOrderDto dgAfterSaleOrderDto = new DgAfterSaleOrderDto();
        dgAfterSaleOrderDto.setId(id);
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, id, dgAfterSaleOrderDto, (Object)DgF2BAfterMachineEvents.F2B_SUBMIT_RETURN_ORDER_BY_ID).getActionResultSubRestResponse(Long.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#dgAfterSaleOrderDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Long> addAfterSaleApplyOfOriginalTest(String bizModel, DgAfterSaleOrderDto dgAfterSaleOrderDto) {
        return new RestResponse((Object)this.dgF2BAfterOrderSaveAction.addAfterSaleApply(dgAfterSaleOrderDto));
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#dgAfterSaleOrderDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Long> saveAfterSaleApplyOfOriginal(String bizModel, DgAfterSaleOrderDto dgAfterSaleOrderDto) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, null, dgAfterSaleOrderDto, (Object)DgF2BAfterMachineEvents.F2B_SAVE_RETURN_ORDER).getActionResultSubRestResponse(Long.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#returnAuditReqDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> auditAfterSale(String bizModel, DgAfterSaleOrderAuditDto returnAuditReqDto) {
        this.LOGGER.info("\u9000\u8d27\u5355\u5ba1\u6838auditAfterSale\uff1a{}", (Object)JSON.toJSONString((Object)returnAuditReqDto));
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, returnAuditReqDto.getId(), returnAuditReqDto, (Object)DgF2BAfterMachineEvents.AFTER_AUDIT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#auditResultDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> oaAuditAfterSale(String bizModel, OaAuditResultDto auditResultDto) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)auditResultDto.getAfterSaleOrderNo()), (String)"\u9000\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)auditResultDto.getAuditStatus()), (String)"\u5ba1\u6838\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderEo query = new DgAfterSaleOrderEo();
        query.setAfterSaleOrderNo(auditResultDto.getAfterSaleOrderNo());
        DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)this.dgAfterSaleOrderDomain.selectOne((BaseEo)query);
        AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)afterSaleOrderEo), (String)"\u627e\u4e0d\u5230\u9000\u8d27\u5355");
        DgAfterSaleOrderAuditDto auditDto = new DgAfterSaleOrderAuditDto();
        auditDto.setId(afterSaleOrderEo.getId());
        auditDto.setAuditDesc(auditResultDto.getRemark());
        auditDto.setAuditTime(auditResultDto.getAuditTime());
        auditDto.setAuditor(auditResultDto.getAuditor());
        auditDto.setOaAuditStatus(auditResultDto.getAuditStatus());
        switch (Objects.requireNonNull(OaAuditStatusEnum.getStatusByCode((String)auditResultDto.getAuditStatus()))) {
            case PASS: {
                auditDto.setAuditStatus(AuditStatusEnum.PASS.getType());
                break;
            }
            case NO_PASS: {
                auditDto.setAuditStatus(AuditStatusEnum.REJECT.getType());
                break;
            }
            default: {
                throw new BizException("\u975e\u6cd5\u5ba1\u6838\u7ed3\u679c");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)auditDto.getOaAuditStatus()) && ObjectUtils.isNotEmpty((Object)auditDto.getId())) {
            DgAfterSaleOrderEo updateEo = new DgAfterSaleOrderEo();
            updateEo.setId(auditDto.getId());
            updateEo.setOaAuditStatus(auditDto.getOaAuditStatus());
            this.LOGGER.info("\u4fee\u6539OA\u5ba1\u6838\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)updateEo));
            this.dgAfterSaleOrderDomain.updateSelective((BaseEo)updateEo);
        }
        return this.xThis.auditAfterSale(bizModel, auditDto);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#orderDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> cancelAfterSale(String bizModel, DgAfterSaleOrderDto orderDto) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, orderDto.getId(), orderDto, (Object)DgF2BAfterMachineEvents.AFTER_CANCEL).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> reviewAfterSaleReality(String bizModel, Long id) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, id, null, (Object)DgF2BAfterMachineEvents.REVIEW_REALITY).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#returnModTobReqDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> modifyUncertainItemReturnInfo(String bizModel, ReturnModTobReqDto returnModTobReqDto) {
        Long returnId = this.returnNo2OrderId(returnModTobReqDto.getReturnNo());
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, returnId, returnModTobReqDto, (Object)DgF2BAfterMachineEvents.MODIFY_RETURN_ORDER).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#reviewToBReqDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> reviewAfterSale(String bizModel, DgAfterSaleOrderDto reviewToBReqDto) {
        this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, reviewToBReqDto.getId(), reviewToBReqDto, (Object)DgF2BAfterMachineEvents.FIN_REVIEW_ORDER);
        return RestResponse.VOID;
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#reviewToBReqDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> reissueSlipAfterSale(String bizModel, DgAfterSaleOrderDto reviewToBReqDto) {
        this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, reviewToBReqDto.getId(), reviewToBReqDto, (Object)DgF2BAfterMachineEvents.FIN_REVIEW_ORDER);
        return RestResponse.VOID;
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#dgBizPerformNoticeSyncRecordDto.businessId", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> externalAfterInResult(String bizModel, DgBizPerformNoticeSyncRecordDto dgBizPerformNoticeSyncRecordDto) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, dgBizPerformNoticeSyncRecordDto.getBusinessId(), dgBizPerformNoticeSyncRecordDto, (Object)DgF2BAfterMachineEvents.SYNC_ORDER_DELIVER_RESULT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> closeAfterSale(String bizModel, Long id, String reason) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, id, reason, (Object)DgF2BAfterMachineEvents.AFTER_CLOSE).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#orderId", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> cancelExternalAfterInResult(String bizModel, Long orderId, ResultOrderOptReqDto resultOrderOptReqDto) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, orderId, resultOrderOptReqDto, (Object)DgF2BAfterMachineEvents.CANCEL_SYNC_NOTICE_RESULT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#afterSaleOrderDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> uploadReceiveNum(String bizModel, DgAfterSaleOrderDto afterSaleOrderDto) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, afterSaleOrderDto.getId(), afterSaleOrderDto, (Object)DgF2BAfterMachineEvents.UPLOAD_RECEIVE_QUANTITY).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#afterSaleOrderDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> confirmReceiveNum(String bizModel, DgAfterSaleOrderDto afterSaleOrderDto) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, afterSaleOrderDto.getId(), afterSaleOrderDto, (Object)DgF2BAfterMachineEvents.UPLOAD_RECEIVE_QUANTITY).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#afterSaleOrderDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> confirmQualityControl(String bizModel, DgAfterSaleOrderDto afterSaleOrderDto) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, afterSaleOrderDto.getId(), afterSaleOrderDto, (Object)DgF2BAfterMachineEvents.CUSTOMER_CONFIRM_ANALYSE).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#reqDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> rejectAfterSaleReceiveNum(String bizModel, DgAfterSaleOrderRejectReqDto reqDto) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, reqDto.getId(), reqDto, (Object)DgF2BAfterMachineEvents.CUSTOMER_REJECT_RECEIVE_QUANTITY).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @Transactional
    @OptLogEntryMethod(linkCodeSpel="#reqDto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> rejectQc(String bizModel, DgAfterSaleOrderRejectReqDto reqDto) {
        this.qualityControlServiceImpl.rejectQc(reqDto.getAfterSaleOrderNo());
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, reqDto.getId(), reqDto, (Object)DgF2BAfterMachineEvents.REJECT_QUALITY_TEST_JUDGMENT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @Transactional
    @OptLogEntryMethod(linkCodeSpel="#uploadQcReqDto.qualityControlDto.afterSaleOrderId", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> uploadQc(String bizModel, UploadQcReqDto uploadQcReqDto) {
        List qualityControlItemDtos = this.qualityControlServiceImpl.submitQc(uploadQcReqDto);
        uploadQcReqDto.setQualityControlItemDtoList(qualityControlItemDtos);
        if (uploadQcReqDto.isSubmit()) {
            return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(bizModel, uploadQcReqDto.getQualityControlDto().getAfterSaleOrderId(), uploadQcReqDto, (Object)DgF2BAfterMachineEvents.ENTER_QUALITY_TEST_JUDGMENT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
        }
        return RestResponse.VOID;
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#dto.id", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> fillReturnShippingInfo(String code, DgAfterSaleOrderDto dto) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(code, dto.getId(), dto, (Object)DgF2BAfterMachineEvents.FILL_RETURN_SHIPPING_INFO).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    @OptLogEntryMethod(linkCodeSpel="#dto.platformRefundOrderId", linkCodeType="AFTER_SALE_ORDER")
    public RestResponse<Void> syncApplyToChannelAfterOrder(String code, DgBizAfterSaleOrderReqDto dto) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(code, Long.valueOf(dto.getPlatformRefundOrderId()), dto, (Object)DgF2BAfterMachineEvents.SALE_RETURN_IN_WAREHOUSE_CALL_BACK).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    @Override
    public RestResponse<Void> channelTransferSaleReturn(String code, DgAfterSaleOrderDto dto) {
        return Optional.ofNullable(this.dgF2BAfterrStatemachineExecutor.executeStatemachine(code, dto.getId(), dto, (Object)DgF2BAfterMachineEvents.CHANNEL_TRANSFER_SALE_RETURN).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }
}

