/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataLimit;

import com.yunxi.dg.base.commons.dataLimit.DataLimitReqAspect;
import com.yunxi.dg.base.commons.dataLimit.DataLimitReqWebMvcConfigurer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="${data.limit.effect.enable:false}==true")
public class DataLimitEnableConfig {
    private static final Logger log = LoggerFactory.getLogger(DataLimitEnableConfig.class);

    @Bean
    public DataLimitReqWebMvcConfigurer dataLimitReqWebMvcConfigurer() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add("/swagger-resources/**");
        urls.add("/swagger-resources");
        urls.add("/webjars/springfox-swagger-ui/**");
        urls.add("/webjars/springfox-swagger-ui/*.*");
        urls.add("/swagger-ui.html");
        urls.add("/swagger-ui/*.*");
        urls.add("/v2/api-docs");
        urls.add("/favicon.ico");
        urls.add("/xapi.html");
        urls.add("/xapi/**");
        log.info("dataLimitReqWebMvcConfigurer\u8f7d\u5165");
        return new DataLimitReqWebMvcConfigurer().setExcludePathPatterns(urls);
    }

    @Bean
    public DataLimitReqAspect dataLimitReqAspect() {
        return new DataLimitReqAspect();
    }
}

