/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataLimit;

import cn.hutool.core.util.ObjectUtil;
import com.yunxi.dg.base.commons.dataLimit.DataLimitSettingUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;

public class DataLimitReqAspect {
    private static final Logger log = LoggerFactory.getLogger(DataLimitReqAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public Object checkPermission(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = this.getMethodSignature(joinPoint);
        if (ObjectUtil.isNull((Object)signature)) {
            return joinPoint.proceed(joinPoint.getArgs());
        }
        RequestMapping annotation = this.getRequestMappingAnnotation(signature);
        if (annotation != null && this.containsPathKeyword(annotation.path())) {
            try {
                DataLimitSettingUtils.enableDataLimit();
                Object object = joinPoint.proceed(joinPoint.getArgs());
                return object;
            }
            finally {
                DataLimitSettingUtils.disableDataLimit();
            }
        }
        return joinPoint.proceed(joinPoint.getArgs());
    }

    private MethodSignature getMethodSignature(ProceedingJoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        return signature instanceof MethodSignature ? (MethodSignature)signature : null;
    }

    private RequestMapping getRequestMappingAnnotation(MethodSignature signature) {
        return signature.getMethod().getAnnotation(RequestMapping.class);
    }

    private boolean containsPathKeyword(String[] paths) {
        for (String path : paths) {
            if (!path.contains("list") && !path.contains("page") && !path.contains("detail")) continue;
            return true;
        }
        return false;
    }
}

