/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataLimit;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.util.Base64;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class DataLimitReqInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataLimitReqInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String requestMethod = request.getMethod();
        if (!HttpMethod.OPTIONS.name().equalsIgnoreCase(requestMethod)) {
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (!"yx.dg.data.limit.enable.header".equals(headerName)) continue;
                String value = request.getHeader(headerName);
                log.info("\u4eceheader\u4e2d\u83b7\u53d6\u5230\u8c03\u7528\u94fe\u4fe1\u606f");
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                ServiceContext.getContext().setAttachment("yx.dg.data.limit.enable.header", Base64.decodeString((String)value));
            }
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ServiceContext.getContext().removeAttachment("yx.dg.data.limit.enable.header");
    }
}

