/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import java.util.Collection;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class AssertUtils {
    public static void notBlank(String target, String args) {
        if (StrUtil.isBlank((CharSequence)target)) {
            throw new BizException(args);
        }
    }

    public static void notEmpty(String target, String args) {
        if (StrUtil.isEmpty((CharSequence)target)) {
            throw new BizException(args);
        }
    }

    public static <T> void notEmpty(T target, String args) {
        if (ObjectUtil.isEmpty(target)) {
            throw new BizException(args);
        }
    }

    public static void notNull(Object target, String args) {
        if (target == null) {
            throw new BizException(args);
        }
    }

    public static void notEmpty(Collection<? extends Object> collection, String args) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new BizException(args);
        }
    }

    public static void isTrue(boolean expression, String code, String message) {
        if (!expression) {
            throw new BizException(code, message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        AssertUtils.isTrue(expression, ExceptionCode.FAIL.getCode(), message);
    }

    public static void isTrue(boolean expression, ExceptionCode exceptionEnum) {
        AssertUtils.isTrue(expression, exceptionEnum.getCode(), exceptionEnum.getMsg());
    }

    public static void isFalse(boolean expression, String code, String message) {
        if (expression) {
            throw new BizException(code, message);
        }
    }

    public static void isFalse(boolean expression, String message) {
        AssertUtils.isFalse(expression, ExceptionCode.FAIL.getCode(), message);
    }

    public static void isTrue(boolean expression, String errorMsgTemplate, Object ... params) throws BizException {
        if (!expression) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
    }

    public static void isTrue(boolean expression) throws BizException {
        AssertUtils.isTrue(expression, "[Assertion failed] - this expression must be true");
    }

    public static void isFalse(boolean expression, String errorMsgTemplate, Object ... params) throws BizException {
        if (expression) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
    }

    public static void isFalse(boolean expression) throws BizException {
        AssertUtils.isFalse(expression, "[Assertion failed] - this expression must be false");
    }

    public static void isNull(Object object, String errorMsgTemplate, Object ... params) throws BizException {
        if (object != null) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
    }

    public static void isNull(Object object) throws BizException {
        AssertUtils.isNull(object, "[Assertion failed] - the object argument must be null", new Object[0]);
    }

    public static <T> T notNull(T object, String errorMsgTemplate, Object ... params) throws BizException {
        if (object == null) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
        return object;
    }

    public static <T extends CharSequence> T notEmpty(T text, String errorMsgTemplate, Object ... params) throws BizException {
        if (StrUtil.isEmpty(text)) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
        return text;
    }

    public static <T> void notEmpty(T text) throws BizException {
        AssertUtils.notEmpty(text, "[Assertion failed] - this String argument must have length; it must not be null or empty");
    }

    public static <T extends CharSequence> T notBlank(T text, String errorMsgTemplate, Object ... params) throws BizException {
        if (StrUtil.isBlank(text)) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
        return text;
    }

    public static <T extends CharSequence> T notBlank(T text) throws BizException {
        return AssertUtils.notBlank(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank", new Object[0]);
    }

    public static String notContain(String textToSearch, String substring, String errorMsgTemplate, Object ... params) throws BizException {
        if (StrUtil.isNotEmpty((CharSequence)textToSearch) && StrUtil.isNotEmpty((CharSequence)substring) && textToSearch.contains(substring)) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
        return substring;
    }

    public static String notContain(String textToSearch, String substring) throws BizException {
        return AssertUtils.notContain(textToSearch, substring, "[Assertion failed] - this String argument must not contain the substring [{}]", substring);
    }

    public static Object[] notEmpty(Object[] array, String errorMsgTemplate, Object ... params) throws BizException {
        if (ArrayUtil.isEmpty((Object[])array)) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
        return array;
    }

    public static void notEmpty(Object[] array) throws BizException {
        AssertUtils.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static <T> T[] noNullElements(T[] array, String errorMsgTemplate, Object ... params) throws BizException {
        if (ArrayUtil.hasNull((Object[])array)) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
        return array;
    }

    public static <T> T[] noNullElements(T[] array) throws BizException {
        return AssertUtils.noNullElements(array, "[Assertion failed] - this array must not contain any null elements", new Object[0]);
    }

    public static <T> Collection<T> notEmpty(Collection<T> collection, String errorMsgTemplate, Object ... params) throws BizException {
        if (CollectionUtil.isEmpty(collection)) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
        return collection;
    }

    public static <T> void notEmpty(Collection<T> collection) throws BizException {
        AssertUtils.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> map, String errorMsgTemplate, Object ... params) throws BizException {
        if (CollectionUtil.isEmpty(map)) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
        return map;
    }

    public static <K, V> void notEmpty(Map<K, V> map) throws BizException {
        AssertUtils.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry");
    }

    public static <T> T isInstanceOf(Class<?> type, T obj) {
        return AssertUtils.isInstanceOf(type, obj, "Object [{}] is not instanceof [{}]", obj, type);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj, String errorMsgTemplate, Object ... params) throws BizException {
        AssertUtils.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
        return obj;
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) throws BizException {
        AssertUtils.isAssignable(superType, subType, "{} is not assignable to {})", subType, superType);
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String errorMsgTemplate, Object ... params) throws BizException {
        AssertUtils.notNull(superType, "Type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new BizException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
    }

    public static void state(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
    }

    public static void state(boolean expression) throws IllegalStateException {
        AssertUtils.state(expression, "[Assertion failed] - this state invariant must be true", new Object[0]);
    }

    public static int checkIndex(int index, int size) throws BizException, IndexOutOfBoundsException {
        return AssertUtils.checkIndex(index, size, "[Assertion failed]", new Object[0]);
    }

    public static int checkIndex(int index, int size, String errorMsgTemplate, Object ... params) throws BizException, IndexOutOfBoundsException {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(AssertUtils.badIndexMsg(index, size, errorMsgTemplate, params));
        }
        return index;
    }

    public static int checkBetween(int value, int min, int max) {
        if (value < min || value > max) {
            throw new BizException(StrUtil.format((CharSequence)"Length must be between {} and {}.", (Object[])new Object[]{min, max}));
        }
        return value;
    }

    public static long checkBetween(long value, long min, long max) {
        if (value < min || value > max) {
            throw new BizException(StrUtil.format((CharSequence)"Length must be between {} and {}.", (Object[])new Object[]{min, max}));
        }
        return value;
    }

    public static double checkBetween(double value, double min, double max) {
        if (value < min || value > max) {
            throw new BizException(StrUtil.format((CharSequence)"Length must be between {} and {}.", (Object[])new Object[]{min, max}));
        }
        return value;
    }

    public static Number checkBetween(Number value, Number min, Number max) {
        AssertUtils.notNull(value, "value is null");
        AssertUtils.notNull(min, "min value is null");
        AssertUtils.notNull(max, "max value is null");
        double valueDouble = value.doubleValue();
        double minDouble = min.doubleValue();
        double maxDouble = max.doubleValue();
        if (valueDouble < minDouble || valueDouble > maxDouble) {
            throw new BizException(StrUtil.format((CharSequence)"Length must be between {} and {}.", (Object[])new Object[]{min, max}));
        }
        return value;
    }

    private static String badIndexMsg(int index, int size, String desc, Object ... params) {
        if (index < 0) {
            return StrUtil.format((CharSequence)"{} ({}) must not be negative", (Object[])new Object[]{StrUtil.format((CharSequence)desc, (Object[])params), index});
        }
        if (size < 0) {
            throw new BizException("negative size: " + size);
        }
        return StrUtil.format((CharSequence)"{} ({}) must be less than size ({})", (Object[])new Object[]{StrUtil.format((CharSequence)desc, (Object[])params), index, size});
    }
}

