/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.dto.KeyValueDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class BeanCopyUtil {
    private static Map<Class, Object> clsObjMap = Collections.synchronizedMap(new HashMap());

    public static void copyProperties(Object src, Object target) {
        BeanUtil.copyProperties((Object)src, (Object)target, (String[])new String[0]);
    }

    public static <T> T copyProperties(Object src, Class<T> targetClass) {
        try {
            T obj = targetClass.newInstance();
            BeanUtil.copyProperties((Object)src, obj, (String[])new String[0]);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> copyProperties(List<Object> srcList, Class<T> targetClass) {
        ArrayList targetList = new ArrayList();
        if (srcList != null) {
            srcList.forEach(src -> {
                try {
                    Object target = targetClass.newInstance();
                    BeanUtil.copyProperties((Object)src, target, (String[])new String[0]);
                    targetList.add(target);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        return targetList;
    }

    public static <T, E> List<T> copyProperties(List<E> srcList, Class<T> targetClass, Consumer<KeyValueDto<E, T>> elementFunction) {
        ArrayList targetList = new ArrayList();
        if (srcList != null) {
            srcList.forEach(src -> {
                try {
                    Object target = targetClass.newInstance();
                    BeanUtil.copyProperties((Object)src, target, (String[])new String[0]);
                    elementFunction.accept(KeyValueDto.of(src, target));
                    targetList.add(target);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        return targetList;
    }

    public static <T> List<T> copyPropertiesForList(List srcList, Class<T> targetClass) {
        return BeanCopyUtil.copyProperties(srcList, targetClass);
    }

    public static <T> List<T> copyPropertiesForList(List srcList, Class<T> targetClass, Consumer<KeyValueDto<Object, T>> elementFunction) {
        return BeanCopyUtil.copyProperties(srcList, targetClass, elementFunction);
    }

    public static <T> PageInfo<T> copyProperties(PageInfo srcPageInfo, Class<T> targetClass) {
        ArrayList targetList = new ArrayList();
        if (srcPageInfo != null && srcPageInfo.getList() != null) {
            srcPageInfo.getList().forEach(src -> {
                try {
                    Object target = targetClass.newInstance();
                    BeanUtil.copyProperties((Object)src, target, (String[])new String[0]);
                    targetList.add(target);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        PageInfo targetPageInfo = new PageInfo(targetList, srcPageInfo.getPageSize());
        BeanUtil.copyProperties((Object)srcPageInfo, (Object)targetPageInfo, (String[])new String[]{"list"});
        return targetPageInfo;
    }

    public static <T, E> PageInfo<T> copyProperties(PageInfo<E> srcPageInfo, Class<T> targetClass, Consumer<KeyValueDto<E, T>> elementFunction) {
        ArrayList targetList = new ArrayList();
        if (srcPageInfo != null && srcPageInfo.getList() != null) {
            srcPageInfo.getList().forEach(src -> {
                try {
                    Object target = targetClass.newInstance();
                    BeanUtil.copyProperties((Object)src, target, (String[])new String[0]);
                    elementFunction.accept(KeyValueDto.of(src, target));
                    targetList.add(target);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        PageInfo targetPageInfo = new PageInfo(targetList, srcPageInfo.getPageSize());
        BeanUtil.copyProperties(srcPageInfo, (Object)targetPageInfo, (String[])new String[]{"list"});
        return targetPageInfo;
    }

    public static <T> T copy(Object obj, Class<T> targetClass) {
        if (obj instanceof JSONObject) {
            return (T)((JSONObject)obj).toJavaObject(targetClass);
        }
        String json = JacksonUtil.toJson((Object)obj);
        return (T)JacksonUtil.readValue((String)json, targetClass);
    }
}

