/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils;

import com.yunxi.dg.base.commons.utils.TopUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateTimeUtil {
    public static final String SDFyyyyMM = "yyyy-MM";
    public static final String SDFyyyyMMdd = "yyyy-MM-dd";
    public static final String SDFyyyyMMddHH = "yyyy-MM-dd HH";
    public static final String SDFyyyyMMddHHmm = "yyyy-MM-dd HH:mm";
    public static final String SDFyyyyMMddHHmmss = "yyyy-MM-dd HH:mm:ss";
    public static final String SDFyyyyMMddHHmmssS = "yyyy-MM-dd HH:mm:ss.S";
    public static final long millisecondsPerMinute = 60000L;
    public static final long millisecondsPerHour = 3600000L;
    public static final long millisecondsPerDay = 86400000L;
    public static final long millisecondsPerWeek = 604800000L;

    public static String dateFormat(Timestamp d) {
        return d == null ? null : new SimpleDateFormat(SDFyyyyMMdd).format(d);
    }

    public static String DateTimeFormat(Date d) {
        return d == null ? null : new SimpleDateFormat(SDFyyyyMMddHHmmss).format(d);
    }

    public static Timestamp toTimestamp(Date d) {
        return d == null ? null : new Timestamp(d.getTime());
    }

    public static Timestamp toTimestamp(String str) {
        if (TopUtil.isValidValue(str)) {
            int len = str.length();
            if (len < 29) {
                for (int i = 0; i < 29 - len; ++i) {
                    str = str + "0";
                }
            }
            return Timestamp.valueOf(str);
        }
        return null;
    }

    public static Date dateAdd(Date oldDate, int numDays) {
        if (TopUtil.isValidValue(oldDate)) {
            Date newDate = new Date();
            newDate.setTime(oldDate.getTime() + (long)numDays * 86400000L);
            return newDate;
        }
        return null;
    }

    public static Date dateAddMonths(Date oldDate, int numMonths) {
        if (oldDate == null || numMonths == 0) {
            return oldDate;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldDate);
        calendar.setLenient(true);
        calendar.add(2, numMonths);
        return calendar.getTime();
    }

    public static Date dateAddWeeks(Date oldDate, int numWeeks) {
        if (TopUtil.isValidValue(oldDate)) {
            return new Date(oldDate.getTime() + (long)numWeeks * 604800000L);
        }
        return null;
    }

    public static int dateDiff(Date first, Date second) {
        if (first == null || second == null) {
            return 0;
        }
        long timeDiff = second.getTime() - first.getTime();
        long approxDays = timeDiff / 86400000L;
        if (timeDiff > 0L && timeDiff < 86400000L) {
            approxDays = 1L;
        }
        if (timeDiff % 86400000L != 0L) {
            if (approxDays <= 0L && timeDiff - 3600000L == (approxDays - 1L) * 86400000L) {
                --approxDays;
            } else if (approxDays >= 0L && timeDiff + 3600000L == (approxDays + 1L) * 86400000L) {
                ++approxDays;
            }
        }
        return (int)approxDays;
    }

    public static int dateDiffMonths(Date first, Date second) {
        if (first == null || second == null || first.equals(second)) {
            return 0;
        }
        GregorianCalendar firstCalendar = new GregorianCalendar();
        firstCalendar.setTime(first);
        int firstDay = firstCalendar.get(5);
        int firstMonth = firstCalendar.get(2);
        int firstYear = firstCalendar.get(1);
        GregorianCalendar secondCalendar = new GregorianCalendar();
        secondCalendar.setTime(second);
        int secondDay = secondCalendar.get(5);
        int secondMonth = secondCalendar.get(2);
        int secondYear = secondCalendar.get(1);
        int monthDiff = 0;
        if (firstCalendar.before(secondCalendar)) {
            if (firstYear == secondYear && firstMonth < secondMonth) {
                monthDiff += secondMonth - firstMonth;
                if (firstDay > secondDay) {
                    --monthDiff;
                }
            } else if (firstYear != secondYear) {
                monthDiff += (secondYear - firstYear - 1) * 12;
                monthDiff += 11 - firstMonth;
                monthDiff += secondMonth - 0;
                if (firstDay <= secondDay) {
                    ++monthDiff;
                }
            }
        } else {
            Log log = LogFactory.getLog((String)DateTimeUtil.class.getName());
            log.error((Object)"First must before Second.");
        }
        return monthDiff;
    }

    public static int dateDiffWeeks(Date first, Date second) {
        return DateTimeUtil.dateDiff(first, second) / 7;
    }

    public static String getDateString(Date javaDate, String dateFormat) {
        if (javaDate == null) {
            return null;
        }
        return new SimpleDateFormat(dateFormat).format(javaDate);
    }

    public static int getYear() {
        return DateTimeUtil.getYear(new Date());
    }

    public static int getYear(Date d) {
        if (TopUtil.isValidValue(d)) {
            return DateTimeUtil.getYear(new Timestamp(d.getTime()));
        }
        return 0;
    }

    public static int getYear(Timestamp ts) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(ts.getTime());
        return calendar.get(1);
    }

    public static int getMonth() {
        return DateTimeUtil.getMonth(new Date());
    }

    public static int getMonth(Date d) {
        if (TopUtil.isValidValue(d)) {
            return DateTimeUtil.getMonth(new Timestamp(d.getTime()));
        }
        return 0;
    }

    public static int getMonth(Timestamp ts) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(ts.getTime());
        return calendar.get(2) + 1;
    }

    public static int getDay() {
        return DateTimeUtil.getDay(new Date());
    }

    public static int getDay(Date d) {
        if (TopUtil.isValidValue(d)) {
            return DateTimeUtil.getDay(new Timestamp(d.getTime()));
        }
        return 0;
    }

    public static int getDay(Timestamp ts) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(ts.getTime());
        return calendar.get(5);
    }

    public static int getHour() {
        return DateTimeUtil.getHour(new Date());
    }

    public static int getHour(Date d) {
        if (TopUtil.isValidValue(d)) {
            return DateTimeUtil.getHour(new Timestamp(d.getTime()));
        }
        return 0;
    }

    public static int getHour(Timestamp ts) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(ts.getTime());
        return calendar.get(11);
    }

    public static int getMinute() {
        return DateTimeUtil.getMinute(new Date());
    }

    public static int getMinute(Date d) {
        if (TopUtil.isValidValue(d)) {
            return DateTimeUtil.getMinute(new Timestamp(d.getTime()));
        }
        return 0;
    }

    public static int getMinute(Timestamp ts) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(ts.getTime());
        return calendar.get(12);
    }

    public static int getSecond() {
        return DateTimeUtil.getSecond(new Date());
    }

    public static int getSecond(Date d) {
        if (TopUtil.isValidValue(d)) {
            return DateTimeUtil.getSecond(new Timestamp(d.getTime()));
        }
        return 0;
    }

    public static int getSecond(Timestamp ts) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(ts.getTime());
        return calendar.get(13);
    }

    public static int getMilliseconds() {
        return DateTimeUtil.getMilliseconds(new Date());
    }

    public static int getMilliseconds(Date d) {
        if (TopUtil.isValidValue(d)) {
            return DateTimeUtil.getMilliseconds(new Timestamp(d.getTime()));
        }
        return 0;
    }

    public static int getMilliseconds(Timestamp ts) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(ts.getTime());
        return calendar.get(14);
    }

    public static int getWeek() {
        return DateTimeUtil.getWeek(new Date());
    }

    public static int getWeek(Timestamp ts) {
        if (TopUtil.isValidValue(ts)) {
            return DateTimeUtil.getWeek(new Date(ts.getTime()));
        }
        return 0;
    }

    public static int getWeek(Date d) {
        if (TopUtil.isValidValue(d)) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(d);
            return gc.get(7) - 1;
        }
        return 0;
    }

    public static boolean isWorkDate(Date dt) {
        int d = DateTimeUtil.getWeek(dt);
        return d > 0 && d <= 5;
    }

    public static Date getFirstDayOfCurrentWeek() {
        Date dt = new Date();
        return DateTimeUtil.dateAdd(dt, -DateTimeUtil.getWeek(dt));
    }

    public static boolean isFirstDayOfCurrentWeek(Date dt) {
        return DateTimeUtil.dateToString(dt, SDFyyyyMMdd).equals(DateTimeUtil.dateToString(DateTimeUtil.getFirstDayOfCurrentWeek(), SDFyyyyMMdd));
    }

    public static Date getLastDayOfCurrentWeek() {
        return DateTimeUtil.dateAdd(DateTimeUtil.getFirstDayOfCurrentWeek(), 6);
    }

    public static Date getFirstDayOfCurrentMonth() {
        try {
            return new SimpleDateFormat(SDFyyyyMMdd).parse(DateTimeUtil.getYear() + "-" + DateTimeUtil.getMonth() + "-01");
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Date getLastDayOfCurrentMonth() {
        try {
            Date d = new SimpleDateFormat(SDFyyyyMMdd).parse(DateTimeUtil.getYear() + "-" + (DateTimeUtil.getMonth() + 1) + "-01");
            return DateTimeUtil.dateAdd(d, -1);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Date getLastDayOfCurrentMonth(Date dt) {
        try {
            Date d = new SimpleDateFormat(SDFyyyyMMdd).parse(DateTimeUtil.getYear(dt) + "-" + (DateTimeUtil.getMonth(dt) + 1) + "-01");
            return DateTimeUtil.dateAdd(d, -1);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getDaysOfMonth(String yyyyMM) {
        Date fromDt = DateTimeUtil.stringToDate(yyyyMM + "01", "yyyyMMdd");
        return DateTimeUtil.dateDiff(fromDt, DateTimeUtil.getLastDayOfCurrentMonth(fromDt));
    }

    public static int getAge(Date d) {
        if (d == null) {
            return 0;
        }
        String ds = DateTimeUtil.dateToString(d, SDFyyyyMMdd);
        int age = DateTimeUtil.getYear() - Integer.parseInt(ds.substring(0, 4)) - 1;
        if (Integer.parseInt(ds.substring(5, 7)) < DateTimeUtil.getMonth()) {
            ++age;
        } else if (Integer.parseInt(ds.substring(8, 10)) <= DateTimeUtil.getDay()) {
            ++age;
        }
        return age;
    }

    public static Date ageToDate(int age) {
        if (age <= 0) {
            return null;
        }
        Calendar ca = Calendar.getInstance();
        ca.set(DateTimeUtil.getYear() - age, DateTimeUtil.getMonth() - 1, DateTimeUtil.getDay());
        return ca.getTime();
    }

    public static String getYearMonth(Date start, Date end) {
        int days = DateTimeUtil.dateDiff(start, end);
        if (days > 360 && days < 367) {
            return "1\u5e74";
        }
        if (days < 360) {
            int n = days / 30;
            if (days % 30 > 10) {
                ++n;
            }
            return n + "\u4e2a\u6708";
        }
        if (days >= 360) {
            int yr = days / 365;
            int mn = 0;
            if ((days %= 365) > 25 && days < 30) {
                mn = 1;
            } else {
                mn = days / 30;
                if (days % 30 > 10) {
                    ++mn;
                }
                if (mn == 12) {
                    ++yr;
                    mn = 0;
                }
            }
            if (mn > 0) {
                return yr + "\u5e74" + mn + "\u4e2a\u6708";
            }
            return yr + "\u5e74";
        }
        return null;
    }

    public static String dateToString(Date date, String format) {
        if (date == null || format == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static Date stringToDate(String date, String format) {
        if (date == null || format == null || date == "") {
            return null;
        }
        try {
            return new SimpleDateFormat(format).parse(date);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static String getBirthDayByIdCard(String idCard) {
        String bir = null;
        int len = idCard.length();
        if (len == 15) {
            bir = "19" + idCard.substring(6, 8) + "-" + idCard.substring(8, 10) + "-" + idCard.substring(10, 12);
        } else if (len == 18) {
            bir = idCard.substring(6, 10) + "-" + idCard.substring(10, 12) + "-" + idCard.substring(12, 14);
        }
        return bir;
    }

    public static String hmsDiff(Date first, Date second) {
        if (first == null || second == null) {
            return "";
        }
        String str = "";
        if (first.after(second)) {
            str = str + "-";
        }
        long time = Math.abs(second.getTime() - first.getTime());
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        hours = time / 3600000L;
        if (hours > 0L) {
            time %= 3600000L;
        }
        seconds = (minutes = time / 60000L) > 0L ? time % 60000L / 1000L : time / 1000L;
        return str + (hours > 9L ? Long.valueOf(hours) : "0" + hours) + ":" + (minutes > 9L ? Long.valueOf(minutes) : "0" + minutes) + ":" + (seconds > 9L ? Long.valueOf(seconds) : "0" + seconds);
    }

    public static String dhmsDiff(Date first, Date second) {
        if (first == null || second == null) {
            return "";
        }
        String str = "";
        if (first.after(second)) {
            str = str + "-";
        }
        long time = Math.abs(second.getTime() - first.getTime());
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        days = time / 86400000L;
        if (days > 0L) {
            time %= 86400000L;
        }
        if ((hours = time / 3600000L) > 0L) {
            time %= 3600000L;
        }
        seconds = (minutes = time / 60000L) > 0L ? time % 60000L / 1000L : time / 1000L;
        return str + days + "," + (hours > 9L ? Long.valueOf(hours) : "0" + hours) + ":" + (minutes > 9L ? Long.valueOf(minutes) : "0" + minutes) + ":" + (seconds > 9L ? Long.valueOf(seconds) : "0" + seconds);
    }

    public static Date genDate(String year, String month) {
        Calendar cal = Calendar.getInstance();
        cal.set(Integer.parseInt(year), Integer.parseInt(month) - 1, 0, 0, 0, 0);
        cal.set(11, 24);
        return cal.getTime();
    }

    public static Date parseStandardDate(String value) {
        Date date = null;
        int n = value.length();
        try {
            if (n >= SDFyyyyMMddHHmmssS.length()) {
                date = new SimpleDateFormat(SDFyyyyMMddHHmmssS).parse(value);
            } else if (n == SDFyyyyMMddHHmmss.length()) {
                date = new SimpleDateFormat(SDFyyyyMMddHHmmss).parse(value);
            } else if (n == SDFyyyyMMddHHmm.length()) {
                date = new SimpleDateFormat(SDFyyyyMMddHHmm).parse(value);
            } else if (n == SDFyyyyMMddHH.length()) {
                date = new SimpleDateFormat(SDFyyyyMMddHH).parse(value);
            } else if (n == SDFyyyyMMdd.length()) {
                date = new SimpleDateFormat(SDFyyyyMMdd).parse(value);
            } else if (n == SDFyyyyMM.length()) {
                date = new SimpleDateFormat(SDFyyyyMM).parse(value);
            }
        }
        catch (ParseException e) {
            Log log = LogFactory.getLog((String)DateTimeUtil.class.getName());
            log.warn((Object)("Can not parse [" + value + "] to java.util.Date"));
        }
        return date;
    }

    public static Date addMinutes(Date oldDate, int minutes) {
        if (ObjectUtils.isNotEmpty((Object)oldDate)) {
            return new Date(oldDate.getTime() + (long)minutes * 60000L);
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(DateTimeUtil.getWeek(DateTimeUtil.stringToDate("2014-09-14", SDFyyyyMMdd)));
    }
}

