/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Pattern;

public class TopUtil {
    private static final char fileSeq = System.getProperties().getProperty("file.separator").charAt(0);

    public static String getUrlChar() {
        return System.getProperties().getProperty("file.separator");
    }

    public static String replaceAll(String src, char oldChar, char newChar) {
        int len = src.length();
        for (int i = 0; i < len; ++i) {
            src = src.replace(oldChar, newChar);
        }
        return src;
    }

    public static String getRandNumber(int n) {
        String rn = "";
        if (n > 0 && n < 10) {
            Random r = new Random();
            String str = "";
            for (int i = 0; i < n; ++i) {
                str = str + "9";
            }
            int num = Integer.parseInt(str);
            while (rn.length() < n) {
                rn = "" + r.nextInt(num);
            }
        } else {
            rn = "0";
        }
        return rn;
    }

    public static String getRandChars(int n) {
        String[] chars = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        String rn = "";
        if (n > 0 && n < 10) {
            Random r = new Random();
            while (rn.length() < n) {
                rn = rn + chars[r.nextInt(chars.length)];
            }
        } else {
            rn = "0";
        }
        return rn;
    }

    public static boolean isValidValue(String value) {
        if (value == null) {
            return false;
        }
        return !value.trim().equals("");
    }

    public static boolean isValidValue(Integer value) {
        return value != null;
    }

    public static boolean isValidValue(Long value) {
        return value != null;
    }

    public static boolean isValidValue(Float value) {
        return value != null;
    }

    public static boolean isValidValue(Double value) {
        return value != null;
    }

    public static boolean isValidValue(Date value) {
        if (value == null) {
            return false;
        }
        return !value.equals("");
    }

    public static boolean isValidValue(Object value) {
        if (value == null) {
            return false;
        }
        return !value.equals("");
    }

    public static String getClassPhysicalPath(Class cls) {
        String path = cls.getResource("").getPath();
        if (System.getProperty("os.name").startsWith("Windows")) {
            path = path.substring(path.lastIndexOf(":") - 1);
        }
        return path;
    }

    public static String getPackagePhysicalPath(Class cls) {
        String path = cls.getResource("").getPath();
        path = System.getProperty("os.name").startsWith("Windows") ? path.substring(path.lastIndexOf(":") - 1) : path.substring(5);
        String packageName = cls.getPackage().getName();
        if ((path = path.substring(0, path.indexOf(packageName = TopUtil.replaceAll(packageName, '.', '/') + "/"))).indexOf(".jar!/") != -1) {
            int n = path.lastIndexOf(".jar");
            path = path.substring(0, n);
            path = path.substring(0, path.lastIndexOf("/") + 1);
        }
        return path;
    }

    public static String getJarFileName(Class cls) {
        String path = cls.getResource("").getPath();
        path = System.getProperty("os.name").startsWith("Windows") ? path.substring(path.lastIndexOf(":") - 1) : path.substring(5);
        String packageName = cls.getPackage().getName();
        int n = (path = path.substring(0, path.indexOf(packageName = TopUtil.replaceAll(packageName, '.', '/') + "/"))).lastIndexOf(".jar");
        if (n == -1) {
            return "";
        }
        path = path.substring(0, n);
        return path.substring(path.lastIndexOf("/") + 1, path.length()) + ".jar";
    }

    public static String firstCharToUpperCase(String src) {
        return src.substring(0, 1).toUpperCase() + src.substring(1);
    }

    public static String firstCharToLowerCase(String src) {
        return src.substring(0, 1).toLowerCase() + src.substring(1);
    }

    public static String getSystemMemoryStatus() {
        NumberFormat nfFloat = NumberFormat.getNumberInstance();
        Runtime runTime = Runtime.getRuntime();
        long mb = 0x100000L;
        long free = runTime.freeMemory() / mb;
        long total = runTime.totalMemory() / mb;
        long max = runTime.maxMemory() / mb;
        float percent = (float)(total - free) / (float)total * 100.0f;
        nfFloat.setMaximumFractionDigits(2);
        return "Memory(MB)[Free:" + free + ",Total:" + total + ",Max:" + max + ",Used Percent:" + nfFloat.format(percent) + "%]";
    }

    public static byte[] inputStreamToByte(InputStream is) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] bt = new byte[1024];
            int s = 0;
            while ((s = is.read(bt)) != -1) {
                bos.write(bt, 0, s);
            }
            bt = bos.toByteArray();
            bos.close();
            return bt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String compress(String src) {
        return Pattern.compile("\\s*|\t|\r|\n").matcher(src).replaceAll("");
    }

    public static void printSystemProperties() {
        Properties p = System.getProperties();
        for (Object key : p.keySet()) {
            System.out.println("key=" + key + ",value=" + System.getProperty(key + ""));
        }
    }

    public static void main(String[] args) {
        System.out.println(TopUtil.getRandChars(5));
    }
}

