/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataChange;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.Consumer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DataChangeInterceptUtils {
    private static final Logger log = LoggerFactory.getLogger(DataChangeInterceptUtils.class);
    public static boolean LIMIT_FLAG = false;
    public static String LIMIT_KET = "DataChangeInterceptUtils";
    static Pattern updatePattern = Pattern.compile("(?i)\\bWHERE\\s+(.+?)\\s*;", 32);
    static Pattern deletePattern = Pattern.compile("(?i)DELETE\\s+(?i)FROM\\s+(\\w+)\\s+(?i)WHERE\\s+(.+?)\\s*;", 32);
    static Pattern insertPattern = Pattern.compile("(?i)INSERT\\s+(?i)INTO\\s+\\w+\\s*\\((.*)\\)\\s*(?i)VALUES\\s*(.*);");
    public static List<Pattern> REGISTER_TABLE = new ArrayList<Pattern>();

    public static boolean isTableRegistered(String tableName) {
        for (Pattern pattern : REGISTER_TABLE) {
            Matcher matcher = pattern.matcher(tableName);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public static void registerSynchronizationAfterCompletion(final Consumer consumer) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCompletion(int status) {
                    consumer.accept();
                }
            });
        } else {
            consumer.accept();
        }
    }

    public static List<Long> getChangeIds(String sql, String sqlType, String tableName) {
        switch (sqlType) {
            case "UPDATE": 
            case "DELETE": {
                String querySql = DataChangeInterceptUtils.getQuerySql(sql, tableName, "UPDATE".equals(sqlType) ? updatePattern : deletePattern);
                if (querySql == null) {
                    return null;
                }
                return DataChangeInterceptUtils.executeSql(querySql);
            }
            case "INSERT": {
                return DataChangeInterceptUtils.parseMultiValues(sql + ";");
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static List<Long> executeSql(String sql) {
        try (Connection connection = ((DataSource)SpringBeanUtil.getBean(DataSource.class)).getConnection();){
            CallableStatement preparedStatement = connection.prepareCall(sql);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<Long> ids = new ArrayList<Long>();
            while (resultSet.next()) {
                long id = resultSet.getLong("id");
                ids.add(id);
            }
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
        catch (SQLException e) {
            log.error("\u83b7\u53d6\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    @Nullable
    private static String getQuerySql(String sql, String tableName, Pattern updatePattern) {
        Matcher matcher = updatePattern.matcher(sql + ";");
        if (matcher.find()) {
            String conditions = matcher.group(1);
            return "SELECT id FROM " + tableName + " WHERE " + conditions;
        }
        return null;
    }

    public static void setIntercept(String table, String sqlType) {
        ServiceContext.getContext().setAttachment(LIMIT_KET, table + "__" + sqlType);
    }

    public static String revIntercept() {
        String attachment = ServiceContext.getContext().getAttachment(LIMIT_KET);
        ServiceContext.getContext().removeAttachment(LIMIT_KET);
        return attachment;
    }

    public static List<Long> parseMultiValues(String insertSql) {
        ArrayList<Long> valuesList = new ArrayList<Long>();
        Matcher matcher = insertPattern.matcher(insertSql);
        if (matcher.find()) {
            String valuesPart = matcher.group(2).trim();
            Matcher valuesMatcher = Pattern.compile("\\((.*?)\\)").matcher(valuesPart);
            while (valuesMatcher.find()) {
                String values = valuesMatcher.group(1);
                valuesList.add(Long.valueOf(values.split(",")[0].trim()));
            }
        } else {
            throw new IllegalArgumentException("Invalid INSERT SQL statement");
        }
        return valuesList;
    }

    public static void main(String[] args) {
        String sql = "UPDATE sh_virtual_inventory SET balance = case when id = ? and balance = ? then balance + ? when id = ? and balance = ? then balance + ?  else 'error' end, preempt = case when id = ? and preempt = ? then preempt + ? when id = ? and preempt = ? then preempt + ?  else 'error' end, available = case when id = ? and available = ? then available + ? when id = ? and available = ? then available + ?  else 'error' end, dispatch = case when id = ? and dispatch = ? then dispatch + ? when id = ? and dispatch = ? then dispatch + ?  else 'error' end, update_person = case id when ? then ? when ? then ? end, update_time = case id when ? then now() when ? then now() end WHERE id in (?, \n\t?);;;;";
        Pattern pattern = Pattern.compile("(?i)\\bWHERE\\s+(.+?)\\s*;", 32);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            String whereClause = matcher.group(1).trim();
            System.out.println("WHERE clause: " + whereClause);
        } else {
            System.out.println("No match found");
        }
    }
}

