/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataChange;

import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.pool.DruidPooledPreparedStatement;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxyImpl;
import com.dtyunxi.huieryun.util.EoUtil;
import com.dtyunxi.util.SpringBeanUtil;
import com.yunxi.dg.base.commons.dataChange.DataChangeInterceptUtils;
import com.yunxi.dg.base.commons.dataChange.DataChangeMsgBo;
import com.yunxi.dg.base.commons.dataChange.RealSqlStrategyUtil;
import com.yunxi.dg.base.commons.mq.DgSendMqHelper;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.logging.jdbc.PreparedStatementLogger;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class DataChangeUpdateInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DataChangeUpdateInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        String key = DataChangeInterceptUtils.revIntercept();
        if (StrUtil.isBlank((CharSequence)key)) {
            return invocation.proceed();
        }
        Statement s = (Statement)invocation.getArgs()[0];
        PreparedStatementLogger o = (PreparedStatementLogger)DataChangeUpdateInterceptor.realTarget(s);
        Statement stmt = ((DruidPooledPreparedStatement)o.getPreparedStatement()).getStatement();
        PreparedStatement pstmt = null;
        if (stmt instanceof PreparedStatementProxyImpl) {
            pstmt = ((PreparedStatementProxyImpl)stmt).getRawObject();
        }
        String sql = RealSqlStrategyUtil.getSql(pstmt);
        String[] split = key.split("__");
        log.info("\u66f4\u65b0sql:{}", (Object)sql);
        String sqlType = split[1];
        List<Long> ids = DataChangeInterceptUtils.getChangeIds(sql, sqlType, split[0]);
        DataChangeMsgBo changeMsgBo = DataChangeMsgBo.builder().changeType(sqlType).tableName(split[0]).ids(ids).build();
        if (CollectionUtils.isEmpty(changeMsgBo.getIds())) {
            return invocation.proceed();
        }
        Object proceed = invocation.proceed();
        DataChangeInterceptUtils.registerSynchronizationAfterCompletion(() -> ((DgSendMqHelper)SpringBeanUtil.getBean(DgSendMqHelper.class)).sendPublishMq("${data.change.mq:PUBLISH_TOPIC}", changeMsgBo, "MQ_DATA_CHANGE_DISTRIBUTE"));
        return proceed;
    }

    public static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return DataChangeUpdateInterceptor.realTarget(metaObject.getValue("h"));
        }
        return (T)target;
    }

    private Class<?> getaClass(MappedStatement mappedStatement) throws ClassNotFoundException {
        return this.getEoClass(mappedStatement);
    }

    private Class<?> getEoClass(MappedStatement mappedStatement) throws ClassNotFoundException {
        Class<?> classType = Class.forName(mappedStatement.getId().substring(0, mappedStatement.getId().lastIndexOf(".")));
        return EoUtil.getEoClass(classType);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

