/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataLimit;

import com.yunxi.dg.base.commons.dataLimit.DataLimitHeadWebMvcConfigurer;
import com.yunxi.dg.base.commons.dataLimit.DataLimitReqWebMvcConfigurer;
import com.yunxi.dg.base.commons.dataLimit.DataLimitSettingUtils;
import feign.RequestInterceptor;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="${data.limit.effect.enable:false}==true")
public class DataLimitEnableConfig {
    private static final Logger log = LoggerFactory.getLogger(DataLimitEnableConfig.class);

    @Bean
    public DataLimitHeadWebMvcConfigurer dataLimitHeadWebMvcConfigurer() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add("/swagger-resources/**");
        urls.add("/swagger-resources");
        urls.add("/webjars/springfox-swagger-ui/**");
        urls.add("/webjars/springfox-swagger-ui/*.*");
        urls.add("/swagger-ui.html");
        urls.add("/swagger-ui/*.*");
        urls.add("/v2/api-docs");
        urls.add("/favicon.ico");
        urls.add("/xapi.html");
        urls.add("/xapi/**");
        log.info("dataLimitReqWebMvcConfigurer\u8f7d\u5165");
        return new DataLimitHeadWebMvcConfigurer().setExcludePathPatterns(urls);
    }

    @Bean
    public RequestInterceptor requestInterceptor() {
        return template -> Optional.ofNullable(DataLimitSettingUtils.getDataLimitValue()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(r -> template.header("yx.dg.data.limit.enable.header", new String[]{DataLimitSettingUtils.getDataLimitValue()}));
    }

    @Bean
    @ConditionalOnExpression(value="${data.limit.effect.filter.enable:false}==true")
    public DataLimitReqWebMvcConfigurer dataLimitReqWebMvcConfigurer() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add("/swagger-resources/**");
        urls.add("/swagger-resources");
        urls.add("/webjars/springfox-swagger-ui/**");
        urls.add("/webjars/springfox-swagger-ui/*.*");
        urls.add("/swagger-ui.html");
        urls.add("/swagger-ui/*.*");
        urls.add("/v2/api-docs");
        urls.add("/favicon.ico");
        urls.add("/xapi.html");
        urls.add("/xapi/**");
        log.info("dataLimitReqWebMvcConfigurer\u8f7d\u5165");
        return new DataLimitReqWebMvcConfigurer().setExcludePathPatterns(urls);
    }
}

