/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.commons.dataLimit;

import com.dtyunxi.app.ServiceContext;
import com.yunxi.dg.base.commons.dataLimit.annotations.DataLimitSelector;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="${dtyunxi.cube.starter.data.limit.enable}==true")
@Aspect
public class DataLimitSelectorAspect {
    private static final Logger log = LoggerFactory.getLogger(DataLimitSelectorAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(com.yunxi.dg.base.commons.dataLimit.annotations.DataLimitSelector)")
    public Object checkPermission(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        DataLimitSelector annotation = signature.getMethod().getAnnotation(DataLimitSelector.class);
        ServiceContext.getContext().setAttachment("data_limit_authority_selector", annotation.tableName());
        ServiceContext.getContext().setAttachment("data_limit_authority_selector_counter", "1000");
        try {
            Object object = joinPoint.proceed(joinPoint.getArgs());
            return object;
        }
        finally {
            ServiceContext.getContext().remove("data_limit_authority_selector");
            ServiceContext.getContext().remove("data_limit_authority_selector_counter");
        }
    }
}

