{
  "MD5Code": "${vo.md5Code}",
  "openapi": "3.0.1",
  "info":
  {
    "title": "${vo.apifox.appCode}",
    "description": "${vo.apifox.appName}",
    "version": "${vo.apifox.version}"
  },
  "tags":
  [
    <#list vo.apifox.tagList as tag>
    {"name": "${tag.code}-${tag.name}"}<#if tag_has_next>,</#if>
    </#list>
  ],
  "servers": [],
  "components":
  {
      "schemas":
      {
            "BaseDto":
            {
                "type": "object",
                "title": "BaseDto-基类对象",
                "x-apifox-folder": "",
                "properties":
                {
                  "id":
                  {
                    "type": "integer",
                    "title": "ID主键"
                  },
                  "createPerson":
                  {
                    "type": "string",
                    "title": "创建者"
                  },
                  "createTime":
                   {
                    "type": "string",
                    "default": "",
                    "examples": ["2022-12-01 00:00:00"],
                    "minLength": 0,
                    "maxLength": 19,
                    "title": "创建时间",
                    "format": "date-time"
                  },
                  "updatePerson":
                  {
                    "type": "string",
                    "title": "更新者"
                  },
                  "updateTime":
                  {
                    "type": "string",
                    "title": "更新时间",
                    "format": "date-time"
                  },
                  "dr":
                  {
                    "type": "integer",
                    "title": "逻辑删除标识",
                    "description": "1是0非"
                  },
                  "tenantId":
                  {
                    "type": "integer",
                    "title": "租户ID"
                  },
                  "instanceId":
                  {
                    "type": "integer",
                    "title": "实例ID"
                  },
                  "extension":
                  {
                    "type": "string",
                    "title": "扩展字段"
                  }
                },
                "x-apifox-orders":
                [
                  "id",
                  "createPerson",
                  "createTime",
                  "updatePerson",
                  "updateTime",
                  "dr",
                  "tenantId",
                  "instanceId",
                  "extension"
                ],
                "x-apifox-ignore-properties": []
            },
            "BasePageDto":
            {
                "type": "object",
                "title": "BasePageDto-分页基类对象",
                "x-apifox-folder": "",
                "properties":
                {
                  "id":
                  {
                    "type": "integer",
                    "title": "ID主键"
                  },
                  "createPerson":
                  {
                    "type": "string",
                    "title": "创建者"
                  },
                  "createTime":
                  {
                    "type": "string",
                    "default": "",
                    "examples": ["2022-12-01 00:00:00"],
                    "minLength": 0,
                    "maxLength": 19,
                    "title": "创建时间",
                    "format": "date-time"
                  },
                  "updatePerson":
                  {
                    "type": "string",
                    "title": "更新者"
                  },
                  "updateTime":
                  {
                    "type": "string",
                    "title": "更新时间",
                    "format": "date-time"
                  },
                  "dr":
                  {
                    "type": "integer",
                    "title": "逻辑删除标识",
                    "description": "1是0非"
                  },
                  "tenantId":
                  {
                    "type": "integer",
                    "title": "租户ID"
                  },
                  "instanceId":
                  {
                    "type": "integer",
                    "title": "实例ID"
                  },
                  "extension":
                  {
                    "type": "string",
                    "title": "扩展字段"
                  },
                  "pageNum":
                   {
                    "type": "integer",
                    "title": "页面号",
                    "default": 1
                  },
                  "pageSize":
                  {
                    "type": "integer",
                    "title": "每页记录数",
                    "default": 10
                  },
                  "sorts":
                  {
                    "type": "array",
                    "items":
                    {
                      "$ref": "#/components/SortDto"
                    },
                    "title": "排序参数集合"
                  }
                },
                "x-apifox-orders":
                [
                  "REF_BaseDto",
                  "pageNum",
                  "pageSize",
                  "sorts"
                ],
                "required":
                [
                  "pageNum",
                  "pageSize"
                ],
                "x-apifox-refs":
                {
                  "REF_BaseDto":
                  {
                    "$ref": "#/components/schemas/BaseDto"
                  }
                },
                "x-apifox-ignore-properties":
                [
                  "id",
                  "createPerson",
                  "createTime",
                  "updatePerson",
                  "updateTime",
                  "dr",
                  "tenantId",
                  "instanceId",
                  "extension"
                ]
          },
          "SortDto":
          {
                "type": "object",
                "title": "SortDto-排序参数",
                "x-apifox-folder": "",
                "properties":
                {
                  "field":
                  {
                    "type": "string",
                    "title": "排序字段"
                  },
                  "direction":
                  {
                    "type": "string",
                    "title": "排序方向",
                    "description": "'DESC'-降序，'ASC'-升序",
                    "default": "ASC"
                  }
                },
                "x-apifox-orders": [
                  "field",
                  "direction"
                ],
                "x-apifox-ignore-properties": []
          },
          "PageInfo":
          {
                "type": "object",
                "title": "PageInfo-分页器对象",
                "x-apifox-folder": "",
                "properties":
                {
                  "pageNum":
                  {
                    "type": "integer",
                    "title": "页面号"
                  },
                  "pageSize":
                  {
                    "type": "integer",
                    "title": "每页记录数"
                  },
                  "size":
                  {
                    "type": "integer",
                    "title": "每页记录数"
                  },
                  "startRow":
                  {
                    "type": "integer",
                    "title": "开始记录下标"
                  },
                  "endRow":
                  {
                    "type": "integer",
                    "title": "结束记录下标"
                  },
                  "pages":
                  {
                    "type": "integer",
                    "title": "总页数"
                  },
                  "prePage":
                  {
                    "type": "integer",
                    "title": "上一页"
                  },
                  "nextPage":
                   {
                    "type": "string",
                    "title": "下一页"
                  },
                  "isFirstPage":
                  {
                    "type": "boolean",
                    "title": "是否首页"
                  },
                  "isLastPage":
                  {
                    "type": "boolean",
                    "title": "是否尾页"
                  },
                  "hasPreviousPage":
                  {
                    "type": "boolean",
                    "title": "是否有上一页"
                  },
                  "hasNextPage":
                  {
                    "type": "boolean",
                    "title": "是否有下一页"
                  },
                  "navigatePages":
                  {
                    "type": "integer",
                    "title": "导航页数"
                  },
                  "navigatepageNums":
                  {
                    "type": "array",
                    "items":
                    {
                      "type": "integer"
                    },
                    "title": "导航页码数组"
                  },
                  "navigateFirstPage":
                   {
                    "type": "integer",
                    "title": "导航首页"
                  },
                  "navigateLastPage":
                  {
                    "type": "integer",
                    "title": "导航末页"
                  },
                  "total":
                   {
                    "type": "integer",
                    "title": "总记录数"
                  },
                  "list":
                  {
                    "type": "array",
                    "items":
                    {
                      "type": "object",
                      "properties": {},
                      "x-apifox-orders": [],
                      "x-apifox-ignore-properties": []
                    },
                    "title": "数据集合"
                  }
                },
                "x-apifox-orders":
                [
                  "pageNum",
                  "pageSize",
                  "size",
                  "startRow",
                  "endRow",
                  "pages",
                  "prePage",
                  "nextPage",
                  "isFirstPage",
                  "isLastPage",
                  "hasPreviousPage",
                  "hasNextPage",
                  "navigatePages",
                  "navigatepageNums",
                  "navigateFirstPage",
                  "navigateLastPage",
                  "total",
                  "list"
                ],
                "x-apifox-ignore-properties": []
          },
          "RestResponse":
          {
            "type": "object",
            "title": "RestResponse-请求响应对象",
            "x-apifox-folder": "",
            "properties":
            {
              "resultCode":
              {
                "type": "string",
                "title": "结果编码",
                "description": "0-成功，100000-失败"
              },
              "resultMsg":
              {
                "type": "string",
                "title": "结果信息"
              },
              "extFields":
              {
                "type": "object",
                "properties": {},
                "title": "扩展属性集合",
                "x-apifox-ignore-properties": [],
                "x-apifox-orders": []
              },
              "data":
              {
                "type": "object",
                "title": "业务对象",
                "properties": {},
                "x-apifox-orders": [],
                "x-apifox-ignore-properties": []
              }
            },
            "x-apifox-orders":
            [
              "resultCode",
              "resultMsg",
              "extFields",
              "data"
            ],
            "required":
            [
              "resultCode"
            ],
            "x-apifox-ignore-properties": []
          }<#if vo.apifox.componentList??>,</#if>
          <#list vo.apifox.componentList as component>
          "${component.name}":
          {
            "type": "object",
            "title": "${component.title}",
            "description": "${component.desc}",
            "x-apifox-folder": "${component.entityCode}-${component.entityName}",
            "properties":
            {
              "id":
              {
                "type": "integer",
                "title": "ID主键"
              },
              "createPerson":
              {
                "type": "string",
                "title": "创建者"
              },
              "createTime":
              {
                "type": "string",
                "title": "创建时间",
                "default": "",
                "examples": ["2022-12-01 00:00:00"],
                "minLength": 0,
                "maxLength": 19,
                "format": "date-time"
              },
              "updatePerson":
              {
                "type": "string",
                "title": "更新者"
              },
              "updateTime":
              {
                "type": "string",
                "title": "更新时间",
                "format": "date-time"
              },
              "dr":
              {
                "type": "integer",
                "title": "逻辑删除标识",
                "description": "1是0非"
              },
              "tenantId":
              {
                "type": "integer",
                "title": "租户ID"
              },
              "instanceId":
              {
                "type": "integer",
                "title": "实例ID"
              },
              "extension":
              {
                "type": "string",
                "title": "扩展字段"
              },
              <#list component.propertiesList as properties>
              "${properties.name}":
              {
                "type": "${properties.type}",
                "title": "${properties.title}",
                <#if properties.ref??>
                "$ref": "#/components/${properties.ref}",
                </#if>
                "description": "${properties.desc}"
              }<#if properties_has_next>,</#if>
              </#list>
            },
            "x-apifox-orders":
            [
              "REF_${component.ref}",
              <#list component.propertiesList as properties>
              "${properties.name}"<#if properties_has_next>,</#if>
              </#list>
            ],
            "x-apifox-refs":
            {
              "REF_BaseDto":
              {
                "$ref": "#/components/${component.ref}"
              }
            },
            "required":[],
            "x-apifox-ignore-properties":
            [
              "id",
              "createPerson",
              "createTime",
              "updatePerson",
              "updateTime",
              "dr",
              "tenantId",
              "instanceId",
              "extension"
            ]
          }<#if component_has_next>,</#if>
          </#list>
      }
  },
  "paths":
  {
    <#list vo.apifox.pathList as path>
    "${path.uri}":
    {
      "post": {
        "summary": "${path.methodName}-${path.methodDesc}",
        "x-apifox-folder": "${path.apiCode}-${path.domainName}服务接口",
        "x-apifox-status": "developing",
        "deprecated": false,
        "description": "${path.methodDesc}",
        "tags": ["${path.apiCode}-${path.domainName}服务接口"],
        "parameters":
        [
            <#if path.reqParameter??>
            {
              "name": "${path.reqParameter.name}",
              "in": "path",
              "description": "${path.reqParameter.desc}",
              "required": ${path.reqParameter.required?c},
              "schema": {"type": "${path.reqParameter.type}"}
            }
            </#if>
        ],
        <#if path.reqDtoName??>
        "requestBody":
        {
          "content":
          {
            "application/json":
            {
              "schema":
              {
                "$ref": "#/components/${path.reqDtoName}"
              }
            }
          }
        },
        </#if>
        "responses":
        {
          "200":
          {
            "description": "成功",
            "content":
            {
              "application/json":
              {
                "schema":
                {
                  "type": "object",
                  "properties":
                  {
                    "resultCode":
                    {
                      "type": "string",
                      "title": "结果编码",
                      "description": "0-成功，100000-失败"
                    },
                    "resultMsg":
                    {
                      "type": "string",
                      "title": "结果信息"
                    },
                    "extFields":
                    {
                      "type": "object",
                      "properties": {},
                      "title": "扩展属性集合",
                      "x-apifox-ignore-properties": [],
                      "x-apifox-orders": []
                    },
                    "data":
                    {
                      <#if path.respDataDto.ref??>
                      "$ref": "#/components/${path.respDataDto.ref}"
                      <#else>
                      "type": "${path.respDataDto.type}",
                      "title": "${path.respDataDto.title}",
                      <#if path.isPage>
                      "x-apifox-refs":
                      {
                          "REF_PageInfo":
                          {
                            "$ref": "#/components/schemas/PageInfo",
                            "x-apifox-overrides": {}
                          }
                      },
                      "properties":
                      {
                          "pageNum":
                          {
                            "type": "integer",
                            "title": "页面号"
                          },
                          "pageSize":
                          {
                            "type": "integer",
                            "title": "每页记录数"
                          },
                          "size":
                          {
                            "type": "integer",
                            "title": "每页记录数"
                          },
                          "startRow":
                          {
                            "type": "integer",
                            "title": "开始记录下标"
                          },
                          "endRow":
                          {
                            "type": "integer",
                            "title": "结束记录下标"
                          },
                          "pages":
                          {
                            "type": "integer",
                            "title": "总页数"
                          },
                          "prePage":
                          {
                            "type": "integer",
                            "title": "上一页"
                          },
                          "nextPage":
                          {
                            "type": "string",
                            "title": "下一页"
                          },
                          "isFirstPage":
                          {
                            "type": "boolean",
                            "title": "是否首页"
                          },
                          "isLastPage":
                          {
                            "type": "boolean",
                            "title": "是否尾页"
                          },
                          "hasPreviousPage":
                          {
                            "type": "boolean",
                            "title": "是否有上一页"
                          },
                          "hasNextPage":
                          {
                            "type": "boolean",
                            "title": "是否有下一页"
                          },
                          "navigatePages":
                          {
                            "type": "integer",
                            "title": "导航页数"
                          },
                          "navigatepageNums":
                          {
                            "type": "array",
                            "items": {"type": "integer"},
                            "title": "导航页码数组"
                          },
                          "navigateFirstPage":
                          {
                            "type": "integer",
                            "title": "导航首页"
                          },
                          "navigateLastPage":
                          {
                            "type": "integer",
                            "title": "导航末页"
                          },
                          "total":
                          {
                            "type": "integer",
                            "title": "总记录数"
                          },
                          "list":
                          {
                            "type": "array",
                            "items":
                            {
                              "$ref": "#/components/${path.respDataDto.listDtoName}"
                            },
                            "title": "数据集合"
                          }
                        },
                        "required": ["list"],
                        "x-apifox-orders": ["REF_PageInfo","list"],
                        "x-apifox-ignore-properties":
                        [
                          "pageNum",
                          "pageSize",
                          "size",
                          "startRow",
                          "endRow",
                          "pages",
                          "prePage",
                          "nextPage",
                          "isFirstPage",
                          "isLastPage",
                          "hasPreviousPage",
                          "hasNextPage",
                          "navigatePages",
                          "navigatepageNums",
                          "navigateFirstPage",
                          "navigateLastPage",
                          "total"
                        ],
                      </#if>
                      "description": "${path.respDataDto.desc}"
                      </#if>
                    }
                  },
                  "x-apifox-orders": ["REF_RestResponse","data"],
                  "required":["data","resultCode"],
                  "x-apifox-refs": {"REF_RestResponse": {"$ref": "#/components/schemas/RestResponse"}},
                  "x-apifox-ignore-properties": ["resultCode","resultMsg","extFields"]
                }
              }
            }
          }
        },
        "x-run-in-apifox'": "https://www.apifox.cn/web/project/2024918/apis/api-${path.apiCode}-${path.methodName}-run"
      }
    }<#if path_has_next>,</#if>
    </#list>
  }
}