package ${vo.basePackage}.rest.entity;

import javax.annotation.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import ${vo.basePackage}.api.entity.I${vo.baseBeanName}Api;
import ${vo.basePackage}.dto.entity.${vo.baseBeanName}Dto;
import ${vo.basePackage}.dto.entity.${vo.baseBeanName}PageReqDto;
import ${vo.basePackage}.service.entity.I${vo.baseBeanName}Service;

/**
 * @Description ${vo.baseBeanDesc} Restful Api接口服务
 * @Author 代码生成器
 * @Date ${vo.date}
 * @TemplateVersion ${vo.version}
 ${vo.md5Code}
 **/
@RestController
@Api(tags = {"${vo.appName}:${vo.baseBeanDesc}接口服务"})
public class ${vo.baseBeanName}Controller implements I${vo.baseBeanName}Api {

    @Resource
    private I${vo.baseBeanName}Service service;

    @Override
    public RestResponse<Long> insert(@RequestBody ${vo.baseBeanName}Dto dto) {
         return service.insert(dto);
    }

    @Override
    public RestResponse update(@RequestBody ${vo.baseBeanName}Dto dto) {
         return service.update(dto);
    }

    @Override
    public RestResponse<${vo.baseBeanName}Dto> get(Long id) {
         return service.get(id);
    }

    @Override
    public RestResponse logicDelete(@PathVariable(name="id",required=true) Long id) {
         return service.logicDelete(id);
    }

    @Override
    public RestResponse<PageInfo<${vo.baseBeanName}Dto>> page(@RequestBody ${vo.baseBeanName}PageReqDto dto) {
         return service.page(BeanCopyUtil.copy(dto,${vo.baseBeanName}Dto.class),dto.getPageNum(),dto.getPageSize());
    }

}