/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.poi.utils.excel;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelUtil;
import com.dtyunxi.util.DateConverter;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.util.ReflectionUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.poi.anno.ImportUnCheck;
import com.yunxi.dg.base.poi.constant.PoiFileModeMap;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.Test1;
import com.yunxi.dg.base.poi.utils.EasyPoiExportUtil;
import com.yunxi.dg.base.poi.utils.excel.NewBigDataParseExcel;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.hibernate.validator.constraints.Length;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewExcelUtil
extends NewBigDataParseExcel {
    private static final Logger logger = LoggerFactory.getLogger(NewExcelUtil.class);
    private Map<Integer, List<String>> headerTitleMap = new HashMap<Integer, List<String>>();
    private Map<Integer, List<String>> fieldNameMap = new HashMap<Integer, List<String>>();
    private Map<Integer, List<String>> unCheckTitleMap = new HashMap<Integer, List<String>>();
    private InputStream inputStream;
    private Map<Integer, List<ImportBaseModeDto>> successMap = new HashMap<Integer, List<ImportBaseModeDto>>();
    private Map<Integer, List<ImportBaseModeDto>> failMap = new HashMap<Integer, List<ImportBaseModeDto>>();
    private boolean verfiyFail = false;
    private String importUrl;

    public NewExcelUtil(List<Class<? extends ImportBaseModeDto>> importTemplateList, String importUrl, Integer headRows) {
        this.importTemplateList = importTemplateList;
        this.inputStream = EasyPoiExportUtil.getInputStream(importUrl);
        this.headRows = headRows;
        this.importUrl = importUrl;
        this.getHeaderTitleMap();
        this.setTitleRow(headRows - 1);
    }

    public void execute() throws Exception {
        if (this.importUrl.endsWith("xlsx")) {
            this.process(this.inputStream);
        } else {
            this.optRows();
        }
    }

    @Override
    public void optRows(int sheetIndex, int curRow, List<String> rowlist) throws Exception {
        if (curRow < this.headRows) {
            return;
        }
        if (curRow == this.headRows) {
            this.checkExcelHeader(sheetIndex, rowlist);
            return;
        }
        ImportBaseModeDto dto = (ImportBaseModeDto)((Object)((Class)this.importTemplateList.get(sheetIndex)).newInstance());
        boolean emptyStr = this.isEmptyStr(rowlist);
        if (emptyStr) {
            return;
        }
        Boolean result = true;
        for (int i = 0; i < this.fieldNameMap.get(sheetIndex).size(); ++i) {
            boolean flag;
            String fieldName = this.fieldNameMap.get(sheetIndex).get(i);
            Field accessibleField = ReflectionUtils.getAccessibleField((Object)((Object)dto), (String)fieldName);
            String value = null;
            if (rowlist.size() > i) {
                value = rowlist.get(i);
            }
            if (!(flag = this.verifyAnnotation(dto, accessibleField, value))) {
                result = false;
                continue;
            }
            if (rowlist.size() <= i) {
                ReflectionUtils.setFieldValue((Object)((Object)dto), (String)fieldName, null);
                dto.setRowNum(curRow - this.headRows);
                continue;
            }
            if (StrUtil.isBlank((CharSequence)rowlist.get(i))) continue;
            Object val = rowlist.get(i);
            if (accessibleField.getType().getName().indexOf("Date") >= 0) {
                val = rowlist.get(i).indexOf(".") >= 0 ? HSSFDateUtil.getJavaDate((double)Double.valueOf(rowlist.get(i))) : new DateConverter().convert(rowlist.get(i));
            }
            if (accessibleField.getType().getName().indexOf("Integer") >= 0 || accessibleField.getType().getName().indexOf("int") >= 0) {
                val = Integer.valueOf(rowlist.get(i));
            }
            if (accessibleField.getType().getName().indexOf("BigDecimal") >= 0) {
                val = new BigDecimal(rowlist.get(i));
            }
            ReflectionUtils.setFieldValue((Object)((Object)dto), (String)fieldName, (Object)val);
            dto.setRowNum(curRow - this.headRows);
        }
        if (!result.booleanValue()) {
            List list = this.failMap.getOrDefault(sheetIndex, new ArrayList());
            list.add(dto);
            this.failMap.put(sheetIndex, list);
            this.verfiyFail = true;
        }
        if (result.booleanValue()) {
            List list = this.successMap.getOrDefault(sheetIndex, new ArrayList());
            list.add(dto);
            this.successMap.put(sheetIndex, list);
        }
        if (sheetIndex == 0) {
            this.totalRows = ((List)this.successMap.getOrDefault(0, new ArrayList())).size() + ((List)this.failMap.getOrDefault(0, new ArrayList())).size();
        }
    }

    private void optRows() throws Exception {
        Workbook workbook = ExcelUtil.getReader((InputStream)this.inputStream).getWorkbook();
        int activeSheetIndex = workbook.getNumberOfSheets();
        for (int i = 0; i < activeSheetIndex; ++i) {
            ImportParams params = new ImportParams();
            params.setHeadRows(this.headRows.intValue());
            params.setNeedVerify(true);
            params.setStartSheetIndex(i);
            Row row = workbook.getSheetAt(i).getRow(this.headRows - 1);
            this.checkExcelHeader(row, i);
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)EasyPoiExportUtil.getInputStream(this.importUrl), (Class)((Class)this.importTemplateList.get(i)), (ImportParams)params);
            EasyPoiExportUtil.handleImportResultListFilterEmpty(result);
            if (CollectionUtil.isNotEmpty((Collection)result.getFailList())) {
                this.failMap.put(i, result.getFailList());
                this.verfiyFail = true;
            }
            if (CollectionUtil.isNotEmpty((Collection)result.getList())) {
                this.successMap.put(i, result.getList());
            }
            if (i != 0) continue;
            this.totalRows = ((List)this.successMap.getOrDefault(0, new ArrayList())).size() + ((List)this.failMap.getOrDefault(0, new ArrayList())).size();
        }
    }

    private boolean verifyAnnotation(ImportBaseModeDto dto, Field accessibleField, String rowValue) {
        java.util.regex.Pattern p;
        Matcher m;
        NotBlank notBlank = accessibleField.getAnnotation(NotBlank.class);
        NotNull notNull = accessibleField.getAnnotation(NotNull.class);
        Length length = accessibleField.getAnnotation(Length.class);
        Max max = accessibleField.getAnnotation(Max.class);
        Pattern pattern = accessibleField.getAnnotation(Pattern.class);
        if (Objects.nonNull(notBlank) || Objects.nonNull(notNull)) {
            boolean flag;
            boolean bl = flag = Objects.isNull(rowValue) || rowValue == null || StrUtil.isBlank((CharSequence)rowValue);
            if (notBlank != null && flag) {
                dto.setErrorMsg(notBlank.message());
                return false;
            }
            if (notNull != null && flag) {
                dto.setErrorMsg(notNull.message());
                return false;
            }
        }
        if (Objects.nonNull(length) && StrUtil.isNotBlank((CharSequence)rowValue)) {
            if (length.min() != 0 && rowValue.length() < length.min()) {
                dto.setErrorMsg(length.message());
                return false;
            }
            if (length.max() != Integer.MAX_VALUE && rowValue.length() > length.max()) {
                dto.setErrorMsg(length.message());
                return false;
            }
        }
        if (Objects.nonNull(max) && StrUtil.isNotBlank((CharSequence)rowValue) && max.value() != 0L && StrUtil.isNumeric((CharSequence)rowValue) && Long.valueOf(rowValue) > max.value()) {
            dto.setErrorMsg(max.message());
            return false;
        }
        if (Objects.nonNull(pattern) && Objects.nonNull(rowValue) && StrUtil.isNotBlank((CharSequence)rowValue) && !(m = (p = java.util.regex.Pattern.compile(pattern.regexp())).matcher(rowValue)).matches()) {
            dto.setErrorMsg(pattern.message());
            return false;
        }
        return true;
    }

    private void checkExcelHeader(Row row, Integer index) {
        Iterator iterator = row.iterator();
        ArrayList<String> rowlist = new ArrayList<String>();
        while (iterator.hasNext()) {
            rowlist.add(((Cell)iterator.next()).getStringCellValue());
        }
        this.checkExcelHeader(index, rowlist);
    }

    private void checkExcelHeader(int sheetIndex, List<String> rowlist) {
        List<String> headerTitle = this.headerTitleMap.get(sheetIndex);
        List<String> unCheckTitleList = this.unCheckTitleMap.get(sheetIndex);
        rowlist.removeAll(unCheckTitleList);
        String md5FieldNames = MD5Util.getMd5ByString((String)rowlist.toString());
        String md5HeaderNames = MD5Util.getMd5ByString((String)headerTitle.toString());
        logger.info("\u5b9a\u4e49\u6a21\u677f\u7684\u5934headerTitle====>{},md5=>{}", rowlist, (Object)md5FieldNames);
        logger.info("\u8bfb\u53d6\u5230\u6a21\u677f\u7684title====>{},md5=>{}", headerTitle, (Object)md5HeaderNames);
        AssertUtils.isTrue((boolean)md5FieldNames.equals(md5HeaderNames), (String)"\u4e0a\u4f20\u7684\u6a21\u677f\u4e0d\u5bf9\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u7684\u6a21\u677f");
    }

    private void getHeaderTitleMap() {
        for (int i = 0; i < this.importTemplateList.size(); ++i) {
            ArrayList<String> rowlist = new ArrayList<String>();
            ArrayList<String> fieldNameList = new ArrayList<String>();
            ArrayList<String> unCheckRowlist = new ArrayList<String>();
            Class importTemplate = (Class)this.importTemplateList.get(i);
            for (Field declaredField : importTemplate.getDeclaredFields()) {
                Excel annotation = declaredField.getAnnotation(Excel.class);
                if (Objects.isNull(annotation)) continue;
                ImportUnCheck importUnCheck = declaredField.getAnnotation(ImportUnCheck.class);
                if (Objects.nonNull(importUnCheck)) {
                    unCheckRowlist.add(annotation.name());
                    continue;
                }
                Integer index = annotation.fixedIndex();
                if (index >= 0) {
                    AssertUtils.isTrue((index >= 1 ? 1 : 0) != 0, (String)"fixedIndex\u7684\u4e0b\u8868\u4ece1\u5f00\u59cb");
                    if (CollectionUtil.isEmpty(rowlist) || rowlist.size() < index) {
                        rowlist.add(annotation.name());
                        fieldNameList.add(declaredField.getName());
                        continue;
                    }
                    rowlist.add(index - 1, annotation.name());
                    fieldNameList.add(index - 1, declaredField.getName());
                    continue;
                }
                rowlist.add(annotation.name());
                fieldNameList.add(declaredField.getName());
            }
            this.headerTitleMap.put(i, rowlist);
            this.fieldNameMap.put(i, fieldNameList);
            this.unCheckTitleMap.put(i, unCheckRowlist);
        }
    }

    private boolean isEmptyStr(List<String> rowlist) {
        return rowlist.stream().allMatch(e -> StrUtil.isBlank((CharSequence)e));
    }

    public void setHeadRows(Integer headRows) {
        this.headRows = headRows;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public Map<Integer, List<ImportBaseModeDto>> getSuccessMap() {
        return this.successMap;
    }

    public Map<Integer, List<ImportBaseModeDto>> getFailMap() {
        return this.failMap;
    }

    public boolean isVerfiyFail() {
        return this.verfiyFail;
    }

    public static void main1(String[] args) throws Exception {
        PoiFileModeMap.importTemplateMap.put((Object)"key1", Test1.class);
        PoiFileModeMap.importTemplateMap.put((Object)"key1", (Object)2);
        PoiFileModeMap.importTemplateMap.put((Object)"key1", (Object)"\u6d4b\u8bd5\u5bfc\u5165");
        PoiFileModeMap.importTemplateMap.put((Object)"key1", (Object)"\u6d4b\u8bd5\u5bfc\u5165\u6587\u4ef6");
        ImportFileOperationCommonReqDto importFileParams = new ImportFileOperationCommonReqDto();
        importFileParams.setImportFileUrl("https://yunxi-dev.oss-cn-shenzhen.aliyuncs.com/dg-sit/\u5176\u4ed6\u5165\u5e93\u5355\u5bfc\u5165\u6a21\u677f (2)-1697424347000QCkN.xlsx");
        importFileParams.setKey("key1");
        importFileParams.setFileName("\u6d4b\u8bd5\u5bfc\u5165\u6587\u4ef6");
        List list = (List)PoiFileModeMap.importTemplateMap.get((Object)importFileParams.getKey());
        Object obj = list.get(0);
        ArrayList<Class<? extends ImportBaseModeDto>> importTemplateList = new ArrayList<Class>();
        if (obj instanceof List) {
            importTemplateList = (List)obj;
        } else {
            importTemplateList.add((Class)obj);
        }
        Integer headRows = (Integer)list.get(1);
        NewExcelUtil excelUtil = new NewExcelUtil(importTemplateList, importFileParams.getImportFileUrl(), headRows == null ? 1 : headRows);
        logger.info("\u6267\u884c\u89e3\u6790\u4e86");
        excelUtil.execute();
        System.out.println(excelUtil);
    }
}

