/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.GetShopChannelListPageParams;
import com.dtyunxi.cis.pms.biz.model.ShopChannelVO;
import com.dtyunxi.cis.pms.biz.model.SubmitShopChannelBody;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterShopChannelService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.shop.IPcpShopChannelApi;
import com.dtyunxi.yundt.cube.center.data.api.shop.dto.request.PcpShopChannelReqDto;
import com.dtyunxi.yundt.cube.center.data.api.shop.dto.response.PcpShopChannelRespDto;
import com.dtyunxi.yundt.cube.center.data.api.shop.query.IPcpShopChannelQueryApi;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class BasedataCenterShopChannelServiceServiceImpl
implements BasedataCenterShopChannelService {
    @Resource
    private IPcpShopChannelApi pcpShopChannelApi;
    @Resource
    private IPcpShopChannelQueryApi pcpShopChannelQueryApi;

    @Override
    public RestResponse<Object> addShopChannel(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitShopChannelBody submitShopChannelBody) {
        PcpShopChannelReqDto reqDto = new PcpShopChannelReqDto();
        reqDto.setChannelCode(submitShopChannelBody.getShopChannelCode());
        reqDto.setChannelName(submitShopChannelBody.getShopChannelName());
        reqDto.setStatus(submitShopChannelBody.getShopChannelStatus());
        reqDto.setDescription(submitShopChannelBody.getShopChannelRemark());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pcpShopChannelApi.addShopChannel(reqDto)));
    }

    @Override
    public RestResponse<Object> deleteShopChannel(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pcpShopChannelApi.removeShopChannel(id)));
    }

    @Override
    public RestResponse<ShopChannelVO> getShopChannelDetail(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        PcpShopChannelRespDto shopChannelRespDto = (PcpShopChannelRespDto)RestResponseHelper.extractData((RestResponse)this.pcpShopChannelQueryApi.queryById(Long.valueOf(id)));
        ShopChannelVO shopChannelVO = DtoExchangeUtils.createDtoBySource(shopChannelRespDto, ShopChannelVO.class);
        shopChannelVO.setShopChannelCode(shopChannelRespDto.getChannelCode());
        shopChannelVO.setShopChannelName(shopChannelRespDto.getChannelName());
        shopChannelVO.setShopChannelStatus(shopChannelRespDto.getStatus());
        shopChannelVO.setShopChannelRemark(shopChannelRespDto.getDescription());
        return new RestResponse((Object)shopChannelVO);
    }

    @Override
    public RestResponse<PageInfo<ShopChannelVO>> getShopChannelListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetShopChannelListPageParams getShopChannelListPageParams) {
        PcpShopChannelReqDto reqDto = new PcpShopChannelReqDto();
        reqDto.setChannelName(getShopChannelListPageParams.getShopChannelName());
        reqDto.setChannelCode(getShopChannelListPageParams.getShopChannelCode());
        reqDto.setStatus(getShopChannelListPageParams.getShopChannelStatus());
        reqDto.setCreateTimeStart(getShopChannelListPageParams.getCreateTimeStart());
        reqDto.setCreateTimeEnd(getShopChannelListPageParams.getCreateTimeEnd());
        PageInfo shopChannelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpShopChannelQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), getShopChannelListPageParams.getPageNum(), getShopChannelListPageParams.getPageSize()));
        if (CollectionUtils.isNotEmpty((Collection)shopChannelRespDtoPageInfo.getList())) {
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)shopChannelRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List shopChannelVOS = shopChannelRespDtoPageInfo.getList().stream().map(o -> {
                ShopChannelVO shopChannelVO = DtoExchangeUtils.createDtoBySource(o, ShopChannelVO.class);
                shopChannelVO.setShopChannelId(o.getId().toString());
                shopChannelVO.setShopChannelCode(o.getChannelCode());
                shopChannelVO.setShopChannelName(o.getChannelName());
                shopChannelVO.setShopChannelRemark(o.getDescription());
                shopChannelVO.setShopChannelStatus(o.getStatus());
                return shopChannelVO;
            }).collect(Collectors.toList());
            pageInfo.setList(shopChannelVOS);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> updateShopChannel(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) SubmitShopChannelBody submitShopChannelBody) {
        PcpShopChannelReqDto reqDto = new PcpShopChannelReqDto();
        reqDto.setId(Long.valueOf(id));
        reqDto.setChannelCode(submitShopChannelBody.getShopChannelCode());
        reqDto.setChannelName(submitShopChannelBody.getShopChannelName());
        reqDto.setStatus(submitShopChannelBody.getShopChannelStatus());
        reqDto.setDescription(submitShopChannelBody.getShopChannelRemark());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pcpShopChannelApi.modifyShopChannel(reqDto)));
    }
}

