/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cis.pms.biz.enums.PlatformOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.SaleOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.model.BusinessOrderInfoVO;
import com.dtyunxi.cis.pms.biz.model.DeliveryInfoVo;
import com.dtyunxi.cis.pms.biz.model.GetInResultListPageParams;
import com.dtyunxi.cis.pms.biz.model.InResultOrderVO;
import com.dtyunxi.cis.pms.biz.model.RelateBillInfoVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBillInResultOrderService;
import com.dtyunxi.cis.search.api.dto.request.GetResultOrderPageParams;
import com.dtyunxi.cis.search.api.query.inventory.EsInventoryOrderQueryApi;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OutResultOrderReqDto;
import com.dtyunxi.tcbj.api.query.ICsLogisticsInfoQueryApi;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsInResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInResultOrderRespDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class InventoryCenterBillInResultOrderServiceServiceImpl
implements InventoryCenterBillInResultOrderService {
    @Resource
    private EsInventoryOrderQueryApi esInventoryOrderQueryApi;
    @Resource
    private ICsInResultOrderQueryApi csInResultOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Resource
    private ICsLogisticsInfoQueryApi iCsLogisticsInfoQueryApi;
    @Autowired
    IOutResultOrderQueryApi outResultOrderQueryApi;
    @Value(value="${esQuery:true}")
    private Boolean esQuery;

    @Override
    public RestResponse<PageInfo<InResultOrderVO>> getInResultListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetInResultListPageParams getInResultListPageParams) {
        if (!this.esQuery.booleanValue()) {
            PageInfo pageInfoRestResponse = new PageInfo();
            PageInfo pageInfo = new PageInfo();
            OutResultOrderReqDto reqDto = new OutResultOrderReqDto();
            BeanUtils.copyProperties((Object)getInResultListPageParams, (Object)reqDto);
            reqDto.setOrderNo(getInResultListPageParams.getDocumentNo());
            reqDto.setBusinessType(getInResultListPageParams.getBusinessType());
            reqDto.setDeliveryWarehouseName(getInResultListPageParams.getDeliveryLogicalWarehouseName());
            reqDto.setReceiveWarehouseName(getInResultListPageParams.getReceiveLogicalWarehouseName());
            reqDto.setOrderStatus(getInResultListPageParams.getDocumentStatus());
            if (ObjectUtil.isNotEmpty((Object)getInResultListPageParams.getStartTime()) && ObjectUtil.isNotEmpty((Object)getInResultListPageParams.getEndTime())) {
                reqDto.setCreateBeginTime(DateUtil.parse((String)(getInResultListPageParams.getStartTime() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                reqDto.setCreateEndTime(DateUtil.parse((String)(getInResultListPageParams.getEndTime() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (CollectionUtils.isEmpty((Collection)(pageInfoRestResponse = (PageInfo)this.outResultOrderQueryApi.queryByPageInResult(reqDto).getData()).getList())) {
                return new RestResponse();
            }
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoRestResponse, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList outResultOrderVOS = new ArrayList();
            pageInfoRestResponse.getList().forEach(o -> {
                InResultOrderVO outResultOrderVO = new InResultOrderVO();
                BeanUtils.copyProperties((Object)o, (Object)outResultOrderVO);
                outResultOrderVO.setDeliveryLogicalWarehouseName(o.getDeliveryWarehouseName());
                outResultOrderVO.setDeliveryLogicalWarehouseCode(o.getDeliveryWarehouseCode());
                outResultOrderVO.setReceiveLogicalWarehouseName(o.getReceiveWarehouseName());
                outResultOrderVO.setReceiveLogicalWarehouseCode(o.getReceiveWarehouseCode());
                outResultOrderVO.setDocumentStatus(o.getOrderStatus());
                outResultOrderVO.setBusinessOrderNo(o.getRelevanceNo());
                outResultOrderVO.setNoticeNo(o.getNoticeNo());
                outResultOrderVO.setTotalSku(o.getTotalSku());
                outResultOrderVO.setTotalVolume(o.getTotalVolume() == null ? new BigDecimal(0) : o.getTotalVolume());
                outResultOrderVO.setTotalWeight(o.getTotalWeight() == null ? new BigDecimal(0) : o.getTotalWeight());
                outResultOrderVO.setCreateTime(ObjectUtil.isNotEmpty((Object)o.getCreateTime()) ? DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
                outResultOrderVO.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
                outResultOrderVO.setMixBoxesNum(o.getMixBoxesNum() == null ? new BigDecimal(0) : o.getMixBoxesNum());
                outResultOrderVO.setTotalBoxesNum(o.getTotalBoxesNum() == null ? new BigDecimal(0) : o.getTotalBoxesNum());
                outResultOrderVO.setWmsNo(outResultOrderVO.getWmsNo());
                outResultOrderVOS.add(outResultOrderVO);
            });
            pageInfo.setList(outResultOrderVOS);
            return new RestResponse((Object)pageInfo);
        }
        GetResultOrderPageParams params = new GetResultOrderPageParams();
        BeanUtils.copyProperties((Object)getInResultListPageParams, (Object)params);
        params.setOrderNo(getInResultListPageParams.getDocumentNo());
        params.setOrderStatus(getInResultListPageParams.getDocumentStatus());
        params.setWarehouse(getInResultListPageParams.getReceiveLogicalWarehouseName());
        params.setInLogicWarehouseName(getInResultListPageParams.getReceiveLogicalWarehouseName());
        params.setOutLogicWarehouseName(getInResultListPageParams.getDeliveryLogicalWarehouseName());
        PageInfo inResultOrderVOPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esInventoryOrderQueryApi.queryResultOrderPage(params));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)inResultOrderVOPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)inResultOrderVOPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = inResultOrderVOPageInfo.getList().stream().map(o -> {
            InResultOrderVO vo = new InResultOrderVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            vo.setBusinessOrderNo(o.getRelevanceNo());
            vo.setExternalOrderNo(o.getExternalOrderNo());
            vo.setDocumentStatus(o.getOrderStatus());
            vo.setDeliveryLogicalWarehouseName(o.getOutLogicWarehouseName());
            vo.setDeliveryLogicalWarehouseCode(o.getOutLogicWarehouseCode());
            vo.setReceiveLogicalWarehouseName(o.getInLogicWarehouseName());
            vo.setReceiveLogicalWarehouseCode(o.getInLogicWarehouseCode());
            vo.setWmsNo(o.getWmsOrderNo());
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<InResultOrderVO> getInResultOrderDetail(@ApiParam(value="\u5165\u5e93\u7ed3\u679c\u5355\u53f7") @Valid @RequestParam(value="inResultNo", required=false) String inResultNo) {
        List relOrderInfoList;
        List respDtos;
        if (StringUtils.isBlank((CharSequence)inResultNo)) {
            throw new BizException("\u5165\u5e93\u7ed3\u679c\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CsInResultOrderRespDto respDto = (CsInResultOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csInResultOrderQueryApi.queryByDocumentNo(inResultNo));
        InResultOrderVO vo = new InResultOrderVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setDocumentNo(respDto.getDocumentNo());
        vo.setBusinessType(respDto.getBusinessType());
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setDocumentStatus(respDto.getOrderStatus());
        vo.setDeliveryPhysicalWarehouseName(respDto.getOutWarehouseName());
        vo.setDeliveryPhysicalWarehouseCode(respDto.getOutWarehouseCode());
        vo.setDeliveryLogicalWarehouseCode(respDto.getOutLogicWarehouseCode());
        vo.setDeliveryLogicalWarehouseName(respDto.getOutLogicWarehouseName());
        vo.setReceiveLogicalWarehouseCode(respDto.getInLogicWarehouseCode());
        vo.setReceiveLogicalWarehouseName(respDto.getInLogicWarehouseName());
        vo.setReceivePhysicalWarehouseCode(respDto.getWarehouseCode());
        vo.setReceivePhysicalWarehouseName(respDto.getWarehouseName());
        vo.setSummary(respDto.getTotalQuantity() == null ? BigDecimal.ZERO : respDto.getTotalQuantity());
        vo.setTotalSku(respDto.getSkuNum() == null ? BigDecimal.ZERO : respDto.getSkuNum());
        vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)respDto.getBizDate()) ? DateUtil.format((Date)respDto.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
        ContactDto contactDto = respDto.getContactDto();
        if (Objects.nonNull(contactDto)) {
            BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
            BeanUtils.copyProperties((Object)contactDto, (Object)businessOrderInfo);
            vo.setBusinessOrderInfo(businessOrderInfo);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iCsLogisticsInfoQueryApi.queryResultDeliveryInformation(inResultNo))))) {
            List<DeliveryInfoVo> list = respDtos.stream().map(o -> {
                DeliveryInfoVo documentVO = new DeliveryInfoVo();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                if (o.getConsignmentType() != null) {
                    documentVO.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
                }
                return documentVO;
            }).collect(Collectors.toList());
            vo.setDeliveryInfoList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)(relOrderInfoList = respDto.getRelOrderInfoList()))) {
            List<RelateBillInfoVO> list = relOrderInfoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrderNo())).map(o -> {
                RelateBillInfoVO relateBillInfoVO = new RelateBillInfoVO();
                if (PlatformOrderTypeEnum.PLATFORM_ORDER_NO.getCode().equals(o.getOrderType())) {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setIsExternalOrder(true);
                } else if (SaleOrderTypeEnum.getStatusByCode(o.getOrderType()) != null) {
                    if (SaleOrderTypeEnum.ORDER_SALES_REFUND.getCode().equals(o.getOrderType())) {
                        BizSaleRefundRespDto bizSaleRefundRespDto = (BizSaleRefundRespDto)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryByRefundNo(o.getOrderNo()));
                        if (bizSaleRefundRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(bizSaleRefundRespDto.getRefundStatus());
                            SaleRefundAddrRespDto saleRefundAddrRespDto = bizSaleRefundRespDto.getSaleRefundAddrRespDto();
                            if (saleRefundAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(saleRefundAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(saleRefundAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(Optional.ofNullable(saleRefundAddrRespDto.getProvince()).orElse("") + Optional.ofNullable(saleRefundAddrRespDto.getCity()).orElse("") + Optional.ofNullable(saleRefundAddrRespDto.getCounty()).orElse("") + Optional.ofNullable(saleRefundAddrRespDto.getReceiveAddress()).orElse(""));
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    } else {
                        BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(o.getOrderNo()));
                        if (saleOrderRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(saleOrderRespDto.getOrderStatus());
                            SaleOrderAddrRespDto orderAddrRespDto = saleOrderRespDto.getOrderAddrRespDto();
                            if (orderAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(orderAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(orderAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(Optional.ofNullable(orderAddrRespDto.getProvince()).orElse("") + Optional.ofNullable(orderAddrRespDto.getCity()).orElse("") + Optional.ofNullable(orderAddrRespDto.getCounty()).orElse("") + Optional.ofNullable(orderAddrRespDto.getReceiveAddress()).orElse(""));
                                businessOrderInfo.setRemark(saleOrderRespDto.getRemark());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    }
                } else {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setLogisticsCompany(o.getShippingCompany());
                    relateBillInfoVO.setLogisticsNo(o.getShippingCode());
                    relateBillInfoVO.setDeliveryWay(o.getShippingType());
                    relateBillInfoVO.setWmsNo(o.getWmsOrderNo());
                    if (o.getEstimatedTime() != null) {
                        relateBillInfoVO.setExpectedArriveTime(DateUtil.format((Date)o.getEstimatedTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                    }
                }
                return relateBillInfoVO;
            }).collect(Collectors.toList());
            vo.setRelateBillInfoList(list);
        }
        return new RestResponse((Object)vo);
    }
}

