/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.AdjustmentInventoryHelper;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryTransferHelper;
import com.dtyunxi.cis.pms.biz.utils.CodeGenerateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AdjustmentInventoryHelperImpl
implements AdjustmentInventoryHelper {
    private static final Logger log = LoggerFactory.getLogger(AdjustmentInventoryHelperImpl.class);
    @Resource
    private IAdjustmentInventoryApi adjustmentInventoryApi;
    @Resource
    private CodeGenerateUtil codeGenerateUtil;
    @Resource
    private InventoryTransferHelper inventoryTransferHelper;

    @Override
    public void save(AdjustmentInventoryHelper.AdjustmentInventoryAddVo csOutResultOrderRespDto) {
        log.info("\u8fdb\u5165\u8c03\u6574\u5355\u4fdd\u5b58\u903b\u8f91:{}", (Object)JSON.toJSONString((Object)csOutResultOrderRespDto));
        Optional.ofNullable(this.transferAdjust(csOutResultOrderRespDto)).ifPresent(this::doSave);
    }

    private void doSave(AdjustmentInventoryReqDto csInventoryAdjustAddReqDto) {
        RestResponseHelper.checkOrThrow((RestResponse)this.adjustmentInventoryApi.addAdjustmentInventory(csInventoryAdjustAddReqDto));
    }

    private AdjustmentInventoryReqDto transferAdjust(AdjustmentInventoryHelper.AdjustmentInventoryAddVo csOutResultOrderRespDto) {
        return Optional.ofNullable(this.inventoryTransferHelper.getLogicWarehouseByCode(csOutResultOrderRespDto.getWarehouseCode())).map(inTransitWarehouse -> {
            AdjustmentInventoryReqDto csInventoryAdjustAddReqDto = new AdjustmentInventoryReqDto();
            csInventoryAdjustAddReqDto.setPreOrderNo(csOutResultOrderRespDto.getPreOrderNo());
            csInventoryAdjustAddReqDto.setRelevanceNo(csOutResultOrderRespDto.getRelevanceNo());
            csInventoryAdjustAddReqDto.setAdjustmentRemark(csOutResultOrderRespDto.getRemark());
            csInventoryAdjustAddReqDto.setAutoAuditPass(Boolean.valueOf(true));
            csInventoryAdjustAddReqDto.setSourceType(csOutResultOrderRespDto.getSourceType());
            csInventoryAdjustAddReqDto.setWarehouseCode(inTransitWarehouse.getWarehouseCode());
            csInventoryAdjustAddReqDto.setWarehouseClassify("in_transit");
            csInventoryAdjustAddReqDto.setWarehouseName(inTransitWarehouse.getWarehouseName());
            csInventoryAdjustAddReqDto.setWarehouseId(inTransitWarehouse.getId());
            boolean addNumFlag = Objects.equals(csOutResultOrderRespDto.getOrderType(), "out");
            csInventoryAdjustAddReqDto.setBusinessType(addNumFlag ? CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT_OUT.getCode() : CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT_IN.getCode());
            csInventoryAdjustAddReqDto.setAdjustmentType(CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT.getCode());
            csInventoryAdjustAddReqDto.setDetailReqDtoList(csOutResultOrderRespDto.getDetailRespDtoList().stream().map(r -> this.buildCsInventoryAdjustDetailAddReqDto(csInventoryAdjustAddReqDto.getAdjustmentNo(), addNumFlag, (AdjustmentInventoryHelper.DetailRespDto)((Object)((Object)r)))).collect(Collectors.toList()));
            return csInventoryAdjustAddReqDto;
        }).orElse(null);
    }

    private AdjustmentInventoryDetailReqDto buildCsInventoryAdjustDetailAddReqDto(String adjustmentNo, boolean addNumFlag, AdjustmentInventoryHelper.DetailRespDto r) {
        AdjustmentInventoryDetailReqDto addReqDto = new AdjustmentInventoryDetailReqDto();
        addReqDto.setChangeType(addNumFlag ? "decrease" : "increase");
        addReqDto.setArtNo(r.getLongCode());
        addReqDto.setLongCode(r.getLongCode());
        addReqDto.setBatch(r.getBatch());
        addReqDto.setCargoCode(Optional.ofNullable(r.getCargoCode()).orElse(r.getLongCode()));
        addReqDto.setCargoId(r.getCargoId());
        addReqDto.setCargoName(r.getCargoName());
        addReqDto.setChangeQuantity(r.getQuantity());
        addReqDto.setAdjustmentNo(adjustmentNo);
        addReqDto.setProduceTime(r.getProduceTime());
        addReqDto.setExpireTime(r.getExpireTime());
        return addReqDto;
    }
}

