/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.AuditResultEnum;
import com.dtyunxi.cis.pms.biz.model.AddInventoryReadjustmentBody;
import com.dtyunxi.cis.pms.biz.model.AssociatedDocumentVO;
import com.dtyunxi.cis.pms.biz.model.AuditInventoryReadjustmentOrderBody;
import com.dtyunxi.cis.pms.biz.model.AuditVO;
import com.dtyunxi.cis.pms.biz.model.CloseInventoryReadjustmentOrderBody;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetInventoryReadjustmentGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetInventoryReadjustmentListParams;
import com.dtyunxi.cis.pms.biz.model.InventoryReadjustmentGoodsVO;
import com.dtyunxi.cis.pms.biz.model.InventoryReadjustmentVO;
import com.dtyunxi.cis.pms.biz.model.OutInventoryReadjustmentVO;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryInventoryReadjustmentOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsStorageAuditRecordApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryAuditRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.adjustmentInventoryStatusCountRespDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="abstractFileOperationCommonService_inventory_readjustment_order")
public class FinishedGoodsInventoryInventoryReadjustmentOrderServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinishedGoodsInventoryInventoryReadjustmentOrderService {
    @Resource
    private IAdjustmentInventoryApi adjustmentInventoryApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private ICsStorageAuditRecordApi csStorageAuditRecordQueryApi;
    @Resource
    private IAdjustmentInventoryDetailApi adjustmentInventoryDetailQueryApi;

    @Override
    public RestResponse<Object> addInventoryReadjustmentOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AddInventoryReadjustmentBody addInventoryReadjustmentBody) {
        AdjustmentInventoryReqDto reqDto = new AdjustmentInventoryReqDto();
        BeanUtils.copyProperties((Object)addInventoryReadjustmentBody, (Object)reqDto);
        reqDto.setWarehouseCode(addInventoryReadjustmentBody.getLogicWarehouseCode());
        reqDto.setWarehouseName(addInventoryReadjustmentBody.getLogicWarehouseName());
        reqDto.setAdjustmentRemark(addInventoryReadjustmentBody.getRemark());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(addInventoryReadjustmentBody.getGoodsList()), "\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List list = addInventoryReadjustmentBody.getGoodsList().stream().map(o -> {
            AdjustmentInventoryDetailReqDto dto = new AdjustmentInventoryDetailReqDto();
            BeanUtils.copyProperties((Object)o, (Object)dto);
            dto.setCargoName(o.getGoodsName());
            dto.setCargoCode(o.getGoodsLongCode());
            dto.setLongCode(o.getGoodsLongCode());
            dto.setChangeQuantity(ParamConverter.convertToBigDecimal((Object)o.getReadjustmenttQuantity()));
            dto.setChangeType(o.getReadjustmentType());
            dto.setBatch(o.getBatchNo());
            return dto;
        }).collect(Collectors.toList());
        reqDto.setDetailReqDtoList(list);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.adjustmentInventoryApi.addAdjustmentInventory(reqDto)));
    }

    @Override
    public RestResponse<Object> auditInventoryReadjustmentOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AuditInventoryReadjustmentOrderBody auditInventoryReadjustmentOrderBody) {
        AdjustmentInventoryAuditRespDto dto = new AdjustmentInventoryAuditRespDto();
        BeanUtils.copyProperties((Object)auditInventoryReadjustmentOrderBody, (Object)dto);
        List<Long> ids = auditInventoryReadjustmentOrderBody.getIds();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(ids), "id\u4e0d\u80fd\u4e3a\u7a7a");
        dto.setAuditIds(ids);
        dto.setAuditRemark(auditInventoryReadjustmentOrderBody.getAuditReason());
        if (YesNoEnum.NO.getValue().equals(auditInventoryReadjustmentOrderBody.getAuditResult())) {
            dto.setAuditStatus(AuditResultEnum.FAILED.getCode());
        } else if (YesNoEnum.YES.getValue().equals(auditInventoryReadjustmentOrderBody.getAuditResult())) {
            dto.setAuditStatus(AuditResultEnum.PASS.getCode());
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.adjustmentInventoryApi.auditAdjustmentInventory(dto)));
    }

    @Override
    public RestResponse<Object> closeInventoryReadjustmentOrder(@ApiParam(value="") @Valid @RequestBody(required=false) CloseInventoryReadjustmentOrderBody closeInventoryReadjustmentOrderBody) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)closeInventoryReadjustmentOrderBody.getId()), "id\u4e0d\u80fd\u4e3a\u7a7a");
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.adjustmentInventoryApi.closeAdjustmentInventory(ParamConverter.convertToLong((Object)closeInventoryReadjustmentOrderBody.getId()), closeInventoryReadjustmentOrderBody.getCloseReason())));
    }

    @Override
    public RestResponse<InventoryReadjustmentVO> getInventoryReadjustmentOrder(@ApiParam(value="\u5e93\u5b58\u8c03\u6574\u5355\u53f7") @Valid @RequestParam(value="bussinessOrderNo", required=false) String bussinessOrderNo) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)bussinessOrderNo), "\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AdjustmentInventoryRespDto respDto = (AdjustmentInventoryRespDto)RestResponseHelper.extractData((RestResponse)this.adjustmentInventoryApi.queryByAdjustmentNo(bussinessOrderNo));
        InventoryReadjustmentVO vo = new InventoryReadjustmentVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setBussinessOrderNo(respDto.getAdjustmentNo());
        vo.setLogicWarehouseCode(respDto.getWarehouseCode());
        vo.setLogicWarehouseName(respDto.getWarehouseName());
        vo.setBussinessOrderStatus(respDto.getAdjustmentStatus());
        vo.setRemark(respDto.getAdjustmentRemark());
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        ArrayList<AssociatedDocumentVO> associatedDocumentList = new ArrayList<AssociatedDocumentVO>();
        List infoList = respDto.getRelOrderInfoList();
        if (CollectionUtils.isNotEmpty((Collection)infoList)) {
            infoList.forEach(o -> {
                AssociatedDocumentVO documentVO = new AssociatedDocumentVO();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                documentVO.setOrderNo(o.getDocumentNo());
                if (o.getCreateTime() != null) {
                    documentVO.setCreateTime(null != respDto.getCreateTime() ? DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
                }
                associatedDocumentList.add(documentVO);
            });
        }
        vo.setAssociatedDocumentList(associatedDocumentList);
        List auditList = respDto.getAuditList();
        if (CollectionUtils.isNotEmpty((Collection)auditList)) {
            List<AuditVO> list = auditList.stream().map(o -> {
                AuditVO auditVO = new AuditVO();
                BeanUtils.copyProperties((Object)o, (Object)auditVO);
                auditVO.setAuditResult(o.getAuditStatus());
                auditVO.setAuditReason(o.getAuditRemark());
                if (o.getCreateTime() != null) {
                    auditVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                return auditVO;
            }).collect(Collectors.toList());
            vo.setAuditRecordList(list);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<InventoryReadjustmentGoodsVO>> getInventoryReadjustmentOrderGoodsList(@ApiParam(value="") @Valid @RequestBody(required=false) GetInventoryReadjustmentGoodsListPageParams getInventoryReadjustmentGoodsListPageParams) {
        AdjustmentInventoryDetailReqDto reqDto = new AdjustmentInventoryDetailReqDto();
        reqDto.setAdjustmentNo(getInventoryReadjustmentGoodsListPageParams.getBussinessOrderNo());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.adjustmentInventoryDetailQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), getInventoryReadjustmentGoodsListPageParams.getPageNum(), getInventoryReadjustmentGoodsListPageParams.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            InventoryReadjustmentGoodsVO goodsVO = new InventoryReadjustmentGoodsVO();
            BeanUtils.copyProperties((Object)o, (Object)goodsVO);
            goodsVO.setGoodsId(ParamConverter.convertToString((Object)o.getCargoId()));
            goodsVO.setBatchNo(o.getBatch());
            goodsVO.setGoodsName(o.getCargoName());
            goodsVO.setGoodsLongCode(o.getCargoCode());
            goodsVO.setReadjustmentType(o.getChangeType());
            goodsVO.setReadjustmenttQuantity(BigDecimalUtils.check((BigDecimal)o.getChangeQuantity()).intValue());
            return goodsVO;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<InventoryReadjustmentVO>> getInventoryReadjustmentOrderList(@ApiParam(value="") @Valid @RequestBody(required=false) GetInventoryReadjustmentListParams getInventoryReadjustmentListParams) {
        AdjustmentInventoryReqDto reqDto = new AdjustmentInventoryReqDto();
        BeanUtils.copyProperties((Object)getInventoryReadjustmentListParams, (Object)reqDto);
        reqDto.setAdjustmentNo(getInventoryReadjustmentListParams.getBussinessOrderNo());
        reqDto.setRelevanceNo(getInventoryReadjustmentListParams.getRelevanceNo());
        reqDto.setAdjustmentStatus(getInventoryReadjustmentListParams.getBussinessOrderStatus());
        reqDto.setWarehouseCode(getInventoryReadjustmentListParams.getLogicWarehouseCode());
        reqDto.setWarehouseName(getInventoryReadjustmentListParams.getLogicWarehouseName());
        reqDto.setSourceTypeList(getInventoryReadjustmentListParams.getSourceTypeList());
        reqDto.setPreOrderNo(getInventoryReadjustmentListParams.getPreOrderNo());
        reqDto.setExternalOrderNo(getInventoryReadjustmentListParams.getExternalOrderNofe());
        if (StringUtils.isNotBlank((CharSequence)getInventoryReadjustmentListParams.getStartTime())) {
            reqDto.setStartTime(DateUtil.parse((String)(getInventoryReadjustmentListParams.getStartTime() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getInventoryReadjustmentListParams.getEndTime())) {
            reqDto.setEndTime(DateUtil.parse((String)(getInventoryReadjustmentListParams.getEndTime() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.adjustmentInventoryApi.queryByPage(JSON.toJSONString((Object)reqDto), getInventoryReadjustmentListParams.getPageNum(), getInventoryReadjustmentListParams.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            InventoryReadjustmentVO vo = new InventoryReadjustmentVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setBussinessOrderNo(o.getAdjustmentNo());
            vo.setBussinessOrderStatus(o.getAdjustmentStatus());
            vo.setLogicWarehouseCode(o.getWarehouseCode());
            vo.setLogicWarehouseName(o.getWarehouseName());
            vo.setRemark(o.getAdjustmentRemark());
            if (o.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<adjustmentInventoryStatusCountRespDto> adjustmentInventoryStatusCount(@Valid GetInventoryReadjustmentListParams getInventoryReadjustmentListParams) {
        AdjustmentInventoryReqDto reqDto = new AdjustmentInventoryReqDto();
        BeanUtils.copyProperties((Object)getInventoryReadjustmentListParams, (Object)reqDto);
        reqDto.setAdjustmentNo(getInventoryReadjustmentListParams.getBussinessOrderNo());
        reqDto.setRelevanceNo(getInventoryReadjustmentListParams.getRelevanceNo());
        reqDto.setAdjustmentStatus(getInventoryReadjustmentListParams.getBussinessOrderStatus());
        reqDto.setWarehouseCode(getInventoryReadjustmentListParams.getLogicWarehouseCode());
        reqDto.setWarehouseName(getInventoryReadjustmentListParams.getLogicWarehouseName());
        reqDto.setSourceTypeList(getInventoryReadjustmentListParams.getSourceTypeList());
        reqDto.setRelevanceNo(getInventoryReadjustmentListParams.getRelevanceNo());
        reqDto.setPreOrderNo(getInventoryReadjustmentListParams.getPreOrderNo());
        reqDto.setExternalOrderNo(getInventoryReadjustmentListParams.getExternalOrderNofe());
        if (StringUtils.isNotBlank((CharSequence)getInventoryReadjustmentListParams.getStartTime())) {
            reqDto.setStartTime(DateUtil.parse((String)(getInventoryReadjustmentListParams.getStartTime() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)getInventoryReadjustmentListParams.getEndTime())) {
            reqDto.setEndTime(DateUtil.parse((String)(getInventoryReadjustmentListParams.getEndTime() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        return this.adjustmentInventoryApi.adjustmentInventoryStatusCount(JSON.toJSONString((Object)reqDto));
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetInventoryReadjustmentListParams params = new GetInventoryReadjustmentListParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetInventoryReadjustmentListParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInventoryReadjustmentListParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            re.setAdjustmentType("in_transit_adjustment");
            ArrayList<String> list = new ArrayList<String>();
            list.add("deliverResult");
            list.add("receiveResult");
            re.setSourceTypeList(list);
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getInventoryReadjustmentOrderList((GetInventoryReadjustmentListParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutInventoryReadjustmentVO vo = new OutInventoryReadjustmentVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setBussinessOrderStatus(Optional.ofNullable(o.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "wait_in": {
                            return "\u5f85\u5165\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "portion_in": {
                            return "\u90e8\u5206\u5165\u5e93";
                        }
                        case "completed": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "cancel": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return o.getBussinessOrderStatus();
                }).orElse(""));
                vo.setPreOrderNo(o.getPreOrderNo());
                vo.setRelevanceNo(o.getRelevanceNo());
                vo.setBusinessType(Optional.ofNullable(o.getBusinessType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                    switch (Type2) {
                        case "in_transit_adjustment_out": {
                            return "\u5728\u9014\u5e93\u5b58\u51fa\u5e93";
                        }
                        case "in_transit_adjustment_in": {
                            return "\u5728\u9014\u5e93\u5b58\u5165\u5e93";
                        }
                    }
                    return o.getBusinessType();
                }).orElse(""));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutInventoryReadjustmentVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetInventoryReadjustmentListParams params = new GetInventoryReadjustmentListParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetInventoryReadjustmentListParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInventoryReadjustmentListParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getInventoryReadjustmentOrderList(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }
}

