/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.helper.impl;

import com.dtyunxi.cis.pms.biz.service.helper.DataCheckHelper;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;

@Service
public class DataCheckHelperImpl
implements DataCheckHelper {
    @Override
    public <CLAZZ> DataCheckHelper.CheckResultVo compareListData(Class<CLAZZ> clazz, List<CLAZZ> dataList, List<String> writeList) throws IllegalAccessException {
        for (Field declaredField : clazz.getDeclaredFields()) {
            DataCheckHelper.CheckResultVo msg = this.getCheckResultVo(dataList, writeList, declaredField);
            if (msg == null) continue;
            return msg;
        }
        return DataCheckHelper.CheckResultVo.successData();
    }

    @Override
    public <CLAZZ> DataCheckHelper.CheckResultVo checkNullField(CLAZZ data) throws IllegalAccessException {
        for (Field declaredField : data.getClass().getDeclaredFields()) {
            if (!this.isCheck(declaredField)) continue;
            declaredField.setAccessible(true);
            if (!Objects.isNull(declaredField.get(data))) continue;
            return DataCheckHelper.CheckResultVo.failData(this.getFieldNullMsg(declaredField) + "\u6216\u540c\u4ed3\u5e93\u7f16\u7801\u6570\u636e\u5f02\u5e38");
        }
        return DataCheckHelper.CheckResultVo.successData();
    }

    private <CLAZZ> DataCheckHelper.CheckResultVo getCheckResultVo(List<CLAZZ> dataList, List<String> writeList, Field declaredField) throws IllegalAccessException {
        if (!writeList.contains(declaredField.getName()) && this.isCheck(declaredField)) {
            declaredField.setAccessible(true);
            Object temp = declaredField.get(dataList.get(0));
            for (int i = 1; i < dataList.size(); ++i) {
                CLAZZ data = dataList.get(i);
                if (Objects.equals(declaredField.get(data), temp)) continue;
                String msg = "\u540c\u4ed3\u5e93\u7f16\u7801\u6216\u540c\u5355\u53f7\u5173\u952e\u6570\u636e\u5f02\u5e38";
                return DataCheckHelper.CheckResultVo.failData(msg);
            }
        }
        return null;
    }

    private String getFieldNullMsg(Field declaredField) {
        return Optional.ofNullable(declaredField.getAnnotation(NotBlank.class)).map(NotBlank::message).orElseGet(() -> Optional.ofNullable(declaredField.getAnnotation(NotNull.class)).map(NotNull::message).orElse(declaredField.getAnnotation(NotEmpty.class).message()));
    }

    private boolean isCheck(Field declaredField) {
        return declaredField.isAnnotationPresent(NotNull.class) || declaredField.isAnnotationPresent(NotBlank.class) || declaredField.isAnnotationPresent(NotEmpty.class);
    }
}

