/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.WarehouseTypeEnum;
import com.dtyunxi.cis.pms.biz.model.AddPhysicalWarehouseParams;
import com.dtyunxi.cis.pms.biz.model.AddressVO;
import com.dtyunxi.cis.pms.biz.model.BatchPhysicalWarehouseParams;
import com.dtyunxi.cis.pms.biz.model.CoordinateVO;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetPhysicalWarehouseListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutPhysicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.PhysicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.UpdatePhysicalWarehouseParams;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehousePhysicalWarehouseService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseExposedAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseDetailRespDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_physical_warehouse")
public class InventoryCenterBaseWarehousePhysicalWarehouseServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements InventoryCenterBaseWarehousePhysicalWarehouseService {
    @Resource
    private ICsPhysicsWarehouseExposedApi csPhysicsWarehouseExposedApi;

    @Override
    public RestResponse<Object> addPhysicalWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) AddPhysicalWarehouseParams addPhysicalWarehouseParams) {
        CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto = DtoExchangeUtils.createDtoBySource(addPhysicalWarehouseParams, CsPhysicsWarehouseExposedAddReqDto.class);
        csPhysicsWarehouseExposedAddReqDto.setRdcFlag(addPhysicalWarehouseParams.getIsRDC());
        csPhysicsWarehouseExposedAddReqDto.setEasWarehouseCode(addPhysicalWarehouseParams.getEasWarehouseId());
        csPhysicsWarehouseExposedAddReqDto.setContacts(addPhysicalWarehouseParams.getContact());
        CoordinateVO coordinate = addPhysicalWarehouseParams.getCoordinate();
        csPhysicsWarehouseExposedAddReqDto.setLatitude(coordinate.getLatitude());
        csPhysicsWarehouseExposedAddReqDto.setLongitude(coordinate.getLongitude());
        AddressVO address = addPhysicalWarehouseParams.getAddress();
        csPhysicsWarehouseExposedAddReqDto.setProvince(address.getProvince());
        csPhysicsWarehouseExposedAddReqDto.setProvinceCode(address.getProvinceCode());
        csPhysicsWarehouseExposedAddReqDto.setCity(address.getCity());
        csPhysicsWarehouseExposedAddReqDto.setCityCode(address.getCityCode());
        csPhysicsWarehouseExposedAddReqDto.setDistrict(address.getDistrict());
        csPhysicsWarehouseExposedAddReqDto.setDistrictCode(address.getDistrictCode());
        csPhysicsWarehouseExposedAddReqDto.setDetailAddress(address.getDetailAddress());
        csPhysicsWarehouseExposedAddReqDto.setRdcFlag(addPhysicalWarehouseParams.getIsRDC());
        Long data = (Long)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.addPhysicsWarehouse(csPhysicsWarehouseExposedAddReqDto));
        return new RestResponse((Object)data);
    }

    @Override
    public RestResponse<PhysicalWarehouseVO> getPhysicalWarehouseById(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        CsPhysicsWarehouseDetailRespDto respDto = (CsPhysicsWarehouseDetailRespDto)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.queryDetailById(Long.valueOf(id)));
        if (Objects.nonNull(respDto)) {
            PhysicalWarehouseVO physicalWarehouseVO = DtoExchangeUtils.createDtoBySource(respDto, PhysicalWarehouseVO.class);
            physicalWarehouseVO.setIsRDC(respDto.getRdcFlag());
            physicalWarehouseVO.setEasWarehouseId(respDto.getEasWarehouseCode());
            physicalWarehouseVO.setContact(respDto.getContacts());
            CoordinateVO coordinate = new CoordinateVO();
            coordinate.setLatitude(respDto.getLatitude());
            coordinate.setLongitude(respDto.getLongitude());
            physicalWarehouseVO.setCoordinate(coordinate);
            AddressVO address = new AddressVO();
            address.setProvinceCode(respDto.getProvinceCode());
            address.setCityCode(respDto.getCityCode());
            address.setDistrictCode(respDto.getDistrictCode());
            address.setDetailAddress(respDto.getDetailAddress());
            physicalWarehouseVO.setAddress(address);
            physicalWarehouseVO.setId(respDto.getId());
            physicalWarehouseVO.setCreateTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)respDto.getCreateTime()));
            return new RestResponse((Object)physicalWarehouseVO);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<PhysicalWarehouseVO>> getPhysicalWarehouseListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetPhysicalWarehouseListPageParams getPhysicalWarehouseListPageParams) {
        CsPhysicsWarehousePageQueryDto csPhysicsWarehousePageQueryDto = DtoExchangeUtils.createDtoBySource(getPhysicalWarehouseListPageParams, CsPhysicsWarehousePageQueryDto.class);
        csPhysicsWarehousePageQueryDto.setEasWarehouseCode(getPhysicalWarehouseListPageParams.getEasWarehouseId());
        csPhysicsWarehousePageQueryDto.setRdcFlag(getPhysicalWarehouseListPageParams.getIsRDC());
        csPhysicsWarehousePageQueryDto.setIsLogistics(getPhysicalWarehouseListPageParams.getIsLogistics());
        RestResponse pageInfo = this.csPhysicsWarehouseExposedApi.queryPageInfo(csPhysicsWarehousePageQueryDto);
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfo);
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            PageInfo dtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List dtoList = respDtoPageInfo.getList().stream().map(respDto -> {
                PhysicalWarehouseVO physicalWarehouseVO = DtoExchangeUtils.createDtoBySource(respDto, PhysicalWarehouseVO.class);
                physicalWarehouseVO.setIsRDC(respDto.getRdcFlag());
                physicalWarehouseVO.setEasWarehouseId(respDto.getEasWarehouseCode());
                CoordinateVO coordinate = new CoordinateVO();
                physicalWarehouseVO.setCoordinate(coordinate);
                AddressVO address = new AddressVO();
                address.setProvinceCode(respDto.getProvinceCode());
                address.setCityCode(respDto.getCityCode());
                address.setDistrict(respDto.getDistrictCode());
                address.setDetailAddress(respDto.getDetailAddress());
                physicalWarehouseVO.setAddress(address);
                physicalWarehouseVO.setId(respDto.getId());
                physicalWarehouseVO.setWarehouseType(WarehouseTypeEnum.PHYSICS.getCode());
                return physicalWarehouseVO;
            }).collect(Collectors.toList());
            dtoPageInfo.setList(dtoList);
            return new RestResponse((Object)dtoPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetPhysicalWarehouseListPageParams params = new GetPhysicalWarehouseListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetPhysicalWarehouseListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetPhysicalWarehouseListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getPhysicalWarehouseListPage((GetPhysicalWarehouseListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutPhysicalWarehouseVO vo = new OutPhysicalWarehouseVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setWarehouseType(Optional.ofNullable(o.getWarehouseType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                    switch (Type2) {
                        case "physics": {
                            return "\u7269\u7406\u4ed3";
                        }
                        case "logic": {
                            return "\u903b\u8f91\u4ed3";
                        }
                        case "virtual": {
                            return "\u865a\u62df\u4ed3";
                        }
                        case "channel": {
                            return "\u6e20\u9053\u4ed3";
                        }
                        case "in_transit": {
                            return "\u5728\u9014\u4ed3";
                        }
                    }
                    return o.getWarehouseType();
                }).orElse(""));
                vo.setWarehouseStatus(Optional.ofNullable(o.getWarehouseStatus()).filter(StringUtils::isNotBlank).map(Status -> {
                    switch (Status) {
                        case "disable": {
                            return "\u65e0\u6548";
                        }
                        case "enable": {
                            return "\u6709\u6548";
                        }
                    }
                    return o.getWarehouseStatus();
                }).orElse(""));
                vo.setIsRDC(Optional.ofNullable(o.getIsRDC()).map(r -> r.equals("1") ? "\u662f" : "\u5426").orElse("\u5426"));
                vo.setAddress(o.getAddress().getDetailAddress());
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutPhysicalWarehouseVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetPhysicalWarehouseListPageParams params = new GetPhysicalWarehouseListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetPhysicalWarehouseListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetPhysicalWarehouseListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getPhysicalWarehouseListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public RestResponse<Object> updatePhysicalWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) UpdatePhysicalWarehouseParams updatePhysicalWarehouseParams) {
        CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto = DtoExchangeUtils.createDtoBySource(updatePhysicalWarehouseParams, CsPhysicsWarehouseExposedAddReqDto.class);
        csPhysicsWarehouseExposedAddReqDto.setId(Long.valueOf(updatePhysicalWarehouseParams.getWarehouseId()));
        csPhysicsWarehouseExposedAddReqDto.setRdcFlag(updatePhysicalWarehouseParams.getIsRDC());
        csPhysicsWarehouseExposedAddReqDto.setEasWarehouseCode(updatePhysicalWarehouseParams.getEasWarehouseId());
        csPhysicsWarehouseExposedAddReqDto.setContacts(updatePhysicalWarehouseParams.getContact());
        CoordinateVO coordinate = updatePhysicalWarehouseParams.getCoordinate();
        csPhysicsWarehouseExposedAddReqDto.setLatitude(coordinate.getLatitude());
        csPhysicsWarehouseExposedAddReqDto.setLongitude(coordinate.getLongitude());
        AddressVO address = updatePhysicalWarehouseParams.getAddress();
        csPhysicsWarehouseExposedAddReqDto.setProvince(address.getProvince());
        csPhysicsWarehouseExposedAddReqDto.setProvinceCode(address.getProvinceCode());
        csPhysicsWarehouseExposedAddReqDto.setCity(address.getCity());
        csPhysicsWarehouseExposedAddReqDto.setCityCode(address.getCityCode());
        csPhysicsWarehouseExposedAddReqDto.setDistrict(address.getDistrict());
        csPhysicsWarehouseExposedAddReqDto.setDistrictCode(address.getDistrictCode());
        csPhysicsWarehouseExposedAddReqDto.setDetailAddress(address.getDetailAddress());
        csPhysicsWarehouseExposedAddReqDto.setRdcFlag(updatePhysicalWarehouseParams.getIsRDC());
        RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.updatePhysicsWarehouse(csPhysicsWarehouseExposedAddReqDto));
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> batchUpdatePhysicalWarehouseStatus(@ApiParam(value="") @Valid @RequestBody(required=false) BatchPhysicalWarehouseParams batchPhysicalWarehouseParams) {
        if (CollectionUtils.isEmpty(batchPhysicalWarehouseParams.getPhysicalWarehouseIds())) {
            throw new BizException("\u7269\u7406\u4ed3id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String ids = batchPhysicalWarehouseParams.getPhysicalWarehouseIds().stream().collect(Collectors.joining(","));
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.modifyPhysicalWarehouseStatus(ids, batchPhysicalWarehouseParams.getPhysicalWarehouseStatus())));
    }
}

