/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.WarehouseTypeEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportInventoryWithPackageInfoQueryVO;
import com.dtyunxi.cis.pms.biz.model.GetInventoryQueryWithPackageInfoListPageParams;
import com.dtyunxi.cis.pms.biz.model.InventoryQueryWithPackageInfoVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterWithPackageInfoInquiryService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InventoryQueryWithGiftPackageInfoDto;
import com.dtyunxi.tcbj.api.query.IInventoryReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_inventory_query_with_package_info")
public class InventoryCenterWithPackageInfoInquiryServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements InventoryCenterWithPackageInfoInquiryService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryCenterWithPackageInfoInquiryServiceServiceImpl.class);
    @Autowired
    IInventoryReportQueryApi inventoryReportQueryApi;

    @Override
    public RestResponse<PageInfo<InventoryQueryWithPackageInfoVO>> getInventoryQueryWithPackageInfoListPage(GetInventoryQueryWithPackageInfoListPageParams params) {
        InventoryQueryWithGiftPackageInfoDto inventoryQueryDto = new InventoryQueryWithGiftPackageInfoDto();
        inventoryQueryDto.setWarehouseType(params.getWarehouseType());
        inventoryQueryDto.setBatch(params.getBatchNo());
        inventoryQueryDto.setCargoName(params.getGoodsName());
        inventoryQueryDto.setCargoCode(params.getGoodsLongCode());
        inventoryQueryDto.setWarehouseCode(params.getWarehouseCode());
        inventoryQueryDto.setWarehouseName(params.getWarehouseName());
        inventoryQueryDto.setIsExceedZero(params.getIsExceedZero());
        inventoryQueryDto.setPageNum(params.getPageNum());
        inventoryQueryDto.setPageSize(params.getPageSize());
        inventoryQueryDto.setOrganizationNames(params.getOrganizationNames());
        inventoryQueryDto.setIsGift(params.getIsGift());
        inventoryQueryDto.setSub1ProNo(params.getSub1ProNo());
        inventoryQueryDto.setSub1ProBatch(params.getSub1ProBatch());
        inventoryQueryDto.setFirstSubLot(params.getFirstSubLot());
        if (CollectionUtils.isEmpty((Collection)inventoryQueryDto.getWarehouseType())) {
            inventoryQueryDto.setWarehouseType((List)Lists.newArrayList((Object[])new String[]{WarehouseTypeEnum.LOGIC.getCode(), WarehouseTypeEnum.CHANNEL.getCode(), WarehouseTypeEnum.IN_TRANSIT.getCode(), WarehouseTypeEnum.VIRTUAL.getCode()}));
        }
        logger.info("inventoryQueryDto,\u4f20\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)inventoryQueryDto));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryReportQueryApi.queryInventoryWithGiftPackageInfoPage(inventoryQueryDto));
        logger.info("respDtoPageInfo,\u4f20\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)respDtoPageInfo));
        if (respDtoPageInfo == null) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            InventoryQueryWithPackageInfoVO vo = new InventoryQueryWithPackageInfoVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setGoodsLongCode(o.getLongCode());
            vo.setGoodsName(o.getCargoName());
            vo.setBatchNo(o.getBatch());
            vo.setWarehouseType(o.getClassify());
            vo.setActualInventory(ParamConverter.convertToBigDecimal((Object)o.getBalance()));
            vo.setAvailableInventory(ParamConverter.convertToBigDecimal((Object)o.getAvailable()));
            vo.setWaitInventory(ParamConverter.convertToBigDecimal((Object)o.getFutureIn()));
            vo.setPreoccupyInventory(ParamConverter.convertToBigDecimal((Object)o.getPreempt()));
            vo.setPreemptInventory(ParamConverter.convertToBigDecimal((Object)o.getLockInventory()));
            vo.setSaleInventory(ParamConverter.convertToBigDecimal((Object)o.getAllocate()));
            if (StringUtils.isNotBlank((CharSequence)o.getProduceTime())) {
                vo.setProduceTime(o.getProduceTime().substring(0, 10));
            }
            if (StringUtils.isNotBlank((CharSequence)o.getExpireTime())) {
                vo.setExpireTime(o.getExpireTime().substring(0, 10));
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetInventoryQueryWithPackageInfoListPageParams params = new GetInventoryQueryWithPackageInfoListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetInventoryQueryWithPackageInfoListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInventoryQueryWithPackageInfoListPageParams.class);
        }
        InventoryQueryWithGiftPackageInfoDto queryDto = new InventoryQueryWithGiftPackageInfoDto();
        BeanUtils.copyProperties((Object)params, (Object)queryDto);
        queryDto.setWarehouseType(params.getWarehouseType());
        queryDto.setBatch(params.getBatchNo());
        queryDto.setCargoName(params.getGoodsName());
        queryDto.setCargoCode(params.getGoodsLongCode());
        queryDto.setWarehouseCode(params.getWarehouseCode());
        queryDto.setWarehouseName(params.getWarehouseName());
        queryDto.setIsExceedZero(params.getIsExceedZero());
        queryDto.setIsGift(params.getIsGift());
        queryDto.setSub1ProBatch(params.getSub1ProBatch());
        queryDto.setSub1ProNo(params.getSub1ProNo());
        queryDto.setFirstSubLot(params.getFirstSubLot());
        if (CollectionUtils.isEmpty((Collection)queryDto.getWarehouseType())) {
            queryDto.setWarehouseType((List)Lists.newArrayList((Object[])new String[]{WarehouseTypeEnum.LOGIC.getCode(), WarehouseTypeEnum.CHANNEL.getCode(), WarehouseTypeEnum.IN_TRANSIT.getCode(), WarehouseTypeEnum.VIRTUAL.getCode()}));
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo inventoryRespVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryReportQueryApi.queryInventoryWithGiftPackageInfoPage(re));
            PageInfo resultPage = new PageInfo();
            BeanUtils.copyProperties((Object)inventoryRespVoPageInfo, (Object)resultPage);
            List list = inventoryRespVoPageInfo.getList().stream().map(o -> {
                ExportInventoryWithPackageInfoQueryVO vo = new ExportInventoryWithPackageInfoQueryVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setGoodsLongCode(o.getCargoCode());
                vo.setGoodsName(o.getCargoName());
                CsWarehouseClassifyEnum classifyEnum = CsWarehouseClassifyEnum.getByCode((String)o.getClassify());
                if (null != classifyEnum) {
                    vo.setWarehouseType(classifyEnum.getDesc());
                }
                vo.setActualInventory(BigDecimalUtils.check((BigDecimal)o.getBalance()).intValue());
                vo.setAvailableInventory(BigDecimalUtils.check((BigDecimal)o.getAvailable()).intValue());
                vo.setWaitInventory(BigDecimalUtils.check((BigDecimal)o.getFutureIn()).intValue());
                vo.setPreoccupyInventory(BigDecimalUtils.check((BigDecimal)o.getPreempt()).intValue());
                vo.setPreemptInventory(BigDecimalUtils.check((BigDecimal)o.getLockInventory()).intValue());
                if (StringUtils.isNotBlank((CharSequence)o.getProduceTime())) {
                    vo.setProduceTime(DateUtil.parse((String)o.getProduceTime(), (String)"yyyy-MM-dd"));
                }
                if (StringUtils.isNotBlank((CharSequence)o.getExpireTime())) {
                    vo.setExpireTime(DateUtil.parse((String)o.getExpireTime(), (String)"yyyy-MM-dd"));
                }
                vo.setAllocate(o.getAllocate().intValue());
                return vo;
            }).collect(Collectors.toList());
            resultPage.setList(list);
            return resultPage;
        }, queryDto, ExportInventoryWithPackageInfoQueryVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetInventoryQueryWithPackageInfoListPageParams params = new GetInventoryQueryWithPackageInfoListPageParams();
        InventoryQueryWithGiftPackageInfoDto queryDto = new InventoryQueryWithGiftPackageInfoDto();
        BeanUtils.copyProperties((Object)params, (Object)queryDto);
        queryDto.setWarehouseType(params.getWarehouseType());
        queryDto.setBatch(params.getBatchNo());
        queryDto.setCargoName(params.getGoodsName());
        queryDto.setCargoCode(params.getGoodsLongCode());
        queryDto.setWarehouseCode(params.getWarehouseCode());
        queryDto.setWarehouseName(params.getWarehouseName());
        queryDto.setIsExceedZero(params.getIsExceedZero());
        queryDto.setIsGift(params.getIsGift());
        queryDto.setSub1ProBatch(params.getSub1ProBatch());
        queryDto.setSub1ProNo(params.getSub1ProNo());
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1));
        PageInfo inventoryRespVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryReportQueryApi.queryInventoryWithGiftPackageInfoPage(queryDto));
        if (null == inventoryRespVoPageInfo || CollectionUtils.isEmpty((Collection)inventoryRespVoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)inventoryRespVoPageInfo.getTotal());
    }
}

