/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.dto.request.ItemWarehouseBlackVo;
import com.dtyunxi.cis.pms.biz.model.ExportClaimTransferOrderVo;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetTransferOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportClaimTransferOrderMsgVo;
import com.dtyunxi.cis.pms.biz.model.ImportClaimTransferOrderVo;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryTransferOrderService;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryTransferHelper;
import com.dtyunxi.cis.pms.biz.service.helper.TransferAddBaseDto;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CargoInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.query.ILogicInventoryQueryApi;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.inventory.api.entity.IInOutResultOrderDetailApi;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderDetailPageReqDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_claim_transfer_order")
public class ImportClaimTransferOrderServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(ImportClaimTransferOrderServiceImpl.class);
    @Resource
    private ILogicInventoryQueryApi logicInventoryQueryApi;
    @Resource
    private InventoryTransferHelper inventoryTransferHelper;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private ICsLogicWarehouseExposedApi warehouseExposedQueryApi;
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private ICsTransferOrderDetailApi transferOrderDetailApi;
    @Resource
    private ICsLogicInventoryQueryApi csLogicInventoryQueryApi;
    @Resource
    private IInOutResultOrderDetailApi iInOutResultOrderDetailApi;
    @Resource
    private IcsShipmenetEnterpriseQueryApi shipmenetEnterpriseQueryApi;
    @Resource
    private FinishedGoodsInventoryTransferOrderService service;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetTransferOrderListPageParams params = new GetTransferOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetTransferOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetTransferOrderListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.service.getTransferOrderListPage((GetTransferOrderListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                ExportClaimTransferOrderVo vo = new ExportClaimTransferOrderVo();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setBussinessOrderNo(o.getBussinessOrderNo());
                vo.setBussinessOrderType(o.getBussinessOrderType());
                vo.setBussinessOrderStatus(o.getBussinessOrderStatus());
                vo.setPreOrderNo(o.getPreOrderNo());
                vo.setOutCargoRightName(o.getOutCargoRightName());
                vo.setInCargoRightName(o.getInCargoRightName());
                vo.setOutLogicalWarehouseCode(o.getOutLogicalWarehouseCode());
                vo.setOutLogicalWarehouseName(o.getOutLogicalWarehouseName());
                vo.setInLogicalWarehouseCode(o.getInLogicalWarehouseCode());
                vo.setInLogicalWarehouseName(o.getInLogicalWarehouseName());
                vo.setClaimCarrierCode(o.getConsignmentNo());
                vo.setClaimConsignmentNo(o.getConsignmentNo());
                vo.setQuantity(o.getPlanTransferQuantity());
                vo.setRemark(o.getRemark());
                vo.setCreateTime(o.getCreateTime());
                if (Objects.nonNull(o.getBizDate())) {
                    vo.setBizDate(DateUtil.format((Date)o.getBizDate()));
                }
                vo.setTotalCartons(o.getTotalCartons() == null ? "" : o.getTotalCartons().stripTrailingZeros().toPlainString());
                vo.setMergeQuantity(o.getMergeQuantity() == null ? "" : o.getMergeQuantity().stripTrailingZeros().toPlainString());
                vo.setTotalWeight(o.getTotalWeight() == null ? "" : o.getTotalWeight().stripTrailingZeros().toPlainString());
                vo.setTotalVolume(o.getTotalVolume() == null ? "" : o.getTotalVolume().stripTrailingZeros().toPlainString());
                vo.setBussinessOrderStatus(Optional.ofNullable(o.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_delivery": {
                            return "\u5f85\u53d1\u8d27";
                        }
                        case "wait_receive": {
                            return "\u5f85\u6536\u8d27";
                        }
                        case "delivery": {
                            return "\u5df2\u53d1\u8d27";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "finish": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "canceled": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return "";
                }).orElse(""));
                vo.setBussinessOrderType(Optional.ofNullable(o.getBussinessOrderType()).filter(StringUtils::isNotBlank).map(r -> {
                    switch (r) {
                        case "allot_in_only": {
                            return "\u5e93\u5b58\u8c03\u62e8(\u8c03\u62e8\u5165\u5e93)";
                        }
                        case "allot_logic_out": {
                            return "\u903b\u8f91\u8c03\u62e8";
                        }
                        case "allot_lose_efficacy": {
                            return "\u8fd1\u6548\u671f\u5546\u54c1\u8c03\u62e8";
                        }
                        case "allot_out": {
                            return "\u666e\u901a\u8c03\u62e8";
                        }
                        case "allot_out_only": {
                            return "\u5e93\u5b58\u8c03\u62e8(\u8c03\u62e8\u51fa\u5e93)";
                        }
                        case "bc_allot": {
                            return "bc\u8c03\u62e8";
                        }
                        case "cb_allot": {
                            return "cb\u8c03\u62e8";
                        }
                        case "cc_allot": {
                            return "cc\u8c03\u62e8";
                        }
                        case "inspection_qualified": {
                            return "\u5f85\u68c0\u8f6c\u5408\u683c";
                        }
                        case "allot_sale": {
                            return "\u9500\u552e\u8c03\u62e8";
                        }
                        case "allot_sale_bh": {
                            return "\u9500\u552e\u8865\u8d27\u8c03\u62e8";
                        }
                    }
                    return "\u7d22\u8d54\u8c03\u62e8";
                }).orElse("\u7d22\u8d54\u8c03\u62e8"));
                vo.setPlanTransferQuantity(Optional.ofNullable(o.getPlanTransferQuantity()).orElse(BigDecimal.ZERO).intValue());
                vo.setOutWarehouseQuantity(new BigDecimal(this.getVal(o.getOutWarehouseQuantity())).intValue());
                vo.setInWarehouseQuantity(new BigDecimal(this.getVal(o.getInWarehouseQuantity())).intValue());
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportClaimTransferOrderVo.class, commonReqDto.getFileName());
        return urls.get(0);
    }

    private String getVal(String o) {
        return Optional.ofNullable(o).orElse("0");
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportClaimTransferOrderVo.class);
        HashSet checkRepeatData = Sets.newHashSet();
        HashSet warehouseCodes = Sets.newHashSet();
        HashSet inWarehouseCodes = Sets.newHashSet();
        this.assembleQueryParams(list, warehouseCodes, inWarehouseCodes);
        Map<String, LogicWarehouseRespDto> logicWarehouseMap = this.getLogicWarehouseMap(warehouseCodes);
        log.info("logicWarehouseMap=={}", (Object)JSON.toJSONString(logicWarehouseMap));
        List<CargoInventoryReqDto> queryList = this.assembleQueryParams(list);
        log.info("queryList=={}", (Object)JSON.toJSONString(queryList));
        log.info("list=={}", (Object)JSON.toJSONString((Object)list));
        Map<String, LogicInventoryRespDto> inventoryMap = this.getInventoryMap(queryList);
        log.info("inventoryMap=={}", (Object)JSON.toJSONString(inventoryMap));
        Map<String, CsLogicWarehousePageRespDto> logicWarehousePhysicsWarehouseMap = this.getLogicWarehousePhysicsWarehouseMap(inWarehouseCodes);
        log.info("logicWarehousePhysicsWarehouseMap=={}", (Object)JSON.toJSONString(logicWarehousePhysicsWarehouseMap));
        Map<String, Map<String, CsTransferOrderDetailRespDto>> relatedTransferOrderDetailsMap = this.getRelatedTransferOrderDetailsMap(list);
        log.info("relatedTransferOrderDetailsMap=={}", (Object)JSON.toJSONString(relatedTransferOrderDetailsMap));
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCodeAndCode("ITEM_IN_WAREHOUSE_BLACK", "ITEM_IN_WAREHOUSE_BLACK"));
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        Map<String, LogicWarehouseRespDto> finalLogicWarehouseMap = logicWarehouseMap;
        for (ImportClaimTransferOrderVo i : list) {
            ImportClaimTransferOrderMsgVo msgDto = new ImportClaimTransferOrderMsgVo();
            CubeBeanUtils.copyProperties((Object)msgDto, (Object)((Object)i), (String[])new String[0]);
            this.transformBizDate(i, msgDto);
            this.checkRepeatData(i.getUniqueKey(), checkRepeatData, msgDto);
            this.checkBusinessType(i.getBusinessType(), msgDto);
            this.checkRelatedTransferOrderNo(i.getRelatedTransferOrderNo(), msgDto);
            this.checkClaimCarrierCode(i.getClaimCarrierCode(), msgDto);
            this.checkClaimConsignmentNo(i.getClaimConsignmentNo(), msgDto);
            this.checkWarehouseIdentical(i.getOutLogicWarehouseCode(), i.getInLogicWarehouseCode(), msgDto);
            this.checkWarehouse(finalLogicWarehouseMap.get(i.getOutLogicWarehouseCode()), msgDto, i, 1);
            this.checkWarehouse(finalLogicWarehouseMap.get(i.getInLogicWarehouseCode()), msgDto, i, 2);
            this.checkInventoryOrganization(finalLogicWarehouseMap.get(i.getOutLogicWarehouseCode()), finalLogicWarehouseMap.get(i.getInLogicWarehouseCode()), msgDto);
            this.checkItemAndBatchAndQuantity(inventoryMap.get(i.getItemCodeAndBatchKey()), msgDto, i);
            this.checkRelatedTransferOrderItem(i.getRelatedTransferOrderNo(), i.getLongCode(), i.getBatch(), Integer.valueOf(i.getQuantity()), relatedTransferOrderDetailsMap, msgDto);
            this.specialCheckItem(logicWarehousePhysicsWarehouseMap, msgDto, i, dictDto);
            if (StringUtils.isNotBlank((CharSequence)msgDto.getErrorMsg())) {
                msgList.add(msgDto);
                continue;
            }
            saveList.add(i);
        }
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    private void specialCheckItem(Map<String, CsLogicWarehousePageRespDto> logicWarehousePhysicsWarehouseMap, ImportClaimTransferOrderMsgVo msgDto, ImportClaimTransferOrderVo i, DictDto dictDto) {
        log.info("\u7279\u6b8a\u6821\u9a8c:{}", (Object)JSON.toJSONString((Object)((Object)i)));
        if (!Objects.equals(i.getLongCode(), "10000084") || !Objects.equals(i.getBatch().substring(i.getBatch().length() - 1), "N")) {
            return;
        }
        String inLogicWarehouseCode = i.getInLogicWarehouseCode();
        if (logicWarehousePhysicsWarehouseMap.containsKey(inLogicWarehouseCode)) {
            CsLogicWarehousePageRespDto wh = logicWarehousePhysicsWarehouseMap.get(inLogicWarehouseCode);
            if (Objects.isNull(dictDto) || StringUtils.isEmpty((CharSequence)dictDto.getValue())) {
                return;
            }
            ItemWarehouseBlackVo vo = (ItemWarehouseBlackVo)JSON.parseObject((String)dictDto.getValue(), ItemWarehouseBlackVo.class);
            log.info("\u5546\u54c1\u4ed3\u5e93\u9ed1\u540d\u5355:{}", (Object)dictDto.getValue());
            if (!vo.isCheck()) {
                return;
            }
            if (CollectionUtils.isEmpty(vo.getWarehouseList())) {
                return;
            }
            List warehouseNameList = vo.getWarehouseList().stream().map(ItemWarehouseBlackVo.WarehouseDto::getName).collect(Collectors.toList());
            log.info("\u5224\u65ad\u662f\u5426\u4e3a\u6210\u90fd\u4ed3{}", (Object)warehouseNameList.contains(wh.getSubordinatePhysicsWarehouseName()));
            if (warehouseNameList.contains(wh.getSubordinatePhysicsWarehouseName())) {
                this.setErrorMsg(msgDto, "\u5546\u54c1\u957f\u7f16\u7801\uff1a10000084\uff0c\u5546\u54c1\u540d\u79f0\uff1a\u6c64\u81e3\u500d\u5065\u86cb\u767d\u7c89(450g/\u9ad8\u76d6\uff09A\uff0c\u6279\u6b21\u4ee5N\u7ed3\u5c3e\u7684\u5546\u54c1\uff0c\u4e0d\u53ef\u8c03\u62e8\u5230" + wh.getSubordinatePhysicsWarehouseName());
            }
        }
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        ArrayList msgList = Lists.newArrayList();
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            Map<String, List<ImportClaimTransferOrderVo>> importMap = saveList.stream().collect(Collectors.groupingBy(ImportClaimTransferOrderVo::getMergeOrderKey));
            List<TransferAddBaseDto> transferAddList = this.convertData(saveList, importMap);
            log.info("===\u8c03\u62e8\u5bfc\u5165\u6570\u636e==={}", (Object)JSON.toJSONString(transferAddList));
            transferAddList.forEach(i -> {
                block2: {
                    try {
                        this.createTransfer((TransferAddBaseDto)i);
                    }
                    catch (Exception e) {
                        String key = String.format("%s;%s", i.getSourceWarehouse(), i.getWare().getWarehouseCode());
                        if (!importMap.containsKey(key)) break block2;
                        List importTransferOrderVos = (List)importMap.get(key);
                        ArrayList list = Lists.newArrayList();
                        CubeBeanUtils.copyCollection((Collection)list, (Collection)importTransferOrderVos, ImportClaimTransferOrderMsgVo.class);
                        list.forEach(j -> j.setErrorMsg(e.getMessage()));
                        msgList.addAll(list);
                    }
                }
            });
        }
        String errorMsgUrl = null;
        if (msgObj != null) {
            List checkMsgList = (List)msgObj;
            msgList.addAll(checkMsgList);
        }
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = String.format("%s%s", "\u8c03\u62e8\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportClaimTransferOrderMsgVo.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private List<CargoInventoryReqDto> assembleQueryParams(List<ImportClaimTransferOrderVo> list) {
        ArrayList queryList = Lists.newArrayList();
        list.stream().forEach(i -> {
            i.setOutLogicWarehouseCode(i.getOutLogicWarehouseCode());
            CargoInventoryReqDto reqDto = new CargoInventoryReqDto();
            reqDto.setWarehouseCode(i.getOutLogicWarehouseCode());
            reqDto.setCargoCode(i.getLongCode());
            reqDto.setBatch(i.getBatch());
            queryList.add(reqDto);
        });
        return queryList;
    }

    private void assembleQueryParams(List<ImportClaimTransferOrderVo> list, Set<String> warehouseCodes, Set<String> inWarehouseCodes) {
        list.forEach(i -> {
            warehouseCodes.add(i.getOutLogicWarehouseCode());
            warehouseCodes.add(i.getInLogicWarehouseCode());
            inWarehouseCodes.add(i.getInLogicWarehouseCode());
        });
    }

    private Map<String, LogicInventoryRespDto> getInventoryMap(List<CargoInventoryReqDto> queryList) {
        HashMap inventoryMap = Maps.newHashMap();
        if (CollectionUtil.isEmpty(queryList)) {
            return inventoryMap;
        }
        Map<String, List<CargoInventoryReqDto>> warehouseGroupMap = queryList.stream().collect(Collectors.groupingBy(CargoInventoryReqDto::getWarehouseCode));
        for (Map.Entry<String, List<CargoInventoryReqDto>> entry : warehouseGroupMap.entrySet()) {
            String warehouseCode = entry.getKey();
            List<CargoInventoryReqDto> warehouseQueryList = entry.getValue();
            try {
                List longCodes = warehouseQueryList.stream().map(CargoInventoryReqDto::getCargoCode).distinct().collect(Collectors.toList());
                CsLogicInventoryQueryDto queryDto = new CsLogicInventoryQueryDto();
                queryDto.setWarehouseCode(warehouseCode);
                queryDto.setLongCodes(longCodes);
                queryDto.setPageNum(Integer.valueOf(1));
                queryDto.setPageSize(Integer.valueOf(1000));
                PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryQueryApi.queryByPage(queryDto));
                if (!CollectionUtil.isNotEmpty((Collection)respDtoPageInfo.getList())) continue;
                Map<String, BigDecimal> longCodeAvailableMap = respDtoPageInfo.getList().stream().collect(Collectors.groupingBy(CsLogicInventoryRespDto::getLongCode, Collectors.reducing(BigDecimal.ZERO, record -> record.getAvailable() != null ? record.getAvailable() : BigDecimal.ZERO, BigDecimal::add)));
                Map<String, BigDecimal> longCodeBatchAvailableMap = respDtoPageInfo.getList().stream().collect(Collectors.groupingBy(r -> r.getLongCode() + "_" + r.getBatch(), Collectors.reducing(BigDecimal.ZERO, record -> record.getAvailable() != null ? record.getAvailable() : BigDecimal.ZERO, BigDecimal::add)));
                for (CargoInventoryReqDto cargoInventoryReqDto : warehouseQueryList) {
                    String key = cargoInventoryReqDto.getWarehouseCode() + cargoInventoryReqDto.getCargoCode() + cargoInventoryReqDto.getBatch();
                    String batchKey = cargoInventoryReqDto.getCargoCode() + "_" + cargoInventoryReqDto.getBatch();
                    BigDecimal availableQuantity = longCodeBatchAvailableMap.get(batchKey);
                    if (availableQuantity == null || availableQuantity.compareTo(BigDecimal.ZERO) <= 0) {
                        availableQuantity = longCodeAvailableMap.get(cargoInventoryReqDto.getCargoCode());
                    }
                    if (availableQuantity == null || availableQuantity.compareTo(BigDecimal.ZERO) <= 0) continue;
                    LogicInventoryRespDto logicInventoryRespDto = new LogicInventoryRespDto();
                    logicInventoryRespDto.setAvailable(availableQuantity);
                    logicInventoryRespDto.setWarehouseCode(cargoInventoryReqDto.getWarehouseCode());
                    logicInventoryRespDto.setItemLongCode(cargoInventoryReqDto.getCargoCode());
                    logicInventoryRespDto.setBatch(cargoInventoryReqDto.getBatch());
                    inventoryMap.put(key, logicInventoryRespDto);
                }
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u4ed3\u5e93\u3010{}\u3011\u5e93\u5b58\u5931\u8d25\uff1a{}", new Object[]{warehouseCode, e.getMessage(), e});
            }
        }
        log.info("\u5546\u54c1\u5e93\u5b58\u6570\u636e========={}", (Object)JSON.toJSONString((Object)inventoryMap));
        return inventoryMap;
    }

    private Map<String, LogicWarehouseRespDto> getLogicWarehouseMap(Set<String> warehouseCodes) {
        Map<Object, Object> logicWarehouseMap = Maps.newHashMap();
        List warehouses = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryWarehouseByCode((List)Lists.newArrayList(warehouseCodes)));
        if (CollectionUtil.isNotEmpty((Collection)warehouses)) {
            logicWarehouseMap = warehouses.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        }
        return logicWarehouseMap;
    }

    private Map<String, CsLogicWarehousePageRespDto> getLogicWarehousePhysicsWarehouseMap(Set<String> warehouseCodes) {
        Map<Object, Object> logicWarehouseMap = Maps.newHashMap();
        CsLogicWarehousePageQueryDto queryDto = new CsLogicWarehousePageQueryDto();
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(warehouseCodes.size()));
        queryDto.setWarehouseCodeList(warehouseCodes);
        List warehouses = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.warehouseExposedQueryApi.queryPageInfo(queryDto))).getList();
        if (CollectionUtil.isNotEmpty((Collection)warehouses)) {
            logicWarehouseMap = warehouses.stream().collect(Collectors.toMap(CsLogicWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        }
        return logicWarehouseMap;
    }

    private Map<String, Map<String, CsTransferOrderDetailRespDto>> getRelatedTransferOrderDetailsMap(List<ImportClaimTransferOrderVo> list) {
        HashMap resultMap = Maps.newHashMap();
        Set relatedTransferOrderNos = list.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getRelatedTransferOrderNo())).map(ImportClaimTransferOrderVo::getRelatedTransferOrderNo).collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(relatedTransferOrderNos)) {
            return resultMap;
        }
        for (String transferOrderNo : relatedTransferOrderNos) {
            try {
                List transferOrderDetails = (List)RestResponseHelper.extractData((RestResponse)this.transferOrderDetailApi.queryListByTransferOrderNo(transferOrderNo));
                if (!CollectionUtil.isNotEmpty((Collection)transferOrderDetails)) continue;
                Map detailMap = transferOrderDetails.stream().collect(Collectors.toMap(detail -> detail.getLongCode() + "_" + detail.getBatch(), Function.identity(), (existing, replacement) -> existing));
                resultMap.put(transferOrderNo, detailMap);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u5173\u8054\u8c03\u62e8\u5355\u8be6\u60c5\u5931\u8d25, transferOrderNo: {}", (Object)transferOrderNo, (Object)e);
                resultMap.put(transferOrderNo, Maps.newHashMap());
            }
        }
        return resultMap;
    }

    private void checkWarehouse(LogicWarehouseRespDto warehouse, ImportClaimTransferOrderMsgVo msgDto, ImportClaimTransferOrderVo importDto, int type) {
        if (warehouse == null) {
            this.setErrorMsg(msgDto, String.format("%s\u4ed3\u5e93\u7f16\u7801\u4e0d\u6b63\u786e", type == 1 ? "\u8c03\u51fa\u4ed3" : "\u8c03\u5165\u4ed3"));
        } else {
            if (type == 1) {
                importDto.setOutLogicWarehouseName(warehouse.getWarehouseName());
            }
            if (type == 2) {
                importDto.setInLogicWarehouseName(warehouse.getWarehouseName());
                this.checkClaimWarehouse(warehouse, msgDto, importDto);
            }
        }
    }

    private void checkClaimWarehouse(LogicWarehouseRespDto warehouse, ImportClaimTransferOrderMsgVo msgDto, ImportClaimTransferOrderVo importDto) {
        try {
            CsLogicWarehouseDetailRespDto warehouseDetail = (CsLogicWarehouseDetailRespDto)RestResponseHelper.extractData((RestResponse)this.warehouseExposedQueryApi.queryDetailByCode(warehouse.getWarehouseCode()));
            if (warehouseDetail != null) {
                Integer isClaim = warehouseDetail.getIsClaim();
                if (isClaim == null || isClaim != 1) {
                    this.setErrorMsg(msgDto, String.format("\u8c03\u5165\u4ed3\u3010%s\u3011\u4e0d\u662f\u7d22\u8d54\u4ed3\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u7d22\u8d54\u8c03\u62e8", warehouse.getWarehouseName()));
                }
            } else {
                this.setErrorMsg(msgDto, String.format("\u65e0\u6cd5\u83b7\u53d6\u8c03\u5165\u4ed3\u3010%s\u3011\u7684\u8be6\u7ec6\u4fe1\u606f", warehouse.getWarehouseName()));
            }
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u8c03\u5165\u4ed3\u662f\u5426\u4e3a\u7d22\u8d54\u4ed3\u5931\u8d25\uff0c\u4ed3\u5e93\u7f16\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{warehouse.getWarehouseCode(), e.getMessage(), e});
            this.setErrorMsg(msgDto, String.format("\u6821\u9a8c\u8c03\u5165\u4ed3\u3010%s\u3011\u662f\u5426\u4e3a\u7d22\u8d54\u4ed3\u65f6\u53d1\u751f\u9519\u8bef", warehouse.getWarehouseName()));
        }
    }

    private void createTransfer(TransferAddBaseDto addBaseDto) {
        this.inventoryTransferHelper.doAddTransfer(addBaseDto);
    }

    private List<TransferAddBaseDto> convertData(List<ImportClaimTransferOrderVo> saveList, Map<String, List<ImportClaimTransferOrderVo>> map) {
        ArrayList list = Lists.newArrayList();
        map.forEach((key, value) -> {
            ImportClaimTransferOrderVo importDto = (ImportClaimTransferOrderVo)((Object)((Object)value.get(0)));
            List<LogicInventoryRespDto> inventoryList = value.stream().map(i -> {
                LogicInventoryRespDto addDto = new LogicInventoryRespDto();
                addDto.setItemLongCode(i.getLongCode());
                addDto.setBatch(i.getBatch());
                addDto.setAvailable(new BigDecimal(i.getQuantity()));
                addDto.setRemark(i.getRemake());
                return addDto;
            }).collect(Collectors.toList());
            LogicWarehouseRespDto ware = new LogicWarehouseRespDto();
            ware.setWarehouseCode(importDto.getInLogicWarehouseCode());
            TransferAddBaseDto addBaseDto = new TransferAddBaseDto(importDto.getOutLogicWarehouseCode(), inventoryList, ware, CsPcpBusinessTypeEnum.BORROW_ALLOT.getCode(), null);
            addBaseDto.setImportFlag(true);
            addBaseDto.setPreOrderNo(importDto.getRelatedTransferOrderNo());
            addBaseDto.setPrefixNo("SPDB");
            addBaseDto.setBizDate(new Date());
            addBaseDto.setType(CsPcpBusinessTypeEnum.CLAIM_ALLOT.getCode());
            String claimCarrierCode = importDto.getClaimCarrierCode();
            if (StringUtils.isNotBlank((CharSequence)claimCarrierCode)) {
                try {
                    CsShipmenetEnterpriseRespDto shipmenetEnterprise = (CsShipmenetEnterpriseRespDto)RestResponseHelper.extractData((RestResponse)this.shipmenetEnterpriseQueryApi.queryByCode(claimCarrierCode));
                    if (shipmenetEnterprise != null && StringUtils.isNotBlank((CharSequence)shipmenetEnterprise.getShipmentEnterpriseName())) {
                        addBaseDto.setShipmentEnterpriseCode(claimCarrierCode);
                        addBaseDto.setShipmentEnterpriseName(shipmenetEnterprise.getShipmentEnterpriseName());
                        addBaseDto.setExpressNo(importDto.getClaimConsignmentNo());
                        addBaseDto.setApplyclaimFile("");
                        log.info("\u5bfc\u5165\u7d22\u8d54\u8c03\u62e8\u5355\uff0c\u7269\u6d41\u5546\u7f16\u7801\u3010{}\u3011\u83b7\u53d6\u5230\u7269\u6d41\u5546\u540d\u79f0\u3010{}\u3011", (Object)claimCarrierCode, (Object)shipmenetEnterprise.getShipmentEnterpriseName());
                    } else {
                        log.warn("\u7269\u6d41\u5546\u7f16\u7801\u3010{}\u3011\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u5bf9\u5e94\u7684\u7269\u6d41\u5546\u540d\u79f0", (Object)claimCarrierCode);
                    }
                }
                catch (Exception e) {
                    log.error("\u67e5\u8be2\u7269\u6d41\u5546\u4fe1\u606f\u5931\u8d25, claimCarrierCode: {}", (Object)claimCarrierCode, (Object)e);
                }
            }
            list.add(addBaseDto);
        });
        return list;
    }

    private void transformBizDate(ImportClaimTransferOrderVo vo, ImportClaimTransferOrderMsgVo msgDto) {
        if (StringUtils.isNotBlank((CharSequence)vo.getBizDateStr())) {
            try {
                log.info("\u8c03\u62e8\u65f6\u95f4\u8d4b\u503c\uff1a{}", (Object)JSON.toJSONString((Object)((Object)vo)));
                vo.setBizDate(DateUtil.parse((String)vo.getBizDateStr(), (String)DatePattern.DATE_PATTERN.getPattern()));
                log.info("\u8c03\u62e8\u65f6\u95f4\u8d4b\u503c\u540e\uff1a{}", (Object)JSON.toJSONString((Object)((Object)vo)));
            }
            catch (Exception e) {
                this.setErrorMsg(msgDto, "\u8c03\u62e8\u65f6\u95f4\u683c\u5f0f\u6709\u8bef");
            }
        }
    }

    private void checkRepeatData(String uniqueKey, Set<String> checkRepeatData, ImportClaimTransferOrderMsgVo msgDto) {
        if (checkRepeatData.contains(uniqueKey)) {
            this.setErrorMsg(msgDto, "\u6570\u636e\u91cd\u590d");
        } else {
            checkRepeatData.add(uniqueKey);
        }
    }

    private void checkWarehouseIdentical(String outLogicWarehouseCode, String inLogicWarehouseCode, ImportClaimTransferOrderMsgVo msgDto) {
        if (Objects.equals(outLogicWarehouseCode, inLogicWarehouseCode)) {
            this.setErrorMsg(msgDto, "\u8c03\u5165\u903b\u8f91\u4ed3\u548c\u8c03\u51fa\u903b\u8f91\u4ed3\u76f8\u540c");
        }
    }

    private void setErrorMsg(ImportClaimTransferOrderMsgVo msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setErrorMsg(errorMsg);
        } else {
            msgDto.setErrorMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), errorMsg));
        }
    }

    private void checkItemAndBatchAndQuantity(LogicInventoryRespDto logicInventoryRespDto, ImportClaimTransferOrderMsgVo msgDto, ImportClaimTransferOrderVo importDto) {
        if (logicInventoryRespDto == null) {
            try {
                BigDecimal totalAvailable;
                CsLogicInventoryQueryDto queryDto = new CsLogicInventoryQueryDto();
                queryDto.setWarehouseCode(importDto.getOutLogicWarehouseCode());
                queryDto.setLongCodes((List)Lists.newArrayList((Object[])new String[]{importDto.getLongCode()}));
                queryDto.setPageNum(Integer.valueOf(1));
                queryDto.setPageSize(Integer.valueOf(1000));
                PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryQueryApi.queryByPage(queryDto));
                if (CollectionUtil.isNotEmpty((Collection)respDtoPageInfo.getList()) && BigDecimalUtils.gtZero((BigDecimal)(totalAvailable = respDtoPageInfo.getList().stream().map(CsLogicInventoryRespDto::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add))).booleanValue()) {
                    this.setErrorMsg(msgDto, String.format("\u8be5\u5546\u54c1\u5728\u903b\u8f91\u4ed3\u3010%s\u3011\u5b58\u5728\u5e93\u5b58\u3010%s\u3011\uff0c\u4f46\u6279\u6b21\u3010%s\u3011\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6279\u6b21\u4fe1\u606f", importDto.getOutLogicWarehouseName(), totalAvailable.toString(), importDto.getBatch()));
                    return;
                }
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u65e0\u6279\u6b21\u5e93\u5b58\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
            this.setErrorMsg(msgDto, String.format("\u8be5\u6279\u6b21\u5546\u54c1\u5728\u903b\u8f91\u4ed3\u3010%s\u3011\u672a\u627e\u5230", importDto.getOutLogicWarehouseName()));
        } else {
            if (logicInventoryRespDto.getAvailable() == null || logicInventoryRespDto.getAvailable().longValue() < Long.valueOf(importDto.getQuantity())) {
                this.setErrorMsg(msgDto, String.format("\u5e93\u5b58\u4e0d\u8db3,\u73b0\u6709\u5e93\u5b58\u3010%s\u3011", logicInventoryRespDto.getAvailable()));
            }
            importDto.setItemName(logicInventoryRespDto.getItemName());
        }
    }

    private void checkInventoryOrganization(LogicWarehouseRespDto outWarehouse, LogicWarehouseRespDto inWarehouse, ImportClaimTransferOrderMsgVo msgDto) {
        if (!Objects.equals(outWarehouse.getOrganizationId(), inWarehouse.getOrganizationId())) {
            this.setErrorMsg(msgDto, "\u8c03\u5165\u4ed3\u548c\u8c03\u51fa\u4ed3\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u4e00\u81f4");
        }
    }

    private void checkBusinessType(String businessType, ImportClaimTransferOrderMsgVo msgDto) {
        if (StringUtils.isBlank((CharSequence)businessType)) {
            this.setErrorMsg(msgDto, "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (!"\u7d22\u8d54\u8c03\u62e8".equals(businessType)) {
            this.setErrorMsg(msgDto, "\u4e1a\u52a1\u7c7b\u578b\u5fc5\u987b\u4e3a'\u7d22\u8d54\u8c03\u62e8'");
        }
    }

    private void checkRelatedTransferOrderNo(String relatedTransferOrderNo, ImportClaimTransferOrderMsgVo msgDto) {
        if (StringUtils.isBlank((CharSequence)relatedTransferOrderNo)) {
            this.setErrorMsg(msgDto, "\u5173\u8054\u8c03\u62e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (relatedTransferOrderNo.length() > 50) {
            this.setErrorMsg(msgDto, "\u5173\u8054\u8c03\u62e8\u5355\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26");
        }
    }

    private void checkClaimCarrierCode(String claimCarrierCode, ImportClaimTransferOrderMsgVo msgDto) {
        if (StringUtils.isBlank((CharSequence)claimCarrierCode)) {
            this.setErrorMsg(msgDto, "\u7d22\u8d54\u627f\u8fd0\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (claimCarrierCode.length() > 20) {
            this.setErrorMsg(msgDto, "\u7d22\u8d54\u627f\u8fd0\u5546\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26");
        } else {
            try {
                CsShipmenetEnterpriseRespDto shipmenetEnterprise = (CsShipmenetEnterpriseRespDto)RestResponseHelper.extractData((RestResponse)this.shipmenetEnterpriseQueryApi.queryByCode(claimCarrierCode));
                if (shipmenetEnterprise == null || StringUtils.isBlank((CharSequence)shipmenetEnterprise.getShipmentEnterpriseCode())) {
                    this.setErrorMsg(msgDto, String.format("\u7d22\u8d54\u627f\u8fd0\u5546\u7f16\u7801\u3010%s\u3011\u4e0d\u5b58\u5728", claimCarrierCode));
                }
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u7269\u6d41\u5546\u4fe1\u606f\u5931\u8d25, claimCarrierCode: {}", (Object)claimCarrierCode, (Object)e);
                this.setErrorMsg(msgDto, String.format("\u67e5\u8be2\u7269\u6d41\u5546\u4fe1\u606f\u5931\u8d25\uff0c\u7f16\u7801\u3010%s\u3011", claimCarrierCode));
            }
        }
    }

    private void checkClaimConsignmentNo(String claimConsignmentNo, ImportClaimTransferOrderMsgVo msgDto) {
        if (StringUtils.isBlank((CharSequence)claimConsignmentNo)) {
            this.setErrorMsg(msgDto, "\u7d22\u8d54\u6258\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (claimConsignmentNo.length() > 50) {
            this.setErrorMsg(msgDto, "\u7d22\u8d54\u6258\u8fd0\u5355\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26");
        }
    }

    private void checkRelatedTransferOrderItem(String relatedTransferOrderNo, String itemCode, String batch, Integer quantity, Map<String, Map<String, CsTransferOrderDetailRespDto>> relatedTransferOrderDetailsMap, ImportClaimTransferOrderMsgVo msgDto) {
        if (StringUtils.isBlank((CharSequence)relatedTransferOrderNo) || StringUtils.isBlank((CharSequence)itemCode) || StringUtils.isBlank((CharSequence)batch)) {
            return;
        }
        try {
            String actualOutKey;
            Map<String, CsTransferOrderDetailRespDto> transferOrderDetails = relatedTransferOrderDetailsMap.get(relatedTransferOrderNo);
            if (transferOrderDetails == null || transferOrderDetails.isEmpty()) {
                this.setErrorMsg(msgDto, String.format("\u5173\u8054\u8c03\u62e8\u5355\u53f7\u3010%s\u3011\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u5546\u54c1\u660e\u7ec6", relatedTransferOrderNo));
                return;
            }
            String itemKey = itemCode + "_" + batch;
            CsTransferOrderDetailRespDto matchedItem = transferOrderDetails.get(itemKey);
            if (matchedItem == null) {
                this.setErrorMsg(msgDto, String.format("\u5546\u54c1\u3010%s\u3011\u6279\u6b21\u3010%s\u3011\u5728\u5173\u8054\u8c03\u62e8\u5355\u53f7\u3010%s\u3011\u4e2d\u4e0d\u5b58\u5728", itemCode, batch, relatedTransferOrderNo));
                return;
            }
            InOutResultOrderDetailPageReqDto queryDto = new InOutResultOrderDetailPageReqDto();
            queryDto.setRelevanceNo(relatedTransferOrderNo);
            queryDto.setPageNum(Integer.valueOf(1));
            queryDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iInOutResultOrderDetailApi.page(queryDto));
            List resultOrderDetails = pageInfo.getList();
            if (CollectionUtils.isEmpty((Collection)resultOrderDetails)) {
                this.setErrorMsg(msgDto, String.format("\u539f\u8c03\u62e8\u5355\u3010%s\u3011\u672a\u627e\u5230\u5173\u8054\u7684\u51fa\u5e93\u7ed3\u679c\u5355", relatedTransferOrderNo));
                return;
            }
            Map<String, BigDecimal> actualOutQuantityMap = resultOrderDetails.stream().filter(r -> r.getDocumentNo().startsWith("PRO")).collect(Collectors.groupingBy(detail -> detail.getSkuCode() + "_" + Optional.ofNullable(detail.getBatch()).orElse(""), Collectors.reducing(BigDecimal.ZERO, detail -> Optional.ofNullable(detail.getQuantity()).orElse(BigDecimal.ZERO), BigDecimal::add)));
            BigDecimal actualOutQuantity = actualOutQuantityMap.get(actualOutKey = itemCode + "_" + batch);
            if (actualOutQuantity == null || actualOutQuantity.compareTo(BigDecimal.ZERO) <= 0) {
                this.setErrorMsg(msgDto, String.format("\u5546\u54c1\u3010%s\u3011\u6279\u6b21\u3010%s\u3011\u5728\u539f\u8c03\u62e8\u5355\u3010%s\u3011\u4e2d\u672a\u627e\u5230\u5b9e\u9645\u51fa\u5e93\u6570\u91cf", itemCode, batch, relatedTransferOrderNo));
                return;
            }
            BigDecimal claimQuantity = new BigDecimal(quantity);
            if (claimQuantity.compareTo(actualOutQuantity) > 0) {
                this.setErrorMsg(msgDto, String.format("\u5546\u54c1\u3010%s\u3011\u6279\u6b21\u3010%s\u3011\u7684\u7d22\u8d54\u6570\u91cf\u3010%s\u3011\u8d85\u8fc7\u4e86\u539f\u8c03\u62e8\u5355\u3010%s\u3011\u7684\u5b9e\u9645\u51fa\u5e93\u6570\u91cf\u3010%s\u3011", itemCode, batch, claimQuantity.toString(), relatedTransferOrderNo, actualOutQuantity.toString()));
            }
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u5173\u8054\u8c03\u62e8\u5355\u5546\u54c1\u548c\u6570\u91cf\u5931\u8d25, relatedTransferOrderNo: {}, itemCode: {}, batch: {}", new Object[]{relatedTransferOrderNo, itemCode, batch, e});
            this.setErrorMsg(msgDto, String.format("\u6821\u9a8c\u5173\u8054\u8c03\u62e8\u5355\u3010%s\u3011\u5931\u8d25: %s", relatedTransferOrderNo, e.getMessage()));
        }
    }
}

