/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.FinishedGoodsInventoryTypeEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.InternalDealDetailReportVo;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.IReportCenterService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.tcbj.api.dto.request.TransferOrderReportReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_internal_deal_detail_report")
public class ExportInternalDealDetailReportServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    private static final Logger logger = LoggerFactory.getLogger(ExportInternalDealDetailReportServiceImpl.class);
    @Resource
    private IReportCenterService reportCenterService;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u62a5\u8868\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        TransferOrderReportReqDto params = new TransferOrderReportReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (TransferOrderReportReqDto)JSON.parseObject((String)commonReqDto.getFilter(), TransferOrderReportReqDto.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.reportCenterService.internalDealReportPage((TransferOrderReportReqDto)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(item -> {
                InternalDealDetailReportVo vo = new InternalDealDetailReportVo();
                BeanUtils.copyProperties((Object)item, (Object)((Object)vo));
                if (StringUtils.isNotBlank((CharSequence)vo.getType())) {
                    vo.setType(FinishedGoodsInventoryTypeEnum.getDescByCode(vo.getType()));
                }
                vo.setOrderStatus(this.getOrderStatus(vo.getOrderStatus()));
                if (ObjectUtil.isNotEmpty((Object)item.getCreateTime())) {
                    vo.setCreateTimeStr(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(item.getCreateTime()));
                }
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, InternalDealDetailReportVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u62a5\u8868\u5bfc\u51fa\u603b\u6570\uff1a{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        TransferOrderReportReqDto params = new TransferOrderReportReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (TransferOrderReportReqDto)JSON.parseObject((String)commonReqDto.getFilter(), TransferOrderReportReqDto.class);
        }
        params.setPageNum(Integer.valueOf(1));
        params.setPageSize(Integer.valueOf(1));
        return Math.toIntExact(Optional.ofNullable(this.reportCenterService.internalDealReportPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    private String getOrderStatus(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        for (CsTransferOrderEnum.Status e : CsTransferOrderEnum.Status.values()) {
            if (!e.getCode().equals(code)) continue;
            return e.getDesc();
        }
        return "";
    }
}

