/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.effective.strategy;

import com.dtyunxi.cis.pms.biz.effective.EffectiveLoseStrategy;
import com.dtyunxi.cis.pms.biz.fetch.FetchDataService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LogicInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.query.ILogicInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.enums.DictEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;

public class DictEffectiveLoseStrategy
implements EffectiveLoseStrategy {
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private ILogicInventoryQueryApi logicInventoryQueryApi;
    private final FetchDataService<LogicInventoryReqDto, LogicInventoryRespDto> fetchDataService = req -> (PageInfo)this.logicInventoryQueryApi.queryByPage(req).getData();

    @Override
    public List<LogicInventoryRespDto> loadEffectiveLoseInventory() {
        return Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCodeAndCode(DictEnum.INVENTORY_SETTING_EXPIRATION_WARNING.getGroupCode(), DictEnum.INVENTORY_SETTING_EXPIRATION_WARNING.getCode()))).map(DictDto::getValue).map(dict -> {
            LogicInventoryReqDto logicInventoryReqDto = new LogicInventoryReqDto();
            logicInventoryReqDto.setWarehouseQuality("qualified");
            logicInventoryReqDto.setPositiveAvailable(Integer.valueOf(1));
            logicInventoryReqDto.setExpireBeginTime(new Date(this.getTodayZero()));
            logicInventoryReqDto.setItemNameStater("1");
            logicInventoryReqDto.setPositiveAvailable(Integer.valueOf(1));
            logicInventoryReqDto.setFilterWarehouse(Integer.valueOf(1));
            GregorianCalendar c = new GregorianCalendar();
            ((Calendar)c).add(5, Integer.parseInt(dict));
            logicInventoryReqDto.setExpireEndTime(c.getTime());
            return this.fetchDataService.fetchAll(logicInventoryReqDto).stream().filter(i -> i.getAvailable().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        }).orElse(Lists.newArrayList());
    }

    private long getTodayZero() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }
}

