/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.AddAdjustBatchNoParams;
import com.dtyunxi.cis.pms.biz.model.BatchNoReadjustmentVO;
import com.dtyunxi.cis.pms.biz.model.GetAdjustBatchNoListPageParams;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryBatchNoReadjustmentService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.BatchAdjustmentOrderReqDto;
import com.dtyunxi.tcbj.api.query.IBatchAdjustmentOrderQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsBatchAdjustmentOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsBatchAdjustmentOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsBatchAdjustmentOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBatchAdjustmentOrderStatusEnum;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class FinishedGoodsInventoryBatchNoReadjustmentServiceServiceImpl
implements FinishedGoodsInventoryBatchNoReadjustmentService {
    @Resource
    private ICsBatchAdjustmentOrderApi csBatchAdjustmentOrderApi;
    @Resource
    private IBatchAdjustmentOrderQueryApi batchAdjustmentOrderQueryApi;

    @Override
    public RestResponse<Object> addBatchNoReadjustment(@ApiParam(value="") @Valid @RequestBody(required=false) AddAdjustBatchNoParams addAdjustBatchNoParams) {
        CsBatchAdjustmentOrderGenerateReqDto reqDto = new CsBatchAdjustmentOrderGenerateReqDto();
        this.getBatchAdjustmentOrder(addAdjustBatchNoParams, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csBatchAdjustmentOrderApi.generateBatchAdjustmentOrder(reqDto)));
    }

    private void getBatchAdjustmentOrder(AddAdjustBatchNoParams addAdjustBatchNoParams, CsBatchAdjustmentOrderGenerateReqDto reqDto) {
        BeanUtils.copyProperties((Object)addAdjustBatchNoParams, (Object)reqDto);
        reqDto.setOrderStatus(CsBatchAdjustmentOrderStatusEnum.WAIT_SUBMIT.getCode());
        if (YesOrNoEnum.YES.getCode().equals(addAdjustBatchNoParams.getSubmitType())) {
            reqDto.setOrderStatus(CsBatchAdjustmentOrderStatusEnum.WAIT_AUDIT.getCode());
        }
        reqDto.setBusinessType(addAdjustBatchNoParams.getBussinessOrderType());
        reqDto.setSynchronousWms(YesOrNoEnum.YES.getCode());
        if (BatchNoReadjustmentVO.SyncWMSEnum._0.getValue().equals(addAdjustBatchNoParams.getSyncWMS())) {
            reqDto.setSynchronousWms(YesOrNoEnum.NO.getCode());
        }
        if (CollectionUtils.isNotEmpty(addAdjustBatchNoParams.getGoodsList())) {
            List list = addAdjustBatchNoParams.getGoodsList().stream().map(o -> {
                CsBatchAdjustmentOrderDetailAddReqDto dto = new CsBatchAdjustmentOrderDetailAddReqDto();
                BeanUtils.copyProperties((Object)o, (Object)dto, (String[])new String[]{"id"});
                dto.setLongCode(o.getGoodsLongCode());
                dto.setCargoCode(o.getGoodsCode());
                dto.setCargoName(o.getGoodsName());
                dto.setBatch(o.getBatchNo());
                if (StringUtils.isNotBlank((CharSequence)o.getEffectiveTime())) {
                    dto.setProduceTime(DateUtil.parse((String)o.getEffectiveTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                if (o.getInvalidTime() != null) {
                    dto.setExpireTime(DateUtil.parse((String)o.getInvalidTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                dto.setNewBatch(o.getAdjustedBatchNo());
                if (o.getAdjustedEffectiveTime() != null) {
                    dto.setNewProduceTime(DateUtil.parse((String)o.getAdjustedEffectiveTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                if (o.getAdjustedInvalidTime() != null) {
                    dto.setNewExpireTime(DateUtil.parse((String)o.getAdjustedInvalidTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                dto.setChangeQuantity(ParamConverter.convertToBigDecimal((Object)o.getAdjustedQuantity()));
                return dto;
            }).collect(Collectors.toList());
            reqDto.setItemDetailList(list);
        }
    }

    @Override
    public RestResponse<PageInfo<BatchNoReadjustmentVO>> getBatchNoReadjustmentListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetAdjustBatchNoListPageParams getAdjustBatchNoListPageParams) {
        BatchAdjustmentOrderReqDto reqDto = new BatchAdjustmentOrderReqDto();
        BeanUtils.copyProperties((Object)getAdjustBatchNoListPageParams, (Object)reqDto);
        reqDto.setOrderNo(getAdjustBatchNoListPageParams.getBussinessOrderNo());
        reqDto.setOrderStatus(getAdjustBatchNoListPageParams.getBussinessOrderStatus());
        reqDto.setBusinessType(getAdjustBatchNoListPageParams.getBussinessOrderType());
        if (StringUtils.isNotBlank((CharSequence)getAdjustBatchNoListPageParams.getSyncWMS())) {
            if (BatchNoReadjustmentVO.SyncWMSEnum._1.getValue().equals(getAdjustBatchNoListPageParams.getSyncWMS())) {
                reqDto.setSynchronousWms(YesOrNoEnum.YES.getCode());
            }
            if (BatchNoReadjustmentVO.SyncWMSEnum._0.getValue().equals(getAdjustBatchNoListPageParams.getSyncWMS())) {
                reqDto.setSynchronousWms(YesOrNoEnum.NO.getCode());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)getAdjustBatchNoListPageParams.getStartTime())) {
            reqDto.setCreateBeginTime(DateUtil.parse((String)(getAdjustBatchNoListPageParams.getStartTime() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (StringUtils.isNotEmpty((CharSequence)getAdjustBatchNoListPageParams.getEndTime())) {
            reqDto.setCreateEndTime(DateUtil.parse((String)(getAdjustBatchNoListPageParams.getEndTime() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.batchAdjustmentOrderQueryApi.queryByPage(reqDto));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            BatchNoReadjustmentVO vo = new BatchNoReadjustmentVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setBussinessOrderNo(o.getOrderNo());
            vo.setBussinessOrderType(o.getBusinessType());
            vo.setBussinessOrderStatus(o.getOrderStatus());
            if (o.getSynchronousWms() != null) {
                vo.setSyncWMS(ParamConverter.convertToString((Object)o.getSynchronousWms()));
            }
            vo.setTotalNum(o.getTotalQuantity() != null ? Integer.parseInt(o.getTotalQuantity().setScale(0, 1).toString()) : 0);
            if (o.getCreateTime() != null) {
                vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> updateBatchNoReadjustment(@ApiParam(value="") @Valid @RequestBody(required=false) AddAdjustBatchNoParams addAdjustBatchNoParams) {
        if (StringUtils.isBlank((CharSequence)addAdjustBatchNoParams.getBussinessOrderNo())) {
            throw new BizException("\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CsBatchAdjustmentOrderGenerateReqDto reqDto = new CsBatchAdjustmentOrderGenerateReqDto();
        this.getBatchAdjustmentOrder(addAdjustBatchNoParams, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csBatchAdjustmentOrderApi.editBatchAdjustmentOrder(addAdjustBatchNoParams.getBussinessOrderNo(), reqDto)));
    }
}

