/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.scheduler.task;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.api.IMergeNoticeTransferApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.MergeNoticeTransferDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.basicdata.api.query.IPcpDictQueryApi;
import com.yunxi.dg.base.commons.utils.LogUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class MergeNoticeTransferTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(MergeNoticeTransferTask.class);
    @Autowired
    IPcpDictQueryApi pcpDictQueryApi;
    @Autowired
    IMergeNoticeTransferApi mergeNoticeTransferApi;
    @Resource
    ThreadPoolExecutor threadPoolExecutor;

    public void before(TaskMsg taskMsg) {
        log.info("=========\u5f00\u59cb\u5408\u5355\u8f6c\u8fd0\u68c0\u67e5\u4efb\u52a1==========");
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictQueryApi.queryByGroupCodeAndCode("COMMON_CONFIG", "COMBINATION_ORDER_DELAY_CONFIGURATION"));
            log.info("\u83b7\u53d6\u5408\u5355\u65f6\u95f4\u7b49\u5f85\u914d\u7f6e: {}", (Object)LogUtils.buildLogContent((Object)dictDto));
            Integer waitMinutes = 60;
            if (null != dictDto) {
                waitMinutes = Integer.valueOf(dictDto.getValue());
            }
            log.info("\u83b7\u53d6\u5408\u5355\u65f6\u95f4\u7b49\u5f85\u914d\u7f6e\u65f6\u95f4: {}", (Object)waitMinutes);
            List mergeNoticeTransferDtos = (List)RestResponseHelper.extractData((RestResponse)this.mergeNoticeTransferApi.queryWaitMergeList());
            log.info("\u67e5\u8be2\u5f85\u5408\u5355\u4fe1\u606f: {}", (Object)LogUtils.buildLogContent((Collection)mergeNoticeTransferDtos));
            if (CollectionUtils.isEmpty((Collection)mergeNoticeTransferDtos)) {
                return true;
            }
            Long nowTime = new Date().getTime();
            Long waitSeconds = (long)(waitMinutes * 60) * 1000L;
            for (MergeNoticeTransferDto mergeNoticeTransferDto : mergeNoticeTransferDtos) {
                if (nowTime - waitSeconds <= mergeNoticeTransferDto.getCreateTime().getTime()) continue;
                this.threadPoolExecutor.execute(() -> this.mergeNoticeTransferApi.doMerge(mergeNoticeTransferDto.getMergeNo()));
            }
        }
        catch (Exception e) {
            log.error("\u5f00\u59cb\u5408\u5355\u8f6c\u8fd0\u68c0\u67e5\u4efb\u52a1\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        log.info("=========\u7ed3\u675f\u5408\u5355\u8f6c\u8fd0\u68c0\u67e5\u4efb\u52a1==========");
    }
}

