/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.utils;

import cn.hutool.core.util.ObjectUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrUtils {
    private static final Logger log = LoggerFactory.getLogger(QrUtils.class);
    private static final int CODE_WIDTH = 200;
    private static final int CODE_HEIGHT = 200;
    private static final int FRONT_COLOR = 0;
    private static final int BACKGROUND_COLOR = 0xFFFFFF;

    public static byte[] createCodeToByte(String content, Integer width, Integer height) {
        try {
            log.info("\u751f\u6210\u4e8c\u7ef4\u7801\uff0c\u8fd4\u56de\u5b57\u8282\u6570\uff1a{}", (Object)content);
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            BufferedImage bufferedImage = QrUtils.getBufferedImage(content, width, height);
            ImageIO.write((RenderedImage)bufferedImage, "png", byteOutput);
            return byteOutput.toByteArray();
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u4e8c\u7ef4\u7801\u5f02\u5e38\uff1a{}", (Object)content);
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void createCodeToFile(String content, File codeImgFileSaveDir, String fileName) {
        try {
            if (StringUtils.isBlank((CharSequence)content) || StringUtils.isBlank((CharSequence)fileName)) {
                return;
            }
            content = content.trim();
            if (codeImgFileSaveDir == null || codeImgFileSaveDir.isFile()) {
                codeImgFileSaveDir = FileSystemView.getFileSystemView().getHomeDirectory();
            }
            if (!codeImgFileSaveDir.exists()) {
                codeImgFileSaveDir.mkdirs();
            }
            BufferedImage bufferedImage = QrUtils.getBufferedImage(content, null, null);
            File codeImgFile = new File(codeImgFileSaveDir, fileName);
            ImageIO.write((RenderedImage)bufferedImage, "png", codeImgFile);
            log.info("\u4e8c\u7ef4\u7801\u56fe\u7247\u751f\u6210\u6210\u529f\uff1a" + codeImgFile.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createCodeToOutputStream(String content, OutputStream outputStream) {
        try {
            if (StringUtils.isBlank((CharSequence)content)) {
                return;
            }
            content = content.trim();
            BufferedImage bufferedImage = QrUtils.getBufferedImage(content, null, null);
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
            log.info("\u4e8c\u7ef4\u7801\u56fe\u7247\u751f\u6210\u5230\u8f93\u51fa\u6d41\u6210\u529f...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static BufferedImage getBufferedImage(String content, Integer width, Integer height) throws WriterException {
        if (ObjectUtil.isEmpty((Object)width) || width == 0) {
            width = 200;
        }
        if (ObjectUtil.isEmpty((Object)height) || height == 0) {
            height = 200;
        }
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        hints.put(EncodeHintType.MARGIN, 1);
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        BitMatrix bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, width.intValue(), height.intValue(), hints);
        BufferedImage bufferedImage = new BufferedImage(width, height, 4);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                bufferedImage.setRGB(x, y, bitMatrix.get(x, y) ? 0 : 0xFFFFFF);
            }
        }
        return bufferedImage;
    }
}

