/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.AddProductOrderParams;
import com.dtyunxi.cis.pms.biz.model.AssociatedDocumentVO;
import com.dtyunxi.cis.pms.biz.model.AuditVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportProductRepairVo;
import com.dtyunxi.cis.pms.biz.model.FinishedGoodsInventoryGoodsVO;
import com.dtyunxi.cis.pms.biz.model.GetProductOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.ProductOrderVO;
import com.dtyunxi.cis.pms.biz.model.RepairProductOrderVO;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryProductRepairService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.search.api.dto.request.InPlannedOrderPageParams;
import com.dtyunxi.cis.search.api.dto.response.InPlannedOrderVO;
import com.dtyunxi.cis.search.api.query.inventory.EsPlannedOrderQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.es.ProductOrderLisReq;
import com.dtyunxi.tcbj.api.dto.response.InPlannedOrderStatusCountRespDto;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderOperateEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="abstractFileOperationCommonService_product_repair")
public class FinishedGoodsInventoryProductRepairServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinishedGoodsInventoryProductRepairService {
    @Resource
    private EsPlannedOrderQueryApi esPlannedOrderQueryApi;
    @Resource
    private ICsOutPlannedOrderApi csOutPlannedOrderApi;
    @Resource
    private ICsOutPlannedOrderQueryApi csOutPlannedOrderQueryApi;
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;

    @Override
    public RestResponse<Object> addProductRepair(@ApiParam(value="") @Valid @RequestBody(required=false) AddProductOrderParams addProductOrderParams) {
        CsOutPlannedOrderGenerateReqDto reqDto = new CsOutPlannedOrderGenerateReqDto();
        BeanUtils.copyProperties((Object)addProductOrderParams, (Object)reqDto);
        this.getAddProductRepair(addProductOrderParams, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.generateRetreatOrder(reqDto)));
    }

    private void getAddProductRepair(AddProductOrderParams addProductOrderParams, CsOutPlannedOrderGenerateReqDto reqDto) {
        Integer submitType = addProductOrderParams.getSubmitType();
        reqDto.setOperateFlag(CsPlannedOrderOperateEnum.DRAFT.getCode());
        if (YesOrNoEnum.YES.getCode().equals(submitType)) {
            reqDto.setOperateFlag(CsPlannedOrderOperateEnum.SUBMIT.getCode());
        }
        reqDto.setOrderType(CsPlannedOrderTypeEnum.PRODUCT_REPAIR.getCode());
        reqDto.setBusinessType(CsPlannedOrderBusinessTypeEnum.PRODUCT_REPAIR.getCode());
        reqDto.setWarehouseCode(addProductOrderParams.getReceiveLogicalWarehouseCode());
        reqDto.setWarehouseName(addProductOrderParams.getReceiveLogicalWarehouseName());
        reqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
        reqDto.setRemark(addProductOrderParams.getRemark());
        reqDto.setEstimatedTime(StringUtils.isNotBlank((CharSequence)addProductOrderParams.getArrivalTime()) ? DateUtil.parse((String)addProductOrderParams.getArrivalTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
        List<FinishedGoodsInventoryGoodsVO> goodsList = addProductOrderParams.getGoodsList();
        List list = goodsList.stream().map(o -> {
            CsOutPlannedOrderGenerateDetailReqDto dto = new CsOutPlannedOrderGenerateDetailReqDto();
            BeanUtils.copyProperties((Object)o, (Object)dto);
            dto.setLongCode(o.getGoodsLongCode());
            dto.setBatch(o.getBatchNo());
            dto.setCargoName(o.getGoodsName());
            dto.setCargoCode(o.getGoodsCode());
            dto.setCargoId(ParamConverter.convertToLong((Object)o.getGoodsId()));
            if (StringUtils.isNotBlank((CharSequence)o.getEffectiveTime())) {
                dto.setProduceTime(DateUtil.parse((String)o.getEffectiveTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (StringUtils.isNotBlank((CharSequence)o.getInvalidTime())) {
                dto.setExpireTime(DateUtil.parse((String)o.getInvalidTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            dto.setPlanQuantity(ParamConverter.convertToBigDecimal((Object)o.getPlanQuantity()));
            return dto;
        }).collect(Collectors.toList());
        reqDto.setItemDetailList(list);
    }

    @Override
    public RestResponse<ProductOrderVO> getProductRepairDetail(@NotNull @ApiParam(value="\u5355\u636e\u7f16\u53f7", required=true) @Valid @RequestParam(value="bussinessOrderNo", required=true) String bussinessOrderNo) {
        List<AssociatedDocumentVO> list;
        List relOrderInfoList;
        CsOutPlannedOrderDetailQueryInfoRespDto respDto = (CsOutPlannedOrderDetailQueryInfoRespDto)RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderQueryApi.queryDetailByOrderNo(bussinessOrderNo));
        ProductOrderVO vo = new ProductOrderVO();
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setBussinessOrderNo(respDto.getOrderNo());
        vo.setBussinessOrderType(respDto.getOrderType());
        vo.setBussinessOrderStatus(respDto.getOrderStatus());
        vo.setExternalOrderNo(respDto.getPlatformOrderNo());
        vo.setDeliveryWarehouseCode(respDto.getDeliveryWarehouseCode());
        vo.setDeliveryWarehouseName(respDto.getDeliveryWarehouseName());
        vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        if (respDto.getCreateTime() != null) {
            vo.setArrivalTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(relOrderInfoList = respDto.getRelOrderInfoList()))) {
            list = relOrderInfoList.stream().map(o -> {
                AssociatedDocumentVO associatedDocumentVO = new AssociatedDocumentVO();
                BeanUtils.copyProperties((Object)o, (Object)associatedDocumentVO);
                if (o.getCreateTime() != null) {
                    associatedDocumentVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                return associatedDocumentVO;
            }).collect(Collectors.toList());
            vo.setAssociatedDocumentList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)respDto.getAuditRespDtoList())) {
            list = respDto.getAuditRespDtoList().stream().map(o -> {
                AuditVO auditVO = new AuditVO();
                BeanUtils.copyProperties((Object)o, (Object)auditVO);
                auditVO.setAuditResult(o.getAuditResult());
                auditVO.setAuditReason(o.getRemark());
                if (o.getCreateTime() != null) {
                    auditVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                vo.setAuditRemark(o.getRemark());
                return auditVO;
            }).collect(Collectors.toList());
            vo.setAuditRecordList(list);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<ProductOrderVO>> getProductRepairListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetProductOrderListPageParams getProductOrderListPageParams) {
        PageInfo pageInfo = new PageInfo();
        PageInfo respDtoPageInfo = new PageInfo();
        ArrayList repairProductOrderVOList = new ArrayList();
        if (!this.esQuery.booleanValue()) {
            ProductOrderLisReq req = new ProductOrderLisReq();
            BeanUtils.copyProperties((Object)getProductOrderListPageParams, (Object)req);
            req.setReceiveLogicalWarehouseCode(getProductOrderListPageParams.getDeliveryWarehouseCode());
            req.setReceiveLogicalWarehouseName(getProductOrderListPageParams.getDeliveryWarehouseName());
            req.setOrderType(CsPlannedOrderTypeEnum.PRODUCT_REPAIR.getCode());
            PageInfo purchaseOrderVOPageInfo = (PageInfo)this.inventoryEsReportQueryApi.queryProductOrderListPage(req).getData();
            if (CollectionUtils.isEmpty((Collection)purchaseOrderVOPageInfo.getList())) {
                return new RestResponse();
            }
            CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)purchaseOrderVOPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList list = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)list, (Collection)purchaseOrderVOPageInfo.getList(), InPlannedOrderVO.class);
            CubeBeanUtils.copyCollection(repairProductOrderVOList, (Collection)purchaseOrderVOPageInfo.getList(), RepairProductOrderVO.class);
            respDtoPageInfo.setList((List)list);
        } else {
            InPlannedOrderPageParams params = new InPlannedOrderPageParams();
            BeanUtils.copyProperties((Object)getProductOrderListPageParams, (Object)params);
            params.setOrderNo(getProductOrderListPageParams.getBussinessOrderNo());
            params.setOrdeType(CsPlannedOrderTypeEnum.PRODUCT_REPAIR.getCode());
            params.setWarehouseCode(getProductOrderListPageParams.getDeliveryWarehouseCode());
            params.setWarehouseName(getProductOrderListPageParams.getDeliveryWarehouseName());
            params.setOrderStatus(getProductOrderListPageParams.getBussinessOrderStatus());
            respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esPlannedOrderQueryApi.queryInPlannedOrderPage(params));
            if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
                return new RestResponse((Object)pageInfo);
            }
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        AtomicInteger i = new AtomicInteger();
        List list = respDtoPageInfo.getList().stream().map(o -> {
            ProductOrderVO vo = new ProductOrderVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setLongCode(o.getCargoCode());
            vo.setBussinessOrderNo(o.getOrderNo());
            vo.setBussinessOrderType(o.getBusinessType());
            vo.setBussinessOrderStatus(o.getOrderStatus());
            vo.setExternalOrderNo(o.getPlatformOrderNo());
            vo.setTotalNum(BigDecimalUtils.check((BigDecimal)o.getTotalQuantity()).intValue());
            vo.setReceiveLogicalWarehouseCode(o.getReceiveWarehouseCode());
            vo.setReceiveLogicalWarehouseName(o.getReceiveWarehouseName());
            vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            RepairProductOrderVO repairProductOrderVO = (RepairProductOrderVO)repairProductOrderVOList.get(i.getAndIncrement());
            vo.setDeliveryWarehouseId(repairProductOrderVO.getDeliveryWarehouseId());
            vo.setDeliveryWarehouseName(repairProductOrderVO.getDeliveryWarehouseName());
            vo.setDeliveryWarehouseCode(repairProductOrderVO.getDeliveryWarehouseCode());
            vo.setPlanQuantity(repairProductOrderVO.getPlanQuantity());
            vo.setDoneOutQuantity(repairProductOrderVO.getDoneOutQuantity());
            vo.setDoneQuantity(repairProductOrderVO.getDoneQuantity());
            vo.setWaitQuantity(repairProductOrderVO.getWaitQuantity());
            vo.setRemark(repairProductOrderVO.getRemark());
            vo.setOutPhysicsWarehouseCode(repairProductOrderVO.getOutPhysicsWarehouseCode());
            vo.setOutPhysicsWarehouseName(repairProductOrderVO.getOutPhysicsWarehouseName());
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<InPlannedOrderStatusCountRespDto>> productRepariOrderStatusCount(@Valid GetProductOrderListPageParams getProductOrderListPageParams) {
        ProductOrderLisReq req = new ProductOrderLisReq();
        BeanUtils.copyProperties((Object)getProductOrderListPageParams, (Object)req);
        req.setReceiveLogicalWarehouseCode(getProductOrderListPageParams.getDeliveryWarehouseCode());
        req.setReceiveLogicalWarehouseName(getProductOrderListPageParams.getDeliveryWarehouseName());
        req.setOrderType(CsPlannedOrderTypeEnum.PRODUCT_REPAIR.getCode());
        return this.inventoryEsReportQueryApi.productOrderStatusCount(req);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetProductOrderListPageParams params = new GetProductOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetProductOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetProductOrderListPageParams.class);
        }
        params.setPageSize(commonReqDto.getPageSize());
        params.setPageNum(commonReqDto.getPageNum());
        RestResponse<PageInfo<ProductOrderVO>> pageInfoRestResponse = this.getProductRepairListPage(params);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(p -> {
                ExportProductRepairVo vo = new ExportProductRepairVo();
                CubeBeanUtils.copyProperties((Object)((Object)vo), (Object)p, (String[])new String[0]);
                vo.setBussinessOrderStatus(Optional.ofNullable(p.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status -> {
                    switch (Status) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "wait_in": {
                            return "\u5f85\u5165\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "portion_in": {
                            return "\u90e8\u5206\u5165\u5e93";
                        }
                        case "completed": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "cancel": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return p.getBussinessOrderStatus();
                }).orElse(""));
                vo.setBussinessOrderType("\u751f\u4ea7\u8fd4\u4fee");
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetProductOrderListPageParams params = new GetProductOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetProductOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetProductOrderListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getProductRepairListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public RestResponse<Object> updateProductRepair(@ApiParam(value="") @Valid @RequestBody(required=false) AddProductOrderParams addProductOrderParams) {
        CsOutPlannedOrderGenerateReqDto reqDto = new CsOutPlannedOrderGenerateReqDto();
        BeanUtils.copyProperties((Object)addProductOrderParams, (Object)reqDto);
        reqDto.setOrderNo(addProductOrderParams.getBussinessOrderNo());
        this.getAddProductRepair(addProductOrderParams, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.editRetreatOrder(reqDto)));
    }
}

