/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.aop.OptLogAspect;
import com.dtyunxi.cis.pms.biz.enums.FinishedGoodsInventoryTypeEnum;
import com.dtyunxi.cis.pms.biz.fetch.FetchDataService;
import com.dtyunxi.cis.pms.biz.model.CustomerImportFile;
import com.dtyunxi.cis.pms.biz.model.CustomerImportFileResultVO;
import com.dtyunxi.cis.pms.biz.model.CustomerVO;
import com.dtyunxi.cis.pms.biz.model.FinishedGoodsInventoryGoodsVO;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportCheckGoodsDto;
import com.dtyunxi.cis.pms.biz.model.ImportCheckGoodsMsgDto;
import com.dtyunxi.cis.pms.biz.model.ImportCustomerCodeMsgVo;
import com.dtyunxi.cis.pms.biz.model.ImportCustomerDto;
import com.dtyunxi.cis.pms.biz.model.ImportItemBlackBatchEndDto;
import com.dtyunxi.cis.pms.biz.model.ImportItemBlackBatchEndMsgVo;
import com.dtyunxi.cis.pms.biz.model.ImportItemBlackBatchNoDto;
import com.dtyunxi.cis.pms.biz.model.ImportItemBlackBatchNoMsgVo;
import com.dtyunxi.cis.pms.biz.model.ImportOtherInGoodDto;
import com.dtyunxi.cis.pms.biz.model.ImportOtherInGoodMsgVo;
import com.dtyunxi.cis.pms.biz.model.ImportOtherOutGoodDto;
import com.dtyunxi.cis.pms.biz.model.ImportOtherOutGoodMsgVo;
import com.dtyunxi.cis.pms.biz.model.ImportSaleOrderNoDto;
import com.dtyunxi.cis.pms.biz.model.ImportTranserOrderGoodDto;
import com.dtyunxi.cis.pms.biz.model.ImportTranserOrderGoodMsgDto;
import com.dtyunxi.cis.pms.biz.model.InventoryCheckImportFileResultVO;
import com.dtyunxi.cis.pms.biz.model.InventoryCheckImportGoodsParams;
import com.dtyunxi.cis.pms.biz.model.ItemBlackImportFileResultVO;
import com.dtyunxi.cis.pms.biz.model.ItemBlacklistImportBatchMsgVo;
import com.dtyunxi.cis.pms.biz.model.ItemBlacklistImportBatchVo;
import com.dtyunxi.cis.pms.biz.model.ItemBlacklistImportEndMsgVo;
import com.dtyunxi.cis.pms.biz.model.ItemBlacklistImportEndVo;
import com.dtyunxi.cis.pms.biz.model.ItemBlacklistImportVo;
import com.dtyunxi.cis.pms.biz.model.OtherInGoodsVO;
import com.dtyunxi.cis.pms.biz.model.OtherInImportFileResultVO;
import com.dtyunxi.cis.pms.biz.model.OtherInImportGoodsParams;
import com.dtyunxi.cis.pms.biz.model.OtherOutGoodsVO;
import com.dtyunxi.cis.pms.biz.model.OtherOutImportFileResultVO;
import com.dtyunxi.cis.pms.biz.model.OtherOutImportGoodsParams;
import com.dtyunxi.cis.pms.biz.model.SaleOrderNoImportFile;
import com.dtyunxi.cis.pms.biz.model.SaleOrderNoImportFileResultVO;
import com.dtyunxi.cis.pms.biz.model.SourceItemBlackImportFileResultVO;
import com.dtyunxi.cis.pms.biz.model.SourceItemBlackVO;
import com.dtyunxi.cis.pms.biz.model.TransferOrderGoodsVO;
import com.dtyunxi.cis.pms.biz.model.TransferOrderImportFileResultVO;
import com.dtyunxi.cis.pms.biz.model.TransferOrderImportGoodsParams;
import com.dtyunxi.cis.pms.biz.service.ImportCenterSynchronousService;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.center.source.api.constant.SourceItemBlackTypeEnum;
import com.dtyunxi.cube.center.source.api.dto.response.ClueItemBlackListCityDto;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.tcbj.api.query.IPCPCustomerQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.PcpRegionReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IPcpRegionQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryTotalQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTotalQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpItemQueryDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class ImportCenterSynchronousServiceServiceImpl
implements ImportCenterSynchronousService {
    private static final Logger logger = LoggerFactory.getLogger(OptLogAspect.class);
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private ICsLogicInventoryQueryApi csLogicInventoryQueryApi;
    @Resource
    private ICsLogicInventoryTotalQueryApi csLogicInventoryTotalQueryApi;
    @Resource
    private IPCPCustomerQueryApi customerQueryApi;
    @Resource
    private IContext iContext;
    @Resource
    private IPcpRegionQueryApi pcpRegionQueryApi;
    private static final String regex_split_str = ";|\uff1b|\uff0c|,";
    private static final String batch_regex = "^[A-Za-z0-9_.,\uff0c;\uff1b-]+$";

    @Override
    public RestResponse<CustomerImportFileResultVO> customerImportFile(@ApiParam(value="") @Valid @RequestBody(required=false) CustomerImportFile customerImportFile) {
        EasyPoiExportUtil.checkFileInfo(customerImportFile.getImportFileUrl());
        Integer headRow = 0;
        InputStream inputStream = ExcelUtils.getInputStream(customerImportFile.getImportFileUrl());
        EasyPoiExportUtil.checkExcelHeader(inputStream, ImportCustomerDto.class, (int)headRow);
        ExcelImportResult<ImportBaseModeDto> result = null;
        try {
            result = EasyPoiExportUtil.handlerExcelDataResult(ImportCustomerDto.class, customerImportFile.getImportFileUrl(), (Integer)1);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
        }
        this.checkParam(result);
        CustomerImportFileResultVO resultVO = new CustomerImportFileResultVO();
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportCustomerDto.class);
        List customerCodeList = list.stream().map(ImportCustomerDto::getCustomerCode).collect(Collectors.toList());
        PCPCustomerSearchReqDto customerSearchReqDto = new PCPCustomerSearchReqDto();
        customerSearchReqDto.setCodeInList(customerCodeList);
        List pcpCustomerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryPCPCustomerDetail(customerSearchReqDto));
        Map customerRespDtoMap = pcpCustomerRespDtos.stream().collect(Collectors.toMap(PCPCustomerRespDto::getCustomerCode, Function.identity(), (k1, k3) -> k1));
        ArrayList msgList = Lists.newArrayList();
        ArrayList customerVOList = Lists.newArrayList();
        HashSet customerCodeSet = new HashSet();
        list.forEach(o -> {
            String customerCode = o.getCustomerCode();
            ImportCustomerCodeMsgVo msgVo = new ImportCustomerCodeMsgVo();
            BeanUtils.copyProperties((Object)o, (Object)((Object)msgVo));
            if (customerCodeSet.contains(customerCode)) {
                msgVo.setMsg("\u6570\u636e\u91cd\u590d");
            } else {
                customerCodeSet.add(customerCode);
            }
            CustomerVO customerVO = new CustomerVO();
            this.checkInCustomer(customerRespDtoMap, (ImportCustomerDto)((Object)o), customerCode, msgVo, customerVO);
            if (StringUtils.isNotBlank((CharSequence)msgVo.getMsg())) {
                msgList.add(msgVo);
            } else {
                customerVO.setCreatePerson(this.iContext.userName());
                customerVO.setCreateTime(DateUtils.format((Date)new Date()));
                customerVOList.add(customerVO);
            }
        });
        String errorMsgUrl = null;
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = "\u5ba2\u6237\u5bfc\u5165\u9519\u8bef\u4fe1\u606f";
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportCustomerCodeMsgVo.class, null, excelName);
        }
        resultVO.setList(customerVOList);
        resultVO.setErrorFileUrl(errorMsgUrl);
        return new RestResponse((Object)resultVO);
    }

    private void checkInCustomer(Map<String, PCPCustomerRespDto> customerRespDtoMap, ImportCustomerDto o, String customerCode, ImportCustomerCodeMsgVo msgVo, CustomerVO customerVO) {
        if (CollectionUtil.isNotEmpty(customerRespDtoMap) && customerRespDtoMap.containsKey(o.getCustomerCode())) {
            PCPCustomerRespDto pcpCustomerRespDto = customerRespDtoMap.get(customerCode);
            BeanUtils.copyProperties((Object)pcpCustomerRespDto, (Object)customerVO);
        } else if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
            msgVo.setMsg("\u5ba2\u6237\u4e0d\u5b58\u5728");
        } else {
            msgVo.setMsg(msgVo.getMsg() + ";\u5ba2\u6237\u4e0d\u5b58\u5728");
        }
    }

    @Override
    public RestResponse<InventoryCheckImportFileResultVO> importGoodsOfInventoryCheck(@ApiParam(value="") @Valid @RequestBody(required=false) InventoryCheckImportGoodsParams inventoryCheckImportGoodsParams) {
        EasyPoiExportUtil.checkFileInfo(inventoryCheckImportGoodsParams.getImportFileUrl());
        Integer headRow = 0;
        InputStream inputStream = ExcelUtils.getInputStream(inventoryCheckImportGoodsParams.getImportFileUrl());
        EasyPoiExportUtil.checkExcelHeader(inputStream, ImportCheckGoodsDto.class, (int)headRow);
        ExcelImportResult<ImportBaseModeDto> result = null;
        try {
            result = EasyPoiExportUtil.handlerExcelDataResult(ImportCheckGoodsDto.class, inventoryCheckImportGoodsParams.getImportFileUrl(), (Integer)1);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
        }
        this.checkParam(result);
        InventoryCheckImportFileResultVO resultVO = new InventoryCheckImportFileResultVO();
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportCheckGoodsDto.class);
        HashMap dataMap = Maps.newHashMap();
        HashSet set = Sets.newHashSet();
        list.forEach(o -> {
            o.setLongCode(o.getLongCode().replace(" ", ""));
            o.setBatch(o.getBatch().replace(" ", ""));
            o.setDifferencesNum(o.getDifferencesNum().replace(" ", ""));
            String Code = o.getLongCode() + inventoryCheckImportGoodsParams.getWarehouseCode() + o.getBatch();
            if (dataMap.containsKey(Code)) {
                set.add(Code);
            } else {
                dataMap.put(Code, o);
            }
        });
        HashMap<String, CsLogicInventoryRespDto> itemRespDtoMap = new HashMap<String, CsLogicInventoryRespDto>();
        HashMap<String, CsLogicInventoryRespDto> itemRespDtoCodeMap = new HashMap<String, CsLogicInventoryRespDto>();
        this.getStringCsLogicInventoryRespDtoMap(inventoryCheckImportGoodsParams, list, itemRespDtoMap, itemRespDtoCodeMap);
        ArrayList msgList = Lists.newArrayList();
        ArrayList goodsList = Lists.newArrayList();
        list.forEach(o -> {
            String Code = o.getLongCode() + o.getBatch() + inventoryCheckImportGoodsParams.getWarehouseCode();
            ImportCheckGoodsMsgDto msgVo = new ImportCheckGoodsMsgDto();
            BeanUtils.copyProperties((Object)o, (Object)((Object)msgVo));
            this.extracted(set, (Map<String, CsLogicInventoryRespDto>)itemRespDtoMap, (ImportCheckGoodsDto)((Object)o), Code, msgVo);
            FinishedGoodsInventoryGoodsVO goodsVO = new FinishedGoodsInventoryGoodsVO();
            this.checkCheckOrderGoods((Map<String, CsLogicInventoryRespDto>)itemRespDtoCodeMap, (Map<String, CsLogicInventoryRespDto>)itemRespDtoMap, (ImportCheckGoodsDto)((Object)o), Code, msgVo, goodsVO, inventoryCheckImportGoodsParams);
            if (StringUtils.isNotBlank((CharSequence)msgVo.getMsg())) {
                msgList.add(msgVo);
            } else {
                goodsList.add(goodsVO);
            }
        });
        String errorMsgUrl = null;
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = "\u76d8\u70b9\u5355\u5546\u54c1\u5bfc\u5165\u9519\u8bef\u4fe1\u606f";
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportCheckGoodsMsgDto.class, null, excelName);
        }
        resultVO.setList(goodsList);
        resultVO.setErrorFileUrl(errorMsgUrl);
        return new RestResponse((Object)resultVO);
    }

    private void extracted(HashSet<String> set, Map<String, CsLogicInventoryRespDto> itemRespDtoMap, ImportCheckGoodsDto o, String code, ImportCheckGoodsMsgDto msgVo) {
        if (set.contains(code)) {
            msgVo.setMsg("\u6570\u636e\u91cd\u590d");
        }
        Date productionTime = new Date();
        Date overdueTime = new Date();
        if (o.getProductionTime() != null) {
            try {
                productionTime = DateUtils.parseDate((String)o.getProductionTime(), (String)"yyyy/MM/dd");
            }
            catch (ParseException e) {
                e.printStackTrace();
                msgVo.setMsg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u751f\u4ea7\u65e5\u671f");
            }
        }
        if (o.getOverdueTime() != null) {
            try {
                overdueTime = DateUtils.parseDate((String)o.getOverdueTime(), (String)"yyyy/MM/dd");
            }
            catch (ParseException e) {
                e.printStackTrace();
                msgVo.setMsg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5230\u671f\u65e5\u671f");
            }
        }
        if (productionTime != null && overdueTime != null && overdueTime.before(productionTime)) {
            msgVo.setMsg("\u5230\u671f\u65e5\u671f\u4e0d\u53ef\u65e9\u4e8e\u751f\u4ea7\u65e5\u671f");
        }
        if (!Pattern.matches("^[a-zA-Z0-9]+$", o.getBatch())) {
            msgVo.setMsg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6279\u6b21");
        }
    }

    private void getStringCsLogicInventoryRespDtoMap(@RequestBody(required=false) @ApiParam(value="") @Valid InventoryCheckImportGoodsParams inventoryCheckImportGoodsParams, List<ImportCheckGoodsDto> list, Map<String, CsLogicInventoryRespDto> map, Map<String, CsLogicInventoryRespDto> map2) {
        List longCodes = list.stream().map(ImportCheckGoodsDto::getLongCode).collect(Collectors.toList());
        List batch = list.stream().map(ImportCheckGoodsDto::getBatch).collect(Collectors.toList());
        CsLogicInventoryQueryDto csLogicInventoryQueryDto = new CsLogicInventoryQueryDto();
        csLogicInventoryQueryDto.setWarehouseCode(inventoryCheckImportGoodsParams.getWarehouseCode());
        csLogicInventoryQueryDto.setLongCodes(longCodes);
        FetchDataService invenFetch = req -> (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryQueryApi.queryByPage(req));
        List csLogicInventoryRespDto = invenFetch.fetchAll(csLogicInventoryQueryDto);
        csLogicInventoryRespDto.forEach(info -> {
            map.put(info.getLongCode() + info.getBatch() + inventoryCheckImportGoodsParams.getWarehouseCode(), (CsLogicInventoryRespDto)info);
            map2.put(info.getLongCode(), (CsLogicInventoryRespDto)info);
        });
    }

    private void checkCheckOrderGoods(Map<String, CsLogicInventoryRespDto> itemCodeRespDtoMap, Map<String, CsLogicInventoryRespDto> itemRespDtoMap, ImportCheckGoodsDto o, String longCode, ImportCheckGoodsMsgDto msgVo, FinishedGoodsInventoryGoodsVO goodsVO, InventoryCheckImportGoodsParams inventoryCheckImportGoodsParams) {
        PcpItemQueryDto pcpItemQueryDto = new PcpItemQueryDto();
        pcpItemQueryDto.setLongCode(o.getLongCode());
        pcpItemQueryDto.setPageNum(Integer.valueOf(1));
        pcpItemQueryDto.setPageSize(Integer.valueOf(1));
        List pcpItemRespDtos = ((PageInfo)this.pcpItemQueryApi.queryByPage(pcpItemQueryDto).getData()).getList();
        if (CollectionUtil.isEmpty((Collection)pcpItemRespDtos)) {
            if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
                msgVo.setMsg("\u8c03\u51fa\u4ed3\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
            } else {
                msgVo.setMsg(msgVo.getMsg() + ";\u8c03\u51fa\u4ed3\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
            }
        } else {
            CsLogicInventoryRespDto csLogicInventoryRespDto = itemRespDtoMap.get(longCode);
            CsLogicInventoryRespDto csLogicInventoryCodeRespDto = itemCodeRespDtoMap.get(o.getLongCode());
            if (csLogicInventoryRespDto != null) {
                this.extracted(itemRespDtoMap, o, goodsVO, csLogicInventoryRespDto);
            } else if (csLogicInventoryCodeRespDto != null) {
                BeanUtils.copyProperties((Object)((Object)o), (Object)goodsVO);
                goodsVO.setGoodsCode(o.getLongCode());
                goodsVO.setGoodsName(csLogicInventoryCodeRespDto.getCargoName());
                goodsVO.setBatchNo(o.getBatch());
                if (StringUtils.isNotBlank((CharSequence)o.getProductionTime()) && StringUtils.isNotBlank((CharSequence)o.getOverdueTime())) {
                    goodsVO.setAvailableInventory(0);
                } else {
                    goodsVO.setAvailableInventory(csLogicInventoryCodeRespDto.getAvailable().intValue());
                }
                if (StringUtils.isNotBlank((CharSequence)o.getProductionTime())) {
                    goodsVO.setEffectiveTime(o.getProductionTime());
                } else {
                    goodsVO.setEffectiveTime(ParamConverter.convertToString((Object)csLogicInventoryCodeRespDto.getProduceTime()));
                }
                if (StringUtils.isNotBlank((CharSequence)o.getOverdueTime())) {
                    goodsVO.setInvalidTime(o.getOverdueTime());
                } else {
                    goodsVO.setInvalidTime(ParamConverter.convertToString((Object)csLogicInventoryCodeRespDto.getExpireTime()));
                }
                goodsVO.setAdjustedQuantity(ParamConverter.convertToInteger((Object)o.getDifferencesNum()));
                goodsVO.setInventoryType(o.getAdjustType());
            } else if (CollectionUtils.isNotEmpty((Collection)pcpItemRespDtos)) {
                goodsVO.setGoodsCode(o.getLongCode());
                goodsVO.setGoodsName(((PcpItemRespDto)pcpItemRespDtos.get(0)).getName());
                goodsVO.setBatchNo(o.getBatch());
                goodsVO.setAvailableInventory(0);
                if (o.getProductionTime() != null) {
                    goodsVO.setEffectiveTime(o.getProductionTime());
                }
                if (o.getOverdueTime() != null) {
                    goodsVO.setInvalidTime(o.getOverdueTime());
                }
                goodsVO.setAdjustedQuantity(ParamConverter.convertToInteger((Object)o.getDifferencesNum()));
                goodsVO.setInventoryType(o.getAdjustType());
            }
        }
    }

    private void extracted(Map<String, CsLogicInventoryRespDto> itemRespDtoMap, ImportCheckGoodsDto o, FinishedGoodsInventoryGoodsVO goodsVO, CsLogicInventoryRespDto csLogicInventoryRespDto) {
        CsLogicInventoryRespDto csLogicInventoryRespCodeDto = itemRespDtoMap.get(o.getLongCode());
        BeanUtils.copyProperties((Object)((Object)o), (Object)goodsVO);
        goodsVO.setGoodsCode(csLogicInventoryRespDto.getLongCode());
        goodsVO.setGoodsName(csLogicInventoryRespDto.getCargoName());
        goodsVO.setBatchNo(o.getBatch());
        goodsVO.setAvailableInventory(csLogicInventoryRespDto.getAvailable().intValue());
        if (csLogicInventoryRespDto.getProduceTime() != null) {
            goodsVO.setEffectiveTime(ParamConverter.convertToString((Object)DateUtil.format((Date)csLogicInventoryRespDto.getProduceTime(), (String)DatePattern.DATETIME_PATTERN.getPattern())));
        }
        if (csLogicInventoryRespDto.getExpireTime() != null) {
            goodsVO.setInvalidTime(ParamConverter.convertToString((Object)DateUtil.format((Date)csLogicInventoryRespDto.getExpireTime(), (String)DatePattern.DATETIME_PATTERN.getPattern())));
        }
        goodsVO.setAdjustedQuantity(ParamConverter.convertToInteger((Object)o.getDifferencesNum()));
        goodsVO.setInventoryType(o.getAdjustType());
    }

    @Override
    public RestResponse<OtherInImportFileResultVO> importGoodsOfOtherIn(@ApiParam(value="") @Valid @RequestBody(required=false) OtherInImportGoodsParams otherInImportGoodsParams) {
        EasyPoiExportUtil.checkFileInfo(otherInImportGoodsParams.getImportFileUrl());
        Integer headRow = 0;
        InputStream inputStream = ExcelUtils.getInputStream(otherInImportGoodsParams.getImportFileUrl());
        EasyPoiExportUtil.checkExcelHeader(inputStream, ImportOtherInGoodDto.class, (int)headRow);
        ExcelImportResult<ImportBaseModeDto> result = null;
        try {
            result = EasyPoiExportUtil.handlerExcelDataResult(ImportOtherInGoodDto.class, otherInImportGoodsParams.getImportFileUrl(), (Integer)1);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
        }
        this.checkParam(result);
        OtherInImportFileResultVO resultVO = new OtherInImportFileResultVO();
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportOtherInGoodDto.class);
        HashMap dataMap = Maps.newHashMap();
        HashSet longCodeSet = Sets.newHashSet();
        list.forEach(o -> {
            o.setLongCode(o.getLongCode().replace(" ", ""));
            o.setNum(o.getNum().replace(" ", ""));
            String longCode = o.getLongCode();
            if (dataMap.containsKey(longCode)) {
                longCodeSet.add(longCode);
            } else {
                dataMap.put(longCode, o);
            }
        });
        List longCodes = list.stream().map(ImportOtherInGoodDto::getLongCode).collect(Collectors.toList());
        List pcpItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(longCodes));
        Map itemRespDtoMap = pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k3) -> k1));
        ArrayList msgList = Lists.newArrayList();
        ArrayList goodsList = Lists.newArrayList();
        list.forEach(o -> {
            String longCode = o.getLongCode();
            ImportOtherInGoodMsgVo msgVo = new ImportOtherInGoodMsgVo();
            BeanUtils.copyProperties((Object)o, (Object)((Object)msgVo));
            if (longCodeSet.contains(longCode)) {
                msgVo.setMsg("\u6570\u636e\u91cd\u590d");
            }
            OtherInGoodsVO goodsVO = new OtherInGoodsVO();
            this.checkInGoods(itemRespDtoMap, (ImportOtherInGoodDto)((Object)o), longCode, msgVo, goodsVO);
            if (StringUtils.isNotBlank((CharSequence)msgVo.getMsg())) {
                msgList.add(msgVo);
            } else {
                goodsList.add(goodsVO);
            }
        });
        String errorMsgUrl = null;
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = "\u5176\u4ed6\u5165\u5e93\u5355\u5546\u54c1\u5bfc\u5165\u9519\u8bef\u4fe1\u606f";
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportOtherInGoodMsgVo.class, null, excelName);
        }
        resultVO.setList(goodsList);
        resultVO.setErrorFileUrl(errorMsgUrl);
        return new RestResponse((Object)resultVO);
    }

    private void checkInGoods(Map<String, PcpItemRespDto> itemRespDtoMap, ImportOtherInGoodDto o, String longCode, ImportOtherInGoodMsgVo msgVo, OtherInGoodsVO goodsVO) {
        if (CollectionUtil.isNotEmpty(itemRespDtoMap) && itemRespDtoMap.containsKey(o.getLongCode())) {
            PcpItemRespDto pcpItemRespDto = itemRespDtoMap.get(longCode);
            BeanUtils.copyProperties((Object)pcpItemRespDto, (Object)goodsVO);
            goodsVO.setGoodsId(ParamConverter.convertToString((Object)pcpItemRespDto.getId()));
            goodsVO.setGoodsCode(pcpItemRespDto.getCode());
            goodsVO.setGoodsLongCode(pcpItemRespDto.getLongCode());
            goodsVO.setGoodsName(pcpItemRespDto.getName());
            goodsVO.setGoodsSpec(pcpItemRespDto.getSpecification());
            goodsVO.setInQuantity(ParamConverter.convertToBigDecimal((Object)o.getNum()));
        } else if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
            msgVo.setMsg("\u5546\u54c1\u4e0d\u5b58\u5728");
        } else {
            msgVo.setMsg(msgVo.getMsg() + ";\u5546\u54c1\u4e0d\u5b58\u5728");
        }
    }

    private void checkOutGoods(Map<String, PcpItemRespDto> itemRespDtoMap, ImportOtherOutGoodDto o, String longCode, ImportOtherOutGoodMsgVo msgVo, OtherOutGoodsVO goodsVO) {
        if (CollectionUtil.isEmpty(itemRespDtoMap) || !itemRespDtoMap.containsKey(o.getLongCode())) {
            if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
                msgVo.setMsg("\u5546\u54c1\u4e0d\u5b58\u5728");
            } else {
                msgVo.setMsg(msgVo.getMsg() + ";\u5546\u54c1\u4e0d\u5b58\u5728");
            }
        } else {
            PcpItemRespDto pcpItemRespDto = itemRespDtoMap.get(o.getLongCode());
            if (pcpItemRespDto != null) {
                BeanUtils.copyProperties((Object)((Object)o), (Object)goodsVO);
                goodsVO.setGoodsName(pcpItemRespDto.getName());
                goodsVO.setGoodsSpec(pcpItemRespDto.getSpecification());
                goodsVO.setVolume(pcpItemRespDto.getVolume());
                goodsVO.setGoodsId(ParamConverter.convertToString((Object)pcpItemRespDto.getId()));
                goodsVO.setGoodsLongCode(pcpItemRespDto.getLongCode());
                goodsVO.setGoodsCode(pcpItemRespDto.getLongCode());
                goodsVO.setOutQuantity(ParamConverter.convertToBigDecimal((Object)o.getNum()));
            }
        }
    }

    private void checkParam(ExcelImportResult<ImportBaseModeDto> result) {
        if (result.isVerfiyFail()) {
            int index = 1;
            result.getFailList().forEach(l -> {
                throw new BizException(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", l.getRowNum() + index, l.getErrorMsg()));
            });
        }
        if (CollectionUtils.isEmpty((Collection)result.getList())) {
            throw new BizException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (result.getList().size() > 2000) {
            throw new BizException("\u6700\u591a\u53ea\u80fd\u5bfc\u51652000\u884c\u6570\u636e");
        }
    }

    @Override
    public RestResponse<OtherOutImportFileResultVO> importGoodsOfOtherOut(@ApiParam(value="") @Valid @RequestBody(required=false) OtherOutImportGoodsParams otherOutImportGoodsParams) {
        EasyPoiExportUtil.checkFileInfo(otherOutImportGoodsParams.getImportFileUrl());
        Integer headRow = 0;
        InputStream inputStream = ExcelUtils.getInputStream(otherOutImportGoodsParams.getImportFileUrl());
        EasyPoiExportUtil.checkExcelHeader(inputStream, ImportOtherOutGoodDto.class, (int)headRow);
        ExcelImportResult<ImportBaseModeDto> result = null;
        try {
            result = EasyPoiExportUtil.handlerExcelDataResult(ImportOtherOutGoodDto.class, otherOutImportGoodsParams.getImportFileUrl(), (Integer)1);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
        }
        this.checkParam(result);
        OtherOutImportFileResultVO resultVO = new OtherOutImportFileResultVO();
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportOtherOutGoodDto.class);
        HashMap dataMap = Maps.newHashMap();
        HashSet longCodeSet = Sets.newHashSet();
        list.forEach(o -> {
            o.setLongCode(o.getLongCode().replace(" ", ""));
            o.setNum(o.getNum().replace(" ", ""));
            String longCode = o.getLongCode();
            if (dataMap.containsKey(longCode)) {
                longCodeSet.add(longCode);
            } else {
                dataMap.put(longCode, o);
            }
        });
        List longCodes = list.stream().map(ImportOtherOutGoodDto::getLongCode).collect(Collectors.toList());
        List pcpItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(longCodes));
        Map itemRespDtoMap = pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k3) -> k1));
        CsInventoryTotalQueryReqDto reqDto = new CsInventoryTotalQueryReqDto();
        reqDto.setLongCodeList(longCodes);
        Integer pageSize = 100;
        if (longCodes.size() > pageSize) {
            pageSize = longCodes.size();
        }
        ArrayList msgList = Lists.newArrayList();
        ArrayList goodsList = Lists.newArrayList();
        list.forEach(o -> {
            String longCode = o.getLongCode();
            ImportOtherOutGoodMsgVo msgVo = new ImportOtherOutGoodMsgVo();
            BeanUtils.copyProperties((Object)o, (Object)((Object)msgVo));
            if (longCodeSet.contains(longCode)) {
                msgVo.setMsg("\u6570\u636e\u91cd\u590d");
            }
            OtherOutGoodsVO goodsVO = new OtherOutGoodsVO();
            this.checkOutGoods(itemRespDtoMap, (ImportOtherOutGoodDto)((Object)o), longCode, msgVo, goodsVO);
            if (StringUtils.isNotBlank((CharSequence)msgVo.getMsg())) {
                msgList.add(msgVo);
            } else {
                goodsList.add(goodsVO);
            }
        });
        String errorMsgUrl = null;
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = "\u5176\u4ed6\u51fa\u5e93\u5355\u5546\u54c1\u5bfc\u5165\u9519\u8bef\u4fe1\u606f";
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportOtherOutGoodMsgVo.class, null, excelName);
        }
        resultVO.setList(goodsList);
        resultVO.setErrorFileUrl(errorMsgUrl);
        return new RestResponse((Object)resultVO);
    }

    private void checkLogicInventoryTotal(Map<String, CsLogicInventoryTotalRespDto> inventoryTotalRespDtoMap, ImportOtherOutGoodDto o, ImportOtherOutGoodMsgVo msgVo, OtherOutGoodsVO outGoodsVO) {
        if (CollectionUtil.isNotEmpty(inventoryTotalRespDtoMap) && inventoryTotalRespDtoMap.containsKey(o.getLongCode())) {
            PcpItemRespDto pcpItemRespDto;
            CsLogicInventoryTotalRespDto logicInventoryTotalRespDto = inventoryTotalRespDtoMap.get(o.getLongCode());
            BeanUtils.copyProperties((Object)((Object)o), (Object)outGoodsVO);
            outGoodsVO.setGoodsId(ParamConverter.convertToString((Object)logicInventoryTotalRespDto.getCargoId()));
            outGoodsVO.setGoodsLongCode(logicInventoryTotalRespDto.getLongCode());
            outGoodsVO.setGoodsCode(logicInventoryTotalRespDto.getCargoCode());
            if (logicInventoryTotalRespDto.getCargoId() != null && (pcpItemRespDto = (PcpItemRespDto)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryByPrimaryKey(logicInventoryTotalRespDto.getCargoId()))) != null) {
                outGoodsVO.setGoodsName(pcpItemRespDto.getName());
                outGoodsVO.setGoodsSpec(pcpItemRespDto.getSpecification());
                outGoodsVO.setVolume(pcpItemRespDto.getVolume());
            }
            outGoodsVO.setOutQuantity(ParamConverter.convertToBigDecimal((Object)o.getNum()));
        } else if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
            msgVo.setMsg("\u5546\u54c1\u4e0d\u5b58\u5728");
        } else {
            msgVo.setMsg(msgVo.getMsg() + ";\u5546\u54c1\u4e0d\u5b58\u5728");
        }
    }

    @Override
    public RestResponse<TransferOrderImportFileResultVO> importGoodsOfTransferOrder(@ApiParam(value="") @Valid @RequestBody(required=false) TransferOrderImportGoodsParams transferOrderImportGoodsParams) {
        List<String> longCodes;
        EasyPoiExportUtil.checkFileInfo(transferOrderImportGoodsParams.getImportFileUrl());
        Integer headRow = 0;
        InputStream inputStream = ExcelUtils.getInputStream(transferOrderImportGoodsParams.getImportFileUrl());
        EasyPoiExportUtil.checkExcelHeader(inputStream, ImportTranserOrderGoodDto.class, (int)headRow);
        ExcelImportResult<ImportBaseModeDto> result = null;
        try {
            result = EasyPoiExportUtil.handlerExcelDataResult(ImportTranserOrderGoodDto.class, transferOrderImportGoodsParams.getImportFileUrl(), (Integer)1);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
        }
        this.checkParam(result);
        TransferOrderImportFileResultVO resultVO = new TransferOrderImportFileResultVO();
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportTranserOrderGoodDto.class);
        HashMap dataMap = Maps.newHashMap();
        HashSet set = Sets.newHashSet();
        String allotType = transferOrderImportGoodsParams.getAllotType();
        int index = 1;
        String firstBatch = ((ImportTranserOrderGoodDto)((Object)list.get(0))).getBatch();
        list.forEach(o -> {
            String Code;
            if (StringUtils.isNotBlank((CharSequence)allotType) && (allotType.equals(FinishedGoodsInventoryTypeEnum.ALLOT_OUT.getCode()) || allotType.equals(FinishedGoodsInventoryTypeEnum.ALLOT_LOGIC_OUT.getCode()) || allotType.equals(FinishedGoodsInventoryTypeEnum.MAIYOU_ALLOT_OUT.getCode())) && StringUtils.isBlank((CharSequence)o.getBatch())) {
                throw new BizException(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", o.getRowNum() + index, "\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (StringUtils.isNotBlank((CharSequence)allotType) && (allotType.equals(FinishedGoodsInventoryTypeEnum.BC_ALLOT.getCode()) || allotType.equals(FinishedGoodsInventoryTypeEnum.MAIYOU_BC_ALLOT.getCode())) && StringUtils.isNotBlank((CharSequence)firstBatch) != StringUtils.isNotBlank((CharSequence)o.getBatch())) {
                throw new BizException(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", o.getRowNum() + index, "\u6279\u6b21\u5217\u548c\u7b2c\u4e00\u884c\u683c\u5f0f\u4e0d\u7edf\u4e00"));
            }
            if (StringUtils.isNotBlank((CharSequence)o.getBatch())) {
                o.setBatch(o.getBatch().replace(" ", ""));
            }
            o.setLongCode(o.getLongCode().replace(" ", ""));
            o.setPlanNum(o.getPlanNum().replace(" ", ""));
            String string = Code = o.getLongCode() + o.getBatch() == null ? "" : o.getBatch() + transferOrderImportGoodsParams.getWarehouseCode();
            if (dataMap.containsKey(Code)) {
                set.add(Code);
            } else {
                dataMap.put(Code, o);
            }
        });
        ArrayList goodsList = Lists.newArrayList();
        ArrayList msgList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)allotType) && (allotType.equals(FinishedGoodsInventoryTypeEnum.ALLOT_OUT.getCode()) || allotType.equals(FinishedGoodsInventoryTypeEnum.ALLOT_LOGIC_OUT.getCode()) || allotType.equals(FinishedGoodsInventoryTypeEnum.MAIYOU_ALLOT_OUT.getCode()))) {
            longCodes = list.stream().map(ImportTranserOrderGoodDto::getLongCode).collect(Collectors.toList());
            Map<String, CsLogicInventoryRespDto> itemRespDtoMap = this.getItemRespDtoMap(transferOrderImportGoodsParams, list, longCodes);
            CsInventoryTotalQueryReqDto reqDto = new CsInventoryTotalQueryReqDto();
            reqDto.setLongCodeList(longCodes);
            Integer pageSize = 100;
            if (longCodes.size() > pageSize) {
                pageSize = longCodes.size();
            }
            list.forEach(o -> {
                String Code = o.getLongCode() + o.getBatch() + transferOrderImportGoodsParams.getWarehouseCode();
                ImportTranserOrderGoodMsgDto msgVo = new ImportTranserOrderGoodMsgDto();
                BeanUtils.copyProperties((Object)o, (Object)((Object)msgVo));
                if (set.contains(Code)) {
                    msgVo.setMsg("\u6570\u636e\u91cd\u590d");
                }
                if (itemRespDtoMap.get(Code) != null && ((CsLogicInventoryRespDto)itemRespDtoMap.get(Code)).getAvailable() != null && new BigDecimal(o.getPlanNum()).intValue() > ((CsLogicInventoryRespDto)itemRespDtoMap.get(Code)).getAvailable().intValue()) {
                    msgVo.setMsg("\u5e93\u5b58\u4e0d\u8db3");
                }
                TransferOrderGoodsVO goodsVO = new TransferOrderGoodsVO();
                this.extractedTranserOrderGoods(itemRespDtoMap, (ImportTranserOrderGoodDto)((Object)o), Code, msgVo, goodsVO, transferOrderImportGoodsParams);
                if (StringUtils.isNotBlank((CharSequence)msgVo.getMsg())) {
                    msgList.add(msgVo);
                } else {
                    goodsList.add(goodsVO);
                }
            });
        } else if (allotType.equals(FinishedGoodsInventoryTypeEnum.BC_ALLOT.getCode()) || allotType.equals(FinishedGoodsInventoryTypeEnum.MAIYOU_BC_ALLOT.getCode())) {
            longCodes = list.stream().map(ImportTranserOrderGoodDto::getLongCode).collect(Collectors.toList());
            List batch = list.stream().map(ImportTranserOrderGoodDto::getBatch).filter(str -> StringUtils.isNotBlank((CharSequence)str)).collect(Collectors.toList());
            CsLogicInventoryQueryDto csLogicInventoryQueryDto = new CsLogicInventoryQueryDto();
            csLogicInventoryQueryDto.setWarehouseCode(transferOrderImportGoodsParams.getWarehouseCode());
            csLogicInventoryQueryDto.setLongCodes(longCodes);
            if (batch.size() > 0) {
                csLogicInventoryQueryDto.setBatchList(batch);
            }
            csLogicInventoryQueryDto.setOrderByDesc("batch");
            FetchDataService invenFetch = req -> (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryQueryApi.queryByPage(req));
            List csLogicInventoryRespDto = invenFetch.fetchAll(csLogicInventoryQueryDto);
            ArrayList reverList = new ArrayList(csLogicInventoryRespDto);
            Collections.reverse(reverList);
            list.forEach(o -> {
                String longCode = o.getLongCode();
                String Code = "";
                Code = StringUtils.isNotBlank((CharSequence)firstBatch) ? o.getLongCode() + o.getBatch() + transferOrderImportGoodsParams.getWarehouseCode() : o.getLongCode() + transferOrderImportGoodsParams.getWarehouseCode();
                ImportTranserOrderGoodMsgDto msgVo = new ImportTranserOrderGoodMsgDto();
                BeanUtils.copyProperties((Object)o, (Object)((Object)msgVo));
                if (set.contains(Code)) {
                    msgVo.setMsg("\u6570\u636e\u91cd\u590d");
                }
                int totalAvailable = 0;
                ArrayList<CsLogicInventoryRespDto> tempNumList = new ArrayList<CsLogicInventoryRespDto>();
                HashMap<String, Integer> useAvailable = new HashMap<String, Integer>();
                for (CsLogicInventoryRespDto inv : reverList) {
                    int available;
                    if (!longCode.equals(inv.getLongCode()) || (available = inv.getAvailable().intValue()) <= 0) continue;
                    if (new BigDecimal(o.getPlanNum()).intValue() >= (totalAvailable += available)) {
                        useAvailable.put(inv.getLongCode() + inv.getBatch(), inv.getAvailable().intValue());
                        tempNumList.add(inv);
                        continue;
                    }
                    int lastAvailable = inv.getAvailable().intValue() - (totalAvailable - new BigDecimal(o.getPlanNum()).intValue());
                    useAvailable.put(inv.getLongCode() + inv.getBatch(), lastAvailable);
                    tempNumList.add(inv);
                    break;
                }
                if (new BigDecimal(o.getPlanNum()).intValue() > totalAvailable) {
                    msgVo.setMsg("\u5e93\u5b58\u4e0d\u8db3");
                }
                if (StringUtils.isNotBlank((CharSequence)msgVo.getMsg())) {
                    msgList.add(msgVo);
                } else {
                    for (CsLogicInventoryRespDto csLogicDto : tempNumList) {
                        TransferOrderGoodsVO goodsVO = new TransferOrderGoodsVO();
                        BeanUtils.copyProperties((Object)o, (Object)goodsVO);
                        goodsVO.setGoodsCode(o.getLongCode());
                        goodsVO.setGoodsName(csLogicDto.getCargoName());
                        goodsVO.setBatchNo(csLogicDto.getBatch());
                        goodsVO.setAvailableInventory(String.valueOf(csLogicDto.getAvailable().intValue()));
                        if (csLogicDto.getProduceTime() != null) {
                            goodsVO.setEffectiveTime(ParamConverter.convertToString((Object)DateUtil.format((Date)csLogicDto.getProduceTime(), (String)DatePattern.DATETIME_PATTERN.getPattern())));
                        }
                        if (csLogicDto.getExpireTime() != null) {
                            goodsVO.setInvalidTime(ParamConverter.convertToString((Object)DateUtil.format((Date)csLogicDto.getExpireTime(), (String)DatePattern.DATETIME_PATTERN.getPattern())));
                        }
                        goodsVO.setPlanQuantity(ParamConverter.convertToBigDecimal(useAvailable.get(csLogicDto.getLongCode() + csLogicDto.getBatch())));
                        goodsList.add(goodsVO);
                    }
                }
            });
        } else {
            List longCodeList = list.stream().map(ImportTranserOrderGoodDto::getLongCode).collect(Collectors.toList());
            RestResponse itemRestResponse = this.pcpItemQueryApi.queryItemByItemLongCodes(longCodeList);
            Map itemRespDtoMap = ((List)itemRestResponse.getData()).stream().collect(Collectors.toMap(t -> t.getLongCode(), Function.identity(), (k1, k3) -> k1));
            list.forEach(o -> {
                String Code = o.getLongCode() + o.getBatch() + transferOrderImportGoodsParams.getWarehouseCode();
                ImportTranserOrderGoodMsgDto msgVo = new ImportTranserOrderGoodMsgDto();
                BeanUtils.copyProperties((Object)o, (Object)((Object)msgVo));
                if (set.contains(Code)) {
                    msgVo.setMsg("\u6570\u636e\u91cd\u590d");
                }
                TransferOrderGoodsVO goodsVO = new TransferOrderGoodsVO();
                goodsVO.setGoodsCode(o.getLongCode());
                if (CollectionUtil.isEmpty((Map)itemRespDtoMap) || !itemRespDtoMap.containsKey(o.getLongCode())) {
                    if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
                        msgVo.setMsg("\u8c03\u51fa\u4ed3\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
                    } else {
                        msgVo.setMsg(msgVo.getMsg() + ";\u8c03\u51fa\u4ed3\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
                    }
                }
                goodsVO.setGoodsName(itemRespDtoMap.get(o.getLongCode()) == null ? "" : ((PcpItemRespDto)itemRespDtoMap.get(o.getLongCode())).getName());
                goodsVO.setPlanQuantity(ParamConverter.convertToBigDecimal((Object)o.getPlanNum()));
                if (StringUtils.isNotBlank((CharSequence)msgVo.getMsg())) {
                    msgList.add(msgVo);
                } else {
                    goodsList.add(goodsVO);
                }
            });
        }
        String errorMsgUrl = null;
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = "\u8c03\u62e8\u5355\u5546\u54c1\u5bfc\u5165\u9519\u8bef\u4fe1\u606f";
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportTranserOrderGoodMsgDto.class, null, excelName);
        }
        resultVO.setList(goodsList);
        resultVO.setErrorFileUrl(errorMsgUrl);
        return new RestResponse((Object)resultVO);
    }

    private Map<String, CsLogicInventoryRespDto> getItemRespDtoMap(TransferOrderImportGoodsParams transferOrderImportGoodsParams, List<ImportTranserOrderGoodDto> list, List<String> longCodes) {
        List batch = list.stream().map(ImportTranserOrderGoodDto::getBatch).filter(str -> StringUtils.isNotBlank((CharSequence)str)).collect(Collectors.toList());
        CsLogicInventoryQueryDto csLogicInventoryQueryDto = new CsLogicInventoryQueryDto();
        csLogicInventoryQueryDto.setWarehouseCode(transferOrderImportGoodsParams.getWarehouseCode());
        csLogicInventoryQueryDto.setLongCodes(longCodes);
        csLogicInventoryQueryDto.setBatchList(batch);
        FetchDataService invenFetch = req -> (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryQueryApi.queryByPage(req));
        List csLogicInventoryRespDto = invenFetch.fetchAll(csLogicInventoryQueryDto);
        Map<String, CsLogicInventoryRespDto> itemRespDtoMap = csLogicInventoryRespDto.stream().collect(Collectors.toMap(t -> t.getLongCode() + t.getBatch() + transferOrderImportGoodsParams.getWarehouseCode(), Function.identity(), (k1, k3) -> k1));
        return itemRespDtoMap;
    }

    private void extractedTranserOrderGoods(Map<String, CsLogicInventoryRespDto> itemRespDtoMap, ImportTranserOrderGoodDto o, String longCode, ImportTranserOrderGoodMsgDto msgVo, TransferOrderGoodsVO goodsVO, TransferOrderImportGoodsParams transferOrderImportGoodsParams) {
        if (CollectionUtil.isEmpty(itemRespDtoMap) || !itemRespDtoMap.containsKey(longCode)) {
            if (StringUtils.isBlank((CharSequence)msgVo.getMsg())) {
                msgVo.setMsg("\u8c03\u51fa\u4ed3\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
            } else {
                msgVo.setMsg(msgVo.getMsg() + ";\u8c03\u51fa\u4ed3\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
            }
        } else {
            CsLogicInventoryRespDto csLogicInventoryRespDto = itemRespDtoMap.get(longCode);
            if (csLogicInventoryRespDto != null) {
                BeanUtils.copyProperties((Object)((Object)o), (Object)goodsVO);
                goodsVO.setGoodsCode(o.getLongCode());
                goodsVO.setGoodsName(csLogicInventoryRespDto.getCargoName());
                goodsVO.setBatchNo(o.getBatch());
                goodsVO.setAvailableInventory(String.valueOf(csLogicInventoryRespDto.getAvailable().intValue()));
                if (csLogicInventoryRespDto.getProduceTime() != null) {
                    goodsVO.setEffectiveTime(ParamConverter.convertToString((Object)DateUtil.format((Date)csLogicInventoryRespDto.getProduceTime(), (String)DatePattern.DATETIME_PATTERN.getPattern())));
                }
                if (csLogicInventoryRespDto.getExpireTime() != null) {
                    goodsVO.setInvalidTime(ParamConverter.convertToString((Object)DateUtil.format((Date)csLogicInventoryRespDto.getExpireTime(), (String)DatePattern.DATETIME_PATTERN.getPattern())));
                }
                goodsVO.setPlanQuantity(ParamConverter.convertToBigDecimal((Object)o.getPlanNum()));
            }
        }
    }

    @Override
    public RestResponse<SaleOrderNoImportFileResultVO> saleOrderNoImportFile(@ApiParam(value="") @Valid @RequestBody(required=false) SaleOrderNoImportFile saleOrderNoImportFile) {
        EasyPoiExportUtil.checkFileInfo(saleOrderNoImportFile.getImportFileUrl());
        Integer headRow = 0;
        InputStream inputStream = ExcelUtils.getInputStream(saleOrderNoImportFile.getImportFileUrl());
        EasyPoiExportUtil.checkExcelHeader(inputStream, ImportSaleOrderNoDto.class, (int)headRow);
        ExcelImportResult<ImportBaseModeDto> result = null;
        try {
            result = EasyPoiExportUtil.handlerExcelDataResult(ImportSaleOrderNoDto.class, saleOrderNoImportFile.getImportFileUrl(), (Integer)1);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
        }
        this.checkParam(result);
        SaleOrderNoImportFileResultVO resultVO = new SaleOrderNoImportFileResultVO();
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportSaleOrderNoDto.class);
        List<String> orderNoList = list.stream().map(ImportSaleOrderNoDto::getOrderCode).collect(Collectors.toList());
        resultVO.setList(orderNoList);
        resultVO.setErrorFileUrl("");
        return new RestResponse((Object)resultVO);
    }

    @Override
    public RestResponse<SourceItemBlackImportFileResultVO> sourceItemBlackImportFile(@ApiParam(value="") @Valid @RequestBody(required=false) CustomerImportFile importFile) {
        String[] split;
        List<String> reivceCityList;
        EasyPoiExportUtil.checkFileInfo(importFile.getImportFileUrl());
        String key = importFile.getKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new BizException("\u4e1a\u52a1key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Integer headRow = 0;
        InputStream inputStream = ExcelUtils.getInputStream(importFile.getImportFileUrl());
        ArrayList list = Lists.newArrayList();
        ExcelImportResult<ImportBaseModeDto> result = null;
        if (Objects.equals(key, SourceItemBlackTypeEnum.BY_BATCH_END.code.toString())) {
            EasyPoiExportUtil.checkExcelHeader(inputStream, ImportItemBlackBatchEndDto.class, (int)headRow);
            try {
                result = EasyPoiExportUtil.handlerExcelDataResult(ImportItemBlackBatchEndDto.class, importFile.getImportFileUrl(), (Integer)1);
            }
            catch (Exception e) {
                throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
            }
        } else if (Objects.equals(key, SourceItemBlackTypeEnum.BY_BATCH_NO.code.toString())) {
            EasyPoiExportUtil.checkExcelHeader(inputStream, ImportItemBlackBatchNoDto.class, (int)headRow);
            try {
                result = EasyPoiExportUtil.handlerExcelDataResult(ImportItemBlackBatchNoDto.class, importFile.getImportFileUrl(), (Integer)1);
            }
            catch (Exception e) {
                throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
            }
        } else {
            throw new BizException("\u4e1a\u52a1key\u4e0d\u6b63\u786e\uff01");
        }
        this.checkParam(result);
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportItemBlackBatchEndDto.class);
        List skuCodeList = list.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getSkuCode())).map(ImportItemBlackBatchEndDto::getSkuCode).distinct().collect(Collectors.toList());
        List pcpItemRespDtos = (List)this.pcpItemQueryApi.queryItemByItemLongCodes(skuCodeList).getData();
        Map<Object, Object> pcpItemMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)pcpItemRespDtos)) {
            pcpItemMap = pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k2) -> k1));
        }
        Map<Object, Object> areaDtoMap = new HashMap();
        String reivceCityCodeStr = list.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getReceiveCity())).map(ImportItemBlackBatchEndDto::getReceiveCity).distinct().collect(Collectors.joining(";"));
        if (StringUtils.isNotBlank((CharSequence)reivceCityCodeStr) && CollectionUtils.isNotEmpty(reivceCityList = Arrays.asList(split = reivceCityCodeStr.split(regex_split_str)))) {
            PcpRegionReqDto pcpRegionReqDto = new PcpRegionReqDto();
            pcpRegionReqDto.setNameList(reivceCityList);
            logger.info("\u67e5\u8be2\u533a\u57df\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)pcpRegionReqDto));
            List addressAreaList = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto));
            if (CollectionUtils.isNotEmpty((Collection)addressAreaList)) {
                areaDtoMap = addressAreaList.stream().collect(Collectors.toMap(PcpRegionRespDto::getName, Function.identity(), (k1, k2) -> k1));
            }
        }
        ArrayList msgList = Lists.newArrayList();
        ArrayList sourceItemBlackVOS = Lists.newArrayList();
        HashSet<String> soleVerifySet = new HashSet<String>();
        for (ImportItemBlackBatchEndDto blackBatchEndDto : list) {
            boolean batchNoFlag;
            ImportItemBlackBatchEndMsgVo msgVo = new ImportItemBlackBatchEndMsgVo();
            msgVo.setMsg("");
            BeanUtils.copyProperties((Object)((Object)blackBatchEndDto), (Object)((Object)msgVo));
            String soleKey = blackBatchEndDto.getSkuCode() + "-" + blackBatchEndDto.getBatchNo();
            if (soleVerifySet.contains(soleKey)) {
                msgVo.setMsg("\u6570\u636e\u91cd\u590d;");
            } else {
                soleVerifySet.add(soleKey);
            }
            SourceItemBlackVO sourceItemBlackVO = new SourceItemBlackVO();
            sourceItemBlackVO.setBatchNo(blackBatchEndDto.getBatchNo());
            if (StringUtils.isEmpty((CharSequence)blackBatchEndDto.getSkuCode())) {
                msgVo.setMsg(msgVo.getMsg() + "\u3010\u5546\u54c1\u957f\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (!pcpItemMap.isEmpty() && pcpItemMap.containsKey(blackBatchEndDto.getSkuCode())) {
                PcpItemRespDto pcpItemRespDto = (PcpItemRespDto)pcpItemMap.get(blackBatchEndDto.getSkuCode());
                sourceItemBlackVO.setItemName(pcpItemRespDto.getName());
                sourceItemBlackVO.setSkuCode(pcpItemRespDto.getLongCode());
            } else {
                msgVo.setMsg(msgVo.getMsg() + "\u3010\u5546\u54c1\u957f\u7f16\u7801\u3011" + blackBatchEndDto.getSkuCode() + "\u4e0e\u7cfb\u7edf\u4e0d\u4e00\u81f4\u6216\u4e0d\u5b58\u5728;");
            }
            if (StringUtils.isEmpty((CharSequence)blackBatchEndDto.getReceiveCity())) {
                msgVo.setMsg(msgVo.getMsg() + "\u3010\u6536\u8d27\u7701\u5e02\u3011\u4e0d\u80fd\u4e3a\u7a7a;");
            } else {
                String[] cityArray = blackBatchEndDto.getReceiveCity().split(regex_split_str);
                ArrayList receiveCityCodeList = Lists.newArrayList();
                for (String cityName : cityArray) {
                    if (!areaDtoMap.isEmpty() && areaDtoMap.containsKey(cityName)) {
                        PcpRegionRespDto pcpRegionRespDto = (PcpRegionRespDto)areaDtoMap.get(cityName);
                        ClueItemBlackListCityDto clueItemBlackListCityDto = new ClueItemBlackListCityDto();
                        clueItemBlackListCityDto.setCode(pcpRegionRespDto.getCode());
                        String code = pcpRegionRespDto.getCode();
                        String parentCode = pcpRegionRespDto.getParentCode();
                        if (StringUtils.isNotBlank((CharSequence)parentCode) && !Objects.equals(parentCode, "0") && !Objects.equals(parentCode, "-1")) {
                            code = parentCode + "," + code;
                        }
                        clueItemBlackListCityDto.setName(code);
                        receiveCityCodeList.add(clueItemBlackListCityDto);
                        continue;
                    }
                    msgVo.setMsg(msgVo.getMsg() + "\u3010\u6536\u8d27\u7701\u5e02\u3011" + cityName + "\u4e0e\u7cfb\u7edf\u4e0d\u4e00\u81f4\u6216\u4e0d\u5b58\u5728;");
                }
                sourceItemBlackVO.setReceiveCityCodeList(receiveCityCodeList);
            }
            if (StringUtils.isNotBlank((CharSequence)blackBatchEndDto.getBatchNo()) && !(batchNoFlag = Pattern.matches(batch_regex, blackBatchEndDto.getBatchNo()))) {
                msgVo.setMsg(msgVo.getMsg() + "\u6279\u6b21\u5fc5\u987b\u4e3a\u5927\u5c0f\u5199\u82f1\u6587\u6216\u6570\u5b57;");
            }
            if (StringUtils.isNotBlank((CharSequence)msgVo.getMsg())) {
                msgList.add(msgVo);
                continue;
            }
            sourceItemBlackVOS.add(sourceItemBlackVO);
        }
        String errorMsgUrl = null;
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = "\u5546\u54c1\u9ed1\u540d\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f";
            if (Objects.equals(key, SourceItemBlackTypeEnum.BY_BATCH_END.code.toString())) {
                errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportItemBlackBatchEndMsgVo.class, null, excelName);
            } else if (Objects.equals(key, SourceItemBlackTypeEnum.BY_BATCH_NO.code.toString())) {
                ArrayList msgBatchNoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)msgBatchNoList, (Collection)msgList, ImportItemBlackBatchNoMsgVo.class);
                errorMsgUrl = ExcelUtils.getExportUrl(msgBatchNoList, ImportItemBlackBatchNoMsgVo.class, null, excelName);
            }
        }
        SourceItemBlackImportFileResultVO resultVO = new SourceItemBlackImportFileResultVO();
        resultVO.setList(sourceItemBlackVOS);
        resultVO.setErrorFileUrl(errorMsgUrl);
        return new RestResponse((Object)resultVO);
    }

    @Override
    public RestResponse<ItemBlackImportFileResultVO> ItemBlackListImportFile(CustomerImportFile importFile) {
        EasyPoiExportUtil.checkFileInfo(importFile.getImportFileUrl());
        String key = importFile.getKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new BizException("\u4e1a\u52a1key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Integer headRow = 0;
        InputStream inputStream = ExcelUtils.getInputStream(importFile.getImportFileUrl());
        ArrayList list = Lists.newArrayList();
        ExcelImportResult<ImportBaseModeDto> result = null;
        if (Objects.equals(key, SourceItemBlackTypeEnum.BY_BATCH_END.code.toString())) {
            EasyPoiExportUtil.checkExcelHeader(inputStream, ItemBlacklistImportEndVo.class, (int)headRow);
            try {
                result = EasyPoiExportUtil.handlerExcelDataResult(ItemBlacklistImportEndVo.class, importFile.getImportFileUrl(), (Integer)1);
            }
            catch (Exception e) {
                throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
            }
        } else if (Objects.equals(key, SourceItemBlackTypeEnum.BY_BATCH_NO.code.toString())) {
            EasyPoiExportUtil.checkExcelHeader(inputStream, ItemBlacklistImportBatchVo.class, (int)headRow);
            try {
                result = EasyPoiExportUtil.handlerExcelDataResult(ItemBlacklistImportBatchVo.class, importFile.getImportFileUrl(), (Integer)1);
            }
            catch (Exception e) {
                throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
            }
        } else {
            throw new BizException("\u4e1a\u52a1key\u4e0d\u6b63\u786e\uff01");
        }
        this.checkParam(result);
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ItemBlacklistImportEndVo.class);
        List skuCodeList = list.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getSkuCode())).map(ItemBlacklistImportEndVo::getSkuCode).distinct().collect(Collectors.toList());
        List pcpItemRespDtos = (List)this.pcpItemQueryApi.queryItemByItemLongCodes(skuCodeList).getData();
        Map<Object, Object> pcpItemMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)pcpItemRespDtos)) {
            pcpItemMap = pcpItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k2) -> k1));
        }
        HashMap areaDtoMap = new HashMap();
        ArrayList msgList = Lists.newArrayList();
        ArrayList sourceItemBlackVOS = Lists.newArrayList();
        HashSet<String> soleVerifySet = new HashSet<String>();
        for (ItemBlacklistImportEndVo blackBatchEndDto : list) {
            boolean batchNoFlag;
            ItemBlacklistImportEndMsgVo msgVo = new ItemBlacklistImportEndMsgVo();
            BeanUtils.copyProperties((Object)((Object)blackBatchEndDto), (Object)((Object)msgVo));
            String soleKey = blackBatchEndDto.getSkuCode() + "-" + blackBatchEndDto.getBatchNo();
            if (soleVerifySet.contains(soleKey)) {
                msgVo.setMsg("\u6570\u636e\u91cd\u590d;");
            } else {
                soleVerifySet.add(soleKey);
            }
            ItemBlacklistImportVo sourceItemBlackVO = new ItemBlacklistImportVo();
            sourceItemBlackVO.setBatchNo(blackBatchEndDto.getBatchNo());
            if (StringUtils.isEmpty((CharSequence)blackBatchEndDto.getSkuCode())) {
                msgVo.setMsg(msgVo.getMsg() + "SKU\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (!pcpItemMap.isEmpty() && pcpItemMap.containsKey(blackBatchEndDto.getSkuCode())) {
                PcpItemRespDto pcpItemRespDto = (PcpItemRespDto)pcpItemMap.get(blackBatchEndDto.getSkuCode());
                sourceItemBlackVO.setItemName(pcpItemRespDto.getName());
                sourceItemBlackVO.setSkuCode(pcpItemRespDto.getLongCode());
            } else {
                msgVo.setMsg(msgVo.getMsg() + "SKU\u4fe1\u606f\u4e0d\u5b58\u5728;");
            }
            if (StringUtils.isNotBlank((CharSequence)blackBatchEndDto.getBatchNo()) && !(batchNoFlag = Pattern.matches(batch_regex, blackBatchEndDto.getBatchNo()))) {
                msgVo.setMsg(msgVo.getMsg() + "\u6279\u6b21\u5fc5\u987b\u4e3a\u5927\u5c0f\u5199\u82f1\u6587\u6216\u6570\u5b57;");
            }
            if (StringUtils.isNotBlank((CharSequence)msgVo.getMsg())) {
                msgList.add(msgVo);
                continue;
            }
            sourceItemBlackVOS.add(sourceItemBlackVO);
        }
        String errorMsgUrl = null;
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = "\u5546\u54c1\u9ed1\u540d\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f";
            if (Objects.equals(key, SourceItemBlackTypeEnum.BY_BATCH_END.code.toString())) {
                errorMsgUrl = ExcelUtils.getExportUrl(msgList, ItemBlacklistImportEndMsgVo.class, null, excelName);
            } else if (Objects.equals(key, SourceItemBlackTypeEnum.BY_BATCH_NO.code.toString())) {
                ArrayList msgBatchNoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)msgBatchNoList, (Collection)msgList, ItemBlacklistImportBatchMsgVo.class);
                errorMsgUrl = ExcelUtils.getExportUrl(msgBatchNoList, ItemBlacklistImportBatchMsgVo.class, null, excelName);
            }
        }
        ItemBlackImportFileResultVO resultVO = new ItemBlackImportFileResultVO();
        resultVO.setList(sourceItemBlackVOS);
        resultVO.setErrorFileUrl(errorMsgUrl);
        return new RestResponse((Object)resultVO);
    }
}

