/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.model.AddMaterialsOrderParams;
import com.dtyunxi.cis.pms.biz.model.AssociatedDocumentVO;
import com.dtyunxi.cis.pms.biz.model.AuditVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportMaterialsOrderVO;
import com.dtyunxi.cis.pms.biz.model.FinishedGoodsInventoryGoodsVO;
import com.dtyunxi.cis.pms.biz.model.GetMaterialsOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.MaterialsOrderVO;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryMaterialsOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.search.api.dto.response.InPlannedOrderVO;
import com.dtyunxi.cis.search.api.query.inventory.EsPlannedOrderQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.es.MaterialsOrderLisReq;
import com.dtyunxi.tcbj.api.dto.response.InPlannedOrderStatusCountRespDto;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderOperateEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="abstractFileOperationCommonService_materials_order")
public class FinishedGoodsInventoryMaterialsOrderServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinishedGoodsInventoryMaterialsOrderService {
    @Resource
    private EsPlannedOrderQueryApi esPlannedOrderQueryApi;
    @Resource
    private ICsOutPlannedOrderApi csOutPlannedOrderApi;
    @Resource
    private ICsOutPlannedOrderQueryApi csOutPlannedOrderQueryApi;
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;

    @Override
    public RestResponse<Object> addMaterialsOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AddMaterialsOrderParams addMaterialsOrderParams) {
        CsOutPlannedOrderGenerateReqDto reqDto = new CsOutPlannedOrderGenerateReqDto();
        BeanUtils.copyProperties((Object)addMaterialsOrderParams, (Object)reqDto);
        this.getAddMaterialsOrder(addMaterialsOrderParams, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.generateRetreatOrder(reqDto)));
    }

    private void getAddMaterialsOrder(AddMaterialsOrderParams addMaterialsOrderParams, CsOutPlannedOrderGenerateReqDto reqDto) {
        Integer submitType = addMaterialsOrderParams.getSubmitType();
        reqDto.setOperateFlag(CsPlannedOrderOperateEnum.DRAFT.getCode());
        if (YesOrNoEnum.YES.getCode().equals(submitType)) {
            reqDto.setOperateFlag(CsPlannedOrderOperateEnum.SUBMIT.getCode());
        }
        reqDto.setOrderType(CsPlannedOrderTypeEnum.PRODUCTION_MATERIALS.getCode());
        reqDto.setBusinessType(CsPlannedOrderBusinessTypeEnum.PRODUCTION_MATERIALS.getCode());
        reqDto.setWarehouseCode(addMaterialsOrderParams.getReceiveLogicalWarehouseCode());
        reqDto.setWarehouseName(addMaterialsOrderParams.getReceiveLogicalWarehouseName());
        reqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
        reqDto.setRemark(addMaterialsOrderParams.getRemark());
        reqDto.setEstimatedTime(StringUtils.isNotBlank((CharSequence)addMaterialsOrderParams.getArrivalTime()) ? DateUtil.parse((String)addMaterialsOrderParams.getArrivalTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
        List<FinishedGoodsInventoryGoodsVO> goodsList = addMaterialsOrderParams.getGoodsList();
        List list = goodsList.stream().map(o -> {
            CsOutPlannedOrderGenerateDetailReqDto dto = new CsOutPlannedOrderGenerateDetailReqDto();
            BeanUtils.copyProperties((Object)o, (Object)dto);
            dto.setLongCode(o.getGoodsLongCode());
            dto.setBatch(o.getBatchNo());
            dto.setCargoName(o.getGoodsName());
            dto.setCargoCode(o.getGoodsCode());
            dto.setCargoId(ParamConverter.convertToLong((Object)o.getGoodsId()));
            if (StringUtils.isNotBlank((CharSequence)o.getEffectiveTime())) {
                dto.setProduceTime(DateUtil.parse((String)o.getEffectiveTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (StringUtils.isNotBlank((CharSequence)o.getInvalidTime())) {
                dto.setExpireTime(DateUtil.parse((String)o.getInvalidTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            dto.setPlanQuantity(ParamConverter.convertToBigDecimal((Object)o.getPlanQuantity()));
            return dto;
        }).collect(Collectors.toList());
        reqDto.setItemDetailList(list);
    }

    @Override
    public RestResponse<MaterialsOrderVO> getMaterialsOrderDetail(@NotNull @ApiParam(value="\u5355\u636e\u7f16\u53f7", required=true) @Valid @RequestParam(value="bussinessOrderNo", required=true) String bussinessOrderNo) {
        List<AssociatedDocumentVO> list;
        List relOrderInfoList;
        CsOutPlannedOrderDetailQueryInfoRespDto respDto = (CsOutPlannedOrderDetailQueryInfoRespDto)RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderQueryApi.queryDetailByOrderNo(bussinessOrderNo));
        MaterialsOrderVO vo = new MaterialsOrderVO();
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setBussinessOrderNo(respDto.getOrderNo());
        vo.setBussinessOrderType(respDto.getOrderType());
        vo.setBussinessOrderStatus(respDto.getOrderStatus());
        vo.setExternalOrderNo(respDto.getPlatformOrderNo());
        vo.setDeliveryWarehouseCode(respDto.getDeliveryWarehouseCode());
        vo.setDeliveryWarehouseName(respDto.getDeliveryWarehouseName());
        vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        if (respDto.getCreateTime() != null) {
            vo.setArrivalTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(relOrderInfoList = respDto.getRelOrderInfoList()))) {
            list = relOrderInfoList.stream().map(o -> {
                AssociatedDocumentVO associatedDocumentVO = new AssociatedDocumentVO();
                BeanUtils.copyProperties((Object)o, (Object)associatedDocumentVO);
                if (o.getCreateTime() != null) {
                    associatedDocumentVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                return associatedDocumentVO;
            }).collect(Collectors.toList());
            vo.setAssociatedDocumentList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)respDto.getAuditRespDtoList())) {
            list = respDto.getAuditRespDtoList().stream().map(o -> {
                AuditVO auditVO = new AuditVO();
                BeanUtils.copyProperties((Object)o, (Object)auditVO);
                auditVO.setAuditResult(o.getAuditResult());
                auditVO.setAuditReason(o.getRemark());
                if (o.getCreateTime() != null) {
                    auditVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                vo.setAuditRemark(o.getRemark());
                return auditVO;
            }).collect(Collectors.toList());
            vo.setAuditRecordList(list);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<MaterialsOrderVO>> getMaterialsOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetMaterialsOrderListPageParams getMaterialsOrderListPageParams) {
        PageInfo pageInfo = new PageInfo();
        PageInfo respDtoPageInfo = new PageInfo();
        ArrayList materialsOrderVOList = new ArrayList();
        MaterialsOrderLisReq req = new MaterialsOrderLisReq();
        BeanUtils.copyProperties((Object)getMaterialsOrderListPageParams, (Object)req);
        req.setReceiveLogicalWarehouseCode(getMaterialsOrderListPageParams.getDeliveryWarehouseCode());
        req.setReceiveLogicalWarehouseName(getMaterialsOrderListPageParams.getDeliveryWarehouseName());
        req.setOrderType(CsPlannedOrderTypeEnum.PRODUCTION_MATERIALS.getCode());
        PageInfo materialsOrderVOPageInfo = (PageInfo)this.inventoryEsReportQueryApi.queryMaterialsOrderListPage(req).getData();
        if (CollectionUtils.isEmpty((Collection)materialsOrderVOPageInfo.getList())) {
            return new RestResponse();
        }
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)materialsOrderVOPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList orderList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderList, (Collection)materialsOrderVOPageInfo.getList(), InPlannedOrderVO.class);
        CubeBeanUtils.copyCollection(materialsOrderVOList, (Collection)materialsOrderVOPageInfo.getList(), MaterialsOrderVO.class);
        respDtoPageInfo.setList((List)orderList);
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        AtomicInteger i = new AtomicInteger();
        List list = respDtoPageInfo.getList().stream().map(o -> {
            MaterialsOrderVO vo = new MaterialsOrderVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setLongCode(o.getCargoCode());
            vo.setBussinessOrderNo(o.getOrderNo());
            vo.setBussinessOrderType(o.getBusinessType());
            vo.setBussinessOrderStatus(o.getOrderStatus());
            vo.setExternalOrderNo(o.getPlatformOrderNo());
            vo.setTotalNum(BigDecimalUtils.check((BigDecimal)o.getTotalQuantity()).intValue());
            vo.setReceiveLogicalWarehouseCode(o.getReceiveWarehouseCode());
            vo.setReceiveLogicalWarehouseName(o.getReceiveWarehouseName());
            vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            MaterialsOrderVO materialsOrderOrderVO = (MaterialsOrderVO)materialsOrderVOList.get(i.getAndIncrement());
            vo.setDeliveryWarehouseId(materialsOrderOrderVO.getDeliveryWarehouseId());
            vo.setDeliveryWarehouseName(materialsOrderOrderVO.getDeliveryWarehouseName());
            vo.setDeliveryWarehouseCode(materialsOrderOrderVO.getDeliveryWarehouseCode());
            vo.setPlanQuantity(materialsOrderOrderVO.getPlanQuantity());
            vo.setDoneOutQuantity(materialsOrderOrderVO.getDoneOutQuantity());
            vo.setDoneQuantity(materialsOrderOrderVO.getDoneQuantity());
            vo.setWaitQuantity(materialsOrderOrderVO.getWaitQuantity());
            vo.setRemark(materialsOrderOrderVO.getRemark());
            vo.setOutPhysicsWarehouseCode(materialsOrderOrderVO.getOutPhysicsWarehouseCode());
            vo.setOutPhysicsWarehouseName(materialsOrderOrderVO.getOutPhysicsWarehouseName());
            vo.setProductionWarehouseCode(materialsOrderOrderVO.getProductionWarehouseCode());
            vo.setProductionWarehouseName(materialsOrderOrderVO.getProductionWarehouseName());
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<InPlannedOrderStatusCountRespDto>> materialsOrderStatusCount(@Valid GetMaterialsOrderListPageParams getMaterialsOrderListPageParams) {
        MaterialsOrderLisReq req = new MaterialsOrderLisReq();
        BeanUtils.copyProperties((Object)getMaterialsOrderListPageParams, (Object)req);
        req.setReceiveLogicalWarehouseCode(getMaterialsOrderListPageParams.getDeliveryWarehouseCode());
        req.setReceiveLogicalWarehouseName(getMaterialsOrderListPageParams.getDeliveryWarehouseName());
        req.setOrderType(CsPlannedOrderTypeEnum.PRODUCTION_MATERIALS.getCode());
        return this.inventoryEsReportQueryApi.materialsOrderStatusCount(req);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetMaterialsOrderListPageParams params = new GetMaterialsOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetMaterialsOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetMaterialsOrderListPageParams.class);
        }
        params.setPageSize(commonReqDto.getPageSize());
        params.setPageNum(commonReqDto.getPageNum());
        RestResponse<PageInfo<MaterialsOrderVO>> pageInfoRestResponse = this.getMaterialsOrderListPage(params);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(p -> {
                ExportMaterialsOrderVO vo = new ExportMaterialsOrderVO();
                CubeBeanUtils.copyProperties((Object)((Object)vo), (Object)p, (String[])new String[0]);
                vo.setBussinessOrderStatus(Optional.ofNullable(p.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "wait_in": {
                            return "\u5f85\u5165\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "portion_in": {
                            return "\u90e8\u5206\u5165\u5e93";
                        }
                        case "completed": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "cancel": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return p.getBussinessOrderStatus();
                }).orElse(""));
                vo.setBussinessOrderType("\u751f\u4ea7\u9886\u6599");
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetMaterialsOrderListPageParams params = new GetMaterialsOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetMaterialsOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetMaterialsOrderListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getMaterialsOrderListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public RestResponse<Object> updateMaterialsOrder(@ApiParam(value="") @Valid @RequestBody(required=false) AddMaterialsOrderParams addMaterialsOrderParams) {
        CsOutPlannedOrderGenerateReqDto reqDto = new CsOutPlannedOrderGenerateReqDto();
        BeanUtils.copyProperties((Object)addMaterialsOrderParams, (Object)reqDto);
        reqDto.setOrderNo(addMaterialsOrderParams.getBussinessOrderNo());
        this.getAddMaterialsOrder(addMaterialsOrderParams, reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderApi.editRetreatOrder(reqDto)));
    }
}

