/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.DeriveTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.LogStatusEnum;
import com.dtyunxi.cis.pms.biz.model.BaseAreaVO;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.express.ExpressCostDetailExportDto;
import com.dtyunxi.cis.pms.biz.model.express.ExpressCostReportImportDto;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterAreaService;
import com.dtyunxi.cis.pms.biz.service.ExpressCostOrderService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IExpressCostDetailApi;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportQueryDto;
import com.dtyunxi.tcbj.api.dto.constant.enums.LogisticDocumentTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.query.IExpressCostDetailQueryApi;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_express_cost_report_order")
public class ExpressCostOrderServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExpressCostOrderService {
    private static final Logger logger = LoggerFactory.getLogger(ExpressCostOrderServiceImpl.class);
    @Resource
    private IExpressCostDetailQueryApi expressCostDetailQueryApi;
    @Resource
    private IExpressCostDetailApi expressCostDetailApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi csPhysicsWarehouseExposedQueryApi;
    @Resource
    private IcsShipmenetEnterpriseQueryApi csShipmenetEnterpriseQueryApi;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private BasedataCenterAreaService centerAreaService;
    public static Map<String, Integer> CHARGE_MODE_TYPE = new HashMap<String, Integer>();
    public static Map<String, String> BUSINESS_TYPE = new HashMap<String, String>();
    private static final List<String> CARRIER_MODE = Lists.newArrayList();
    private static final String ERROR_MSG = "\u5f02\u5e38";
    private static final BigDecimal EER_NUM = new BigDecimal("-1");

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ExpressCostReportImportDto.class);
        HashSet checkUnique = Sets.newHashSet();
        HashSet checkUniqueKey = Sets.newHashSet();
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.expressCostDetailQueryApi.queryListByOrders(list.stream().map(ExpressCostReportImportDto::getOutboundCode).collect(Collectors.toList())));
        Map<Object, Object> map = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)respDtos)) {
            map = respDtos.stream().collect(Collectors.toMap(ExpressCostDetailRespDto::getOutboundCode, Function.identity(), (k1, k2) -> k1));
        }
        List respDtos1 = (List)RestResponseHelper.extractData((RestResponse)this.expressCostDetailQueryApi.queryListByExpressOrders(list.stream().map(ExpressCostReportImportDto::getExpressNo).collect(Collectors.toList())));
        Map<Object, Object> map1 = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)respDtos)) {
            map1 = respDtos1.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getExpressNo())).collect(Collectors.toMap(ExpressCostDetailRespDto::getExpressNo, Function.identity(), (k1, k2) -> k1));
        }
        Map<Object, Object> finalMap = map;
        HashMap finalMap1 = map1;
        Map<String, CsPhysicsWarehousePageRespDto> whMap = this.queryPhysicalWareshouseName();
        Map<String, CsShipmenetEnterpriseRespDto> shipmenetEnterprise = this.getShipmenetEnterprise();
        HashSet warehouseCodes = Sets.newHashSet();
        list.forEach(i -> {
            warehouseCodes.add(i.getOutWarehouseCode());
            warehouseCodes.add(i.getInWarehouseCode());
        });
        Map<String, LogicWarehouseRespDto> logicWarehouseMap = this.getLogicWarehouseMap(warehouseCodes);
        Map areaMap = this.centerAreaService.getAreaList().stream().collect(Collectors.toMap(BaseAreaVO::getName, Function.identity(), (k1, k2) -> k1));
        list.forEach(i -> {
            if (checkUnique.contains(i.getOutboundCode())) {
                this.setMsg((ExpressCostReportImportDto)((Object)i), "\u6570\u636e\u91cd\u590d\u3010\u51fa\u5e93\u7ed3\u679c\u5355\u53f7\u3011");
            } else {
                checkUnique.add(i.getOutboundCode());
            }
            this.checkDateFormat((ExpressCostReportImportDto)((Object)i));
            this.checkBookkeepingMonth((ExpressCostReportImportDto)((Object)i));
            if (finalMap.containsKey(i.getOutboundCode())) {
                this.setMsg((ExpressCostReportImportDto)((Object)i), "\u51fa\u5e93\u7ed3\u679c\u5355\u5df2\u5b58\u5728");
            }
            this.checkPhysicalWareshouse(whMap, (ExpressCostReportImportDto)((Object)i));
            this.checkShipmenetEnterprise(shipmenetEnterprise, (ExpressCostReportImportDto)((Object)i));
            this.checkCarrierMode(CARRIER_MODE, (ExpressCostReportImportDto)((Object)i));
            this.checkChargeMode(CHARGE_MODE_TYPE, (ExpressCostReportImportDto)((Object)i));
            if (StringUtils.isNotBlank((CharSequence)i.getExpressNo())) {
                if (checkUniqueKey.contains(i.getExpressNo())) {
                    this.setMsg((ExpressCostReportImportDto)((Object)i), "\u6570\u636e\u91cd\u590d\u3010\u5feb\u9012\u5355\u53f7\u3011");
                } else {
                    checkUniqueKey.add(i.getExpressNo());
                }
            }
            if (finalMap1.containsKey(i.getExpressNo())) {
                this.setMsg((ExpressCostReportImportDto)((Object)i), "\u5feb\u9012\u5355\u53f7\u5df2\u5b58\u5728");
            }
            this.checkWarehouse((LogicWarehouseRespDto)logicWarehouseMap.get(i.getOutWarehouseCode()), (ExpressCostReportImportDto)((Object)i), 1);
            this.checkWarehouse((LogicWarehouseRespDto)logicWarehouseMap.get(i.getInWarehouseCode()), (ExpressCostReportImportDto)((Object)i), 2);
            String adjustmentType = i.getAdjustmentType();
            if (Objects.equals(adjustmentType, "\u589e\u52a0")) {
                i.setAdjustmentType("1");
            } else if (Objects.equals(adjustmentType, "\u51cf\u5c11")) {
                i.setAdjustmentType("2");
            } else {
                this.setMsg((ExpressCostReportImportDto)((Object)i), "\u8c03\u6574\u7c7b\u578b\u9519\u8bef");
            }
            this.checkArea(areaMap, (ExpressCostReportImportDto)((Object)i));
            this.checkBusinessType(BUSINESS_TYPE, (ExpressCostReportImportDto)((Object)i));
            if (StringUtils.isNotBlank((CharSequence)i.getMsg())) {
                msgList.add(i);
            } else {
                saveList.add(this.setData((ExpressCostReportImportDto)((Object)i)));
            }
        });
        HashMap returnMap = Maps.newHashMap();
        returnMap.put("saveList", saveList);
        returnMap.put("msgList", msgList);
        return returnMap;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            this.expressCostDetailApi.batchInsert(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u5feb\u9012\u8d39\u5355\u636e\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ExpressCostReportImportDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        ExpressCostReportQueryDto params = new ExpressCostReportQueryDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (ExpressCostReportQueryDto)JSON.parseObject((String)commonReqDto.getFilter(), ExpressCostReportQueryDto.class);
        }
        logger.info("\u5feb\u9012\u8d39\u7528\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)params));
        ArrayList resultList = Lists.newArrayList();
        params.setPageNum(Integer.valueOf(1));
        params.setPageSize(Integer.valueOf(5000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.expressCostDetailQueryApi.queryByPage(params));
        logger.info("\u67e5\u8be2\u7684\u5feb\u9012\u8d39\u7528\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
        long total = pageInfo.getTotal();
        long maxpage = total / 5000L + 1L;
        while ((long)params.getPageNum().intValue() <= maxpage && ObjectUtil.isNotEmpty((Object)pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            logger.info("\u5206\u6279\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)params));
            ArrayList list = Lists.newArrayList();
            list.addAll(pageInfo.getList().stream().map(o -> {
                ExpressCostDetailExportDto vo = new ExpressCostDetailExportDto();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (o.getUpdateTime() != null) {
                    vo.setLastUpdateTime(dateFormat.format(o.getUpdateTime()));
                }
                if (StringUtils.isNotBlank((CharSequence)o.getUpdatePerson())) {
                    vo.setLastUpdatePerson(o.getUpdatePerson());
                }
                if (o.getAbnormal() != null) {
                    vo.setAbnormal(Optional.ofNullable(LogStatusEnum.getStatusByCode(String.valueOf(o.getAbnormal()))).orElse(String.valueOf(o.getAbnormal())));
                }
                vo.setChargeMode(Optional.ofNullable(o.getChargeMode()).filter(ObjectUtils::isNotEmpty).map(businessType -> {
                    switch (businessType) {
                        case 1: {
                            return "\u6a21\u677f1";
                        }
                        case 2: {
                            return "\u6a21\u677f2";
                        }
                        case 3: {
                            return "\u6a21\u677f3";
                        }
                        case 4: {
                            return "\u6a21\u677f4";
                        }
                        case 5: {
                            return "\u6a21\u677f5";
                        }
                        case 6: {
                            return "\u6a21\u677f6";
                        }
                        case 7: {
                            return "\u6a21\u677f7";
                        }
                        case 8: {
                            return "\u6a21\u677f8";
                        }
                        case 9: {
                            return "\u6a21\u677f9";
                        }
                    }
                    return o.getBusinessType();
                }).orElse(""));
                vo.setAdjustmentType(Optional.ofNullable(o.getAdjustmentType()).filter(StringUtils::isNotEmpty).map(businessType -> {
                    switch (businessType) {
                        case "1": {
                            return "\u589e\u52a0";
                        }
                        case "2": {
                            return "\u51cf\u5c11";
                        }
                    }
                    return o.getAdjustmentType();
                }).orElse(""));
                vo.setBusinessType(Optional.ofNullable(o.getBusinessType()).filter(StringUtils::isNotBlank).map(Type2 -> {
                    if (ObjectUtils.isNotEmpty((Object)DeriveTypeEnum.getMsgByCode(o.getBusinessType()))) {
                        return String.valueOf(DeriveTypeEnum.getMsgByCode(o.getBusinessType()));
                    }
                    return o.getBusinessType();
                }).orElse(""));
                Optional.ofNullable(o.getIfRepeat()).ifPresent(p -> vo.setRepeatStr(p == 1 ? "\u662f" : "\u5426"));
                Optional.ofNullable(o.getMasterOrder()).ifPresent(p -> vo.setMasterOrderStr(p == 1 ? "\u662f" : "\u5426"));
                vo.setFirstPrice(this.formatValue(o.getFirstPricePer()));
                vo.setContinuedOne(this.formatValue(o.getContinuedOnePer()));
                vo.setContinuedTwo(this.formatValue(o.getContinuedTwoPer()));
                vo.setContinuedThree(this.formatValue(o.getContinuedThreePer()));
                vo.setContinuedFour(this.formatValue(o.getContinuedFourPer()));
                vo.setContinuedFreight(this.formatValue(o.getContinuedFreight()));
                vo.setTotalFreight(this.formatValue(o.getTotalFreight()));
                logger.info("expressCostOrderServiceImpl \u7ec4\u7ec7\u5b8c\u6210\u540e\u7684\u6570\u636e1\uff1a{}", (Object)JSON.toJSONString((Object)((Object)vo)));
                return vo;
            }).collect(Collectors.toList()));
            resultList.addAll(list);
            logger.info("\u5206\u6279\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)list));
            if ((long)params.getPageNum().intValue() == maxpage) {
                logger.info("\u7ed3\u675f\u5206\u6279\u67e5\u8be2\uff1a{}");
                break;
            }
            params.setPageNum(Integer.valueOf(params.getPageNum() + 1));
            pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.expressCostDetailQueryApi.queryByPage(params));
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)resultList, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    private String formatValue(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.compareTo(EER_NUM) == 0 ? ERROR_MSG : value.stripTrailingZeros().toPlainString();
    }

    public void setWeightRange(ExpressCostDetailReqDto dto) {
        BigDecimal weight = dto.getWeight();
        BigDecimal volumeWeight = dto.getVolumeWeight() != null ? dto.getVolumeWeight() : BigDecimal.ZERO;
        BigDecimal calculateWeight = weight;
        if (volumeWeight.compareTo(weight) > 0) {
            calculateWeight = volumeWeight;
        }
        if (calculateWeight.compareTo(BigDecimal.ZERO) > 0 && calculateWeight.compareTo(new BigDecimal(0.5)) <= 0) {
            dto.setWeightRange("0\uff1cX\u22640.5");
        } else if (calculateWeight.compareTo(new BigDecimal(0.5)) > 0 && calculateWeight.compareTo(BigDecimal.ONE) <= 0) {
            dto.setWeightRange("0.5\uff1cX\u22641");
        } else if (calculateWeight.compareTo(BigDecimal.ONE) > 0 && calculateWeight.compareTo(BigDecimal.valueOf(2L)) <= 0) {
            dto.setWeightRange("1\uff1cX\u22642");
        } else if (calculateWeight.compareTo(BigDecimal.valueOf(2L)) > 0 && calculateWeight.compareTo(BigDecimal.valueOf(3L)) <= 0) {
            dto.setWeightRange("2\uff1cX\u22643");
        } else if (calculateWeight.compareTo(BigDecimal.valueOf(3L)) > 0) {
            dto.setWeightRange("\uff1e3");
        }
    }

    private ExpressCostDetailReqDto setData(ExpressCostReportImportDto i) {
        ExpressCostDetailReqDto dto = new ExpressCostDetailReqDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)((Object)i), (String[])new String[0]);
        dto.setBillType(LogisticDocumentTypeEnum.IMPORT.getCode());
        if (StringUtils.isNotBlank((CharSequence)i.getOutboundTime())) {
            dto.setOutboundTime(DateUtil.parseDate((String)i.getOutboundTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getChargeMode())) {
            dto.setChargeMode(Integer.valueOf(i.getChargeMode()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getPieceNum())) {
            dto.setPieceNum(Long.valueOf(i.getPieceNum()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getVolumeWeight())) {
            dto.setVolumeWeight(new BigDecimal(i.getVolumeWeight()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getWeight())) {
            dto.setWeight(new BigDecimal(i.getWeight()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getFirstPrice())) {
            dto.setFirstPrice(new BigDecimal(i.getFirstPrice()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getContinuedOne())) {
            dto.setContinuedOne(new BigDecimal(i.getContinuedOne()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getContinuedTwo())) {
            dto.setContinuedTwo(new BigDecimal(i.getContinuedTwo()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getContinuedThree())) {
            dto.setContinuedThree(new BigDecimal(i.getContinuedThree()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getContinuedFour())) {
            dto.setContinuedFour(new BigDecimal(i.getContinuedFour()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getPackingFreight())) {
            dto.setPackingFreight(new BigDecimal(i.getPackingFreight()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getIncrementFreight())) {
            dto.setIncrementFreight(new BigDecimal(i.getIncrementFreight()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getInsureAmount())) {
            dto.setInsureAmount(new BigDecimal(i.getInsureAmount()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getPremium())) {
            dto.setPremium(new BigDecimal(i.getPremium()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getAdjustmentAmount())) {
            dto.setAdjustmentAmount(new BigDecimal(i.getAdjustmentAmount()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getTotalFreight())) {
            dto.setTotalFreight(new BigDecimal(i.getTotalFreight()));
        }
        if (StringUtils.isNotBlank((CharSequence)i.getReturnFee())) {
            dto.setReturnFee(new BigDecimal(i.getReturnFee()));
        }
        dto.setRemark(i.getRemark());
        this.setWeightRange(dto);
        return dto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkArea(Map<String, BaseAreaVO> areaMap, ExpressCostReportImportDto msgDto) {
        if (!areaMap.containsKey(msgDto.getProvince())) {
            this.setMsg(msgDto, "\u7701\u540d\u79f0\u4e0d\u6b63\u786e");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)msgDto.getArea()) && StringUtils.isBlank((CharSequence)msgDto.getCity())) {
            this.setMsg(msgDto, "\u82e5\u586b\u5199\u4e86\u533a/\u53bf\u5219\u7701\u3001\u5e02\u5fc5\u987b\u586b\u5199");
            return;
        }
        if (!StringUtils.isNotBlank((CharSequence)msgDto.getCity())) return;
        if (CollectionUtil.isNotEmpty(areaMap.get(msgDto.getProvince()).getChildren())) {
            Map cityMap = areaMap.get(msgDto.getProvince()).getChildren().stream().collect(Collectors.toMap(BaseAreaVO::getName, Function.identity(), (k1, k2) -> k1));
            if (!cityMap.containsKey(msgDto.getCity())) {
                this.setMsg(msgDto, "\u5e02\u540d\u79f0\u4e0d\u6b63\u786e\u6216\u7701\u5e02\u540d\u79f0\u4e0d\u5339\u914d");
                return;
            }
            if (!StringUtils.isNotBlank((CharSequence)msgDto.getArea())) return;
            if (((BaseAreaVO)cityMap.get(msgDto.getCity())).getChildren() != null) {
                Map districtMap = ((BaseAreaVO)cityMap.get(msgDto.getCity())).getChildren().stream().collect(Collectors.toMap(BaseAreaVO::getName, Function.identity(), (k1, k2) -> k1));
                if (districtMap.containsKey(msgDto.getArea())) return;
                this.setMsg(msgDto, "\u533a/\u53bf\u540d\u79f0\u4e0d\u6b63\u786e\u6216\u7701\u5e02\u533a/\u53bf\u4e0d\u5339\u914d");
                return;
            }
            this.setMsg(msgDto, "\u6ca1\u627e\u5230\u76f8\u5173\u7684\u533a/\u53bf\u4fe1\u606f");
            return;
        }
        this.setMsg(msgDto, "\u6ca1\u627e\u5230\u76f8\u5173\u5e02\u4fe1\u606f");
    }

    private void checkWarehouse(LogicWarehouseRespDto warehouse, ExpressCostReportImportDto i, int type) {
        if (warehouse == null) {
            this.setMsg(i, String.format("%s\u4ed3\u5e93\u7f16\u7801\u4e0d\u6b63\u786e", type == 1 ? "\u8c03\u51fa\u4ed3" : "\u8c03\u5165\u4ed3"));
        } else {
            if (type == 1) {
                i.setOutWarehouseCode(warehouse.getWarehouseCode());
                i.setOutOrg(warehouse.getOrganizationName());
                i.setOutOrgCode(warehouse.getOrganizationCode());
            }
            if (type == 2) {
                i.setInWarehouseCode(warehouse.getWarehouseName());
                i.setInOrg(warehouse.getOrganizationName());
                i.setInOrgCode(warehouse.getOrganizationCode());
            }
        }
    }

    private void checkBusinessType(Map<String, String> businessType, ExpressCostReportImportDto i) {
        if (StringUtils.isNotBlank((CharSequence)i.getBusinessType())) {
            if (!businessType.containsKey(i.getBusinessType())) {
                this.setMsg(i, "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u6b63\u786e");
            } else if (StringUtils.isBlank((CharSequence)i.getMsg())) {
                i.setBusinessType(String.valueOf(businessType.get(i.getBusinessType())));
            }
        }
    }

    private void checkChargeMode(Map<String, Integer> chargeModeType, ExpressCostReportImportDto i) {
        if (StringUtils.isNotBlank((CharSequence)i.getChargeMode())) {
            if (!chargeModeType.containsKey(i.getChargeMode())) {
                this.setMsg(i, "\u8ba1\u8d39\u65b9\u5f0f\u4e0d\u6b63\u786e");
            } else {
                i.setChargeMode(String.valueOf(chargeModeType.get(i.getChargeMode())));
            }
        }
    }

    private void checkCarrierMode(List<String> carrierMode, ExpressCostReportImportDto i) {
        if (StringUtils.isNotBlank((CharSequence)i.getTransportType()) && !carrierMode.contains(i.getTransportType())) {
            this.setMsg(i, "\u627f\u8fd0\u65b9\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    private void checkShipmenetEnterprise(Map<String, CsShipmenetEnterpriseRespDto> shipmenetEnterprise, ExpressCostReportImportDto i) {
        if (StringUtils.isNotBlank((CharSequence)i.getWarehouseName())) {
            if (!shipmenetEnterprise.containsKey(i.getLogisticCompany())) {
                this.setMsg(i, "\u7269\u6d41\u516c\u53f8\u4e0d\u5b58\u5728");
            } else {
                i.setLogisticCode(shipmenetEnterprise.get(i.getLogisticCompany()).getShipmentEnterpriseCode());
            }
        }
    }

    private void checkPhysicalWareshouse(Map<String, CsPhysicsWarehousePageRespDto> whMap, ExpressCostReportImportDto i) {
        if (StringUtils.isNotBlank((CharSequence)i.getWarehouseName())) {
            if (!whMap.containsKey(i.getWarehouseName())) {
                this.setMsg(i, "\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
            } else {
                i.setWarehouseCode(whMap.get(i.getWarehouseName()).getWarehouseCode());
            }
        }
    }

    private Map<String, LogicWarehouseRespDto> getLogicWarehouseMap(Set<String> warehouseCodes) {
        Map<Object, Object> logicWarehouseMap = Maps.newHashMap();
        List warehouses = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryWarehouseByCode((List)Lists.newArrayList(warehouseCodes)));
        if (CollectionUtil.isNotEmpty((Collection)warehouses)) {
            logicWarehouseMap = warehouses.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        }
        return logicWarehouseMap;
    }

    private Map<String, CsShipmenetEnterpriseRespDto> getShipmenetEnterprise() {
        CsShipmenetEnterpriseQueryDto queryDto = new CsShipmenetEnterpriseQueryDto();
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(100));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csShipmenetEnterpriseQueryApi.queryByPage(queryDto));
        return respDtoPageInfo.getList().stream().collect(Collectors.toMap(CsShipmenetEnterpriseRespDto::getShipmentEnterpriseName, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, CsPhysicsWarehousePageRespDto> queryPhysicalWareshouseName() {
        CsPhysicsWarehousePageQueryDto csPhysicsWarehousePageQueryDto = new CsPhysicsWarehousePageQueryDto();
        csPhysicsWarehousePageQueryDto.setPageSize(Integer.valueOf(100));
        csPhysicsWarehousePageQueryDto.setPageNum(Integer.valueOf(1));
        RestResponse pageInfo = this.csPhysicsWarehouseExposedQueryApi.queryPageInfo(csPhysicsWarehousePageQueryDto);
        PageInfo page = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfo);
        return page.getList().stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseName, Function.identity(), (k1, k2) -> k1));
    }

    private void checkBookkeepingMonth(ExpressCostReportImportDto i) {
        try {
            DateUtil.parseDate((String)i.getBookkeepingMonth(), (String)"YYYY-MM");
        }
        catch (Exception e) {
            this.setMsg(i, "\u8bb0\u8d26\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e,\u683c\u5f0f\uff1aYYYY-MM");
        }
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        ExpressCostReportQueryDto params = new ExpressCostReportQueryDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (ExpressCostReportQueryDto)JSON.parseObject((String)commonReqDto.getFilter(), ExpressCostReportQueryDto.class);
        }
        params.setPageNum(Integer.valueOf(1));
        params.setPageSize(Integer.valueOf(1));
        return Math.toIntExact(Optional.ofNullable(this.expressCostDetailQueryApi.queryByPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    public void setMsg(ExpressCostReportImportDto msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getMsg())) {
            msgDto.setMsg(errorMsg);
        } else {
            msgDto.setMsg(String.format("%s\u3001%s", msgDto.getMsg(), errorMsg));
        }
    }

    private void checkDateFormat(ExpressCostReportImportDto i) {
        String outboundTime = i.getOutboundTime();
        logger.info("\u51fa\u5e93\u65e5\u671f:{}", (Object)outboundTime);
        if (StringUtils.isNotBlank((CharSequence)outboundTime)) {
            try {
                Date time = DateUtils.parseDate((String)outboundTime, (String)"yyyy-MM-dd");
                if (time == null) {
                    this.setMsg(i, "\u51fa\u5e93\u65f6\u95f4\u683c\u5f0f\u9519\u8bef,\u683c\u5f0f\uff1ayyyy-MM-dd");
                } else {
                    i.setOutboundTimeExt(DateUtils.format((Date)time));
                }
            }
            catch (Exception e) {
                this.setMsg(i, "\u51fa\u5e93\u65f6\u95f4\u683c\u5f0f\u9519\u8bef,\u683c\u5f0f\uff1ayyyy-MM-dd");
            }
        }
    }

    public static void main(String[] args) {
        Date time = new Date("2022-10-02 04:00:00");
    }

    static {
        CARRIER_MODE.add("\u9646\u8fd0");
        CARRIER_MODE.add("\u6807\u5feb");
        CARRIER_MODE.add("\u5feb\u9012\u5305\u88f9");
        CARRIER_MODE.add("\u6807\u51c6\u5feb\u9012");
        CARRIER_MODE.add("\u7279\u5feb\u4e13\u7ebf");
        CARRIER_MODE.add("\u7535\u5546\u6807\u5feb");
        CARRIER_MODE.add("\u987a\u4e30\u5361\u822a");
        CARRIER_MODE.add("\u987a\u4e30\u7279\u5feb\u5305\u88f9");
        CARRIER_MODE.add("\u987a\u4e30\u7279\u5feb");
        CARRIER_MODE.add("\u987a\u4e30\u6807\u5feb");
        CARRIER_MODE.add("\u81ea\u63d0");
        CHARGE_MODE_TYPE.put("\u6a21\u677f1", 1);
        CHARGE_MODE_TYPE.put("\u6a21\u677f2", 2);
        CHARGE_MODE_TYPE.put("\u6a21\u677f3", 3);
        CHARGE_MODE_TYPE.put("\u6a21\u677f4", 4);
        CHARGE_MODE_TYPE.put("\u6a21\u677f5", 5);
        CHARGE_MODE_TYPE.put("\u6a21\u677f6", 6);
        CHARGE_MODE_TYPE.put("\u6a21\u677f7", 7);
        CHARGE_MODE_TYPE.put("\u6a21\u677f8", 8);
        CHARGE_MODE_TYPE.put("\u6a21\u677f9", 9);
        BUSINESS_TYPE.put("\u666e\u901a\u8ba2\u5355", "common_order");
        BUSINESS_TYPE.put("\u7ecf\u9500\u8ba2\u5355", "agency_order");
        BUSINESS_TYPE.put("\u7ecf\u9500\u5546\u79ef\u5206", "integral_order");
        BUSINESS_TYPE.put("\u6d88\u8d39\u8005\u9000\u6362\u8d27", "customer_refunding_order");
        BUSINESS_TYPE.put("\u7d22\u8d54\u8ba2\u5355", "compensation_order");
        BUSINESS_TYPE.put("\u8425\u517b\u5bb6\u8d27\u8865", "replenishment_order");
        BUSINESS_TYPE.put("\u8d28\u91cf\u9000\u6362\u8d27", "quality_refunding_order");
        BUSINESS_TYPE.put("\u5c11\u8d27\u8865\u53d1", "replenish_order");
        BUSINESS_TYPE.put("\u4ed3\u5e93\u7d22\u8d54\u8865\u53d1", "claim_reissue");
        BUSINESS_TYPE.put("\u5176\u4ed6\u51fa\u5e93", "other_out_stock");
        BUSINESS_TYPE.put("\u5185\u90e8\u5206\u9500", "internal_distribution");
        BUSINESS_TYPE.put("\u4e8c\u7ea7\u5206\u9500", "secondary_distribution");
        BUSINESS_TYPE.put("\u5b50\u516c\u53f8\u76f4\u9500", "child_direct_sales");
        BUSINESS_TYPE.put("\u9884\u552e\u8ba2\u5355", "presale_order");
        BUSINESS_TYPE.put("\u8425\u517b\u5bb6\u79ef\u5206", "nutrition_integral");
        BUSINESS_TYPE.put("\u8425\u517b\u5bb6\u6d3b\u52a8", "activity_order");
        BUSINESS_TYPE.put("\u59d4\u5916\u8ba2\u5355\u9000\u8d27", "outsource_refund");
        BUSINESS_TYPE.put("\u91c7\u8d2d\u4fc3\u9500\u7269\u6599\u9000\u8d27", "purchase_refund");
        BUSINESS_TYPE.put("\u5176\u4ed6\u51fa\u5e93\u5355", "other_out");
        BUSINESS_TYPE.put("\u666e\u901a\u8c03\u62e8", "allot_out");
        BUSINESS_TYPE.put("\u5e93\u5b58\u8c03\u62e8\uff08\u8c03\u62e8\u51fa\u5e93\uff09", "allot_out_only");
    }
}

