/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.LevelEnum;
import com.dtyunxi.cis.pms.biz.export.IExportExcelHelper;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.WarehouseAreaMappingExportVo;
import com.dtyunxi.cis.pms.biz.model.WarehouseAreaMappingImportVo;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.PcpRegionReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IPcpRegionQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.IWarehouseAreaMappingApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseAreaMappingReqDto;
import com.dtyunxi.yundt.cube.center.inventory.constant.WarehouseAreaMappingTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_warehouse_area_mapping")
public class ExportWarehouseAreaMappingServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(ExportWarehouseAreaMappingServiceImpl.class);
    @Resource
    private IWarehouseAreaMappingApi warehouseAreaMappingApi;
    @Resource
    private IExportExcelHelper exportExcelHelper;
    @Resource
    private ICsPhysicsWarehouseExposedApi csPhysicsWarehouseExposedQueryApi;
    @Resource
    private IPcpRegionQueryApi pcpRegionQueryApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("\u53d1\u8d27\u89c4\u5219\u914d\u7f6e\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        WarehouseAreaMappingReqDto params = new WarehouseAreaMappingReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (WarehouseAreaMappingReqDto)JSON.parseObject((String)commonReqDto.getFilter(), WarehouseAreaMappingReqDto.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.warehouseAreaMappingApi.queryByPage(re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(item -> {
                WarehouseAreaMappingExportVo vo = new WarehouseAreaMappingExportVo();
                BeanUtils.copyProperties((Object)item, (Object)((Object)vo));
                vo.setTypeStr(item.getType());
                if (StringUtils.isNotBlank((CharSequence)item.getType()) && ObjectUtil.isNotEmpty((Object)WarehouseAreaMappingTypeEnum.forCode((String)item.getType()))) {
                    vo.setTypeStr(WarehouseAreaMappingTypeEnum.forCode((String)item.getType()).getDesc());
                }
                vo.setStatusStr(ObjectUtil.isNotEmpty((Object)item.getStatus()) && item.getStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, WarehouseAreaMappingExportVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        WarehouseAreaMappingReqDto reqDto = new WarehouseAreaMappingReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            reqDto = (WarehouseAreaMappingReqDto)JSON.parseObject((String)commonReqDto.getFilter(), WarehouseAreaMappingReqDto.class);
        }
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1));
        return Math.toIntExact(Optional.ofNullable(this.warehouseAreaMappingApi.queryByPage(reqDto).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        logger.info("\u53d1\u8d27\u89c4\u5219\u914d\u7f6e\u5012\u5165\u5bfc\u5165\uff1a{}", (Object)JSON.toJSONString((Object)obj));
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("errorList");
        ArrayList errorList = new ArrayList();
        if (saveObj != null) {
            List list = (List)saveObj;
            list.forEach(d -> {
                try {
                    RestResponseHelper.extractData((RestResponse)this.warehouseAreaMappingApi.addWarehouseAreaMapping(d));
                }
                catch (Exception e) {
                    WarehouseAreaMappingImportVo vo = new WarehouseAreaMappingImportVo();
                    vo.setProvince(d.getProvince());
                    vo.setTypeStr(WarehouseAreaMappingTypeEnum.forCode((String)d.getType()).getDesc());
                    vo.setInWarehouse(d.getInWarehouse());
                    vo.setCenterWarehouse(d.getCenterWarehouse());
                    vo.setSourceWarehouse(d.getSourceWarehouse());
                    vo.setMsg("\u65b0\u589e\u5931\u8d25\uff1a" + e.getMessage());
                    errorList.add(vo);
                }
            });
        }
        String errorMsgUrl = null;
        if (msgObj != null) {
            List list = (List)msgObj;
            errorList.addAll(list);
        }
        if (CollectionUtil.isNotEmpty(errorList)) {
            String excelName = String.format("%s%s", "\u53d1\u8d27\u89c4\u5219\u914d\u7f6e\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorList, WarehouseAreaMappingImportVo.class, null, excelName);
        }
        return errorMsgUrl;
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        logger.info("\u53d1\u8d27\u89c4\u5219\u914d\u7f6e\u5bfc\u5165\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString((Object)result.getList()));
        ArrayList<WarehouseAreaMappingImportVo> errorList = new ArrayList<WarehouseAreaMappingImportVo>();
        ArrayList<WarehouseAreaMappingReqDto> saveList = new ArrayList<WarehouseAreaMappingReqDto>();
        CsPhysicsWarehouseParamQueryDto queryDto = new CsPhysicsWarehouseParamQueryDto();
        queryDto.setWarehouseStatus("enable");
        List warehouseList = (List)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedQueryApi.queryParam(queryDto));
        List warehouseIsLogisticsList = Optional.ofNullable(warehouseList.stream().filter(o -> Objects.equals(o.getIsLogistics(), 1)).collect(Collectors.toList())).orElse(Lists.newArrayList());
        Map warehouseIsLogisticsMap = warehouseIsLogisticsList.stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseName, Function.identity(), (k1, k2) -> k1));
        Map<Object, Object> warehouseMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)warehouseList)) {
            warehouseMap = warehouseList.stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseName, Function.identity(), (k1, k2) -> k1));
            logger.info("\u83b7\u53d6\u7269\u7406\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)warehouseList));
        }
        PcpRegionReqDto regionReqDto = new PcpRegionReqDto();
        regionReqDto.setLevelId(LevelEnum.PROVINCE.getCode());
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByPage(JSON.toJSONString((Object)regionReqDto), Integer.valueOf(1), Integer.valueOf(1000)));
        Map<Object, Object> regionMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            regionMap = pageInfo.getList().stream().collect(Collectors.toMap(PcpRegionRespDto::getName, Function.identity(), (k1, k2) -> k1));
            logger.info("\u83b7\u53d6\u7701\u4efd\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo.getList()));
        }
        for (ImportBaseModeDto importDto : result.getList()) {
            WarehouseAreaMappingImportVo importVo = (WarehouseAreaMappingImportVo)importDto;
            WarehouseAreaMappingReqDto reqDto = new WarehouseAreaMappingReqDto();
            reqDto.setRemark(importVo.getRemark());
            if (ObjectUtil.isEmpty((Object)importVo.getStatus())) {
                importVo.setMsg("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199'\u542f\u52a8/\u7981\u7528'");
                errorList.add(importVo);
                continue;
            }
            reqDto.setStatus(importVo.getStatus());
            if (StringUtils.isBlank((CharSequence)importVo.getProvince())) {
                importVo.setMsg("\u6536\u8d27\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
                errorList.add(importVo);
                continue;
            }
            PcpRegionRespDto pcpRegionRespDto = (PcpRegionRespDto)regionMap.get(importVo.getProvince());
            if (ObjectUtil.isEmpty((Object)pcpRegionRespDto)) {
                importVo.setMsg("\u8be5\u7701\u4efd\u4e0d\u5b58\u5728");
                errorList.add(importVo);
                continue;
            }
            reqDto.setProvince(pcpRegionRespDto.getName());
            reqDto.setProvinceCode(pcpRegionRespDto.getCode());
            if (StringUtils.isBlank((CharSequence)importVo.getTypeStr()) || ObjectUtil.isEmpty((Object)WarehouseAreaMappingTypeEnum.forName((String)importVo.getTypeStr()))) {
                importVo.setMsg("\u53d1\u8d27\u7c7b\u578b\u5f02\u5e38");
                errorList.add(importVo);
                continue;
            }
            reqDto.setType(WarehouseAreaMappingTypeEnum.forName((String)importVo.getTypeStr()).getCode());
            if (reqDto.getType().equals(WarehouseAreaMappingTypeEnum.SALE_ORDER_OUT.getCode()) && (StringUtils.isNotBlank((CharSequence)importVo.getCenterWarehouse()) || StringUtils.isNotBlank((CharSequence)importVo.getInWarehouse()))) {
                importVo.setMsg("\u7c7b\u578b\u4e3a\u53d1\u8d27\u65f6\uff0c\u4e2d\u8f6c\u7269\u7406\u4ed3\u3001\u8c03\u5165\u7269\u7406\u4ed3\u4e0d\u80fd\u6709\u503c");
                errorList.add(importVo);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)importVo.getSourceWarehouse())) {
                importVo.setMsg("\u5bfb\u6e90\u7269\u7406\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
                errorList.add(importVo);
                continue;
            }
            CsPhysicsWarehousePageRespDto sourceWarehouse = (CsPhysicsWarehousePageRespDto)warehouseMap.get(importVo.getSourceWarehouse());
            if (ObjectUtil.isEmpty((Object)sourceWarehouse)) {
                importVo.setMsg("\u5bfb\u6e90\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
                errorList.add(importVo);
                continue;
            }
            reqDto.setSourceWarehouse(sourceWarehouse.getWarehouseName());
            reqDto.setSourceWarehouseCode(sourceWarehouse.getWarehouseCode());
            if (StringUtils.isNotBlank((CharSequence)importVo.getCenterWarehouse())) {
                CsPhysicsWarehousePageRespDto centerWarehouse = (CsPhysicsWarehousePageRespDto)warehouseIsLogisticsMap.get(importVo.getCenterWarehouse());
                if (ObjectUtil.isEmpty((Object)centerWarehouse)) {
                    importVo.setMsg("\u4e2d\u8f6c\u7269\u7406\u4ed3\u4e0d\u5b58\u5728\u6216\u8005\u8be5\u7269\u7406\u4ed3\u662f\u975e\u7269\u6d41\u4ed3");
                    errorList.add(importVo);
                    continue;
                }
                reqDto.setCenterWarehouse(centerWarehouse.getWarehouseName());
                reqDto.setCenterWarehouseCode(centerWarehouse.getWarehouseCode());
            }
            if (StringUtils.isBlank((CharSequence)importVo.getInWarehouse()) && reqDto.getType().equals(WarehouseAreaMappingTypeEnum.ALLOT_SALE.getCode())) {
                importVo.setMsg("\u8c03\u5165\u7269\u7406\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
                errorList.add(importVo);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)importVo.getInWarehouse())) {
                CsPhysicsWarehousePageRespDto inWarehouse = (CsPhysicsWarehousePageRespDto)warehouseIsLogisticsMap.get(importVo.getInWarehouse());
                if (ObjectUtil.isEmpty((Object)inWarehouse)) {
                    importVo.setMsg("\u8c03\u5165\u7269\u7406\u4ed3\u4e0d\u5b58\u5728\u6216\u8005\u8be5\u7269\u7406\u4ed3\u662f\u975e\u7269\u6d41\u4ed3");
                    errorList.add(importVo);
                    continue;
                }
                reqDto.setInWarehouse(inWarehouse.getWarehouseName());
                reqDto.setInWarehouseCode(inWarehouse.getWarehouseCode());
            }
            saveList.add(reqDto);
        }
        HashMap<String, ArrayList<WarehouseAreaMappingImportVo>> resultMap = new HashMap<String, ArrayList<WarehouseAreaMappingImportVo>>();
        resultMap.put("errorList", errorList);
        resultMap.put("saveList", saveList);
        return resultMap;
    }
}

