/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.aliyun.openservices.shade.com.google.common.collect.Maps;
import com.aliyun.openservices.shade.com.google.common.collect.Sets;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.constant.ExpressBusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.model.BaseAreaVO;
import com.dtyunxi.cis.pms.biz.model.CarrierVO;
import com.dtyunxi.cis.pms.biz.model.GetCarrierListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetGoodsListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetLogicalWarehouseListPageParams;
import com.dtyunxi.cis.pms.biz.model.GetPhysicalWarehouseListPageParams;
import com.dtyunxi.cis.pms.biz.model.GoodsVO;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportDailyDeliveryReportNoMsgVO;
import com.dtyunxi.cis.pms.biz.model.ImportDailyDeliveryReportNoVO;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.LogicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.PhysicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterAreaService;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterCarrierService;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterCustomerService;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterGoodsService;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehouseLogicalWarehouseService;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehousePhysicalWarehouseService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseOrgRespDto;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsShipmentLogisticsTypeEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportApi;
import com.yunxi.dg.base.center.report.api.inventory.IDgWarehouseAddressApi;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryReportDataSourceEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailDtEo;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailProductDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgWarehouseAddressDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgWarehouseAddressPageReqDto;
import com.yunxi.dg.base.center.report.dto.report.DailyDeliveryReportListQueryDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_report_center_daily_delivery_report_no")
public class ImportDailyDeliveryReportNoImpl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(ImportDailyDeliveryReportNoImpl.class);
    @Resource
    private IDailyDeliveryReportApi dailyDeliveryReportApi;
    @Resource
    private BasedataCenterCarrierService basedataCenterCarrierService;
    @Resource
    private BasedataCenterAreaService basedataCenterAreaService;
    @Resource
    private InventoryCenterBaseWarehousePhysicalWarehouseService inventoryCenterInquiryService;
    @Resource
    private InventoryCenterBaseWarehouseLogicalWarehouseService inventoryCenterBaseWarehouseLogicalWarehouseService;
    @Resource
    private BasedataCenterCustomerService basedataCenterCustomerService;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private BasedataCenterGoodsService basedataCenterGoodsService;
    @Resource
    private IDgWarehouseAddressApi dgWarehouseAddressApi;
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
    public static final SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy/MM/dd");
    public static final SimpleDateFormat dateFormat3 = new SimpleDateFormat("yyyy.MM.dd");
    public static final SimpleDateFormat dateFormat4 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    public static final SimpleDateFormat dateFormat5 = new SimpleDateFormat("MM\u6708dd\u65e5");

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StringUtils.isBlank((CharSequence)MDC.get((String)"yes.req.requestId"))) {
            MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        }
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportDailyDeliveryReportNoVO.class);
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u65e0\u539f\u5355\u5bfc\u5165\u96c6\u5408\uff0clist\uff1a{}", (Object)JSON.toJSONString((Object)list));
        HashSet checkRepeatData = Sets.newHashSet();
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy/MM/dd");
        list.forEach(i -> {
            ImportDailyDeliveryReportNoMsgVO msgDto = new ImportDailyDeliveryReportNoMsgVO();
            try {
                String inputDateStr = i.getOrderCreateTime();
                String inputDateStr2 = i.getOrderShippingTime();
                Date date = this.dateTransformer(inputDateStr);
                Date date2 = this.dateTransformer(inputDateStr2);
                String formattedDate = outputFormat.format(date);
                String formattedDate2 = outputFormat.format(date2);
                i.setOrderCreateTime(formattedDate);
                i.setOrderShippingTime(formattedDate2);
            }
            catch (Exception e) {
                log.info("\u683c\u5f0f\u5316\u65f6\u95f4\u5f02\u5e38");
            }
            log.info("\u5bfc\u5165\u6570\u636e\u5bf9\u8c61:{}", (Object)i);
            msgDto.setInventoryOrganizationName(i.getInventoryOrganizationName());
            msgDto.setReceivingCustomer(i.getReceivingCustomer());
            msgDto.setReceivingAddress(i.getReceivingAddress());
            msgDto.setReceivingPerson(i.getReceivingPerson());
            msgDto.setReceivingPersonPhone(i.getReceivingPersonPhone());
            msgDto.setReceivingAddressProvince(i.getReceivingAddressProvince());
            msgDto.setReceivingAddressCity(i.getReceivingAddressCity());
            msgDto.setReceivingAddressDistrict(i.getReceivingAddressDistrict());
            msgDto.setConsignmentNo(i.getConsignmentNo());
            msgDto.setDocumentNo(i.getDocumentNo());
            msgDto.setTransportNo(i.getTransportNo());
            msgDto.setTotalQuantity(i.getTotalQuantity());
            msgDto.setTotalCartons(i.getTotalCartons());
            msgDto.setTotalVolume(i.getTotalVolume());
            msgDto.setTotalWeight(i.getTotalWeight());
            msgDto.setShippingCompanyName(i.getShippingCompanyName());
            msgDto.setTransportStyle(i.getTransportStyle());
            msgDto.setLongCode(i.getLongCode());
            msgDto.setBatch(i.getBatch());
            msgDto.setQuantity(i.getQuantity());
            msgDto.setVehicleNumber(i.getVehicleNumber());
            msgDto.setCommercialOrderFlag(i.getCommercialOrderFlag());
            msgDto.setShopName(i.getShopName());
            msgDto.setRemark(i.getRemark());
            msgDto.setPhysicalWarehouse(i.getPhysicalWarehouse());
            msgDto.setOrderCreateTime(i.getOrderCreateTime());
            msgDto.setOrderShippingTime(i.getOrderShippingTime());
            msgDto.setOutNoticeNo(i.getOutNoticeNo());
            msgDto.setOutResultNo(i.getOutResultNo());
            msgDto.setPickingOrderNo(i.getPickingOrderNo());
            msgDto.setEasOrderNo(i.getEasOrderNo());
            msgDto.setE3No(i.getE3No());
            msgDto.setRelevanceNo(i.getRelevanceNo());
            msgDto.setBusinessType(i.getBusinessType());
            msgDto.setOutPhysicalWarehouseName(i.getOutPhysicalWarehouseName());
            msgDto.setOutLogicalWarehouseName(i.getOutLogicalWarehouseName());
            msgDto.setOutCargoRightName(i.getOutCargoRightName());
            msgDto.setInPhysicalWarehouseName(i.getInPhysicalWarehouseName());
            msgDto.setInLogicalWarehouseName(i.getInLogicalWarehouseName());
            msgDto.setInCargoRightName(i.getInCargoRightName());
            log.info("\u5f85\u6821\u9a8c\u4fe1\u606f:{},:{}", (Object)i, (Object)msgDto);
            this.checkForm((ImportDailyDeliveryReportNoVO)((Object)i), msgDto);
            log.info("\u9519\u8bef\u4fe1\u606f:{}", (Object)msgDto);
            if (null != i.getConsignmentNo()) {
                String ocs = i.getConsignmentNo() + i.getLongCode() + i.getBatch();
                this.checkRepeatData(ocs, checkRepeatData, msgDto);
            }
            if (StringUtils.isNotBlank((CharSequence)msgDto.getErrorMsg())) {
                msgList.add(msgDto);
            } else {
                saveList.add(i);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u65e0\u539f\u5355\u5bfc\u5165\u6210\u529f\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)saveList));
        log.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u65e0\u539f\u5355\u5bfc\u5165\u5931\u8d25\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)msgList));
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        Map map = (Map)obj;
        HashMap<String, Long> ids = new HashMap<String, Long>();
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        List saveList = (List)saveObj;
        List msgList = (List)msgObj;
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        if (CollectionUtil.isNotEmpty((Collection)saveList)) {
            HashMap saveMap = Maps.newHashMap();
            log.info("===\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u65e0\u539f\u5355\u5bfc\u5165\u6570\u636e===saveList:{}", (Object)JSON.toJSONString((Object)saveList));
            for (ImportDailyDeliveryReportNoVO v : saveList) {
                ImportDailyDeliveryReportNoMsgVO msgVO;
                DailyDeliveryReportDto d = new DailyDeliveryReportDto();
                DailyDeliveryReportDetailProductDto productDto = new DailyDeliveryReportDetailProductDto();
                String key = v.getConsignmentNo();
                if (saveMap.containsKey(key)) {
                    ImportDailyDeliveryReportNoVO one = (ImportDailyDeliveryReportNoVO)((Object)saveMap.get(key));
                    Long id = (Long)ids.get(one.getConsignmentNo());
                    try {
                        productDto.setDailyDeliveryReportId(id);
                        Optional.ofNullable(v).ifPresent(val -> {
                            productDto.setLongCode(val.getLongCode());
                            productDto.setBatch(val.getBatch());
                            productDto.setQuantity(ObjectUtils.isNotEmpty((Object)val.getQuantity()) ? new BigDecimal(val.getQuantity()) : null);
                            productDto.setProductName(val.getProductName());
                            productDto.setCartonQuantity(val.getCartonQuantity());
                            productDto.setSmallBottles(val.getSmallBottles());
                            productDto.setWeight(val.getWeight());
                            productDto.setVolume(val.getVolume());
                            productDto.setInternalTransaction(val.getInternalTransaction());
                            productDto.setRecommendPrice(val.getRecommendPrice());
                            productDto.setDr(Integer.valueOf(0));
                        });
                        this.dailyDeliveryReportApi.add(productDto);
                    }
                    catch (Exception e) {
                        log.error("\u8bf7\u6c42\u65b0\u589e\u5931\u8d25\uff1a{}" + e.getMessage());
                        log.error(e.getMessage(), (Throwable)e);
                        msgVO = (ImportDailyDeliveryReportNoMsgVO)BeanUtil.copyProperties((Object)((Object)v), ImportDailyDeliveryReportNoMsgVO.class, (String[])new String[0]);
                        msgVO.setErrorMsg("\u8bf7\u6c42\u5931\u8d25\uff1a" + e.getMessage());
                        msgList.add(msgVO);
                    }
                    continue;
                }
                saveMap.put(key, v);
                DateTimeFormatter input = DateTimeFormatter.ofPattern("yyyy/MM/dd");
                DateTimeFormatter output = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                try {
                    Optional.ofNullable(v).ifPresent(val -> {
                        d.setPhysicalWarehouse(val.getPhysicalWarehouse());
                        d.setPhysicalWarehouseCode(val.getPhysicalWarehouseCode());
                        d.setInventoryOrganizationName(val.getInventoryOrganizationName());
                        d.setInventoryOrganizationCode(val.getInventoryOrganizationCode());
                        d.setInventoryOrganizationId(val.getInventoryOrganizationId());
                        try {
                            LocalDate creatTime = LocalDate.parse(val.getOrderCreateTime(), input);
                            LocalDate shippingTime = LocalDate.parse(val.getOrderShippingTime(), input);
                            LocalDateTime creatTimeObj = creatTime.atStartOfDay();
                            LocalDateTime shippingTimeObj = shippingTime.atStartOfDay();
                            d.setOrderCreateTime(Date.from(creatTimeObj.atZone(ZoneId.systemDefault()).toInstant()));
                            d.setOrderShippingTime(Date.from(shippingTimeObj.atZone(ZoneId.systemDefault()).toInstant()));
                        }
                        catch (Exception e) {
                            log.info("\u65e0\u539f\u5355\u5bfc\u5165\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
                        }
                        d.setReceivingCustomer(val.getReceivingCustomer());
                        d.setReceivingAddress(val.getReceivingAddress());
                        d.setReceivingPerson(val.getReceivingPerson());
                        d.setReceivingPersonPhone(val.getReceivingPersonPhone());
                        d.setReceivingAddressProvince(val.getReceivingAddressProvince());
                        d.setReceivingAddressProvinceCode(val.getReceivingAddressProvinceCode());
                        d.setReceivingAddressCity(val.getReceivingAddressCity());
                        d.setReceivingAddressCityCode(val.getReceivingAddressCityCode());
                        d.setReceivingAddressDistrict(val.getReceivingAddressDistrict());
                        d.setReceivingAddressDistrictCode(val.getReceivingAddressDistrictCode());
                        d.setConsignmentNo(val.getConsignmentNo());
                        d.setEasOrderNo(val.getEasOrderNo());
                        d.setE3No(val.getE3No());
                        d.setRelevanceNo(val.getRelevanceNo());
                        d.setBusinessType(val.getBusinessType());
                        d.setOutNoticeNo(val.getOutNoticeNo());
                        d.setOutResultNo(val.getOutResultNo());
                        d.setTransportNo(val.getTransportNo());
                        d.setDocumentNo(val.getDocumentNo());
                        d.setPickingOrderNo(val.getPickingOrderNo());
                        d.setTotalQuantity(ObjectUtils.isNotEmpty((Object)val.getTotalQuantity()) ? new BigDecimal(val.getTotalQuantity()) : null);
                        d.setTotalCartons(ObjectUtils.isNotEmpty((Object)val.getTotalCartons()) ? new BigDecimal(val.getTotalCartons()) : null);
                        d.setTotalVolume(ObjectUtils.isNotEmpty((Object)val.getTotalVolume()) ? new BigDecimal(val.getTotalVolume()) : null);
                        d.setTotalWeight(ObjectUtils.isNotEmpty((Object)val.getTotalWeight()) ? new BigDecimal(val.getTotalWeight()) : null);
                        d.setShippingCompanyName(val.getShippingCompanyName());
                        d.setShippingCompany(val.getShippingCompany());
                        d.setShipmentEnterpriseName(val.getShippingCompanyName());
                        d.setShipmentEnterpriseCode(val.getShippingCompany());
                        d.setTransportStyleCode(val.getTransportStyleCode());
                        d.setTransportStyle(val.getTransportStyle());
                        d.setVehicleNumber(val.getVehicleNumber());
                        d.setCommercialOrderFlag(Integer.valueOf("\u662f".equals(val.getCommercialOrderFlag()) ? 1 : 0));
                        d.setShopName(val.getShopName());
                        d.setLogicWarehouse(val.getOutLogicalWarehouseName());
                        d.setLogicWarehouseCode(val.getLogicWarehouseCode());
                        d.setOutInventoryOrg(val.getOutCargoRightName());
                        d.setOutInventoryOrgId(val.getOutInventoryOrgId());
                        d.setInPhysicalWarehouse(val.getInPhysicalWarehouseName());
                        d.setInPhysicalWarehouseCode(val.getInPhysicalWarehouseCode());
                        d.setInLogicWarehouse(val.getInLogicalWarehouseName());
                        d.setInLogicWarehouseCode(val.getInLogicWarehouseCode());
                        d.setInInventoryOrg(val.getInCargoRightName());
                        d.setInInventoryOrgId(val.getInInventoryOrgId());
                        d.setRemark(val.getRemark());
                        d.setMuchDeliveryFlag(Integer.valueOf(0));
                        d.setBillingCartons(d.getTotalCartons());
                        d.setBillingVolume(d.getTotalVolume());
                        d.setBillingWeight(d.getTotalWeight());
                        d.setStartProvince(val.getStartProvince());
                        d.setStartProvinceCode(val.getStartProvinceCode());
                        d.setStartCity(val.getStartCity());
                        d.setStartCityCode(val.getStartCityCode());
                    });
                    d.setDataSource(DailyDeliveryReportDataSourceEnum.NOT_IMP.getCode());
                    log.info("\u65e0\u539f\u5355\u4e3b\u8868\u63d2\u5165\u5bf9\u8c61:{}", (Object)d);
                    Long id = (Long)this.dailyDeliveryReportApi.addDailyDeliveryReport(d).getData();
                    ids.put(d.getConsignmentNo(), id);
                    log.info("\u65e0\u539f\u5355\u4e3b\u8868\u63d2\u5165\u6210\u529f\u7684\u5bf9\u8c61");
                    productDto.setDailyDeliveryReportId(id);
                    Optional.ofNullable(v).ifPresent(val -> {
                        productDto.setLongCode(val.getLongCode());
                        productDto.setBatch(val.getBatch());
                        productDto.setQuantity(ObjectUtils.isNotEmpty((Object)val.getQuantity()) ? new BigDecimal(val.getQuantity()) : null);
                        productDto.setProductName(val.getProductName());
                        productDto.setCartonQuantity(val.getCartonQuantity());
                        productDto.setSmallBottles(val.getSmallBottles());
                        productDto.setWeight(val.getWeight());
                        productDto.setVolume(val.getVolume());
                        productDto.setInternalTransaction(val.getInternalTransaction());
                        productDto.setRecommendPrice(val.getRecommendPrice());
                        productDto.setDr(Integer.valueOf(0));
                    });
                    log.info("\u65e0\u539f\u5355\u660e\u7ec6\u8868\u63d2\u5165\u5bf9\u8c61:{}", (Object)productDto);
                    this.dailyDeliveryReportApi.add(productDto);
                }
                catch (Exception e) {
                    log.error("\u8bf7\u6c42\u65b0\u589e\u660e\u7ec6\u5931\u8d25\uff1a{}" + e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    msgVO = (ImportDailyDeliveryReportNoMsgVO)BeanUtil.copyProperties((Object)((Object)v), ImportDailyDeliveryReportNoMsgVO.class, (String[])new String[0]);
                    msgVO.setErrorMsg("\u8bf7\u6c42\u5931\u8d25\uff1a" + e.getMessage());
                    msgList.add(msgVO);
                }
            }
        }
        String errorMsgUrl = null;
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = String.format("%s%s", "\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u65e0\u539f\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportDailyDeliveryReportNoMsgVO.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private void checkForm(ImportDailyDeliveryReportNoVO i, ImportDailyDeliveryReportNoMsgVO msgDto) {
        Object pa;
        String s;
        PageInfo list;
        StringBuilder errorMsg = new StringBuilder();
        List lists = (List)this.logicWarehouseQueryApi.queryOrgList().getData();
        if (null == i.getInventoryOrganizationName() || i.getInventoryOrganizationName().isEmpty()) {
            errorMsg.append("\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a;");
        } else {
            boolean result = false;
            for (LogicWarehouseOrgRespDto d : lists) {
                if (!d.getOrgName().equals(i.getInventoryOrganizationName())) continue;
                result = true;
                i.setInventoryOrganizationId(d.getOrgId());
                i.setInventoryOrganizationCode(d.getOrgCode());
                break;
            }
            if (!result) {
                errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u5e93\u5b58\u7ec4\u7ec7;");
            }
        }
        if (null != i.getOrderCreateTime()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
            sdf.setLenient(false);
            try {
                sdf.parse(i.getOrderCreateTime());
            }
            catch (ParseException e) {
                errorMsg.append("\u8ba2\u5355\u521b\u5efa\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e;");
            }
        } else {
            errorMsg.append("\u8ba2\u5355\u65f6\u95f4\u4e3a\u7a7a;");
        }
        if (null != i.getOrderShippingTime()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
            sdf.setLenient(false);
            try {
                sdf.parse(i.getOrderShippingTime());
            }
            catch (ParseException e) {
                errorMsg.append("\u8ba2\u5355\u53d1\u8fd0\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e;");
            }
        } else {
            errorMsg.append("\u53d1\u8fd0\u65e5\u671f\u4e3a\u7a7a;");
        }
        GetCarrierListPageParams para = new GetCarrierListPageParams();
        para.setPageNum(1);
        para.setPageSize(100);
        this.fillRegion(i, errorMsg);
        if (null != i.getConsignmentNo() && !i.getConsignmentNo().isEmpty()) {
            DailyDeliveryReportListQueryDto dto = new DailyDeliveryReportListQueryDto();
            dto.setOrderNumber(i.getConsignmentNo());
            list = (PageInfo)this.dailyDeliveryReportApi.queryByPage(dto, Integer.valueOf(1), Integer.valueOf(100)).getData();
            if (null != list && !list.getList().isEmpty()) {
                errorMsg.append("\u8be5\u6258\u8fd0\u5355\u53f7\u5df2\u5b58\u5728;");
            }
        } else {
            errorMsg.append("\u6258\u8fd0\u5355\u53f7\u4e3a\u7a7a;");
        }
        if (null != i.getEasOrderNo() && !i.getEasOrderNo().isEmpty() && !i.getEasOrderNo().matches("^[A-Za-z0-9-]+$")) {
            errorMsg.append("EAS\u5355\u53f7\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        if (null != i.getE3No() && !i.getE3No().isEmpty() && !i.getE3No().matches("[a-zA-Z0-9]+")) {
            errorMsg.append("E3\u5355\u53f7\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        if (null != i.getRelevanceNo() && !i.getRelevanceNo().isEmpty() && !i.getRelevanceNo().matches("[a-zA-Z0-9]+")) {
            errorMsg.append("\u5173\u8054\u5355\u53f7\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        if (null != i.getBusinessType() && !i.getBusinessType().isEmpty() && null == (s = ExpressBusinessTypeEnum.getNameByType(i.getBusinessType()))) {
            errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u4e1a\u52a1\u7c7b\u578b;");
        }
        if (null != i.getOutResultNo() && !i.getOutResultNo().isEmpty() && !i.getOutResultNo().matches("[a-zA-Z0-9]+")) {
            errorMsg.append("\u51fa\u5e93\u7ed3\u679c\u5355\u53f7\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        if (null != i.getOutNoticeNo() && !i.getOutNoticeNo().isEmpty() && !i.getOutNoticeNo().matches("[a-zA-Z0-9]+")) {
            errorMsg.append("\u51fa\u5e93\u901a\u77e5\u5355\u53f7\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        if (null == i.getTransportNo() || !i.getTransportNo().isEmpty()) {
            // empty if block
        }
        if (null != i.getDocumentNo() && !i.getDocumentNo().isEmpty() && !i.getDocumentNo().matches("[a-zA-Z0-9]+")) {
            errorMsg.append("\u51fa\u5e93\u5355\u53f7\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        if (null != i.getPickingOrderNo() && !i.getPickingOrderNo().isEmpty() && !i.getPickingOrderNo().matches("[a-zA-Z0-9]+")) {
            errorMsg.append("\u62e3\u8d27\u8fd4\u56de\u5355\u53f7\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        if (null != i.getTotalQuantity() && !i.getTotalQuantity().isEmpty() && !i.getTotalQuantity().matches("\\d+")) {
            errorMsg.append("\u603b\u6570\u91cf\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        if (null != i.getTotalCartons() && !i.getTotalCartons().isEmpty()) {
            if (!i.getTotalCartons().matches("\\d+")) {
                errorMsg.append("\u603b\u4ef6\u6570\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
            }
        } else {
            errorMsg.append("WMS\u7bb1\u6570\u4e3a\u7a7a;");
        }
        if (null != i.getTotalVolume() && !i.getTotalVolume().isEmpty()) {
            if (!i.getTotalVolume().matches("^\\d+(\\.\\d+)?$")) {
                errorMsg.append("\u4f53\u79ef\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
            }
        } else {
            errorMsg.append("WMS\u4f53\u79ef\u4e3a\u7a7a;");
        }
        if (null != i.getTotalWeight() && !i.getTotalWeight().isEmpty()) {
            if (!i.getTotalWeight().matches("^\\d+(\\.\\d+)?$")) {
                errorMsg.append("\u91cd\u91cf\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
            }
        } else {
            errorMsg.append("WMS\u91cd\u91cf\u4e3a\u7a7a;");
        }
        CarrierVO vo = new CarrierVO();
        if (null == i.getShippingCompanyName() || i.getShippingCompanyName().isEmpty()) {
            errorMsg.append("\u7269\u6d41\u516c\u53f8\u4e3a\u7a7a;");
        } else {
            para.setCarrierName(i.getShippingCompanyName());
            list = (PageInfo)this.basedataCenterCarrierService.getCarrierListPage(para).getData();
            if (null == list) {
                errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u7269\u6d41\u516c\u53f8;");
            } else {
                boolean r = false;
                for (CarrierVO carrierVO : list.getList()) {
                    if (!carrierVO.getCarrierName().equals(i.getShippingCompanyName())) continue;
                    r = true;
                    vo = carrierVO;
                    i.setShippingCompany(vo.getCarrierCode());
                }
                if (!r) {
                    errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u7269\u6d41\u516c\u53f8;");
                }
            }
        }
        if (null == i.getTransportStyle() || i.getTransportStyle().isEmpty() || null == i.getShippingCompanyName() || i.getShippingCompanyName().isEmpty()) {
            errorMsg.append("\u7269\u6d41\u516c\u53f8+\u627f\u8fd0\u65b9\u5f0f\u4e3a\u7a7a;");
        } else {
            List<String> l = vo.getLogisticsType();
            boolean result = false;
            if (null != l && !l.isEmpty()) {
                for (String string : l) {
                    if (!CsShipmentLogisticsTypeEnum.getDescByType((Integer)Integer.valueOf(string)).equals(i.getTransportStyle())) continue;
                    result = true;
                    i.setTransportStyleCode(string);
                    break;
                }
            }
            if (!result) {
                errorMsg.append("\u8be5\u7269\u6d41\u516c\u53f8+\u627f\u8fd0\u65b9\u5f0f\u4e0d\u5b58\u5728;");
            }
        }
        if (!(null == i.getCommercialOrderFlag() || i.getCommercialOrderFlag().isEmpty() || i.getCommercialOrderFlag().equals("\u662f") || i.getCommercialOrderFlag().equals("\u5426"))) {
            errorMsg.append("\u65e0\u6cd5\u5224\u65ad\u662f\u5426\u4e3a\u7535\u5546\u5355;");
        }
        if (null != i.getLongCode() && !i.getLongCode().isEmpty()) {
            pa = new GetGoodsListPageParams();
            ((GetGoodsListPageParams)pa).setPageNum(1);
            ((GetGoodsListPageParams)pa).setPageSize(100);
            ((GetGoodsListPageParams)pa).setGoodsLongCode(i.getLongCode());
            PageInfo list2 = (PageInfo)this.basedataCenterGoodsService.getGoodsListPage((GetGoodsListPageParams)pa).getData();
            if (null == list2) {
                msgDto.setErrorMsg("\u4e0d\u5b58\u5728\u8be5\u5546\u54c1\u4fe1\u606f");
            } else {
                boolean r = false;
                for (Object v : list2.getList()) {
                    if (!((GoodsVO)v).getGoodsLongCode().equals(i.getLongCode())) continue;
                    r = true;
                    ArrayList<String> codes = new ArrayList<String>();
                    codes.add(i.getLongCode());
                    Map map = (Map)this.dailyDeliveryReportApi.getItemByLongCode(codes).getData();
                    DailyDeliveryReportDetailDtEo dteo = (DailyDeliveryReportDetailDtEo)map.get(i.getLongCode());
                    i.setProductName(dteo.getProductName());
                    i.setCartonQuantity(dteo.getCartonQuantity());
                    i.setSmallBottles(dteo.getSmallBottles());
                    i.setWeight(dteo.getWeight());
                    i.setVolume(dteo.getVolume());
                    i.setInternalTransaction(dteo.getInternalTransaction());
                    i.setRecommendPrice(dteo.getRecommendPrice());
                }
                if (!r) {
                    msgDto.setErrorMsg("\u4e0d\u5b58\u5728\u8be5\u5546\u54c1\u4fe1\u606f");
                }
            }
        }
        if (null != i.getBatch() && !i.getBatch().isEmpty() && !i.getBatch().matches("^[a-zA-Z0-9-]+$")) {
            errorMsg.append("\u6279\u6b21\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        if (null != i.getQuantity() && !i.getQuantity().isEmpty() && !i.getTotalCartons().matches("\\d+")) {
            errorMsg.append("\u51fa\u5e93\u6570\u91cf\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        pa = new GetPhysicalWarehouseListPageParams();
        ((GetPhysicalWarehouseListPageParams)pa).setPageNum(1);
        ((GetPhysicalWarehouseListPageParams)pa).setPageSize(100);
        GetLogicalWarehouseListPageParams par = new GetLogicalWarehouseListPageParams();
        par.setPageNum(1);
        par.setPageSize(100);
        if (null == i.getPhysicalWarehouse() || i.getPhysicalWarehouse().isEmpty()) {
            errorMsg.append("\u7269\u7406\u4ed3\u4e3a\u7a7a;");
        } else {
            ((GetPhysicalWarehouseListPageParams)pa).setWarehouseName(i.getPhysicalWarehouse());
            PageInfo list3 = (PageInfo)this.inventoryCenterInquiryService.getPhysicalWarehouseListPage((GetPhysicalWarehouseListPageParams)pa).getData();
            if (null == list3) {
                errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u7269\u7406\u4ed3;");
            } else {
                boolean bl;
                boolean bl2 = false;
                for (Object v : list3.getList()) {
                    if (!((PhysicalWarehouseVO)v).getWarehouseName().equals(i.getPhysicalWarehouse())) continue;
                    bl = true;
                    i.setPhysicalWarehouseCode(((PhysicalWarehouseVO)v).getWarehouseCode());
                }
                if (!bl) {
                    errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u7269\u7406\u4ed3;");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)i.getPhysicalWarehouseCode())) {
                DgWarehouseAddressPageReqDto dgWarehouseAddressPageReqDto = new DgWarehouseAddressPageReqDto();
                dgWarehouseAddressPageReqDto.setWarehouseCode(i.getPhysicalWarehouseCode());
                dgWarehouseAddressPageReqDto.setValidFlag("enable");
                List warehouseAddressDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgWarehouseAddressApi.queryList(dgWarehouseAddressPageReqDto));
                if (CollectionUtil.isNotEmpty((Collection)warehouseAddressDtoList)) {
                    DgWarehouseAddressDto dgWarehouseAddressDto = (DgWarehouseAddressDto)warehouseAddressDtoList.get(0);
                    i.setStartProvince(dgWarehouseAddressDto.getProvince());
                    i.setStartProvinceCode(dgWarehouseAddressDto.getProvinceCode());
                    i.setStartCity(dgWarehouseAddressDto.getCity());
                    i.setStartCityCode(dgWarehouseAddressDto.getCityCode());
                }
            }
        }
        if (null != i.getOutPhysicalWarehouseName() && !i.getOutPhysicalWarehouseName().isEmpty()) {
            ((GetPhysicalWarehouseListPageParams)pa).setWarehouseName(i.getOutPhysicalWarehouseName());
            PageInfo list4 = (PageInfo)this.inventoryCenterInquiryService.getPhysicalWarehouseListPage((GetPhysicalWarehouseListPageParams)pa).getData();
            if (null == list4) {
                errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u8c03\u51fa\u7269\u7406\u4ed3;");
            } else {
                boolean bl;
                boolean bl3 = false;
                for (Object v : list4.getList()) {
                    if (!((PhysicalWarehouseVO)v).getWarehouseName().equals(i.getOutPhysicalWarehouseName())) continue;
                    bl = true;
                }
                if (!bl) {
                    errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u8c03\u51fa\u7269\u7406\u4ed3;");
                }
            }
        }
        if (null != i.getOutLogicalWarehouseName() && !i.getOutLogicalWarehouseName().isEmpty()) {
            par.setWarehouseName(i.getOutLogicalWarehouseName());
            PageInfo list5 = (PageInfo)this.inventoryCenterBaseWarehouseLogicalWarehouseService.getLogicalWarehouseListPage(par).getData();
            if (null == list5) {
                errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u8c03\u51fa\u903b\u8f91\u4ed3;");
            } else {
                boolean bl;
                boolean bl4 = false;
                for (Object v : list5.getList()) {
                    if (!((LogicalWarehouseVO)v).getWarehouseName().equals(i.getOutLogicalWarehouseName())) continue;
                    bl = true;
                    i.setLogicWarehouseCode(((LogicalWarehouseVO)v).getWarehouseCode());
                }
                if (!bl) {
                    errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u8c03\u51fa\u903b\u8f91\u4ed3;");
                }
            }
        }
        if (null != i.getOutCargoRightName() && !i.getOutCargoRightName().isEmpty()) {
            boolean result = false;
            for (Object d : lists) {
                if (!d.getOrgName().equals(i.getOutCargoRightName())) continue;
                result = true;
                i.setOutInventoryOrgId(d.getOrgCode());
                break;
            }
            if (!result) {
                errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u8c03\u51fa\u5e93\u5b58\u7ec4\u7ec7;");
            }
        }
        if (null != i.getInPhysicalWarehouseName() && !i.getInPhysicalWarehouseName().isEmpty()) {
            ((GetPhysicalWarehouseListPageParams)pa).setWarehouseName(i.getInPhysicalWarehouseName());
            PageInfo list6 = (PageInfo)this.inventoryCenterInquiryService.getPhysicalWarehouseListPage((GetPhysicalWarehouseListPageParams)pa).getData();
            if (null == list6) {
                errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u8c03\u5165\u7269\u7406\u4ed3;");
            } else {
                boolean bl;
                boolean bl5 = false;
                for (Object v : list6.getList()) {
                    if (!((PhysicalWarehouseVO)v).getWarehouseName().equals(i.getInPhysicalWarehouseName())) continue;
                    bl = true;
                    i.setInPhysicalWarehouseCode(((PhysicalWarehouseVO)v).getWarehouseCode());
                }
                if (!bl) {
                    errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u8c03\u5165\u7269\u7406\u4ed3;");
                }
            }
        }
        if (null != i.getInLogicalWarehouseName() && !i.getInLogicalWarehouseName().isEmpty()) {
            par.setWarehouseName(i.getInLogicalWarehouseName());
            PageInfo list7 = (PageInfo)this.inventoryCenterBaseWarehouseLogicalWarehouseService.getLogicalWarehouseListPage(par).getData();
            if (null == list7) {
                errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u8c03\u5165\u903b\u8f91\u4ed3;");
            } else {
                boolean bl;
                boolean bl6 = false;
                for (Object v : list7.getList()) {
                    if (!((LogicalWarehouseVO)v).getWarehouseName().equals(i.getInLogicalWarehouseName())) continue;
                    bl = true;
                    i.setInLogicWarehouseCode(((LogicalWarehouseVO)v).getWarehouseCode());
                }
                if (!bl) {
                    errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u8c03\u5165\u903b\u8f91\u4ed3;");
                }
            }
        }
        if (null != i.getInCargoRightName() && !i.getInCargoRightName().isEmpty()) {
            boolean result = false;
            for (Object d : lists) {
                if (!d.getOrgName().equals(i.getInCargoRightName())) continue;
                result = true;
                i.setInInventoryOrgId(d.getOrgCode());
                break;
            }
            if (!result) {
                errorMsg.append("\u4e0d\u5b58\u5728\u8be5\u8c03\u5165\u5e93\u5b58\u7ec4\u7ec7;");
            }
        }
        msgDto.setErrorMsg(errorMsg.toString());
    }

    private void checkRepeatData(String uniqueKey, Set<String> checkRepeatData, ImportDailyDeliveryReportNoMsgVO msgDto) {
        if (checkRepeatData.contains(uniqueKey)) {
            this.setErrorMsg(msgDto, "\u6570\u636e\u91cd\u590d;");
        } else {
            checkRepeatData.add(uniqueKey);
        }
    }

    private void setErrorMsg(ImportDailyDeliveryReportNoMsgVO msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setErrorMsg(errorMsg);
        } else {
            msgDto.setErrorMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), errorMsg));
        }
    }

    private Date dateTransformer(String dataStr) {
        Date date;
        block13: {
            log.info("\u65e5\u671f\u8f6c\u6362\u5165\u53c2\u5b57\u7b26\u4e32\uff1a{}", (Object)dataStr);
            date = null;
            try {
                date = dateFormat.parse(dataStr);
            }
            catch (ParseException e1) {
                try {
                    date = dateFormat1.parse(dataStr);
                }
                catch (ParseException e2) {
                    try {
                        date = dateFormat2.parse(dataStr);
                    }
                    catch (ParseException e3) {
                        try {
                            date = dateFormat3.parse(dataStr);
                        }
                        catch (ParseException e4) {
                            try {
                                date = dateFormat4.parse(dataStr);
                            }
                            catch (ParseException e5) {
                                try {
                                    date = dateFormat5.parse(dataStr);
                                    Calendar calendar = Calendar.getInstance();
                                    calendar.setTime(date);
                                    calendar.set(1, Calendar.getInstance().get(1));
                                    date = calendar.getTime();
                                }
                                catch (ParseException e) {
                                    if (dataStr.length() == 5) {
                                        date = DateUtil.getJavaDate((double)new Double(dataStr));
                                        break block13;
                                    }
                                    log.info("\u8f93\u5165\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)dataStr);
                                }
                            }
                        }
                    }
                }
            }
        }
        log.info("\u65e5\u671f\u8f6c\u6362\u7ed3\u679c\uff1a{}", (Object)date);
        return date;
    }

    private void fillRegion(ImportDailyDeliveryReportNoVO vo, StringBuilder errorMsg) {
        List baseAres = (List)this.basedataCenterAreaService.getBaseAreaTreeByLevel("3").getData();
        if (CollectionUtil.isEmpty((Collection)baseAres)) {
            errorMsg.append("\u7cfb\u7edf\u7f3a\u5c11\u884c\u653f\u533a\u57df\u4fe1\u606f;");
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)vo.getReceivingAddressProvince())) {
                BaseAreaVO province = baseAres.stream().filter(f -> f.getName().equals(vo.getReceivingAddressProvince())).findFirst().orElse(null);
                if (ObjectUtil.isEmpty((Object)province)) {
                    errorMsg.append("\u5339\u914d\u7701\u4efd\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u7701\u4efd\u4fe1\u606f;");
                    return;
                }
                vo.setReceivingAddressProvinceCode(province.getCode());
                if (StringUtils.isNotBlank((CharSequence)vo.getReceivingAddressCity())) {
                    if (CollectionUtil.isEmpty(province.getChildren())) {
                        errorMsg.append("\u5339\u914d\u57ce\u5e02\u5f02\u5e38\uff0c\u7cfb\u7edf\u7f3a\u5c11\u57ce\u5e02\u4fe1\u606f");
                        return;
                    }
                    BaseAreaVO city = province.getChildren().stream().filter(f -> f.getName().equals(vo.getReceivingAddressCity())).findFirst().orElse(null);
                    if (ObjectUtil.isEmpty((Object)city)) {
                        errorMsg.append("\u5339\u914d\u57ce\u5e02\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u57ce\u5e02\u4fe1\u606f;");
                        return;
                    }
                    vo.setReceivingAddressCityCode(city.getCode());
                    if (StringUtils.isNotBlank((CharSequence)vo.getReceivingAddressDistrict())) {
                        if (CollectionUtil.isEmpty(city.getChildren())) {
                            errorMsg.append("\u5339\u914d\u533a\u57df\u5f02\u5e38\uff0c\u7cfb\u7edf\u7f3a\u5c11\u533a\u57df\u4fe1\u606f");
                            return;
                        }
                        BaseAreaVO district = city.getChildren().stream().filter(f -> f.getName().equals(vo.getReceivingAddressDistrict())).findFirst().orElse(null);
                        if (ObjectUtil.isEmpty((Object)district)) {
                            errorMsg.append("\u5339\u914d\u533a\u57df\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u533a\u57df\u4fe1\u606f;");
                            return;
                        }
                        vo.setReceivingAddressDistrictCode(district.getCode());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5339\u914d\u7701\u5e02\u533a\u5f02\u5e38:" + e);
            errorMsg.append("\u5339\u914d\u7701\u5e02\u533a\u5f02\u5e38\uff1a").append(e.getMessage()).append(";");
        }
    }
}

