/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.model.BaseDictVO;
import com.dtyunxi.cis.pms.biz.service.CommonService;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class CommonServiceServiceImpl
implements CommonService {
    @Resource
    private IDictQueryApi dictQueryApi;

    @Override
    public RestResponse<PageInfo<BaseDictVO>> getSystemBaseDict(@ApiParam(value="") @Valid @RequestParam(value="groupKey", required=false) String groupKey) {
        if (StringUtils.isBlank((CharSequence)groupKey)) {
            throw new BizException("groupKey\u4e0d\u80fd\u4e3anull");
        }
        List<String> strings = Arrays.asList(groupKey.split(","));
        PageInfo pageInfo = new PageInfo();
        ArrayList list = new ArrayList();
        HashSet baseDictVOS = Sets.newHashSet();
        for (String key : strings) {
            List dictDtos = (List)RestResponseHelper.extractData((RestResponse)this.dictQueryApi.queryByGroupCodeV3(null, key));
            dictDtos.stream().map(o -> {
                BaseDictVO vo = new BaseDictVO();
                BeanUtils.copyProperties((Object)o, (Object)vo);
                vo.setCode(o.getCode());
                vo.setValue(o.getCode());
                vo.setStatement(o.getStatement());
                vo.setLabel(o.getValue());
                vo.setText(o.getValue());
                baseDictVOS.add(vo);
                return vo;
            }).collect(Collectors.toList());
        }
        Iterator iterator = baseDictVOS.iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<BaseDictVO> getSystemBaseDictDetail(@ApiParam(value="") @Valid @RequestParam(value="groupKey", required=false) String groupKey, @ApiParam(value="") @Valid @RequestParam(value="code", required=false) String code) {
        if (StringUtils.isBlank((CharSequence)groupKey) || StringUtils.isBlank((CharSequence)code)) {
            throw new BizException("groupKey\u6216code\u4e0d\u80fd\u4e3anull");
        }
        DictDto detailData = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApi.queryByGroupCodeAndCodeV3(null, groupKey, code));
        BaseDictVO vo = new BaseDictVO();
        if (detailData == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)detailData, (Object)vo);
        vo.setCode(detailData.getCode());
        vo.setValue(detailData.getCode());
        vo.setStatement(detailData.getStatement());
        vo.setLabel(detailData.getValue());
        vo.setText(detailData.getValue());
        return new RestResponse((Object)vo);
    }
}

