/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.constant.LogisticAppointAreaConstant;
import com.dtyunxi.cis.pms.biz.model.AppointAreaImportFile;
import com.dtyunxi.cis.pms.biz.model.AppointAreaVO;
import com.dtyunxi.cis.pms.biz.model.GetAppointAreaListParams;
import com.dtyunxi.cis.pms.biz.model.GetLogisticsFreightConfigListParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.InlineObject;
import com.dtyunxi.cis.pms.biz.model.InlineObject1;
import com.dtyunxi.cis.pms.biz.model.LogisticsFreightConfigParams;
import com.dtyunxi.cis.pms.biz.model.LogisticsFreightConfigVO;
import com.dtyunxi.cis.pms.biz.model.SumbitAppointAreaParams;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateLowestDto;
import com.dtyunxi.cis.pms.biz.service.ReportCenterLogisticsFreightLogisticsFreightConfigService;
import com.dtyunxi.cis.pms.biz.utils.DateTimeUtils;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.finance.api.ILogisticApi;
import com.dtyunxi.finance.api.dto.request.logistic.AppointAreaQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.AppointAreaReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.VolumeLadderDto;
import com.dtyunxi.finance.api.dto.response.logistic.AppointAreaQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.LogisticRecordQueryRespDto;
import com.dtyunxi.finance.api.exception.ChargeModeEnum;
import com.dtyunxi.finance.api.exception.SeasonTypeEnum;
import com.dtyunxi.finance.api.query.ILogisticQueryApi;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class ReportCenterLogisticsFreightLogisticsFreightConfigServiceServiceImpl
implements ReportCenterLogisticsFreightLogisticsFreightConfigService {
    @Resource
    private ILogisticApi logisticApi;
    @Resource
    private ILogisticQueryApi logisticQueryApi;

    @Override
    public RestResponse<Object> appointAreaImportFile(@ApiParam(value="") @Valid @RequestBody(required=false) AppointAreaImportFile appointAreaImportFile) {
        EasyPoiExportUtil.checkFileInfo(appointAreaImportFile.getImportFileUrl());
        String billingMethod = appointAreaImportFile.getBillingMethod();
        String seasonConfigType = appointAreaImportFile.getSeasonConfigType();
        Class aclass = LogisticAppointAreaConstant.APPOINT_AREA_MAP.get(billingMethod + "_" + seasonConfigType);
        List<TemplateLowestDto> list = this.getListParams(appointAreaImportFile.getImportFileUrl(), aclass);
        if (CollectionUtils.isEmpty(list)) {
            list = this.getHttpListParams(appointAreaImportFile.getImportFileUrl(), aclass);
        }
        ArrayList<AppointAreaReqDto> reqDto = new ArrayList<AppointAreaReqDto>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (JSONObject jSONObject : list) {
                AppointAreaReqDto areaReqDto = new AppointAreaReqDto();
                areaReqDto.setTemplateId(appointAreaImportFile.getConfigId());
                areaReqDto.setType(Integer.valueOf(seasonConfigType));
                areaReqDto.setProvince(jSONObject.getString("province"));
                areaReqDto.setCity(jSONObject.getString("city"));
                areaReqDto.setArea(jSONObject.getString("area"));
                areaReqDto.setDay(jSONObject.getInteger("day"));
                areaReqDto.setParams(JSONObject.toJSONString((Object)jSONObject));
                reqDto.add(areaReqDto);
            }
        }
        if (CollectionUtils.isNotEmpty(reqDto)) {
            this.logisticApi.saveAppointArea(reqDto);
        }
        return new RestResponse();
    }

    private <J> List<TemplateLowestDto> getListParams(String url, Class<J> clazz) {
        ArrayList<TemplateLowestDto> read = new ArrayList();
        try {
            File file = new File(url);
            FileInputStream is = new FileInputStream(file.getAbsolutePath());
            ImportParams params = new ImportParams();
            params.setHeadRows(2);
            params.setStartSheetIndex(0);
            read = ExcelImportUtil.importExcel((InputStream)is, clazz, (ImportParams)params);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
        }
        return read;
    }

    private <J> List<TemplateLowestDto> getHttpListParams(String url, Class<J> clazz) {
        ArrayList<TemplateLowestDto> read = new ArrayList();
        try {
            InputStream is = ExcelUtils.getInputStream(url);
            ImportParams params = new ImportParams();
            params.setHeadRows(2);
            params.setStartSheetIndex(0);
            read = ExcelImportUtil.importExcel((InputStream)is, clazz, (ImportParams)params);
        }
        catch (Exception e) {
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
        }
        return read;
    }

    private void checkParam(ExcelImportResult<ImportBaseModeDto> result) {
        if (result.isVerfiyFail()) {
            int index = 1;
            result.getFailList().forEach(l -> {
                throw new BizException(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", l.getRowNum() + index, l.getErrorMsg()));
            });
        }
        if (CollectionUtils.isEmpty((Collection)result.getList())) {
            throw new BizException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (result.getList().size() > 2000) {
            throw new BizException("\u6700\u591a\u53ea\u80fd\u5bfc\u51652000\u884c\u6570\u636e");
        }
    }

    @Override
    public RestResponse<Object> deleteAllAppointArea(@ApiParam(value="") @Valid @RequestBody(required=false) InlineObject inlineObject1) {
        this.logisticApi.removeAllAppointArea(inlineObject1.getId().toString());
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> deleteAppointArea(@ApiParam(value="") @Valid @RequestBody(required=false) InlineObject inlineObject) {
        RestResponse response = this.logisticApi.removeAppointArea(inlineObject.getId().toString());
        if ("0".equals(response.getResultCode())) {
            return new RestResponse(response.getData());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<AppointAreaVO>> getAppointAreaList(@ApiParam(value="") @Valid @RequestBody(required=false) GetAppointAreaListParams getAppointAreaListParams) {
        AppointAreaQueryReqDto areaQueryReqDto = new AppointAreaQueryReqDto();
        if (StringUtils.isNotEmpty((CharSequence)getAppointAreaListParams.getProvinceCode())) {
            areaQueryReqDto.setProvince(getAppointAreaListParams.getProvinceCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)getAppointAreaListParams.getCityCode())) {
            areaQueryReqDto.setCity(getAppointAreaListParams.getCityCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)getAppointAreaListParams.getDistrictCode())) {
            areaQueryReqDto.setArea(getAppointAreaListParams.getDistrictCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)getAppointAreaListParams.getConfigId())) {
            areaQueryReqDto.setTemplateId(getAppointAreaListParams.getConfigId());
        }
        areaQueryReqDto.setPageNum(getAppointAreaListParams.getPageNum());
        areaQueryReqDto.setPageSize(getAppointAreaListParams.getPageSize());
        RestResponse restResponse = this.logisticQueryApi.queryAppointAreaList(areaQueryReqDto);
        if ("0".equals(restResponse.getResultCode())) {
            PageInfo respDtoPageInfo = (PageInfo)restResponse.getData();
            PageInfo dtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)restResponse.getData(), (String[])new String[]{"list", "navigatepageNums"});
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                ArrayList<AppointAreaVO> areaVOS = new ArrayList<AppointAreaVO>();
                for (AppointAreaQueryRespDto areaQueryRespDto : respDtoPageInfo.getList()) {
                    AppointAreaVO areaVO = new AppointAreaVO();
                    BeanUtils.copyProperties((Object)areaQueryRespDto, (Object)((Object)areaVO));
                    areaVO.setTemplateId(areaQueryRespDto.getTemplateId().toString());
                    areaVOS.add(areaVO);
                }
                if (CollectionUtils.isNotEmpty(areaVOS)) {
                    dtoPageInfo.setList(areaVOS);
                }
            }
            return new RestResponse((Object)dtoPageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> updateAppointArea(@ApiParam(value="") @Valid @RequestBody(required=false) SumbitAppointAreaParams sumbitAppointAreaParams) {
        RestResponse response;
        AppointAreaReqDto reqDto = new AppointAreaReqDto();
        reqDto.setId(sumbitAppointAreaParams.getId());
        if (StringUtils.isNotEmpty((CharSequence)sumbitAppointAreaParams.getTemplateId())) {
            reqDto.setTemplateId(sumbitAppointAreaParams.getTemplateId());
        }
        if (null != sumbitAppointAreaParams.getType()) {
            reqDto.setType(sumbitAppointAreaParams.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)sumbitAppointAreaParams.getProvince())) {
            reqDto.setProvince(sumbitAppointAreaParams.getProvince());
        }
        if (StringUtils.isNotEmpty((CharSequence)sumbitAppointAreaParams.getCity())) {
            reqDto.setCity(sumbitAppointAreaParams.getCity());
        }
        if (StringUtils.isNotEmpty((CharSequence)sumbitAppointAreaParams.getArea())) {
            reqDto.setArea(sumbitAppointAreaParams.getArea());
        }
        if (null != sumbitAppointAreaParams.getDay()) {
            reqDto.setDay(sumbitAppointAreaParams.getDay());
        }
        if (null != sumbitAppointAreaParams.getParams()) {
            reqDto.setParams(JSONObject.toJSONString(sumbitAppointAreaParams.getParams()));
        }
        if ("0".equals((response = this.logisticApi.updateAppointAreaById(reqDto)).getResultCode())) {
            return new RestResponse(response.getData());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Long> addLogisticsFreightConfig(@ApiParam(value="") @Valid @RequestBody(required=false) LogisticsFreightConfigParams logisticsFreightConfigParams) {
        LogisticRecordReqDto logisticRecordReqDto = new LogisticRecordReqDto();
        logisticRecordReqDto.setContractName(logisticsFreightConfigParams.getContractName());
        logisticRecordReqDto.setLogisticId(logisticsFreightConfigParams.getLogisticsCode());
        logisticRecordReqDto.setLogisticCompany(logisticsFreightConfigParams.getLogisticsCompany());
        logisticRecordReqDto.setWarehouseId(logisticsFreightConfigParams.getWarehouseCode());
        logisticRecordReqDto.setWarehouseName(logisticsFreightConfigParams.getWarehouseName());
        logisticRecordReqDto.setTransportType(logisticsFreightConfigParams.getLogisticsType());
        logisticRecordReqDto.setChargeMode(Integer.valueOf(logisticsFreightConfigParams.getBillingMethod()));
        logisticRecordReqDto.setSourceId(logisticsFreightConfigParams.getSourceId());
        logisticRecordReqDto.setCopyFlag(logisticsFreightConfigParams.getCopyFlag());
        if (null != logisticsFreightConfigParams.getParams()) {
            if (ChargeModeEnum.VOLUME.getType().toString().equals(logisticsFreightConfigParams.getBillingMethod()) || ChargeModeEnum.VOLUME_TWO.getType().toString().equals(logisticsFreightConfigParams.getBillingMethod())) {
                logisticRecordReqDto.setParams(JSONObject.toJSONString(logisticsFreightConfigParams.getParams().get(0)));
            } else {
                logisticRecordReqDto.setParams(JSONObject.toJSONString(logisticsFreightConfigParams.getParams()));
            }
        }
        logisticRecordReqDto.setStartTime(DateTimeUtils.parseDateTime(logisticsFreightConfigParams.getEffectStartTime()));
        logisticRecordReqDto.setEndTime(DateTimeUtils.parseDateTime(logisticsFreightConfigParams.getEffectEndTime()));
        if (null != logisticsFreightConfigParams.getDeliveryPrice()) {
            logisticRecordReqDto.setDeliveryPrice(logisticsFreightConfigParams.getDeliveryPrice());
        }
        if (null != logisticsFreightConfigParams.getUnloadPrice()) {
            logisticRecordReqDto.setUnloadPrice(logisticsFreightConfigParams.getUnloadPrice());
        }
        if (null != logisticsFreightConfigParams.getContractOilPrice()) {
            logisticRecordReqDto.setContractOilPrice(logisticsFreightConfigParams.getContractOilPrice());
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getAddress())) {
            logisticRecordReqDto.setAddress(logisticsFreightConfigParams.getAddress());
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getRemark())) {
            logisticRecordReqDto.setRemark(logisticsFreightConfigParams.getRemark());
        }
        logisticRecordReqDto.setSeasonType(Integer.valueOf(logisticsFreightConfigParams.getSeasonType()));
        if (SeasonTypeEnum.OFF_OR_PEAK.getType().toString().equals(logisticsFreightConfigParams.getSeasonType())) {
            logisticRecordReqDto.setOffSeason(logisticsFreightConfigParams.getOffSeason());
            logisticRecordReqDto.setPeakSeason(logisticsFreightConfigParams.getPeakSeason());
        }
        return this.logisticApi.saveLogisticRecord(logisticRecordReqDto);
    }

    @Override
    public RestResponse<Object> deleteLogisticsFreightConfig(@ApiParam(value="") @Valid @RequestBody(required=false) InlineObject inlineObject) {
        RestResponse response = this.logisticApi.removeLogisticRecord(inlineObject.getId().toString());
        if ("0".equals(response.getResultCode())) {
            return new RestResponse(response.getData());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<LogisticsFreightConfigVO> getLogisticsFreightConfigDetail(@NotNull @ApiParam(value="\u7269\u6d41\u8d39\u7528\u8bbe\u7f6eid", required=true) @Valid @RequestParam(value="id", required=true) String id) {
        RestResponse restResponse = this.logisticQueryApi.queryLogisticsRecordById(id);
        if ("0".equals(restResponse.getResultCode())) {
            LogisticRecordQueryRespDto respDto = (LogisticRecordQueryRespDto)restResponse.getData();
            LogisticsFreightConfigVO logisticsFreightConfigVO = new LogisticsFreightConfigVO();
            logisticsFreightConfigVO.setId(respDto.getId());
            logisticsFreightConfigVO.setContractName(respDto.getContractName());
            logisticsFreightConfigVO.setLogisticsCode(respDto.getLogisticId());
            logisticsFreightConfigVO.setLogisticsCompany(respDto.getLogisticCompany());
            logisticsFreightConfigVO.setWarehouseCode(respDto.getWarehouseId());
            logisticsFreightConfigVO.setWarehouseName(respDto.getWarehouseName());
            logisticsFreightConfigVO.setLogisticsType(respDto.getTransportType().toString());
            logisticsFreightConfigVO.setBillingMethod(respDto.getChargeMode().toString());
            logisticsFreightConfigVO.setParams(respDto.getParams());
            logisticsFreightConfigVO.setBizParams(respDto.getBizParams());
            logisticsFreightConfigVO.setEffectStartTime(DateTimeUtils.getDateTimeStr(respDto.getStartTime()));
            logisticsFreightConfigVO.setEffectEndTime(DateTimeUtils.getDateTimeStr(respDto.getEndTime()));
            logisticsFreightConfigVO.setDeliveryPrice(respDto.getDeliveryPrice());
            logisticsFreightConfigVO.setUnloadPrice(respDto.getUnloadPrice());
            logisticsFreightConfigVO.setContractOilPrice(respDto.getContractOilPrice());
            logisticsFreightConfigVO.setAddress(respDto.getAddress());
            logisticsFreightConfigVO.setRemark(respDto.getRemark());
            logisticsFreightConfigVO.setSeasonType(respDto.getSeasonType());
            logisticsFreightConfigVO.setOffSeason(respDto.getOffSeason());
            logisticsFreightConfigVO.setPeakSeason(respDto.getPeakSeason());
            logisticsFreightConfigVO.setStatus(respDto.getStatus().toString());
            logisticsFreightConfigVO.setCreateTime(DateTimeUtils.getDateTimeStr(respDto.getCreateTime()));
            logisticsFreightConfigVO.setCreatePerson(respDto.getCreatePerson());
            logisticsFreightConfigVO.setUpdateTime(DateTimeUtils.getDateTimeStr(respDto.getUpdateTime()));
            logisticsFreightConfigVO.setUpdatePerson(respDto.getUpdatePerson());
            return new RestResponse((Object)logisticsFreightConfigVO);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<LogisticsFreightConfigVO>> getLogisticsFreightConfigList(@ApiParam(value="") @Valid @RequestBody(required=false) GetLogisticsFreightConfigListParams getLogisticsFreightConfigListParams) {
        LogisticRecordQueryReqDto reqDto = new LogisticRecordQueryReqDto();
        if (StringUtils.isNotEmpty((CharSequence)getLogisticsFreightConfigListParams.getLogisticsType())) {
            reqDto.setTransportType(getLogisticsFreightConfigListParams.getLogisticsType());
        }
        if (StringUtils.isNotEmpty((CharSequence)getLogisticsFreightConfigListParams.getBillingMethod())) {
            reqDto.setChargeMode(getLogisticsFreightConfigListParams.getBillingMethod());
        }
        if (StringUtils.isNotEmpty((CharSequence)getLogisticsFreightConfigListParams.getLogisticsCode())) {
            reqDto.setLogisticId(getLogisticsFreightConfigListParams.getLogisticsCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)getLogisticsFreightConfigListParams.getWarehouseCode())) {
            reqDto.setWarehouseId(getLogisticsFreightConfigListParams.getWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)getLogisticsFreightConfigListParams.getStatus())) {
            reqDto.setStatus(Integer.valueOf(getLogisticsFreightConfigListParams.getStatus()));
        }
        reqDto.setPageNum(getLogisticsFreightConfigListParams.getPageNum());
        reqDto.setPageSize(getLogisticsFreightConfigListParams.getPageSize());
        reqDto.setValidYear(getLogisticsFreightConfigListParams.getValidYear());
        reqDto.setFlag(getLogisticsFreightConfigListParams.getFlag());
        RestResponse restResponse = this.logisticQueryApi.queryLogisticsRecordList(reqDto);
        if ("0".equals(restResponse.getResultCode())) {
            PageInfo respDtoPageInfo = (PageInfo)restResponse.getData();
            PageInfo dtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                ArrayList<LogisticsFreightConfigVO> areaVOS = new ArrayList<LogisticsFreightConfigVO>();
                for (LogisticRecordQueryRespDto respDto : respDtoPageInfo.getList()) {
                    LogisticsFreightConfigVO areaVO = new LogisticsFreightConfigVO();
                    BeanUtils.copyProperties((Object)respDto, (Object)areaVO);
                    areaVO.setContractName(respDto.getContractName());
                    areaVO.setLogisticsCode(respDto.getLogisticId());
                    areaVO.setLogisticsCompany(respDto.getLogisticCompany());
                    areaVO.setWarehouseCode(respDto.getWarehouseId());
                    areaVO.setWarehouseName(respDto.getWarehouseName());
                    areaVO.setLogisticsType(respDto.getTransportType().toString());
                    areaVO.setBillingMethod(respDto.getChargeMode().toString());
                    areaVO.setParams(respDto.getParams());
                    areaVO.setEffectStartTime(DateTimeUtils.getDateTimeStr(respDto.getStartTime()));
                    areaVO.setEffectEndTime(DateTimeUtils.getDateTimeStr(respDto.getEndTime()));
                    areaVO.setStatus(respDto.getStatus().toString());
                    areaVO.setCreateTime(DateTimeUtils.getDateTimeStr(respDto.getCreateTime()));
                    areaVO.setCreatePerson(respDto.getCreatePerson());
                    areaVO.setUpdateTime(DateTimeUtils.getDateTimeStr(respDto.getUpdateTime()));
                    areaVO.setUpdatePerson(respDto.getUpdatePerson());
                    areaVOS.add(areaVO);
                }
                if (CollectionUtils.isNotEmpty(areaVOS)) {
                    dtoPageInfo.setList(areaVOS);
                }
                return new RestResponse((Object)dtoPageInfo);
            }
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> statusLogisticsFreightConfig(@ApiParam(value="") @Valid @RequestBody(required=false) InlineObject1 inlineObject1) {
        RestResponse response = this.logisticApi.abolishLogisticRecord(inlineObject1.getId().toString());
        if ("0".equals(response.getResultCode())) {
            return new RestResponse(response.getData());
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Long> updateLogisticsFreightConfig(@ApiParam(value="") @Valid @RequestBody(required=false) LogisticsFreightConfigParams logisticsFreightConfigParams) {
        LogisticRecordReqDto logisticRecordReqDto = new LogisticRecordReqDto();
        logisticRecordReqDto.setId(logisticsFreightConfigParams.getId().toString());
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getContractName())) {
            logisticRecordReqDto.setContractName(logisticsFreightConfigParams.getContractName());
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getLogisticsCode())) {
            logisticRecordReqDto.setLogisticId(logisticsFreightConfigParams.getLogisticsCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getLogisticsCompany())) {
            logisticRecordReqDto.setLogisticCompany(logisticsFreightConfigParams.getLogisticsCompany());
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getWarehouseCode())) {
            logisticRecordReqDto.setWarehouseId(logisticsFreightConfigParams.getWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getWarehouseName())) {
            logisticRecordReqDto.setWarehouseName(logisticsFreightConfigParams.getWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getLogisticsType())) {
            logisticRecordReqDto.setTransportType(logisticsFreightConfigParams.getLogisticsType());
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getBillingMethod())) {
            logisticRecordReqDto.setChargeMode(Integer.valueOf(logisticsFreightConfigParams.getBillingMethod()));
        }
        if (null != logisticsFreightConfigParams.getParams()) {
            if (ChargeModeEnum.VOLUME.getType().toString().equals(logisticsFreightConfigParams.getBillingMethod()) || ChargeModeEnum.VOLUME_TWO.getType().toString().equals(logisticsFreightConfigParams.getBillingMethod())) {
                logisticRecordReqDto.setParams(JSONObject.toJSONString(logisticsFreightConfigParams.getParams().get(0)));
            } else {
                logisticRecordReqDto.setParams(JSONObject.toJSONString(logisticsFreightConfigParams.getParams()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getEffectStartTime())) {
            logisticRecordReqDto.setStartTime(DateTimeUtils.parseDateTime(logisticsFreightConfigParams.getEffectStartTime()));
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getEffectEndTime())) {
            logisticRecordReqDto.setEndTime(DateTimeUtils.parseDateTime(logisticsFreightConfigParams.getEffectEndTime()));
        }
        if (null != logisticsFreightConfigParams.getDeliveryPrice()) {
            logisticRecordReqDto.setDeliveryPrice(logisticsFreightConfigParams.getDeliveryPrice());
        }
        if (null != logisticsFreightConfigParams.getUnloadPrice()) {
            logisticRecordReqDto.setUnloadPrice(logisticsFreightConfigParams.getUnloadPrice());
        }
        if (null != logisticsFreightConfigParams.getContractOilPrice()) {
            logisticRecordReqDto.setContractOilPrice(logisticsFreightConfigParams.getContractOilPrice());
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getAddress())) {
            logisticRecordReqDto.setAddress(logisticsFreightConfigParams.getAddress());
        }
        if (StringUtils.isNotEmpty((CharSequence)logisticsFreightConfigParams.getRemark())) {
            logisticRecordReqDto.setRemark(logisticsFreightConfigParams.getRemark());
        }
        logisticRecordReqDto.setSeasonType(Integer.valueOf(logisticsFreightConfigParams.getSeasonType()));
        if (SeasonTypeEnum.OFF_OR_PEAK.getType().toString().equals(logisticsFreightConfigParams.getSeasonType())) {
            logisticRecordReqDto.setOffSeason(logisticsFreightConfigParams.getOffSeason());
            logisticRecordReqDto.setPeakSeason(logisticsFreightConfigParams.getPeakSeason());
        }
        return this.logisticApi.saveLogisticRecord(logisticRecordReqDto);
    }

    @Override
    public RestResponse<Void> volumeLadderSave(VolumeLadderDto volumeLadderDto) {
        return this.logisticApi.volumeLadderSave(volumeLadderDto);
    }

    @Override
    public RestResponse<Long> addAppointArea(SumbitAppointAreaParams sumbitAppointAreaParams) {
        AppointAreaReqDto reqDto = new AppointAreaReqDto();
        if (StringUtils.isNotEmpty((CharSequence)sumbitAppointAreaParams.getTemplateId())) {
            reqDto.setTemplateId(sumbitAppointAreaParams.getTemplateId());
        }
        if (null != sumbitAppointAreaParams.getType()) {
            reqDto.setType(sumbitAppointAreaParams.getType());
        }
        reqDto.setProvince(sumbitAppointAreaParams.getProvince());
        reqDto.setCity(sumbitAppointAreaParams.getCity());
        reqDto.setArea(sumbitAppointAreaParams.getArea());
        if (null != sumbitAppointAreaParams.getDay()) {
            reqDto.setDay(sumbitAppointAreaParams.getDay());
        }
        if (null != sumbitAppointAreaParams.getParams()) {
            reqDto.setParams(JSONObject.toJSONString(sumbitAppointAreaParams.getParams()));
        }
        return this.logisticApi.addAppointArea(reqDto);
    }
}

