/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class RateLimiter {
    private static final RateLimiter INSTANCE = new RateLimiter();
    private final Map<String, Integer> userCounts = new HashMap<String, Integer>();
    private final int limit = 1;
    private final Timer timer = new Timer();

    public RateLimiter() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                RateLimiter.this.userCounts.clear();
            }
        }, 0L, 10800000L);
    }

    public static RateLimiter getInstance() {
        return INSTANCE;
    }

    public synchronized boolean tryRequest(String userId) {
        if (!this.userCounts.containsKey(userId)) {
            this.userCounts.put(userId, 1);
            return true;
        }
        int count = this.userCounts.get(userId);
        if (count < 1) {
            this.userCounts.put(userId, count + 1);
            return true;
        }
        return false;
    }
}

