/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportWarehouseSupplyAreaDto;
import com.dtyunxi.cis.pms.biz.model.ExportWarehouseSupplyAreaMsgDto;
import com.dtyunxi.cis.pms.biz.model.GetWarehouseSupplyAreaListPageParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportWarehouseSupplyAreaDto;
import com.dtyunxi.cis.pms.biz.model.WarehouseSupplyAreaVO;
import com.dtyunxi.cis.pms.biz.service.SystemSettingWarehouseSupplyAreaService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.center.source.api.IWarehouseProvideGoodsRangeApi;
import com.dtyunxi.cube.center.source.api.dto.request.WarehouseProvideGoodsRangeReqDto;
import com.dtyunxi.cube.center.source.api.query.IWarehouseProvideGoodsRangeQueryApi;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.PcpRegionReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IPcpRegionQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_warehouse_supply_area")
public class SystemSettingWarehouseSupplyAreaServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements SystemSettingWarehouseSupplyAreaService {
    @Resource
    private IWarehouseProvideGoodsRangeApi iWarehouseProvideGoodsRangeApi;
    @Resource
    private IWarehouseProvideGoodsRangeQueryApi iWarehouseProvideGoodsRangeQueryApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi csPhysicsWarehouseExposedApi;
    @Resource
    private IPcpRegionQueryApi iPcpRegionQueryApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportWarehouseSupplyAreaDto.class);
        HashSet araeCodes = Sets.newHashSet();
        HashSet whCodes = Sets.newHashSet();
        HashSet checkDataSet = Sets.newHashSet();
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        list.forEach(i -> {
            araeCodes.add(i.getAreaCode());
            whCodes.add(i.getWarehouseCode());
        });
        Map<String, CsPhysicsWarehousePageRespDto> whMap = this.getWhMap(whCodes);
        Map<String, PcpRegionRespDto> araeMap = this.getArea(araeCodes);
        list.stream().forEach(i -> {
            String whCode = i.getWarehouseCode();
            String areaCode = i.getAreaCode();
            ExportWarehouseSupplyAreaMsgDto msgDto = new ExportWarehouseSupplyAreaMsgDto();
            msgDto.setWarehouseCode(whCode);
            msgDto.setAreaCode(areaCode);
            WarehouseProvideGoodsRangeReqDto saveDto = new WarehouseProvideGoodsRangeReqDto();
            saveDto.setOperator(commonReqDto.getOperator());
            this.checkDataRepeat((ImportWarehouseSupplyAreaDto)((Object)i), checkDataSet, msgDto);
            this.checkWh(whMap, whCode, saveDto, msgDto);
            this.chechArea(araeMap, areaCode, saveDto, msgDto);
            if (StringUtils.isNotBlank((CharSequence)msgDto.getErrorMsg())) {
                msgList.add(msgDto);
            } else {
                saveList.add(saveDto);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    private Map<String, PcpRegionRespDto> getArea(Set<String> araeCodes) {
        if (CollectionUtils.isEmpty(araeCodes)) {
            return null;
        }
        PcpRegionReqDto regionReqDto = new PcpRegionReqDto();
        regionReqDto.setCodes(new ArrayList<String>(araeCodes));
        List arealist = (List)RestResponseHelper.extractData((RestResponse)this.iPcpRegionQueryApi.queryRegionDetail(regionReqDto));
        return arealist.stream().collect(Collectors.toMap(PcpRegionRespDto::getCode, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, CsPhysicsWarehousePageRespDto> getWhMap(Set<String> whCodes) {
        if (CollectionUtils.isEmpty(whCodes)) {
            return null;
        }
        CsPhysicsWarehousePageQueryDto queryWhDto = new CsPhysicsWarehousePageQueryDto();
        queryWhDto.setWarehouseCodeList(new ArrayList<String>(whCodes));
        Integer pageSize = 100;
        if (whCodes.size() > pageSize) {
            pageSize = whCodes.size();
        }
        queryWhDto.setPageSize(pageSize);
        queryWhDto.setPageNum(Integer.valueOf(1));
        PageInfo whPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.queryPageInfo(queryWhDto));
        return whPage.getList().stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k3) -> k1));
    }

    private void checkDataRepeat(ImportWarehouseSupplyAreaDto i, Set<String> checkDataSet, ExportWarehouseSupplyAreaMsgDto msgDto) {
        String code = String.format("%s_%s", i.getWarehouseCode(), i.getAreaCode());
        if (checkDataSet.contains(code)) {
            msgDto.setErrorMsg("\u6570\u636e\u91cd\u590d");
        } else {
            checkDataSet.add(code);
        }
    }

    private void chechArea(Map<String, PcpRegionRespDto> araeMap, String areaCode, WarehouseProvideGoodsRangeReqDto saveDto, ExportWarehouseSupplyAreaMsgDto msgDto) {
        if (CollectionUtil.isNotEmpty(araeMap) && araeMap.containsKey(areaCode)) {
            PcpRegionRespDto area = araeMap.get(areaCode);
            saveDto.setProvideLoadCode(area.getCode());
            if (com.google.common.base.Objects.equal((Object)area.getLevelId(), (Object)0)) {
                if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
                    msgDto.setErrorMsg("\u6536\u8d27\u5730\u533a\u4ee3\u7801\u5c42\u7ea7\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u4e3a\u7701\u7ea7");
                } else {
                    msgDto.setErrorMsg(msgDto.getErrorMsg() + ";\u6536\u8d27\u5730\u533a\u4ee3\u7801\u5c42\u7ea7\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u4e3a\u7701\u7ea7");
                }
            }
            if (com.google.common.base.Objects.equal((Object)area.getLevelId(), (Object)2)) {
                saveDto.setAreaCode(area.getCode());
                saveDto.setCityCode(area.getParentCode());
                saveDto.setProvinceCode(area.getProvinceCode());
            }
            if (com.google.common.base.Objects.equal((Object)area.getLevelId(), (Object)1)) {
                saveDto.setCityCode(area.getCode());
                saveDto.setProvinceCode(area.getParentCode());
            }
        } else if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setErrorMsg("\u6536\u8d27\u5730\u533a\u4ee3\u7801\u4e0d\u6b63\u786e");
        } else {
            msgDto.setErrorMsg(msgDto.getErrorMsg() + ";\u6536\u8d27\u5730\u533a\u4ee3\u7801\u4e0d\u6b63\u786e");
        }
    }

    private void checkWh(Map<String, CsPhysicsWarehousePageRespDto> whMap, String whCode, WarehouseProvideGoodsRangeReqDto saveDto, ExportWarehouseSupplyAreaMsgDto msgDto) {
        if (CollectionUtil.isNotEmpty(whMap) && whMap.containsKey(whCode)) {
            CsPhysicsWarehousePageRespDto wh = whMap.get(whCode);
            saveDto.setPhysicsWarehouseCode(wh.getWarehouseCode());
        } else if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setErrorMsg("\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u6b63\u786e");
        } else {
            msgDto.setErrorMsg(msgDto.getErrorMsg() + ";\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u6b63\u786e");
        }
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            this.iWarehouseProvideGoodsRangeApi.batchSave(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u4ed3\u5e93\u4f9b\u8d27\u533a\u57df\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ExportWarehouseSupplyAreaMsgDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return (Integer)RestResponseHelper.extractData((RestResponse)this.iWarehouseProvideGoodsRangeQueryApi.queryByCount(commonReqDto.getFilter()));
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        WarehouseProvideGoodsRangeReqDto queryDto = new WarehouseProvideGoodsRangeReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            GetWarehouseSupplyAreaListPageParams getWarehouseSupplyAreaListPageParams = (GetWarehouseSupplyAreaListPageParams)JSON.parseObject((String)filter, GetWarehouseSupplyAreaListPageParams.class);
            BeanUtils.copyProperties((Object)getWarehouseSupplyAreaListPageParams, (Object)queryDto);
            queryDto.setProvideLoadCode(getWarehouseSupplyAreaListPageParams.getReceiveAreaCode());
            queryDto.setPhysicsWarehouseCode(getWarehouseSupplyAreaListPageParams.getPhysicalWarehouseCode());
        }
        PageInfo page = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iWarehouseProvideGoodsRangeQueryApi.queryByPage(JSON.toJSONString((Object)queryDto), commonReqDto.getPageNum(), commonReqDto.getPageSize()));
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getList())) {
            HashSet whCodes = Sets.newHashSet();
            HashSet areaCodes = Sets.newHashSet();
            page.getList().forEach(i -> {
                whCodes.add(i.getPhysicsWarehouseCode());
                areaCodes.add(i.getProvinceCode());
                areaCodes.add(i.getCityCode());
                areaCodes.add(i.getAreaCode());
            });
            CsPhysicsWarehouseParamQueryDto whDto = new CsPhysicsWarehouseParamQueryDto();
            whDto.setWarehouseCodeList(new ArrayList(whCodes));
            List whList = (List)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.queryParam(whDto));
            Map whMap = null;
            if (CollectionUtils.isNotEmpty((Collection)whList)) {
                whMap = whList.stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            }
            PcpRegionReqDto regionReqDto = new PcpRegionReqDto();
            List codes = areaCodes.stream().filter(Objects::nonNull).collect(Collectors.toList());
            regionReqDto.setCodes(codes);
            regionReqDto.setPageNum(Integer.valueOf(1));
            regionReqDto.setPageSize(Integer.valueOf(codes.size()));
            PageInfo areaPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iPcpRegionQueryApi.queryByPage(regionReqDto));
            Map araeMap = null;
            if (CollectionUtils.isNotEmpty((Collection)areaPage.getList())) {
                araeMap = areaPage.getList().stream().collect(Collectors.toMap(PcpRegionRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            Map finalWhMap = whMap;
            Map finalAraeMap = araeMap;
            list = page.getList().stream().map(i -> {
                ExportWarehouseSupplyAreaDto vo = new ExportWarehouseSupplyAreaDto();
                if (CollectionUtil.isNotEmpty((Map)finalWhMap) && finalWhMap.containsKey(i.getPhysicsWarehouseCode())) {
                    CsPhysicsWarehousePageRespDto wh = (CsPhysicsWarehousePageRespDto)finalWhMap.get(i.getPhysicsWarehouseCode());
                    vo.setPhysicalWarehouseName(wh.getWarehouseName());
                    vo.setPhysicalWarehouseCode(wh.getWarehouseCode());
                }
                if (finalAraeMap != null && finalAraeMap.containsKey(i.getProvinceCode())) {
                    vo.setProvinceName(((PcpRegionRespDto)finalAraeMap.get(i.getProvinceCode())).getName());
                    vo.setReceiveAreaName(vo.getProvinceName());
                }
                if (finalAraeMap != null && finalAraeMap.containsKey(i.getCityCode())) {
                    vo.setCityName(((PcpRegionRespDto)finalAraeMap.get(i.getCityCode())).getName());
                    vo.setReceiveAreaName(vo.getReceiveAreaName() + vo.getCityName());
                }
                if (finalAraeMap != null && finalAraeMap.containsKey(i.getAreaCode())) {
                    vo.setAreaName(((PcpRegionRespDto)finalAraeMap.get(i.getAreaCode())).getName());
                    vo.setReceiveAreaName(vo.getReceiveAreaName() + vo.getAreaName());
                }
                vo.setReceiveAreaCode(i.getProvideLoadCode());
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public RestResponse<Object> deleteWarehouseSupplyArea(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        RestResponseHelper.extractData((RestResponse)this.iWarehouseProvideGoodsRangeApi.removeWarehouseProvideGoodsRange(id));
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<WarehouseSupplyAreaVO>> getWarehouseSupplyAreaListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetWarehouseSupplyAreaListPageParams dto) {
        WarehouseProvideGoodsRangeReqDto queryDto = new WarehouseProvideGoodsRangeReqDto();
        BeanUtils.copyProperties((Object)dto, (Object)queryDto);
        queryDto.setProvideLoadCode(dto.getReceiveAreaCode());
        queryDto.setPhysicsWarehouseCode(dto.getPhysicalWarehouseCode());
        PageInfo page = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iWarehouseProvideGoodsRangeQueryApi.queryByPage(JSON.toJSONString((Object)queryDto), dto.getPageNum(), dto.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isNotEmpty((Collection)page.getList())) {
            HashSet whCodes = Sets.newHashSet();
            HashSet areaCodes = Sets.newHashSet();
            page.getList().forEach(i -> {
                whCodes.add(i.getPhysicsWarehouseCode());
                areaCodes.add(i.getProvinceCode());
                areaCodes.add(i.getCityCode());
                areaCodes.add(i.getAreaCode());
            });
            CsPhysicsWarehouseParamQueryDto whDto = new CsPhysicsWarehouseParamQueryDto();
            whDto.setWarehouseCodeList(new ArrayList(whCodes));
            List whList = (List)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseExposedApi.queryParam(whDto));
            Map whMap = null;
            if (CollectionUtils.isNotEmpty((Collection)whList)) {
                whMap = whList.stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            }
            PcpRegionReqDto regionReqDto = new PcpRegionReqDto();
            regionReqDto.setCodes(new ArrayList(areaCodes));
            PageInfo areaPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iPcpRegionQueryApi.queryByPage(JSON.toJSONString((Object)regionReqDto), Integer.valueOf(1), Integer.valueOf(areaCodes.size())));
            Map araeMap = null;
            if (CollectionUtils.isNotEmpty((Collection)areaPage.getList())) {
                araeMap = areaPage.getList().stream().collect(Collectors.toMap(PcpRegionRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            Map finalWhMap = whMap;
            Map finalAraeMap = araeMap;
            List voList = page.getList().stream().map(i -> {
                WarehouseSupplyAreaVO vo = new WarehouseSupplyAreaVO();
                BeanUtils.copyProperties((Object)i, (Object)vo);
                if (CollectionUtil.isNotEmpty((Map)finalWhMap) && finalWhMap.containsKey(i.getPhysicsWarehouseCode())) {
                    CsPhysicsWarehousePageRespDto wh = (CsPhysicsWarehousePageRespDto)finalWhMap.get(i.getPhysicsWarehouseCode());
                    vo.setPhysicalWarehouseName(wh.getWarehouseName());
                    vo.setPhysicalWarehouseCode(wh.getWarehouseCode());
                    vo.setPhysicalWarehouseId(String.valueOf(wh.getId()));
                }
                if (finalAraeMap != null && finalAraeMap.containsKey(i.getProvinceCode())) {
                    vo.setProvinceName(((PcpRegionRespDto)finalAraeMap.get(i.getProvinceCode())).getName());
                    vo.setReceiveAreaName(vo.getProvinceName());
                }
                if (finalAraeMap != null && finalAraeMap.containsKey(i.getCityCode())) {
                    vo.setCityName(((PcpRegionRespDto)finalAraeMap.get(i.getCityCode())).getName());
                    vo.setReceiveAreaName(vo.getReceiveAreaName() + vo.getCityName());
                }
                if (finalAraeMap != null && finalAraeMap.containsKey(i.getAreaCode())) {
                    vo.setAreaName(((PcpRegionRespDto)finalAraeMap.get(i.getAreaCode())).getName());
                    vo.setReceiveAreaName(vo.getReceiveAreaName() + vo.getAreaName());
                }
                vo.setReceiveAreaCode(i.getProvideLoadCode());
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(voList);
        }
        return new RestResponse((Object)pageInfo);
    }
}

