/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.export;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.afterturn.easypoi.excel.export.ExcelBatchExportService;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.export.ExportProperties;
import com.dtyunxi.cis.pms.biz.export.IExportExcelHelper;
import com.dtyunxi.cis.pms.biz.fetch.FetchDataService;
import com.dtyunxi.cis.search.api.dto.request.EsBaseReqParams;
import com.dtyunxi.cube.utils.ReflectUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BasePageDto;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExportExcelHelper
implements IExportExcelHelper {
    private static final Logger logger = LoggerFactory.getLogger(ExportExcelHelper.class);
    @Resource
    private OssRegistryVo cubeOssProperties;
    @Resource
    private IObjectStorageService objectStorageService;
    @Value(value="${common.export.page.limit:5000}")
    private Integer pageSizeLimit;
    @Value(value="${common.export.file.limit:50000}")
    private Integer fileSizeLimit;
    @Resource
    private ExportProperties exportProperties;
    private static final String PAGE_SIZE = "pageSize";
    private static final String PAGE_NUM = "pageNum";

    @Override
    public <REQ_DTO, TARGET> String doDefaultExport(List<REQ_DTO> reqs, Class<TARGET> clazz, String fileName) {
        ArrayList exportData = new ArrayList();
        CubeBeanUtils.copyCollection(exportData, reqs, clazz);
        return this.doExport(exportData, clazz, fileName);
    }

    @Override
    public <TARGET, REQ> List<String> doBigDataDivideDataExport(FetchDataService<REQ, TARGET> fetchDataService, REQ req, Class<TARGET> clazz, String baseFileName) {
        return this.doBigDataDivideDataExport(fetchDataService, req, clazz, baseFileName, this.pageSizeLimit);
    }

    @Override
    public <TARGET, REQ> List<String> doBigDataDivideDataExport(FetchDataService<REQ, TARGET> fetchDataService, REQ req, Class<TARGET> clazz, String baseFileName, ExportProperties exportProperties) {
        this.setPageNum(1, req);
        this.setPageSize(1, req);
        PageInfo<TARGET> fetch = fetchDataService.fetch(req);
        Integer pageSizeLimit = Optional.ofNullable(exportProperties.getPageSizeLimit()).orElse(this.pageSizeLimit);
        int fileSize = (int)(fetch.getTotal() / (long)this.fileSizeLimit.intValue() + (long)(fetch.getTotal() % (long)this.fileSizeLimit.intValue() > 0L ? 1 : 0));
        int allPageNum = (int)(fetch.getTotal() / (long)pageSizeLimit.intValue() + (long)(fetch.getTotal() % (long)pageSizeLimit.intValue() > 0L ? 1 : 0));
        int filePageNum = this.fileSizeLimit / pageSizeLimit;
        ArrayList<String> urls = new ArrayList<String>(fileSize + (fileSize >> 1));
        this.setPageSize(pageSizeLimit, req);
        Stream.iterate(1, n -> n + 1).limit(fileSize).forEach(fileNo -> {
            if (YesOrNoEnum.isYes(exportProperties.getHasTemp()).booleanValue()) {
                urls.add(this.getUrl(this.tempExport(fetchDataService, req, clazz, baseFileName, fileSize, allPageNum, filePageNum, (Integer)fileNo, exportProperties.getTempPath())));
            } else {
                urls.add(this.getUrl(this.commonExport(fetchDataService, req, clazz, baseFileName, fileSize, allPageNum, filePageNum, (Integer)fileNo)));
            }
        });
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TARGET, REQ> String commonExport(FetchDataService<REQ, TARGET> fetchDataService, REQ req, Class<TARGET> clazz, String baseFileName, int fileSize, int allPageNum, int filePageNum, Integer fileNo) {
        String fileName = baseFileName + "_" + fileNo;
        ExportParams exportParams = new ExportParams();
        ExcelBatchExportService batchService = ExcelBatchExportService.getExcelBatchExportService((ExportParams)exportParams, clazz);
        try {
            Workbook workbook = batchService.appendData((Collection)Lists.newArrayList());
            this.batchPull(fetchDataService, req, fileSize, allPageNum, filePageNum, fileNo, list -> batchService.appendData((Collection)list));
            this.excelUpload(workbook, fileName + ".xlsx");
        }
        finally {
            batchService.closeExportBigExcel();
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TARGET, REQ> String tempExport(FetchDataService<REQ, TARGET> fetchDataService, REQ req, Class<TARGET> clazz, String baseFileName, int fileSize, int allPageNum, int filePageNum, Integer fileNo, String tempPath) {
        String fileName = baseFileName + "_" + fileNo;
        ExcelBatchExportService batchService = ExcelBatchExportService.getExcelBatchExportService((ExportParams)new ExportParams(), clazz);
        try {
            ArrayList dataList = new ArrayList();
            this.batchPull(fetchDataService, req, fileSize, allPageNum, filePageNum, fileNo, list -> dataList.addAll(list));
            TemplateExportParams param = new TemplateExportParams(tempPath, true, new String[0]);
            HashMap data = new HashMap();
            data.put("list", dataList);
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)param, data);
            this.excelUpload(workbook, fileName + ".xlsx");
        }
        finally {
            batchService.closeExportBigExcel();
        }
        return fileName;
    }

    private <TARGET, REQ> void batchPull(FetchDataService<REQ, TARGET> fetchDataService, REQ req, int fileSize, int allPageNum, int filePageNum, Integer fileNo, Consumer<List<TARGET>> consumer) {
        Stream.iterate(1, n -> n + 1).limit(fileSize != fileNo ? (long)filePageNum : (long)(allPageNum % filePageNum)).forEach(n -> {
            this.setPageNum(filePageNum * (fileNo - 1) + n, req);
            Optional.ofNullable(fetchDataService.fetch(req).getList()).filter(CollectionUtils::isNotEmpty).ifPresent(consumer::accept);
        });
    }

    @Override
    public <TARGET, REQ> List<String> doBigDataDivideDataExport(FetchDataService<REQ, TARGET> fetchDataService, REQ req, Class<TARGET> clazz, String baseFileName, Integer pageSize) {
        return this.doBigDataDivideDataExport(fetchDataService, req, clazz, baseFileName, ExportProperties.builder().pageSizeLimit(pageSize).build());
    }

    private <REQ> void setPageSize(int i, REQ req) {
        if (req instanceof EsBaseReqParams) {
            ((EsBaseReqParams)req).setPageSize(Integer.valueOf(i));
        } else if (req instanceof BasePageDto) {
            ((BasePageDto)req).setPageSize(Integer.valueOf(i));
        } else {
            this.reflectSetVal(i, req, PAGE_SIZE);
        }
    }

    private <REQ> void setPageNum(int i, REQ req) {
        if (req instanceof EsBaseReqParams) {
            ((EsBaseReqParams)req).setPageNum(Integer.valueOf(i));
        } else if (req instanceof BasePageDto) {
            ((BasePageDto)req).setPageNum(Integer.valueOf(i));
        } else {
            this.reflectSetVal(i, req, PAGE_NUM);
        }
    }

    private <REQ> void reflectSetVal(int i, REQ req, String pageNum) {
        this.getFirst(req, pageNum).ifPresent(field -> {
            field.setAccessible(true);
            try {
                field.set(req, i);
            }
            catch (IllegalAccessException e) {
                logger.error("\u53cd\u5c04\u5f02\u5e38", (Throwable)e);
            }
        });
    }

    private <REQ> Optional<Field> getFirst(REQ req, String fieldName) {
        return ReflectUtil.getAllFields(req.getClass()).stream().filter(field -> field.getName().equals(fieldName)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <TARGET> String doExport(List<TARGET> exportData, Class<TARGET> clazz, String fileName) {
        Workbook workbook = ExcelExportUtil.exportBigExcel((ExportParams)new ExportParams(), clazz, exportData);
        try {
            this.excelUpload(workbook, fileName + ".xlsx");
        }
        finally {
            ExcelExportUtil.closeExportBigExcel();
        }
        return this.getUrl(fileName);
    }

    private String getUrl(String fileName) {
        return this.cubeOssProperties.getEndpoint() + "/" + this.cubeOssProperties.getDir() + fileName + ".xlsx";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void excelUpload(Workbook wb, String fileName) {
        ByteArrayOutputStream os = null;
        ByteArrayInputStream in = null;
        try {
            os = new ByteArrayOutputStream();
            wb.write((OutputStream)os);
            in = new ByteArrayInputStream(os.toByteArray());
            this.objectStorageService.put(this.cubeOssProperties.getBucketName(), this.cubeOssProperties.getDir() + fileName, (InputStream)in);
        }
        catch (Exception var23) {
            logger.error("\u5904\u7406excel\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (Exception var22) {
                    logger.error("\u5173\u95edworkbook\u5931\u8d25");
                }
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception var21) {
                logger.error("\u5173\u95edos\u6d41\u5931\u8d25");
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception var20) {
                logger.error("\u5173\u95edin\u6d41\u5931\u8d25");
            }
        }
    }
}

