/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.WarehouseTypeEnum;
import com.dtyunxi.cis.pms.biz.model.AddLogicalWarehouseParams;
import com.dtyunxi.cis.pms.biz.model.DeleteLogicalWarehouseParams;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetLogicalWarehouseListPageParams;
import com.dtyunxi.cis.pms.biz.model.LogicalWarehouseCargoVo;
import com.dtyunxi.cis.pms.biz.model.LogicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.OutLogicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.UpdateChannelWarehouseStatusParams;
import com.dtyunxi.cis.pms.biz.model.UpdateLogicalWarehouseParams;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehouseLogicalWarehouseService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.CsWarehouseTypeEnum;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseExposedAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_logical_warehouse")
public class InventoryCenterBaseWarehouseLogicalWarehouseServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements InventoryCenterBaseWarehouseLogicalWarehouseService {
    private static final Logger log = LoggerFactory.getLogger(InventoryCenterBaseWarehouseLogicalWarehouseServiceServiceImpl.class);
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Autowired
    IChannelWarehouseApi channelWarehouseQueryApi;

    @Override
    public RestResponse<Object> addLogicalWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) AddLogicalWarehouseParams addLogicalWarehouseParams) {
        log.info("\u65b0\u589e\u903b\u8f91\u4ed3addLogicalWarehouse\uff1a{}", (Object)JSON.toJSONString((Object)addLogicalWarehouseParams));
        CsLogicWarehouseExposedAddReqDto reqDto = DtoExchangeUtils.createDtoBySource(addLogicalWarehouseParams, CsLogicWarehouseExposedAddReqDto.class);
        reqDto.setWarehouseProperty(addLogicalWarehouseParams.getWarehouseAttr());
        reqDto.setEasWarehouseCode(addLogicalWarehouseParams.getEasWarehouseId());
        reqDto.setSubordinatePhysicsWarehouseId(StringUtils.isNotBlank((CharSequence)addLogicalWarehouseParams.getOwnPhysicalWarehouseId()) ? Long.valueOf(addLogicalWarehouseParams.getOwnPhysicalWarehouseId()) : null);
        reqDto.setOrganizationId(Long.valueOf(addLogicalWarehouseParams.getCargoRightId()));
        reqDto.setOrganizationName(addLogicalWarehouseParams.getCargoRightName());
        reqDto.setCargoEscheatageName(addLogicalWarehouseParams.getCargoRightName());
        reqDto.setWarehouseOnlineFlag(addLogicalWarehouseParams.getChannelType());
        reqDto.setCostOrg(addLogicalWarehouseParams.getCostOrgName());
        if (StringUtils.isNotEmpty((CharSequence)addLogicalWarehouseParams.getQualifiedWarehouse())) {
            reqDto.setInQualifyWarehouse(addLogicalWarehouseParams.getQualifiedWarehouse());
        }
        if (addLogicalWarehouseParams.getSwitchLogicalWarehouse() != null) {
            reqDto.setIsVirtual(addLogicalWarehouseParams.getSwitchLogicalWarehouse());
        }
        if (StringUtils.isNotBlank((CharSequence)addLogicalWarehouseParams.getEffectiveWarehouse())) {
            reqDto.setInQualifyWarehouse(addLogicalWarehouseParams.getEffectiveWarehouse());
        }
        reqDto.setWarehouseClassify(WarehouseTypeEnum.LOGIC.getCode());
        if (StringUtils.isNotBlank((CharSequence)addLogicalWarehouseParams.getWarehouseClassify())) {
            reqDto.setWarehouseClassify(addLogicalWarehouseParams.getWarehouseClassify());
        }
        reqDto.setSubordinateLogicWarehouseId(addLogicalWarehouseParams.getSubordinateLogicWarehouseId());
        reqDto.setSubordinateLogicWarehouseName(addLogicalWarehouseParams.getSubordinateLogicWarehouseName());
        this.setOrganization(reqDto);
        this.setCostOrg(reqDto);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedApi.addLogicWarehouse(reqDto)));
    }

    private void setOrganization(CsLogicWarehouseExposedAddReqDto reqDto) {
        OrgAdvDetailRespDto orgAdvRespDto = (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryById(reqDto.getOrganizationId()));
        AssertUtil.isTrue(null != orgAdvRespDto, "\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
        reqDto.setOrganizationCode(orgAdvRespDto.getCode());
        reqDto.setOrganizationName(orgAdvRespDto.getName());
        List orgAdvDetailRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryOrgDetailByOrgCode(Arrays.asList(orgAdvRespDto.getCode())));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orgAdvDetailRespDtos), "\u7ec4\u7ec7\u5173\u8054\u7684\u7b2c\u4e09\u65b9\u8d27\u6743\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8865\u5145\u540e\u64cd\u4f5c");
        reqDto.setCargoEscheatageId(((OrgAdvDetailRespDto)orgAdvDetailRespDtos.get(0)).getThirdOrgId());
    }

    private void setCostOrg(CsLogicWarehouseExposedAddReqDto reqDto) {
        if (ObjectUtil.isNotEmpty((Object)reqDto.getCostOrgId())) {
            OrgAdvDetailRespDto orgAdvRespDto = (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryById(reqDto.getCostOrgId()));
            AssertUtil.isTrue(null != orgAdvRespDto, "\u8ba1\u8d39\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
            List orgAdvDetailRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryOrgDetailByOrgCode(Arrays.asList(orgAdvRespDto.getCode())));
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orgAdvDetailRespDtos), "\u8ba1\u8d39\u7ec4\u7ec7\u5173\u8054\u7684\u7b2c\u4e09\u65b9\u8d27\u6743\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8865\u5145\u540e\u64cd\u4f5c");
            reqDto.setCostOrg(((OrgAdvDetailRespDto)orgAdvDetailRespDtos.get(0)).getThirdOrgId());
        }
    }

    @Override
    public RestResponse<Object> deleteLogicalWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) DeleteLogicalWarehouseParams deleteLogicalWarehouseParams) {
        return new RestResponse();
    }

    @Override
    public RestResponse<LogicalWarehouseVO> getLogicalWarehouseById(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        CsLogicWarehouseDetailRespDto respDto = (CsLogicWarehouseDetailRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedApi.queryDetailById(Long.valueOf(id)));
        log.info("respDto: {}", (Object)JSON.toJSONString((Object)respDto));
        if (respDto != null) {
            LogicalWarehouseVO vo = DtoExchangeUtils.createDtoBySource(respDto, LogicalWarehouseVO.class);
            vo.setCargoRightId(respDto.getOrganizationId() != null ? String.valueOf(respDto.getOrganizationId()) : null);
            vo.setCargoRightName(respDto.getCargoEscheatageName());
            vo.setOwnPhysicalWarehouseId(respDto.getSubordinatePhysicsWarehouseId() != null ? String.valueOf(respDto.getSubordinatePhysicsWarehouseId()) : null);
            vo.setOwnPhysicalWarehouseName(respDto.getSubordinatePhysicsWarehouseName());
            vo.setChannelType(respDto.getWarehouseOnlineFlag());
            vo.setEasWarehouseId(respDto.getEasWarehouseCode());
            vo.setWarehouseAttr(respDto.getWarehouseProperty());
            vo.setQualifiedWarehouse(respDto.getInQualifyWarehouse());
            vo.setQualifiedWarehouseName(respDto.getInQualifyWarehouseName());
            vo.setEffectiveWarehouse(respDto.getInNearExpireWarehouse());
            vo.setEffectiveWarehouseName(respDto.getInNearExpireWarehouseName());
            vo.setSwitchLogicalWarehouse(respDto.getIsVirtual());
            vo.setIsReturn(respDto.getIsReturnWarehouse());
            vo.setCreateTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)respDto.getCreateTime()));
            vo.setId(respDto.getId());
            vo.setCostOrgName(respDto.getCostOrgName());
            log.info("vo: {}", (Object)JSON.toJSONString((Object)vo));
            return new RestResponse((Object)vo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<LogicalWarehouseVO>> getLogicalWarehouseListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetLogicalWarehouseListPageParams getLogicalWarehouseListPageParams) {
        CsLogicWarehousePageQueryDto pageQueryDto = DtoExchangeUtils.createDtoBySource(getLogicalWarehouseListPageParams, CsLogicWarehousePageQueryDto.class);
        if (CollectionUtils.isNotEmpty(getLogicalWarehouseListPageParams.getWarehouseAttr())) {
            Object warehouseAttr = getLogicalWarehouseListPageParams.getWarehouseAttr();
            pageQueryDto.setWarehouseProperty(warehouseAttr.get(0));
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalWarehouseListPageParams.getCargoRightId())) {
            pageQueryDto.setCargoEscheatageId(getLogicalWarehouseListPageParams.getCargoRightId());
        }
        if (!ObjectUtil.isNull((Object)getLogicalWarehouseListPageParams.getOrganizationId())) {
            pageQueryDto.setOrganizationId(getLogicalWarehouseListPageParams.getOrganizationId());
        }
        pageQueryDto.setSubordinatePhysicsWarehouseId(StringUtils.isNotBlank((CharSequence)getLogicalWarehouseListPageParams.getOwnPhysicalWarehouseId()) ? Long.valueOf(getLogicalWarehouseListPageParams.getOwnPhysicalWarehouseId()) : null);
        if (StringUtils.isNotBlank((CharSequence)getLogicalWarehouseListPageParams.getEasWarehouseId())) {
            pageQueryDto.setEasWarehouseCode(getLogicalWarehouseListPageParams.getEasWarehouseId());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalWarehouseListPageParams.getOrderChannelId())) {
            pageQueryDto.setShopChannelId(ParamConverter.convertToLong((Object)getLogicalWarehouseListPageParams.getOrderChannelId()));
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalWarehouseListPageParams.getChannelWarehouseCode())) {
            pageQueryDto.setChannelWarehouseCode(getLogicalWarehouseListPageParams.getChannelWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalWarehouseListPageParams.getSubordinateLogicWarehouseName())) {
            pageQueryDto.setSubordinateLogicWarehouseName(getLogicalWarehouseListPageParams.getSubordinateLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalWarehouseListPageParams.getChannelType())) {
            pageQueryDto.setChannelType(getLogicalWarehouseListPageParams.getChannelType());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalWarehouseListPageParams.getCargoRightName())) {
            pageQueryDto.setCargoEscheatageName(getLogicalWarehouseListPageParams.getCargoRightName());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalWarehouseListPageParams.getUpdatePerson())) {
            pageQueryDto.setUpdatePerson(getLogicalWarehouseListPageParams.getUpdatePerson());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalWarehouseListPageParams.getUpdateTime())) {
            pageQueryDto.setUpdateTime(getLogicalWarehouseListPageParams.getUpdateTime());
        }
        if (Objects.nonNull(getLogicalWarehouseListPageParams.getIsClaim())) {
            pageQueryDto.setIsClaim(getLogicalWarehouseListPageParams.getIsClaim());
        }
        if (StringUtils.isNotBlank((CharSequence)getLogicalWarehouseListPageParams.getIsReturnWarehouse())) {
            switch (getLogicalWarehouseListPageParams.getIsReturnWarehouse().trim()) {
                case "\u662f": {
                    pageQueryDto.setIsReturnWarehouse("1");
                    break;
                }
                case "\u5426": {
                    pageQueryDto.setIsReturnWarehouse("0");
                    break;
                }
                default: {
                    pageQueryDto.setIsReturnWarehouse(null);
                }
            }
        }
        pageQueryDto.setIsLogistics(getLogicalWarehouseListPageParams.getIsLogistics());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedApi.queryPageInfo(pageQueryDto));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List logicalWarehouseVOS = respDtoPageInfo.getList().stream().map(respDto -> {
                LogicalWarehouseVO vo = DtoExchangeUtils.createDtoBySource(respDto, LogicalWarehouseVO.class);
                vo.setCargoRightName(respDto.getCargoEscheatageName());
                vo.setCostOrgName(respDto.getCostOrgName());
                vo.setCargoRightId(respDto.getOrganizationId() != null ? respDto.getOrganizationId().toString() : null);
                vo.setOwnPhysicalWarehouseId(respDto.getSubordinatePhysicsWarehouseId() != null ? String.valueOf(respDto.getSubordinatePhysicsWarehouseId()) : null);
                vo.setOwnPhysicalWarehouseName(respDto.getSubordinatePhysicsWarehouseName());
                vo.setChannelType(respDto.getWarehouseOnlineFlag());
                vo.setEasWarehouseId(respDto.getEasWarehouseCode());
                vo.setIsReturn(respDto.getIsReturnWarehouse());
                vo.setWarehouseAttr(respDto.getWarehouseProperty());
                vo.setId(respDto.getId());
                vo.setEffectiveWarehouseName(respDto.getInNearExpireWarehouse());
                vo.setSwitchLogicalWarehouse(respDto.getIsVirtual());
                vo.setQualifiedWarehouseName(respDto.getInQualifyWarehouse());
                vo.setCreatePerson(respDto.getCreatePerson());
                vo.setCreateTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)respDto.getCreateTime()));
                vo.setWarehouseCorrespondingSystem(respDto.getWarehouseCorrespondingSystem());
                vo.setCostOrgName(respDto.getCostOrgName());
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(logicalWarehouseVOS);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetLogicalWarehouseListPageParams params = new GetLogicalWarehouseListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetLogicalWarehouseListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetLogicalWarehouseListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getLogicalWarehouseListPage((GetLogicalWarehouseListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                OutLogicalWarehouseVO vo = new OutLogicalWarehouseVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setWarehouseType(CsWarehouseTypeEnum.getDescByCode((String)o.getWarehouseType()));
                vo.setWarehouseClassify(Optional.ofNullable(o.getWarehouseClassify()).filter(StringUtils::isNotBlank).map(Type2 -> {
                    switch (Type2) {
                        case "physics": {
                            return "\u7269\u7406\u4ed3";
                        }
                        case "logic": {
                            return "\u903b\u8f91\u4ed3";
                        }
                        case "virtual": {
                            return "\u865a\u62df\u4ed3";
                        }
                        case "channel": {
                            return "\u6e20\u9053\u4ed3";
                        }
                        case "in_transit": {
                            return "\u5728\u9014\u4ed3";
                        }
                    }
                    return o.getWarehouseClassify();
                }).orElse(""));
                vo.setWarehouseStatus(Optional.ofNullable(o.getWarehouseStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "disable": {
                            return "\u65e0\u6548";
                        }
                        case "enable": {
                            return "\u6709\u6548";
                        }
                    }
                    return o.getWarehouseStatus();
                }).orElse(""));
                vo.setWarehouseQuality(Optional.ofNullable(o.getWarehouseQuality()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "qualified": {
                            return "\u5408\u683c";
                        }
                        case "wait_inspection": {
                            return "\u5f85\u68c0";
                        }
                        case "un_qualified": {
                            return "\u4e0d\u5408\u683c";
                        }
                        case "pending": {
                            return "\u5f85\u5904\u7406";
                        }
                        case "other": {
                            return "\u5176\u4ed6";
                        }
                    }
                    return o.getWarehouseQuality();
                }).orElse(""));
                vo.setChannelType(Optional.ofNullable(o.getChannelType()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "off_line": {
                            return "\u7ebf\u4e0b";
                        }
                        case "on_line": {
                            return "\u7ebf\u4e0a";
                        }
                    }
                    return o.getChannelType();
                }).orElse(""));
                vo.setIsReturnWarehouse(Optional.ofNullable(o.getIsReturnWarehouse()).map(Type2 -> {
                    switch (Type2) {
                        case 1: {
                            return "\u662f";
                        }
                        case 0: {
                            return "\u5426";
                        }
                    }
                    return "";
                }).orElse(""));
                vo.setWarehouseAttr(Optional.ofNullable(o.getWarehouseAttr()).filter(StringUtils::isNotBlank).map(attr -> {
                    switch (attr) {
                        case "finished_product": {
                            return "\u4ea7\u6210\u54c1";
                        }
                        case "semi_finished_product": {
                            return "\u534a\u6210\u54c1";
                        }
                        case "shoppe": {
                            return "\u4e13\u67dc";
                        }
                        case "third_party": {
                            return "\u7b2c\u4e09\u65b9";
                        }
                        case "promotionp_boring": {
                            return "\u4fc3\u9500\u7269\u6599";
                        }
                    }
                    return o.getWarehouseAttr();
                }).orElse(""));
                vo.setSwitchLogicalWarehouse(Optional.ofNullable(o.getSwitchLogicalWarehouse()).map(Type2 -> {
                    switch (Type2) {
                        case 1: {
                            return "\u5f00\u542f";
                        }
                        case 0: {
                            return "\u4e0d\u5f00\u542f";
                        }
                    }
                    return o.getSwitchLogicalWarehouse().toString();
                }).orElse(""));
                vo.setIsBcShare(Optional.ofNullable(o.getIsBcShare()).map(Type2 -> {
                    switch (Type2) {
                        case 1: {
                            return "\u662f";
                        }
                        case 0: {
                            return "\u5426";
                        }
                    }
                    return o.getIsBcShare().toString();
                }).orElse(""));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, OutLogicalWarehouseVO.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        GetLogicalWarehouseListPageParams params = new GetLogicalWarehouseListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetLogicalWarehouseListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetLogicalWarehouseListPageParams.class);
        }
        params.setPageNum(1);
        params.setPageSize(1);
        return Math.toIntExact(Optional.ofNullable(this.getLogicalWarehouseListPage(params).getData()).map(PageSerializable::getTotal).orElse(0L));
    }

    @Override
    public RestResponse<Object> updateLogicalWarehouse(@ApiParam(value="") @Valid @RequestBody(required=false) UpdateLogicalWarehouseParams updateLogicalWarehouseParams) {
        CsLogicWarehouseExposedAddReqDto reqDto = DtoExchangeUtils.createDtoBySource(updateLogicalWarehouseParams, CsLogicWarehouseExposedAddReqDto.class);
        reqDto.setWarehouseProperty(updateLogicalWarehouseParams.getWarehouseAttr());
        reqDto.setOrganizationId(Long.valueOf(updateLogicalWarehouseParams.getCargoRightId()));
        reqDto.setOrganizationName(updateLogicalWarehouseParams.getCargoRightName());
        reqDto.setSubordinatePhysicsWarehouseId(StringUtils.isNotBlank((CharSequence)updateLogicalWarehouseParams.getOwnPhysicalWarehouseId()) ? Long.valueOf(updateLogicalWarehouseParams.getOwnPhysicalWarehouseId()) : null);
        reqDto.setWarehouseOnlineFlag(updateLogicalWarehouseParams.getChannelType());
        reqDto.setId(Long.valueOf(updateLogicalWarehouseParams.getWarehouseId()));
        reqDto.setEasWarehouseCode(updateLogicalWarehouseParams.getEasWarehouseId());
        reqDto.setCargoEscheatageName(updateLogicalWarehouseParams.getCargoRightName());
        reqDto.setWarehouseCorrespondingSystem(updateLogicalWarehouseParams.getWarehouseCorrespondingSystem());
        reqDto.setCostOrg(updateLogicalWarehouseParams.getCostOrgName());
        if (StringUtils.isNotEmpty((CharSequence)updateLogicalWarehouseParams.getQualifiedWarehouse())) {
            reqDto.setInQualifyWarehouse(updateLogicalWarehouseParams.getQualifiedWarehouse());
        }
        if (updateLogicalWarehouseParams.getSwitchLogicalWarehouse() != null) {
            reqDto.setIsVirtual(updateLogicalWarehouseParams.getSwitchLogicalWarehouse());
        }
        if (StringUtils.isNotBlank((CharSequence)updateLogicalWarehouseParams.getEffectiveWarehouse())) {
            reqDto.setInNearExpireWarehouse(updateLogicalWarehouseParams.getEffectiveWarehouse());
        }
        this.setOrganization(reqDto);
        this.setCostOrg(reqDto);
        Boolean data = (Boolean)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedApi.updateLogicWarehouse(reqDto));
        if (!data.booleanValue()) {
            RestResponse restResponse = new RestResponse();
            restResponse.setData((Object)data);
            restResponse.setResultCode("10001");
            restResponse.setResultMsg("\u4ed3\u5e93\u72b6\u6001\u7981\u7528\u5931\u8d25\uff0c\u903b\u8f91\u4ed3\u5e93\u5b58\u4e3a0\u624d\u80fd\u7981\u7528");
            return restResponse;
        }
        return new RestResponse((Object)data);
    }

    @Override
    public RestResponse<List<String>> updateLogicalWarehouseStatus(@ApiParam(value="") @Valid @RequestBody(required=false) UpdateChannelWarehouseStatusParams updateChannelWarehouseStatusParams) {
        if (CollectionUtils.isEmpty(updateChannelWarehouseStatusParams.getWarehouseIds())) {
            throw new BizException("\u903b\u8f91\u4ed3id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)updateChannelWarehouseStatusParams.getWarehouseIds().get(0))) {
            throw new BizException("\u903b\u8f91\u4ed3id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)updateChannelWarehouseStatusParams.getWarehouseStatus())) {
            throw new BizException("\u903b\u8f91\u4ed3\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"enable".equals(updateChannelWarehouseStatusParams.getWarehouseStatus()) && !"disable".equals(updateChannelWarehouseStatusParams.getWarehouseStatus())) {
            throw new BizException("\u903b\u8f91\u4ed3\u72b6\u6001\u8bbe\u7f6e\u9519\u8bef");
        }
        List<String> ids = updateChannelWarehouseStatusParams.getWarehouseIds();
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedApi.modifyPhysicalWarehouseStatus(ids, updateChannelWarehouseStatusParams.getWarehouseStatus())));
    }

    @Override
    public RestResponse<List<CsLogicWarehousePageRespDto>> queryParam(@RequestBody CsLogicWarehouseParamQueryDto csLogicWarehouseParamQueryDto) {
        return this.csLogicWarehouseExposedApi.queryParam(csLogicWarehouseParamQueryDto);
    }

    @Override
    public RestResponse<List<LogicalWarehouseCargoVo>> getLogicalWarehouseCargoRightList(GetLogicalWarehouseListPageParams logicalWarehouseListPageParams) {
        ArrayList list = Lists.newArrayList();
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.getLogicalWarehouseListPage(logicalWarehouseListPageParams));
        if (pageInfo == null || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return new RestResponse((Object)list);
        }
        Map<String, List<LogicalWarehouseVO>> collect = pageInfo.getList().stream().filter(e -> e.getCargoRightId() != null).collect(Collectors.groupingBy(LogicalWarehouseVO::getCargoRightId));
        collect.forEach((k, v) -> {
            LogicalWarehouseCargoVo cargoVo = new LogicalWarehouseCargoVo();
            cargoVo.setCargoRightId((String)k);
            cargoVo.setCargoRightName(((LogicalWarehouseVO)v.get(0)).getCargoRightName());
            cargoVo.setLogicalWarehouseVOS((List<LogicalWarehouseVO>)v);
            list.add(cargoVo);
        });
        return new RestResponse((Object)list);
    }
}

