/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportSecurityCodeReportRespVo;
import com.dtyunxi.cis.pms.biz.model.LogisticsInReportRespVo;
import com.dtyunxi.cis.pms.biz.service.ReportCenterSecurityCodeReportService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SecurityCodeReportReqDto;
import com.dtyunxi.tcbj.api.query.SecurityCodeReportApi;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_security_code_report")
public class ReportCenterSecurityCodeReportServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterSecurityCodeReportService {
    private static final Logger logger = LoggerFactory.getLogger(ReportCenterSecurityCodeReportServiceServiceImpl.class);
    @Resource
    private SecurityCodeReportApi securityCodeReportApi;

    @Override
    public RestResponse<PageInfo<LogisticsInReportRespVo>> getPreemptionRecordReportListPage(@ApiParam(value="") @Valid @RequestBody(required=false) SecurityCodeReportReqDto pageParams) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        PageInfo preemptionVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.securityCodeReportApi.getSecurityCodeReportListPage(pageParams));
        if (CollectionUtils.isEmpty((Collection)preemptionVoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)preemptionVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = preemptionVoPageInfo.getList().stream().map(o -> {
            LogisticsInReportRespVo vo = new LogisticsInReportRespVo();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    private void getParams(SecurityCodeReportReqDto getPreemptionRecordReportListPageParams, SecurityCodeReportReqDto pageParams) {
        BeanUtils.copyProperties((Object)getPreemptionRecordReportListPageParams, (Object)pageParams);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("ReportCenterLogisticsInReportServiceService\u5f00\u59cb\u5bfc\u51fa\u9632\u4f2a\u7801");
        String filter = commonReqDto.getFilter();
        logger.info("filter:\u8bf7\u6c42\u53c2\u6570:{}", (Object)filter);
        SecurityCodeReportReqDto params = new SecurityCodeReportReqDto();
        SecurityCodeReportReqDto queryDto = new SecurityCodeReportReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (SecurityCodeReportReqDto)JSON.parseObject((String)commonReqDto.getFilter(), SecurityCodeReportReqDto.class);
            this.getParams(params, queryDto);
        }
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1));
        logger.info("\u9632\u4f2a\u7801\u62a5\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
        PageInfo preemptionVoPageInfo = null;
        try {
            preemptionVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.securityCodeReportApi.getSecurityCodeReportListPage(queryDto));
        }
        catch (Exception e) {
            logger.info("getSecurityCodeReportListPageError :{}", preemptionVoPageInfo);
            e.printStackTrace();
        }
        logger.info("\u9632\u4f2a\u7801\u62a5\u8868\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)preemptionVoPageInfo));
        if (CollectionUtils.isEmpty((Collection)preemptionVoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)preemptionVoPageInfo.getTotal());
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        SecurityCodeReportReqDto params = new SecurityCodeReportReqDto();
        SecurityCodeReportReqDto queryDto = new SecurityCodeReportReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (SecurityCodeReportReqDto)JSON.parseObject((String)commonReqDto.getFilter(), SecurityCodeReportReqDto.class);
            this.getParams(params, queryDto);
        }
        Integer dtoPageSize = commonReqDto.getPageSize();
        Integer dtoPageNum = commonReqDto.getPageNum();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < dtoPageNum; ++i) {
            Integer pageSize = 10000;
            Integer pageNum = 0 + i * 5;
            if (dtoPageSize <= pageSize) {
                pageNum = 1 + i * 5;
                pageSize = dtoPageSize;
            } else {
                pageNum = dtoPageSize % pageSize > 0 ? Integer.valueOf(dtoPageSize / pageSize + 1 + i * 5) : Integer.valueOf(dtoPageSize / pageSize + i * 5);
            }
            for (int j = 1 + i * 5; j < pageNum + 1; ++j) {
                queryDto.setPageNum(Integer.valueOf(j));
                queryDto.setPageSize(pageSize);
                logger.info("\u9632\u4f2a\u7801\u62a5\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
                PageInfo preemptionVoPageInfo = null;
                try {
                    preemptionVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.securityCodeReportApi.getSecurityCodeReportListPage(queryDto));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                logger.info("\u9632\u4f2a\u7801\u62a5\u8868\u51fa\u53c2:{}", (Object)preemptionVoPageInfo.getTotal());
                if (!CollectionUtils.isNotEmpty((Collection)preemptionVoPageInfo.getList())) continue;
                preemptionVoPageInfo.getList().forEach(o -> {
                    ExportSecurityCodeReportRespVo vo = new ExportSecurityCodeReportRespVo();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    vo.setIssuedQuantity(o.getIssuedQuantity().intValue());
                    list.add(vo);
                });
            }
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }
}

