/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.GetOrderChannelListPageParams;
import com.dtyunxi.cis.pms.biz.model.OrderChannelVO;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterOrderChannelService;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.transform.api.IPcpOrderChannelApi;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderChannelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPcpOrderChannelQueryApi;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class BasedataCenterOrderChannelServiceServiceImpl
implements BasedataCenterOrderChannelService {
    @Resource
    private IPcpOrderChannelApi pcpOrderChannelApi;
    @Resource
    private IPcpOrderChannelQueryApi pcpOrderChannelQueryApi;

    @Override
    public RestResponse<Object> addOrderChannel(@ApiParam(value="") @Valid @RequestBody(required=false) OrderChannelVO orderChannelVO) {
        PcpOrderChannelReqDto reqDto = new PcpOrderChannelReqDto();
        BeanUtils.copyProperties((Object)orderChannelVO, (Object)reqDto);
        reqDto.setChannelCode(orderChannelVO.getOrderChannelCode());
        reqDto.setChannelName(orderChannelVO.getOrderChannelName());
        reqDto.setStatus(orderChannelVO.getOrderChannelStatus());
        reqDto.setDescription(orderChannelVO.getOrderChannelRemark());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pcpOrderChannelApi.addPcpOrderChannel(reqDto)));
    }

    @Override
    public RestResponse<OrderChannelVO> getOrderChannelDetail(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PcpOrderChannelRespDto respDto = (PcpOrderChannelRespDto)RestResponseHelper.extractData((RestResponse)this.pcpOrderChannelQueryApi.queryById(Long.valueOf(id)));
        OrderChannelVO vo = new OrderChannelVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setOrderChannelId(respDto.getId().toString());
        vo.setOrderChannelCode(respDto.getChannelCode());
        vo.setOrderChannelName(respDto.getChannelName());
        vo.setOrderChannelRemark(respDto.getDescription());
        vo.setOrderChannelStatus(respDto.getStatus());
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        if (respDto.getUpdateTime() != null) {
            vo.setUpdateTime(DateUtil.format((Date)respDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<OrderChannelVO>> getOrderChannelListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetOrderChannelListPageParams getOrderChannelListPageParams) {
        PcpOrderChannelReqDto reqDto = new PcpOrderChannelReqDto();
        reqDto.setChannelName(getOrderChannelListPageParams.getOrderChannelName());
        reqDto.setStatus(getOrderChannelListPageParams.getOrderChannelStatus());
        reqDto.setChannelCode(getOrderChannelListPageParams.getOrderChannelCode());
        reqDto.setCreateTimeStart(getOrderChannelListPageParams.getCreateTimeStart());
        reqDto.setCreateTimeEnd(getOrderChannelListPageParams.getCreateTimeEnd());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.pcpOrderChannelQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), getOrderChannelListPageParams.getPageNum(), getOrderChannelListPageParams.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            OrderChannelVO orderChannelVO = new OrderChannelVO();
            BeanUtils.copyProperties((Object)o, (Object)orderChannelVO);
            orderChannelVO.setOrderChannelId(o.getId().toString());
            orderChannelVO.setOrderChannelCode(o.getChannelCode());
            orderChannelVO.setOrderChannelRemark(o.getDescription());
            orderChannelVO.setOrderChannelStatus(o.getStatus());
            orderChannelVO.setOrderChannelName(o.getChannelName());
            if (o.getCreateTime() != null) {
                orderChannelVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            return orderChannelVO;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> updateOrderChannel(@ApiParam(value="") @Valid @RequestBody(required=false) OrderChannelVO orderChannelVO) {
        PcpOrderChannelReqDto reqDto = new PcpOrderChannelReqDto();
        BeanUtils.copyProperties((Object)orderChannelVO, (Object)reqDto);
        reqDto.setChannelCode(orderChannelVO.getOrderChannelCode());
        reqDto.setChannelName(orderChannelVO.getOrderChannelName());
        reqDto.setStatus(orderChannelVO.getOrderChannelStatus());
        reqDto.setDescription(orderChannelVO.getOrderChannelRemark());
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.pcpOrderChannelApi.modifyPcpOrderChannel(reqDto)));
    }
}

