/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportLogisticsInReportRespVo;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.LogisticsInReportRespVo;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateLogisticInTransitDto;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateLogisticInTransitErrorDto;
import com.dtyunxi.cis.pms.biz.service.ReportCenterLogisticsInReportServiceService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICsLogisticsInfoApi;
import com.dtyunxi.tcbj.api.dto.constant.enums.LogisticInfoStatusEnum;
import com.dtyunxi.tcbj.api.dto.request.CsLogisticsInfoReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticOutResultInfoReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticsInReportQueryDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticsInReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogisticOutResultInfoRespDto;
import com.dtyunxi.tcbj.api.query.ICsLogisticsInfoQueryApi;
import com.dtyunxi.tcbj.api.query.LogisticsInReportApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiParam;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_logistics_in_report")
public class ReportCenterLogisticsInReportServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterLogisticsInReportServiceService {
    private static final Logger logger = LoggerFactory.getLogger(ReportCenterLogisticsInReportServiceServiceImpl.class);
    @Resource
    private LogisticsInReportApi logisticsInReportApi;
    @Resource
    private ICsLogisticsInfoQueryApi csLogisticsInfoQueryApi;
    @Resource
    private ICsLogisticsInfoApi csLogisticsInfoApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IContext iContext;

    @Override
    public RestResponse<PageInfo<LogisticsInReportRespVo>> getPreemptionRecordReportListPage(@ApiParam(value="") @Valid @RequestBody(required=false) LogisticsInReportQueryDto pageParams) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        PageInfo preemptionVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logisticsInReportApi.getLogisticsInReportListPage(pageParams));
        if (CollectionUtils.isEmpty((Collection)preemptionVoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)preemptionVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = preemptionVoPageInfo.getList().stream().map(o -> {
            LogisticsInReportRespVo vo = new LogisticsInReportRespVo();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    private void getParams(LogisticsInReportReqDto getPreemptionRecordReportListPageParams, LogisticsInReportQueryDto pageParams) {
        BeanUtils.copyProperties((Object)getPreemptionRecordReportListPageParams, (Object)pageParams);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        return 1;
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        LogisticsInReportQueryDto params = new LogisticsInReportQueryDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (LogisticsInReportQueryDto)JSON.parseObject((String)commonReqDto.getFilter(), LogisticsInReportQueryDto.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = null;
            try {
                pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logisticsInReportApi.getLogisticsInReportListPage(re));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(item -> {
                ExportLogisticsInReportRespVo vo = new ExportLogisticsInReportRespVo();
                BeanUtils.copyProperties((Object)item, (Object)((Object)vo));
                vo.setBusinessType(Optional.ofNullable(item.getBusinessType()).filter(StringUtils::isNotBlank).map(CsPcpBusinessTypeEnum::getByCode).map(CsPcpBusinessTypeEnum::getDesc).orElse(""));
                if (StringUtils.isNotBlank((CharSequence)item.getCustomerName())) {
                    vo.setCustomerName(item.getCustomerName());
                } else {
                    vo.setCustomerName("\u5176\u4ed6\u5ba2\u6237");
                }
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportLogisticsInReportRespVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), TemplateLogisticInTransitDto.class);
        ArrayList msgList = Lists.newArrayList();
        List logisticsNos = list.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getLogisticsNo())).map(TemplateLogisticInTransitDto::getLogisticsNo).collect(Collectors.toList());
        logger.info("\u7269\u6d41\u5728\u9014\u5bfc\u5165\u7b7e\u6536={}", JSON.toJSON(logisticsNos));
        Map<Object, Object> logisticInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(logisticsNos)) {
            LogisticOutResultInfoReqDto resultInfoReqDto = new LogisticOutResultInfoReqDto();
            resultInfoReqDto.setConsignmentNoList(logisticsNos);
            List logisticOutResultInfoRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csLogisticsInfoQueryApi.queryLogisticsOutResultByList(resultInfoReqDto));
            if (CollectionUtils.isNotEmpty((Collection)logisticOutResultInfoRespDtos)) {
                logisticInfoMap = logisticOutResultInfoRespDtos.stream().collect(Collectors.toMap(LogisticOutResultInfoRespDto::getConsignmentNo, Function.identity(), (k1, k2) -> k1));
            }
        }
        ArrayList saveList = Lists.newArrayList();
        ArrayList logisticsNoList = Lists.newArrayList();
        for (TemplateLogisticInTransitDto inTransitDto : list) {
            LogisticOutResultInfoRespDto logisticOutResultInfoRespDto;
            StringBuffer errorMsg = new StringBuffer();
            if (StringUtils.isEmpty((CharSequence)inTransitDto.getLogisticsNo())) {
                errorMsg.append("\u7269\u6d41\u5355\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a;");
            } else if (logisticsNoList.contains(inTransitDto.getLogisticsNo())) {
                errorMsg.append("\u7269\u6d41\u5355\u53f7\u91cd\u590d\u5bfc\u5165;");
            } else if (!logisticInfoMap.containsKey(inTransitDto.getLogisticsNo())) {
                errorMsg.append("\u65e0\u6cd5\u627e\u5230\u7269\u6d41\u5355\u53f7;");
            } else {
                logisticOutResultInfoRespDto = (LogisticOutResultInfoRespDto)logisticInfoMap.get(inTransitDto.getLogisticsNo());
                if (Objects.equals(logisticOutResultInfoRespDto.getStatus(), LogisticInfoStatusEnum.SIGN.getCode())) continue;
                logisticsNoList.add(inTransitDto.getLogisticsNo());
            }
            if (StringUtils.isEmpty((CharSequence)inTransitDto.getStatus())) {
                errorMsg.append("\u72b6\u6001\u4e0d\u5141\u8bb8\u4e3a\u7a7a;");
            } else if (!Objects.equals(inTransitDto.getStatus(), "\u7b7e\u6536")) {
                errorMsg.append("\u72b6\u6001\u503c\u9519\u8bef;");
            }
            if (StringUtils.isEmpty((CharSequence)inTransitDto.getSignDate())) {
                errorMsg.append("\u7b7e\u6536\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a;");
            }
            try {
                logisticOutResultInfoRespDto = (LogisticOutResultInfoRespDto)logisticInfoMap.get(inTransitDto.getLogisticsNo());
                DateTime dateTime = DateUtil.parse((CharSequence)inTransitDto.getSignDate());
                logisticOutResultInfoRespDto.setActualArrivalTime(DateUtil.endOfDay((Date)dateTime).toJdkDate());
            }
            catch (Exception e) {
                errorMsg.append("\u65e5\u671f\u683c\u5f0f\u6709\u8bef");
            }
            if (StringUtils.isNotEmpty((CharSequence)errorMsg.toString())) {
                TemplateLogisticInTransitErrorDto resultDto = new TemplateLogisticInTransitErrorDto();
                CubeBeanUtils.copyProperties((Object)((Object)resultDto), (Object)((Object)inTransitDto), (String[])new String[0]);
                resultDto.setErrorMsg(errorMsg.toString());
                msgList.add(resultDto);
                continue;
            }
            saveList.add(logisticInfoMap.get(inTransitDto.getLogisticsNo()));
        }
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            ArrayList<CsLogisticsInfoReqDto> list = new ArrayList<CsLogisticsInfoReqDto>();
            for (LogisticOutResultInfoRespDto infoRespDto : saveList) {
                CsLogisticsInfoReqDto dto = new CsLogisticsInfoReqDto();
                dto.setType(infoRespDto.getShipmentEnterpriseType());
                dto.setCarrierCode(infoRespDto.getShippingCompanyCode());
                dto.setCarrierName(infoRespDto.getShippingCompany());
                dto.setCarrierNo(infoRespDto.getShippingCompanyCode());
                dto.setConsignmentNo(infoRespDto.getConsignmentNo());
                dto.setStatus(LogisticInfoStatusEnum.SIGN.getCode());
                dto.setCspNo(infoRespDto.getExternalOrderNo());
                if (infoRespDto.getEstimatedTime() == null) {
                    dto.setExpectedArrivalTime(infoRespDto.getActualArrivalTime());
                }
                dto.setActualArrivalTime(infoRespDto.getActualArrivalTime());
                dto.setOperTime(infoRespDto.getActualArrivalTime());
                dto.setOperPerson(this.iContext.userName());
                list.add(dto);
            }
            try {
                logger.info("\u66f4\u65b0\u7269\u6d41\u4fe1\u606f={}", (Object)JSON.toJSONString(list));
                RestResponseHelper.extractData((RestResponse)this.csLogisticsInfoApi.addLogistics(list));
            }
            catch (Exception e) {
                logger.info("\u66f4\u65b0\u7269\u6d41\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u7269\u6d41\u5728\u9014\u7b7e\u6536\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, TemplateLogisticInTransitErrorDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    public SaleOrderTypeEnum enumOf(String type) {
        SaleOrderTypeEnum[] values;
        for (SaleOrderTypeEnum typeEnum : values = SaleOrderTypeEnum.values()) {
            if (!typeEnum.getType().equals(type)) continue;
            return typeEnum;
        }
        return null;
    }
}

