/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.model.ExportBorrowTransferOrderVo;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetTransferOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportBorrowTransferOrderMsgVo;
import com.dtyunxi.cis.pms.biz.model.ImportBorrowTransferOrderVo;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryTransferOrderService;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryTransferHelper;
import com.dtyunxi.cis.pms.biz.service.helper.TransferAddBaseDto;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_borrow_transfer_order")
public class ImportBorrowTransferOrderServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(ImportBorrowTransferOrderServiceImpl.class);
    @Resource
    private InventoryTransferHelper inventoryTransferHelper;
    @Resource
    private FinishedGoodsInventoryTransferOrderService service;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        GetTransferOrderListPageParams params = new GetTransferOrderListPageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetTransferOrderListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetTransferOrderListPageParams.class);
        }
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.service.getTransferOrderListPage((GetTransferOrderListPageParams)re));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                ExportBorrowTransferOrderVo vo = new ExportBorrowTransferOrderVo();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setBussinessOrderNo(o.getBussinessOrderNo());
                vo.setBussinessOrderType(o.getBussinessOrderType());
                vo.setBussinessOrderStatus(o.getBussinessOrderStatus());
                vo.setExternalOrderNo(o.getExternalOrderNo());
                vo.setOutCargoRightName(o.getOutCargoRightName());
                vo.setInCargoRightName(o.getInCargoRightName());
                vo.setOutLogicalWarehouseCode(o.getOutLogicalWarehouseCode());
                vo.setOutLogicalWarehouseName(o.getOutLogicalWarehouseName());
                vo.setInLogicalWarehouseCode(o.getInLogicalWarehouseCode());
                vo.setInLogicalWarehouseName(o.getInLogicalWarehouseName());
                vo.setBorrowCarrierCode(o.getConsignmentNo());
                vo.setBorrowConsignmentNo(o.getConsignmentNo());
                vo.setLongCode("");
                vo.setItemName("");
                vo.setBatch("");
                vo.setQuantity(o.getPlanTransferQuantity());
                vo.setRemark(o.getRemark());
                vo.setCreateTime(new Date());
                vo.setBizDate(o.getBizDate());
                vo.setTotalCartons(o.getTotalCartons() == null ? "" : o.getTotalCartons().stripTrailingZeros().toPlainString());
                vo.setMergeQuantity(o.getMergeQuantity() == null ? "" : o.getMergeQuantity().stripTrailingZeros().toPlainString());
                vo.setTotalWeight(o.getTotalWeight() == null ? "" : o.getTotalWeight().stripTrailingZeros().toPlainString());
                vo.setTotalVolume(o.getTotalVolume() == null ? "" : o.getTotalVolume().stripTrailingZeros().toPlainString());
                vo.setBussinessOrderStatus(Optional.ofNullable(o.getBussinessOrderStatus()).filter(StringUtils::isNotBlank).map(Status2 -> {
                    switch (Status2) {
                        case "wait_commit": {
                            return "\u5f85\u63d0\u4ea4";
                        }
                        case "wait_delivery": {
                            return "\u5f85\u53d1\u8d27";
                        }
                        case "wait_receive": {
                            return "\u5f85\u6536\u8d27";
                        }
                        case "delivery": {
                            return "\u5df2\u53d1\u8d27";
                        }
                        case "wait_out": {
                            return "\u5f85\u51fa\u5e93";
                        }
                        case "portion_out": {
                            return "\u90e8\u5206\u51fa\u5e93";
                        }
                        case "finish": {
                            return "\u5df2\u5b8c\u6210";
                        }
                        case "canceled": {
                            return "\u5df2\u53d6\u6d88";
                        }
                        case "closed": {
                            return "\u5df2\u5173\u95ed";
                        }
                        case "audit_failed": {
                            return "\u5ba1\u6838\u4e0d\u901a\u8fc7";
                        }
                        case "wait_audit": {
                            return "\u5f85\u5ba1\u6838";
                        }
                        case "hang_up": {
                            return "\u6302\u8d77";
                        }
                    }
                    return "";
                }).orElse(""));
                vo.setBussinessOrderType(Optional.ofNullable(o.getBussinessOrderType()).filter(StringUtils::isNotBlank).map(r -> {
                    switch (r) {
                        case "allot_in_only": {
                            return "\u5e93\u5b58\u8c03\u62e8(\u8c03\u62e8\u5165\u5e93)";
                        }
                        case "allot_logic_out": {
                            return "\u903b\u8f91\u8c03\u62e8";
                        }
                        case "allot_lose_efficacy": {
                            return "\u8fd1\u6548\u671f\u5546\u54c1\u8c03\u62e8";
                        }
                        case "allot_out": {
                            return "\u666e\u901a\u8c03\u62e8";
                        }
                        case "allot_out_only": {
                            return "\u5e93\u5b58\u8c03\u62e8(\u8c03\u62e8\u51fa\u5e93)";
                        }
                        case "bc_allot": {
                            return "bc\u8c03\u62e8";
                        }
                        case "cb_allot": {
                            return "cb\u8c03\u62e8";
                        }
                        case "cc_allot": {
                            return "cc\u8c03\u62e8";
                        }
                        case "inspection_qualified": {
                            return "\u5f85\u68c0\u8f6c\u5408\u683c";
                        }
                        case "allot_sale": {
                            return "\u9500\u552e\u8c03\u62e8";
                        }
                        case "allot_sale_bh": {
                            return "\u9500\u552e\u8865\u8d27\u8c03\u62e8";
                        }
                    }
                    return o.getBussinessOrderType();
                }).orElse(""));
                vo.setPlanTransferQuantity(Optional.ofNullable(o.getPlanTransferQuantity()).orElse(BigDecimal.ZERO).intValue());
                vo.setOutWarehouseQuantity(new BigDecimal(this.getVal(o.getOutWarehouseQuantity())).intValue());
                vo.setInWarehouseQuantity(new BigDecimal(this.getVal(o.getInWarehouseQuantity())).intValue());
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, params, ExportBorrowTransferOrderVo.class, commonReqDto.getFileName());
        return urls.get(0);
    }

    private String getVal(String o) {
        return Optional.ofNullable(o).orElse("0");
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportBorrowTransferOrderVo.class);
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        for (ImportBorrowTransferOrderVo i : list) {
            ImportBorrowTransferOrderMsgVo msgDto = new ImportBorrowTransferOrderMsgVo();
            CubeBeanUtils.copyProperties((Object)msgDto, (Object)((Object)i), (String[])new String[0]);
            if (StringUtils.isBlank((CharSequence)i.getOutLogicWarehouseCode())) {
                msgDto.setErrorMsg("\u8c03\u51fa\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)i.getInLogicWarehouseCode())) {
                msgDto.setErrorMsg("\u8c03\u5165\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)i.getLongCode())) {
                msgDto.setErrorMsg("\u5546\u54c1\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)i.getBatch())) {
                msgDto.setErrorMsg("\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)i.getQuantity())) {
                msgDto.setErrorMsg("\u8ba1\u5212\u8c03\u62e8\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)msgDto.getErrorMsg())) {
                msgList.add(msgDto);
                continue;
            }
            saveList.add(i);
        }
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        ArrayList msgList = Lists.newArrayList();
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            Map<String, List<ImportBorrowTransferOrderVo>> importMap = saveList.stream().collect(Collectors.groupingBy(ImportBorrowTransferOrderVo::getMergeOrderKey));
            List<TransferAddBaseDto> transferAddList = this.convertData(saveList, importMap);
            log.info("===\u501f\u8d27\u8c03\u62e8\u5bfc\u5165\u6570\u636e==={}", (Object)JSON.toJSONString(transferAddList));
            transferAddList.forEach(i -> {
                block2: {
                    try {
                        this.createTransfer((TransferAddBaseDto)i);
                    }
                    catch (Exception e) {
                        String key = String.format("%s;%s", i.getSourceWarehouse(), i.getWare().getWarehouseCode());
                        if (!importMap.containsKey(key)) break block2;
                        List importTransferOrderVos = (List)importMap.get(key);
                        ArrayList list = Lists.newArrayList();
                        CubeBeanUtils.copyCollection((Collection)list, (Collection)importTransferOrderVos, ImportBorrowTransferOrderMsgVo.class);
                        list.forEach(j -> j.setErrorMsg(e.getMessage()));
                        msgList.addAll(list);
                    }
                }
            });
        }
        if (msgObj != null) {
            List errorList = (List)msgObj;
            msgList.addAll(errorList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = String.format("%s%s", "\u501f\u8d27\u8c03\u62e8\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ImportBorrowTransferOrderMsgVo.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private List<TransferAddBaseDto> convertData(List<ImportBorrowTransferOrderVo> saveList, Map<String, List<ImportBorrowTransferOrderVo>> map) {
        ArrayList list = Lists.newArrayList();
        map.forEach((key, value) -> {
            ImportBorrowTransferOrderVo importDto = (ImportBorrowTransferOrderVo)((Object)((Object)value.get(0)));
            List<LogicInventoryRespDto> inventoryList = value.stream().map(i -> {
                LogicInventoryRespDto addDto = new LogicInventoryRespDto();
                addDto.setItemLongCode(i.getLongCode());
                addDto.setBatch(i.getBatch());
                addDto.setAvailable(new BigDecimal(i.getQuantity()));
                addDto.setRemark(i.getRemake());
                return addDto;
            }).collect(Collectors.toList());
            LogicWarehouseRespDto ware = new LogicWarehouseRespDto();
            ware.setWarehouseCode(importDto.getInLogicWarehouseCode());
            TransferAddBaseDto addBaseDto = new TransferAddBaseDto(importDto.getOutLogicWarehouseCode(), inventoryList, ware, CsPcpBusinessTypeEnum.ALLOT_OUT.getCode(), null);
            addBaseDto.setImportFlag(true);
            addBaseDto.setPrefixNo("TP");
            addBaseDto.setBizDate(new Date());
            addBaseDto.setType(CsPcpBusinessTypeEnum.BORROW_ALLOT.getCode());
            list.add(addBaseDto);
        });
        return list;
    }

    private void createTransfer(TransferAddBaseDto transferAddBaseDto) {
        this.inventoryTransferHelper.doAddTransfer(transferAddBaseDto);
    }
}

