/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.export;

import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.export.styler.ExcelExportStylerDefaultImpl;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportStatisticStyler
extends ExcelExportStylerDefaultImpl {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportStatisticStyler.class);
    private CellStyle numberCellStyle;

    public ExcelExportStatisticStyler(Workbook workbook) {
        super(workbook);
        this.createNumberCellStyler();
    }

    private void createNumberCellStyler() {
        this.numberCellStyle = this.workbook.createCellStyle();
        this.numberCellStyle.setAlignment(HorizontalAlignment.CENTER);
        this.numberCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.numberCellStyle.setWrapText(true);
    }

    public CellStyle getStyles(boolean noneStyler, ExcelExportEntity entity) {
        if (entity != null && 10 == entity.getType()) {
            log.info("excel entity: {}", (Object)entity);
            this.numberCellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"0.00%"));
            return this.numberCellStyle;
        }
        return super.getStyles(noneStyler, entity);
    }
}

